/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.prereq.i5os;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.os.PlatformConstants;
import com.ibm.ws.install.ni.framework.prereq.PrereqPlugin;
import com.ibm.ws.install.ni.framework.resourcebundle.NIFResourceBundleUtils;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class OS400RequireProductPrereqPlugin
extends PrereqPlugin {
    private static final int NOT_SET = -1;
    private int os400VersionNum_;
    private String os400Version_;
    private String m_sProductID;
    private String m_sRelease;
    private String m_sOptionID;
    private String m_sLoadID;
    private static final String S_REQPRODUCTS = "reqproducts";
    private static final String S_REQPRODUCTS71 = "reqproducts71";
    private static final String S_PRDFORMAT = "PRDR0100";
    private static final String S_PRDCMD = "/QSYS.LIB/QSZRTVPR.PGM";
    private static final String S_STATE_INSTD = "*INSTALLED";
    private static final String S_ERRCODE_NONE = "*NONE";
    private static final String S_SEPARATOR = ";";
    private static final String[] AS_EMPTY;
    private static final String S_COMMA = ",";
    private static final String S_WILD_CARD = "xx";
    private static final String S_PRODUCT_INFO_PATTERN = "(\\s*.+\\s)(.\\w+\\s)(\\d+\\s)(\\d+\\s*)";
    private static final Pattern PATTERN_NAME;
    private static final int N_PRODID = 1;
    private static final int N_RELEASE = 2;
    private static final int N_OPTIONID = 3;
    private static final int N_LOADID = 4;
    private static final String S_PREREQ_FAILURE_MESSAGE_KEY = "OS400PrereqPlugin.requireProductPrereqFailureMessage";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;

    static {
        Factory factory = new Factory("OS400RequireProductPrereqPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.prereq.i5os.OS400RequireProductPrereqPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.prereq.i5os.OS400RequireProductPrereqPlugin----"), 287);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFlag-com.ibm.ws.install.ni.framework.prereq.i5os.OS400RequireProductPrereqPlugin----java.lang.String-"), 42);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPrereqFailureMessage-com.ibm.ws.install.ni.framework.prereq.i5os.OS400RequireProductPrereqPlugin----java.lang.String-"), 75);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkProducts-com.ibm.ws.install.ni.framework.prereq.i5os.OS400RequireProductPrereqPlugin-com.ibm.as400.access.AS400:-as400:-java.lang.Exception:-boolean-"), 96);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkProduct-com.ibm.ws.install.ni.framework.prereq.i5os.OS400RequireProductPrereqPlugin-com.ibm.as400.access.AS400:java.lang.String:java.lang.String:java.lang.String:java.lang.String:-as400:prdids:rls:option:lodid:-java.lang.Exception:-boolean-"), 134);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getReqProducts-com.ibm.ws.install.ni.framework.prereq.i5os.OS400RequireProductPrereqPlugin----java.lang.String-"), 221);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.prereq.i5os.OS400RequireProductPrereqPlugin----[Ljava.lang.String;-"), 240);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-reqParms-com.ibm.ws.install.ni.framework.prereq.i5os.OS400RequireProductPrereqPlugin----java.lang.String-"), 246);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.prereq.i5os.OS400RequireProductPrereqPlugin----[Ljava.lang.String;-"), 262);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-generateVersionNumber-com.ibm.ws.install.ni.framework.prereq.i5os.OS400RequireProductPrereqPlugin-java.lang.String:-s:--int-"), 273);
        AS_EMPTY = new String[0];
        PATTERN_NAME = Pattern.compile(S_PRODUCT_INFO_PATTERN);
    }

    public OS400RequireProductPrereqPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.os400VersionNum_ = -1;
            this.os400Version_ = null;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getFlag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            if (!PlatformConstants.isOS400Install()) {
                string = Boolean.TRUE.toString();
            } else {
                try {
                    AS400 as400 = this.getInstallToolkitBridge().getAS400Object();
                    this.os400Version_ = PlatformConstants.isOS400RemoteInstall() ? "V" + as400.getVersion() + "R" + as400.getRelease() + "M" + as400.getModification() : System.getProperty("os.version");
                    this.os400VersionNum_ = this.generateVersionNumber(this.os400Version_);
                    boolean fResult = this.checkProducts(as400);
                    string = new Boolean(fResult).toString();
                }
                catch (Exception exception) {
                    this.m_fUnexpectedExceptionOccured = true;
                    string = Boolean.FALSE.toString();
                }
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getPrereqFailureMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            String string = this.m_fUnexpectedExceptionOccured ? this.getPrereqGenericExceptionFailureMessage() : NIFResourceBundleUtils.getLocaleString(S_PREREQ_FAILURE_MESSAGE_KEY, new String[]{this.m_sProductID, this.m_sOptionID});
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkProducts(AS400 aS400) throws Exception {
        AS400 aS4002 = aS400;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)aS4002);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean result = true;
            StringTokenizer parseString = new StringTokenizer(this.getReqProducts(), S_SEPARATOR);
            while (parseString.hasMoreTokens()) {
                String token = parseString.nextToken();
                Matcher matcher = PATTERN_NAME.matcher(token);
                if (matcher.matches()) {
                    void as400;
                    this.m_sProductID = matcher.group(1).trim();
                    this.m_sRelease = matcher.group(2).trim();
                    this.m_sOptionID = matcher.group(3).trim();
                    this.m_sLoadID = matcher.group(4).trim();
                    result &= this.checkProduct((AS400)as400, this.m_sProductID, this.m_sRelease, this.m_sOptionID, this.m_sLoadID);
                }
                if (!result) break;
            }
            boolean bl = result;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkProduct(AS400 aS400, String string, String string2, String string3, String string4) throws Exception {
        AS400 aS4002 = aS400;
        String string5 = string;
        String string6 = string2;
        String string7 = string3;
        String string8 = string4;
        Object[] objectArray = new Object[]{aS4002, string5, string6, string7, string8};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        try {
            boolean bl;
            block4: {
                void prdids;
                void as400;
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                ProgramCall pc = new ProgramCall((AS400)as400);
                ProgramParameter[] parmlist = new ProgramParameter[5];
                AS400Bin4 intConv = new AS400Bin4();
                AS400Text char10Conv = new AS400Text(10, as400.getCcsid(), (AS400)as400);
                AS400Text char8Conv = new AS400Text(8, as400.getCcsid(), (AS400)as400);
                AS400Text char7Conv = new AS400Text(7, as400.getCcsid(), (AS400)as400);
                AS400Text char6Conv = new AS400Text(6, as400.getCcsid(), (AS400)as400);
                AS400Text char4Conv = new AS400Text(4, as400.getCcsid(), (AS400)as400);
                AS400Text char128Conv = new AS400Text(128, as400.getCcsid(), (AS400)as400);
                byte[] prodInfo = new byte[27];
                StringTokenizer parsePrdId = new StringTokenizer((String)prdids, S_COMMA);
                while (parsePrdId.hasMoreTokens()) {
                    void lodid;
                    void option;
                    void rls;
                    String prdid = parsePrdId.nextToken();
                    if (prdid.indexOf(S_WILD_CARD) != -1) {
                        prdid = prdid.replaceAll(S_WILD_CARD, String.valueOf(Integer.toString(as400.getVersion())) + Integer.toString(as400.getRelease()));
                    }
                    char7Conv.toBytes((Object)prdid, prodInfo, 0);
                    char6Conv.toBytes((Object)rls, prodInfo, 7);
                    char4Conv.toBytes((Object)option, prodInfo, 13);
                    char10Conv.toBytes((Object)lodid, prodInfo, 17);
                    parmlist[0] = new ProgramParameter(128);
                    parmlist[1] = new ProgramParameter(intConv.toBytes(128));
                    parmlist[2] = new ProgramParameter(char8Conv.toBytes((Object)S_PRDFORMAT));
                    parmlist[3] = new ProgramParameter(prodInfo);
                    parmlist[4] = new ProgramParameter(intConv.toBytes(1024), 1024);
                    pc.setProgram(S_PRDCMD, parmlist);
                    if (!pc.run()) continue;
                    String output = (String)char128Conv.toObject(parmlist[0].getOutputData());
                    String state = output.substring(43, 53);
                    String errorCode = output.substring(53, 63);
                    if (!state.equalsIgnoreCase(S_STATE_INSTD) || !errorCode.trim().equalsIgnoreCase(S_ERRCODE_NONE)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private String getReqProducts() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String value71 = this.getParamValue(S_REQPRODUCTS71);
            String valueOther = this.getParamValue(S_REQPRODUCTS);
            String string = this.os400VersionNum_ < 710 ? valueOther : (value71 != null ? value71 : valueOther);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            String[] requiredParms;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = requiredParms = new String[]{this.reqParms()};
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return requiredParms;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String reqParms() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = this.os400VersionNum_ < 710 ? S_REQPRODUCTS : (this.getParamValue(S_REQPRODUCTS71) != null ? S_REQPRODUCTS71 : S_REQPRODUCTS);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_EMPTY;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_EMPTY;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int generateVersionNumber(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string2);
        try {
            void s;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            int i = -1;
            StringTokenizer stringtokenizer = new StringTokenizer((String)s, "VRM", false);
            if (stringtokenizer.countTokens() == 3) {
                String s1 = stringtokenizer.nextToken();
                s1 = String.valueOf(s1) + stringtokenizer.nextToken();
                s1 = String.valueOf(s1) + stringtokenizer.nextToken();
                i = Integer.parseInt(s1);
            }
            int n = i;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

