/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.prereq.i5os;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.os.PlatformConstants;
import com.ibm.ws.install.ni.framework.prereq.PrereqPlugin;
import com.ibm.ws.install.ni.framework.resourcebundle.NIFResourceBundleUtils;
import com.ibm.ws.install.ni.framework.utils.SystemValueInfo;
import com.ibm.ws.install.ni.framework.utils.SystemValueList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class OS400SystemValuePrereqPlugin
extends PrereqPlugin {
    private String m_sSystemValueName;
    private String m_sSystemValue;
    private String m_sComparator;
    private String m_sActualValue;
    private static final String S_REQSYSTEMVALUES = "reqsysvalues";
    private static final String S_SYSVALUECMD = "/QSYS.LIB/QWCRSVAL.PGM";
    private static final String S_SEPARATOR = ";";
    private static final String S_SYSVALUE_SEPARATOR = "-";
    private static final String[] AS_EMPTY;
    private static final String S_EMPTY = "";
    private static final int N_TYPE_ARRAY = 4;
    private static final int N_TYPE_DATE = 5;
    private static final int N_TYPE_DECIMAL = 2;
    private static final int N_TYPE_INTEGER = 3;
    private static final int N_TYPE_STRING = 1;
    static final byte B_SERVER_TYPE_BINARY = -62;
    static final byte B_SERVER_TYPE_CHAR = -61;
    private static final String S_LESS_THAN = "LES";
    private static final String S_LESS_EQUAL = "LEQ";
    private static final String S_EQUAL = "EQ";
    private static final String S_GREATER_THAN = "GRE";
    private static final String S_GREATER_EQUAL = "GEQ";
    private static final String S_NOT_EQUAL = "NEQ";
    private static final String S_IN = "IN";
    private static final String S_NOT_IN = "NIN";
    private static final String[] A_COMPARATOR;
    private static final String S_SYSTEM_VALUE_INFO_PATTERN = "(\\s*\\w+\\s)([.?\\w+\\W?]+\\s)(\\w+\\s*)";
    private static final Pattern PATTERN_NAME;
    private static final int N_SYSVALUENAME = 1;
    private static final int N_SYSVALUE = 2;
    private static final int N_COMPARATOR = 3;
    private static final String[] AS_REQUIRED_PARAMS;
    private static final String S_PREREQ_FAILURE_MESSAGE_KEY = "OS400PrereqPlugin.systemValuePrereqFailureMessage";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;

    static {
        Factory factory = new Factory("OS400SystemValuePrereqPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin----"), 42);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFlag-com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin----java.lang.String-"), 52);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkSysValueDate-com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin-java.util.Date:java.lang.String:java.lang.String:-actualValue:recommendValue:comparator:-java.lang.Exception:-boolean-"), 641);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkSysValueArray-com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin-java.lang.String:java.lang.String:java.lang.String:-actualValue:recommendValue:comparator:--boolean-"), 668);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getReqSystemValues-com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin----java.lang.String-"), 735);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin----[Ljava.lang.String;-"), 745);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin----[Ljava.lang.String;-"), 755);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPrereqFailureMessage-com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin----java.lang.String-"), 80);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkSystemValues-com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin-com.ibm.as400.access.AS400:-as400:-java.lang.Exception:-boolean-"), 101);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-retrieveValueFromSystem-com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin-com.ibm.as400.access.AS400:[Ljava.lang.String;:-as400:sysValueNames:-java.lang.Exception:-java.util.Vector-"), 141);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-parse-com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin-[B:com.ibm.as400.access.AS400:-data:as400:-java.lang.Exception:-java.util.Vector-"), 200);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-compareResults-com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin-com.ibm.as400.access.AS400:java.util.Vector:java.util.Vector:-as400:infos:actualValues:-java.lang.Exception:-boolean-"), 359);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkSysValueString-com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin-java.lang.String:java.lang.String:java.lang.String:-actualValue:recommendValue:comparator:--boolean-"), 558);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkSysValueInteger-com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin-java.lang.Integer:java.lang.Integer:java.lang.String:-actualValue:recommendValue:comparator:--boolean-"), 591);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkSysValueDecimal-com.ibm.ws.install.ni.framework.prereq.i5os.OS400SystemValuePrereqPlugin-java.math.BigDecimal:java.math.BigDecimal:java.lang.String:-actualValue:recommendValue:comparator:--boolean-"), 616);
        AS_EMPTY = new String[0];
        A_COMPARATOR = new String[]{S_LESS_THAN, S_LESS_EQUAL, S_EQUAL, S_GREATER_THAN, S_GREATER_EQUAL, S_NOT_EQUAL, S_IN, S_NOT_IN};
        PATTERN_NAME = Pattern.compile(S_SYSTEM_VALUE_INFO_PATTERN);
        AS_REQUIRED_PARAMS = new String[]{S_REQSYSTEMVALUES};
    }

    public OS400SystemValuePrereqPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getFlag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            if (!PlatformConstants.isOS400Install()) {
                string = Boolean.TRUE.toString();
            } else {
                try {
                    AS400 as400 = this.getInstallToolkitBridge().getAS400Object();
                    boolean fResult = this.checkSystemValues(as400);
                    string = new Boolean(fResult).toString();
                }
                catch (Exception exception) {
                    this.m_fUnexpectedExceptionOccured = true;
                    string = Boolean.FALSE.toString();
                }
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getPrereqFailureMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            String string = this.m_fUnexpectedExceptionOccured ? this.getPrereqGenericExceptionFailureMessage() : NIFResourceBundleUtils.getLocaleString(S_PREREQ_FAILURE_MESSAGE_KEY, new String[]{this.m_sSystemValueName, this.m_sSystemValue});
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkSystemValues(AS400 aS400) throws Exception {
        AS400 aS4002 = aS400;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)aS4002);
        try {
            void as400;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            StringTokenizer parseString = new StringTokenizer(this.getReqSystemValues(), S_SEPARATOR);
            Vector<String[]> infos = new Vector<String[]>();
            while (parseString.hasMoreTokens()) {
                String[] systemValueInfo = new String[3];
                String token = parseString.nextToken();
                Matcher matcher = PATTERN_NAME.matcher(token);
                if (!matcher.matches()) continue;
                systemValueInfo[0] = matcher.group(1).trim();
                systemValueInfo[1] = matcher.group(2).trim();
                systemValueInfo[2] = matcher.group(3).trim();
                infos.add(systemValueInfo);
            }
            String[] sysValueNames = new String[infos.size()];
            int i = 0;
            while (i < infos.size()) {
                sysValueNames[i] = ((String[])infos.elementAt(i))[0];
                ++i;
            }
            Vector actualValues = OS400SystemValuePrereqPlugin.retrieveValueFromSystem((AS400)as400, sysValueNames);
            boolean bl = actualValues == null ? false : this.compareResults((AS400)as400, infos, actualValues);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Vector retrieveValueFromSystem(AS400 aS400, String[] stringArray) throws Exception {
        AS400 aS4002 = aS400;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)aS4002, (Object)stringArray2);
        try {
            void sysValueNames;
            AS400 as400;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            ProgramCall pc = new ProgramCall(as400);
            ProgramParameter[] parmlist = new ProgramParameter[5];
            AS400Bin4 intConv = new AS400Bin4();
            AS400Text char10Conv = new AS400Text(10, as400.getCcsid(), as400);
            new AS400Text(128, as400.getCcsid(), as400);
            new AS400Text(1024, as400.getCcsid(), as400);
            int valuesCount = ((void)sysValueNames).length;
            int rLength = 4;
            byte[] systemValues = new byte[valuesCount * 10];
            int i = 0;
            while (i < systemValues.length) {
                systemValues[i] = 64;
                ++i;
            }
            i = 0;
            while (i < valuesCount) {
                SystemValueInfo svi = SystemValueList.getSysValueInfo((String)sysValueNames[i]);
                rLength += svi.getSize() * svi.getArraySize() + 24;
                char10Conv.toBytes((Object)sysValueNames[i], systemValues, i * 10);
                ++i;
            }
            parmlist[0] = new ProgramParameter(rLength);
            parmlist[1] = new ProgramParameter(intConv.toBytes(rLength));
            parmlist[2] = new ProgramParameter(intConv.toBytes(valuesCount));
            parmlist[3] = new ProgramParameter(systemValues);
            parmlist[4] = new ProgramParameter(intConv.toBytes(1024), 1024);
            pc.setProgram(S_SYSVALUECMD, parmlist);
            Vector vector = !pc.run() ? null : OS400SystemValuePrereqPlugin.parse(parmlist[0].getOutputData(), as400);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(vector, joinPoint);
            return vector;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Vector parse(byte[] byArray, AS400 aS400) throws Exception {
        byte[] byArray2 = byArray;
        AS400 aS4002 = aS400;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)byArray2, (Object)aS4002);
        try {
            byte[] data;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Vector<String[]> values = new Vector<String[]>();
            int valueNumber = BinaryConverter.byteArrayToInt((byte[])data, (int)0);
            int i = 0;
            while (i < valueNumber) {
                void as400;
                int valueOffset = BinaryConverter.byteArrayToInt((byte[])data, (int)((i + 1) * 4));
                AS400Text char10Conv = new AS400Text(10, as400.getCcsid(), (AS400)as400);
                String name = ((String)char10Conv.toObject(data, valueOffset)).trim();
                SystemValueInfo obj = SystemValueList.getSysValueInfo(name);
                if (data[valueOffset + 11] == -45) {
                    throw new Exception("System value is locked, name: " + name);
                }
                if (data[valueOffset + 10] != obj.getServerDataType()) {
                    throw new Exception("System value type mismatch, name: " + name);
                }
                int size = BinaryConverter.byteArrayToInt((byte[])data, (int)(valueOffset + 12));
                Object value = null;
                switch (obj.getServerDataType()) {
                    case -61: {
                        if (obj.getType() == 4) {
                            int arrayCount = 0;
                            int dataOffset = valueOffset + 16;
                            while (arrayCount < obj.getArraySize() && data[dataOffset + arrayCount * obj.getSize()] != 64) {
                                ++arrayCount;
                            }
                            String[] valueArray = new String[arrayCount];
                            int ii = 0;
                            while (ii < arrayCount) {
                                AS400Text charConv = new AS400Text(obj.getSize(), as400.getCcsid(), (AS400)as400);
                                valueArray[ii] = (String)charConv.toObject(data, dataOffset + ii * obj.getSize());
                                ++ii;
                            }
                            value = valueArray;
                            break;
                        }
                        AS400Text charConv = new AS400Text(size, as400.getCcsid(), (AS400)as400);
                        value = (String)charConv.toObject(data, valueOffset + 16);
                        break;
                    }
                    case -62: {
                        if (obj.getType() == 2) {
                            byte[] valueBytes = new byte[4];
                            System.arraycopy(data, valueOffset + 16, valueBytes, 0, 4);
                            value = new BigDecimal(new BigInteger(valueBytes), obj.getDecimalPositions());
                            break;
                        }
                        value = new Integer(BinaryConverter.byteArrayToInt((byte[])data, (int)(valueOffset + 16)));
                    }
                }
                if (obj.getName().equals("QDATE")) {
                    String stringValue = value.toString();
                    Calendar cal = Calendar.getInstance();
                    cal.set(1900 + 100 * Integer.parseInt(stringValue.substring(0, 1)) + Integer.parseInt(stringValue.substring(1, 3)), Integer.parseInt(stringValue.substring(3, 5)) - 1, Integer.parseInt(stringValue.substring(5, 7)));
                    value = new Date(cal.getTime().getTime());
                } else if (obj.getName().equals("QTIME")) {
                    String stringValue = value.toString();
                    Calendar cal = Calendar.getInstance();
                    cal.set(11, Integer.parseInt(stringValue.substring(0, 2)));
                    cal.set(12, Integer.parseInt(stringValue.substring(2, 4)));
                    cal.set(13, Integer.parseInt(stringValue.substring(4, 6)));
                    cal.set(14, Integer.parseInt(stringValue.substring(6, 9)));
                    value = new Time(cal.getTime().getTime());
                } else if (obj.getName().equals("PNDSYSNAME")) {
                    value = ((String)value).replace('\u0000', ' ');
                } else if (obj.getName().equals("QLOCALE")) {
                    AS400Text charConv;
                    int offset = valueOffset + 16;
                    BinaryConverter.byteArrayToInt((byte[])data, (int)offset);
                    int localeLen = BinaryConverter.byteArrayToInt((byte[])data, (int)(offset + 16));
                    if (localeLen == 0) {
                        value = "*NONE";
                    } else if (localeLen == 1) {
                        charConv = new AS400Text(20, as400.getCcsid(), (AS400)as400);
                        value = (String)charConv.toObject(data, offset + 32);
                    } else {
                        charConv = new AS400Text(localeLen, as400.getCcsid(), (AS400)as400);
                        value = (String)charConv.toObject(data, offset + 32);
                    }
                }
                values.addElement((String[])value);
                ++i;
            }
            Vector<String[]> vector = values;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(vector, joinPoint);
            return vector;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean compareResults(AS400 aS400, Vector vector, Vector vector2) throws Exception {
        AS400 aS4002 = aS400;
        Vector vector3 = vector;
        Vector vector4 = vector2;
        Object[] objectArray = new Object[]{aS4002, vector3, vector4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        try {
            boolean bl;
            void actualValues;
            void infos;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (infos.size() != actualValues.size()) {
                bl = false;
            } else {
                boolean result = true;
                int i = 0;
                while (i < infos.size()) {
                    if (!result) break;
                    this.m_sSystemValueName = ((String[])infos.elementAt(i))[0];
                    this.m_sSystemValue = ((String[])infos.elementAt(i))[1];
                    this.m_sComparator = ((String[])infos.elementAt(i))[2];
                    SystemValueInfo obj = SystemValueList.getSysValueInfo(this.m_sSystemValueName);
                    switch (obj.getType()) {
                        case 4: {
                            String[] values = (String[])actualValues.elementAt(i);
                            StringBuffer arrayValues = new StringBuffer();
                            int j = 0;
                            while (j < values.length) {
                                arrayValues.append(String.valueOf(values[j].toString().trim()) + S_SYSVALUE_SEPARATOR);
                                ++j;
                            }
                            this.m_sActualValue = arrayValues.toString();
                            result &= this.checkSysValueArray(this.m_sActualValue, this.m_sSystemValue, this.m_sComparator);
                            break;
                        }
                        case 5: {
                            java.util.Date actualDate = (java.util.Date)actualValues.elementAt(i);
                            this.m_sActualValue = actualDate.toString();
                            result &= this.checkSysValueDate(actualDate, this.m_sSystemValue, this.m_sComparator);
                            break;
                        }
                        case 2: {
                            BigDecimal actualDecimal = (BigDecimal)actualValues.elementAt(i);
                            this.m_sActualValue = actualDecimal.toString();
                            result &= this.checkSysValueDecimal(actualDecimal, new BigDecimal(this.m_sSystemValue), this.m_sComparator);
                            break;
                        }
                        case 3: {
                            Integer actualInteger = (Integer)actualValues.elementAt(i);
                            this.m_sActualValue = actualInteger.toString();
                            result &= this.checkSysValueInteger(actualInteger, new Integer(this.m_sSystemValue), this.m_sComparator);
                            break;
                        }
                        case 1: {
                            this.m_sActualValue = (String)actualValues.elementAt(i);
                            result &= this.checkSysValueString(this.m_sActualValue, this.m_sSystemValue, this.m_sComparator);
                            break;
                        }
                        default: {
                            result &= false;
                        }
                    }
                    ++i;
                }
                bl = result;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkSysValueString(String string, String string2, String string3) {
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        Object[] objectArray = new Object[]{string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void recommendValue;
            void actualValue;
            void comparator;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = comparator.equalsIgnoreCase(S_LESS_THAN) ? Integer.parseInt((String)actualValue) < Integer.parseInt((String)recommendValue) : (comparator.equalsIgnoreCase(S_LESS_EQUAL) ? Integer.parseInt((String)actualValue) <= Integer.parseInt((String)recommendValue) : (comparator.equalsIgnoreCase(S_GREATER_THAN) ? Integer.parseInt((String)actualValue) > Integer.parseInt((String)recommendValue) : (comparator.equalsIgnoreCase(S_GREATER_EQUAL) ? Integer.parseInt((String)actualValue) >= Integer.parseInt((String)recommendValue) : (comparator.equalsIgnoreCase(S_EQUAL) ? actualValue.equalsIgnoreCase((String)recommendValue) : (comparator.equalsIgnoreCase(S_NOT_EQUAL) ? !actualValue.equalsIgnoreCase((String)recommendValue) : (comparator.equalsIgnoreCase(S_IN) ? recommendValue.indexOf((String)actualValue) != -1 : (comparator.equalsIgnoreCase(S_NOT_IN) ? recommendValue.indexOf((String)actualValue) == -1 : false)))))));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkSysValueInteger(Integer n, Integer n2, String string) {
        Integer n3 = n;
        Integer n4 = n2;
        String string2 = string;
        Object[] objectArray = new Object[]{n3, n4, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void recommendValue;
            void actualValue;
            void comparator;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = comparator.equalsIgnoreCase(S_LESS_THAN) ? actualValue.compareTo((Integer)recommendValue) < 0 : (comparator.equalsIgnoreCase(S_LESS_EQUAL) ? actualValue.compareTo((Integer)recommendValue) <= 0 : (comparator.equalsIgnoreCase(S_EQUAL) ? actualValue.compareTo((Integer)recommendValue) == 0 : (comparator.equalsIgnoreCase(S_GREATER_THAN) ? actualValue.compareTo((Integer)recommendValue) > 0 : (comparator.equalsIgnoreCase(S_GREATER_EQUAL) ? actualValue.compareTo((Integer)recommendValue) >= 0 : (comparator.equalsIgnoreCase(S_NOT_EQUAL) ? actualValue.compareTo((Integer)recommendValue) != 0 : false)))));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkSysValueDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) {
        BigDecimal bigDecimal3 = bigDecimal;
        BigDecimal bigDecimal4 = bigDecimal2;
        String string2 = string;
        Object[] objectArray = new Object[]{bigDecimal3, bigDecimal4, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void recommendValue;
            void actualValue;
            void comparator;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = comparator.equalsIgnoreCase(S_LESS_THAN) ? actualValue.compareTo((BigDecimal)recommendValue) < 0 : (comparator.equalsIgnoreCase(S_LESS_EQUAL) ? actualValue.compareTo((BigDecimal)recommendValue) <= 0 : (comparator.equalsIgnoreCase(S_EQUAL) ? actualValue.compareTo((BigDecimal)recommendValue) == 0 : (comparator.equalsIgnoreCase(S_GREATER_THAN) ? actualValue.compareTo((BigDecimal)recommendValue) > 0 : (comparator.equalsIgnoreCase(S_GREATER_EQUAL) ? actualValue.compareTo((BigDecimal)recommendValue) >= 0 : (comparator.equalsIgnoreCase(S_NOT_EQUAL) ? actualValue.compareTo((BigDecimal)recommendValue) != 0 : false)))));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkSysValueDate(java.util.Date date, String string, String string2) throws Exception {
        java.util.Date date2 = date;
        String string3 = string;
        String string4 = string2;
        Object[] objectArray = new Object[]{date2, string3, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void actualValue;
            void comparator;
            void recommendValue;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            java.util.Date recommendDate = DateFormat.getDateInstance().parse((String)recommendValue);
            boolean bl = comparator.equalsIgnoreCase(S_LESS_THAN) ? actualValue.compareTo(recommendDate) < 0 : (comparator.equalsIgnoreCase(S_LESS_EQUAL) ? actualValue.compareTo(recommendDate) <= 0 : (comparator.equalsIgnoreCase(S_EQUAL) ? actualValue.compareTo(recommendDate) == 0 : (comparator.equalsIgnoreCase(S_GREATER_THAN) ? actualValue.compareTo(recommendDate) > 0 : (comparator.equalsIgnoreCase(S_GREATER_EQUAL) ? actualValue.compareTo(recommendDate) >= 0 : (comparator.equalsIgnoreCase(S_NOT_EQUAL) ? actualValue.compareTo(recommendDate) != 0 : false)))));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkSysValueArray(String string, String string2, String string3) {
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        Object[] objectArray = new Object[]{string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
        try {
            boolean bl;
            void comparator;
            void recommendValue;
            void actualValue;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            StringTokenizer parseString = new StringTokenizer((String)actualValue, S_SYSVALUE_SEPARATOR);
            Vector<String> actualValues = new Vector<String>();
            while (parseString.hasMoreTokens()) {
                actualValues.add(parseString.nextToken());
            }
            parseString = new StringTokenizer((String)recommendValue, S_SYSVALUE_SEPARATOR);
            Vector<String> recommendValues = new Vector<String>();
            while (parseString.hasMoreTokens()) {
                recommendValues.add(parseString.nextToken());
            }
            if (comparator.equalsIgnoreCase(S_EQUAL) || comparator.equalsIgnoreCase(S_NOT_EQUAL)) {
                boolean result = false;
                if (actualValues.size() != recommendValues.size()) {
                    result = false;
                } else {
                    int i = 0;
                    while (i < recommendValues.size()) {
                        if (actualValues.contains(recommendValues.elementAt(i))) {
                            actualValues.remove(recommendValues.elementAt(i));
                        } else {
                            result = false;
                        }
                        ++i;
                    }
                    result = actualValues.size() == 0;
                }
                bl = comparator.equalsIgnoreCase(S_EQUAL) ? result : !result;
            } else if (comparator.equalsIgnoreCase(S_IN) || comparator.equalsIgnoreCase(S_NOT_IN)) {
                boolean result = false;
                if (actualValues.size() > recommendValues.size()) {
                    result = false;
                } else {
                    int i = 0;
                    while (i < recommendValues.size()) {
                        if (actualValues.contains(recommendValues.elementAt(i))) {
                            actualValues.remove(recommendValues.elementAt(i));
                        }
                        ++i;
                    }
                    result = actualValues.size() == 0;
                }
                bl = comparator.equalsIgnoreCase(S_IN) ? result : !result;
            } else {
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private String getReqSystemValues() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = this.getParamValue(S_REQSYSTEMVALUES);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_REQUIRED_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_REQUIRED_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_EMPTY;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_EMPTY;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

