/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.product;

import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.nifstack.NIFStack;
import com.ibm.ws.install.ni.framework.prereq.PrereqPlugin;
import com.ibm.ws.install.ni.framework.product.ProductPlugin;
import com.ibm.ws.install.ni.framework.product.VersionUtils;
import com.ibm.ws.install.ni.framework.resourcebundle.NIFResourceBundleUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.xml.sax.SAXException;

public class DetectAndHandleIncrementalInstallPrereqPlugin
extends PrereqPlugin {
    private Vector m_vsAllNotInStackFeatures;
    private Vector m_vsAllInStackFeatures;
    private static final String S_PRODUCTGAVERSION_PARAM = "productgaversion";
    private static final String S_PRODUCTCURRENTVERSION_PARAM = "productcurrentversion";
    private static final String S_ACCEPTABLEVERSIONS_PARAM = "acceptableversions";
    private static final String S_COMPONENTMAPREPOSITORY_PARAM = "componentmaprepository";
    private static final String S_BACKUPPATHURI_PARAM = "backuppathuri";
    private static final String S_ALLINSTALLEDPRODUCTFEATURES_PARAM = "allinstalledproductfeatures";
    private static final String S_ISBACKUPPACKAGE_PARAM = "isbackuppackage";
    private static final String S_MAINTENANCENAME_PARAM = "maintenancename";
    private static final String S_FEATUREPREREQFAILUREMESSAGE_MESSAGE_KEY = "DetectAndHandleIncrementalInstallPrereqPlugin.featurePrereqFailureMessage";
    private static final String S_FEATUREPREREQFAILUREMESSAGE_FIXPACK_MESSAGE_KEY = "DetectAndHandleIncrementalInstallPrereqPlugin.featurePrereqFailureMessage.fixpack";
    private static final String S_EMPTY = "";
    private static final String[] AS_REQUIRED_PARAMS;
    private static final String[] AS_OPTIONAL_PARAMS;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;

    static {
        Factory factory = new Factory("DetectAndHandleIncrementalInstallPrereqPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.product.DetectAndHandleIncrementalInstallPrereqPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.product.DetectAndHandleIncrementalInstallPrereqPlugin----"), 285);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFlag-com.ibm.ws.install.ni.framework.product.DetectAndHandleIncrementalInstallPrereqPlugin----java.lang.String-"), 42);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isThisABackupPackage-com.ibm.ws.install.ni.framework.product.DetectAndHandleIncrementalInstallPrereqPlugin----boolean-"), 240);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-hasAnyRefreshPackInstalled-com.ibm.ws.install.ni.framework.product.DetectAndHandleIncrementalInstallPrereqPlugin----boolean-"), 252);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-hasCurrentMaintenancePackageAlreadyInstalled-com.ibm.ws.install.ni.framework.product.DetectAndHandleIncrementalInstallPrereqPlugin---javax.xml.parsers.ParserConfigurationException:java.net.URISyntaxException:org.xml.sax.SAXException:java.io.IOException:-boolean-"), 267);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPrereqFailureMessage-com.ibm.ws.install.ni.framework.product.DetectAndHandleIncrementalInstallPrereqPlugin----java.lang.String-"), 80);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.product.DetectAndHandleIncrementalInstallPrereqPlugin----[Ljava.lang.String;-"), 105);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.product.DetectAndHandleIncrementalInstallPrereqPlugin----[Ljava.lang.String;-"), 115);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-openMaintenanceStackIfItIsNotOpenedYet-com.ibm.ws.install.ni.framework.product.DetectAndHandleIncrementalInstallPrereqPlugin---java.io.IOException:org.xml.sax.SAXException:javax.xml.parsers.ParserConfigurationException:java.net.URISyntaxException:-void-"), 123);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-doAllCurrentFeaturesHaveTheSameVersion-com.ibm.ws.install.ni.framework.product.DetectAndHandleIncrementalInstallPrereqPlugin---java.io.IOException:org.xml.sax.SAXException:javax.xml.parsers.ParserConfigurationException:java.net.URISyntaxException:-boolean-"), 144);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getAllInStackFeatures-com.ibm.ws.install.ni.framework.product.DetectAndHandleIncrementalInstallPrereqPlugin-java.util.Vector:-vsAllCurrentFeatures:-java.io.IOException:org.xml.sax.SAXException:javax.xml.parsers.ParserConfigurationException:java.net.URISyntaxException:-java.util.Vector-"), 172);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isProductGAVersionAcceptable-com.ibm.ws.install.ni.framework.product.DetectAndHandleIncrementalInstallPrereqPlugin----boolean-"), 204);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-removesFromVector1AllElementsContainedInVector2-com.ibm.ws.install.ni.framework.product.DetectAndHandleIncrementalInstallPrereqPlugin-java.util.Vector:java.util.Vector:-vector1:vector2:--java.util.Vector-"), 226);
        AS_REQUIRED_PARAMS = new String[]{S_PRODUCTGAVERSION_PARAM, S_PRODUCTCURRENTVERSION_PARAM, S_ACCEPTABLEVERSIONS_PARAM, S_COMPONENTMAPREPOSITORY_PARAM, S_BACKUPPATHURI_PARAM, S_ALLINSTALLEDPRODUCTFEATURES_PARAM, S_ISBACKUPPACKAGE_PARAM};
        AS_OPTIONAL_PARAMS = new String[]{S_MAINTENANCENAME_PARAM};
    }

    public DetectAndHandleIncrementalInstallPrereqPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.m_vsAllNotInStackFeatures = null;
            this.m_vsAllInStackFeatures = null;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getFlag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            if (this.isThisABackupPackage()) {
                string = Boolean.TRUE.toString();
            } else {
                boolean fSuccess = true;
                try {
                    if (!this.doAllCurrentFeaturesHaveTheSameVersion() && (fSuccess = this.isProductGAVersionAcceptable())) {
                        fSuccess = !this.hasCurrentMaintenancePackageAlreadyInstalled();
                    }
                }
                catch (Exception exception) {
                    this.m_fUnexpectedExceptionOccured = true;
                    fSuccess = false;
                }
                string = new Boolean(fSuccess).toString();
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getPrereqFailureMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            String sMessage = null;
            sMessage = this.hasAnyRefreshPackInstalled() ? NIFResourceBundleUtils.getLocaleString(S_FEATUREPREREQFAILUREMESSAGE_MESSAGE_KEY, (String)this.m_vsAllNotInStackFeatures.elementAt(0)) : NIFResourceBundleUtils.getLocaleString(S_FEATUREPREREQFAILUREMESSAGE_FIXPACK_MESSAGE_KEY, (String)this.m_vsAllNotInStackFeatures.elementAt(0));
            String string = sMessage;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_OPTIONAL_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_OPTIONAL_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_REQUIRED_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_REQUIRED_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private void openMaintenanceStackIfItIsNotOpenedYet() throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (!NIFStack.isOpen()) {
                NIFStack.open(new FileSystemEntry(new URI(this.getParamValue(S_BACKUPPATHURI_PARAM)), this.getInstallToolkitBridge()), this.getInstallToolkitBridge());
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean doAllCurrentFeaturesHaveTheSameVersion() throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Vector vsAllCurrentFeatures = this.getExpandedParams(this.getParamValue(S_ALLINSTALLEDPRODUCTFEATURES_PARAM));
            this.m_vsAllInStackFeatures = this.getAllInStackFeatures(vsAllCurrentFeatures);
            this.m_vsAllNotInStackFeatures = this.removesFromVector1AllElementsContainedInVector2(vsAllCurrentFeatures, this.m_vsAllInStackFeatures);
            boolean bl = this.m_vsAllInStackFeatures.isEmpty() ? true : this.m_vsAllNotInStackFeatures.isEmpty();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Vector getAllInStackFeatures(Vector vector) throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        Vector vector2 = vector;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)vector2);
        try {
            void vsAllCurrentFeatures;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.openMaintenanceStackIfItIsNotOpenedYet();
            String sCurrentOffering = ProductPlugin.getCurrentProductOffering();
            Vector vsAllInstackFeaturesForThisProduct = NIFStack.findAllFeaturesInStackForThisOffering(sCurrentOffering);
            Vector<String> vsAllInStackFeaturesToBeConsidered = new Vector<String>();
            int i = 0;
            while (i < vsAllCurrentFeatures.size()) {
                String sFeatureThis = (String)vsAllCurrentFeatures.elementAt(i);
                if (vsAllInstackFeaturesForThisProduct.contains(sFeatureThis)) {
                    vsAllInStackFeaturesToBeConsidered.addElement(sFeatureThis);
                }
                ++i;
            }
            Vector<String> vector3 = vsAllInStackFeaturesToBeConsidered;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(vector3, joinPoint);
            return vector3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isProductGAVersionAcceptable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sProductGAVersion = this.getParamValue(S_PRODUCTGAVERSION_PARAM);
            String sRequiredVersions = this.getParamValue(S_ACCEPTABLEVERSIONS_PARAM);
            boolean bl = VersionUtils.isVersionAcceptableToTheseVersionParams(sProductGAVersion, sRequiredVersions);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Vector removesFromVector1AllElementsContainedInVector2(Vector vector, Vector vector2) {
        Vector vector3 = vector;
        Vector vector4 = vector2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)vector3, (Object)vector4);
        try {
            void vector22;
            void vector1;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            vector1.removeAll((Collection<?>)vector22);
            void var6_6 = vector1;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(var6_6, joinPoint);
            return var6_6;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isThisABackupPackage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = Boolean.valueOf(this.getParamValue(S_ISBACKUPPACKAGE_PARAM));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean hasAnyRefreshPackInstalled() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sCurrentVersion = this.getParamValue(S_PRODUCTCURRENTVERSION_PARAM);
            boolean bl = VersionUtils.isTheThirdDigitGreaterThanOrEqualToOne(sCurrentVersion);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean hasCurrentMaintenancePackageAlreadyInstalled() throws ParserConfigurationException, URISyntaxException, SAXException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.openMaintenanceStackIfItIsNotOpenedYet();
            String sMaintenanceName = this.getParamValue(S_MAINTENANCENAME_PARAM);
            boolean bl = sMaintenanceName == null ? false : NIFStack.isElementAlreadyThere(sMaintenanceName);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

