/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.registry;

import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.logging.LoggingPlugin;
import com.ibm.ws.install.ni.framework.registry.NIFRegistryDirectory;
import com.ibm.ws.install.ni.framework.registry.NIFRegistryOfferingEntry;
import com.ibm.ws.install.ni.framework.registry.NIFRegistryPAKEntry;
import com.ibm.ws.install.ni.framework.utils.URIUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class NIFRegistryMergerDelta {
    protected Vector m_vnifroeAddToCorrectReg;
    protected Vector m_vnifroeRemoveFromCorrectReg;
    protected LinkedHashMap m_lhmCorrectRegEntries;
    protected LinkedHashMap m_lhmRegToMergeEntries;
    protected LinkedHashMap m_lhmMergedEntries;
    protected InstallToolkitBridge m_itb;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;

    public NIFRegistryMergerDelta(LinkedHashMap lhmCorrectRegEntries, LinkedHashMap lhmRegToMergeEntries, InstallToolkitBridge itb) throws IOException, URISyntaxException, ParseException {
        LinkedHashMap linkedHashMap = lhmCorrectRegEntries;
        LinkedHashMap linkedHashMap2 = lhmRegToMergeEntries;
        InstallToolkitBridge installToolkitBridge = itb;
        Object[] objectArray = new Object[]{linkedHashMap, linkedHashMap2, installToolkitBridge};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.m_vnifroeAddToCorrectReg = new Vector();
            this.m_vnifroeRemoveFromCorrectReg = new Vector();
            this.m_lhmCorrectRegEntries = null;
            this.m_lhmRegToMergeEntries = null;
            this.m_lhmMergedEntries = null;
            this.m_itb = null;
            this.m_lhmCorrectRegEntries = lhmCorrectRegEntries;
            this.m_lhmRegToMergeEntries = lhmRegToMergeEntries;
            this.m_lhmMergedEntries = this.cloneLinkedHashMapEntries(this.m_lhmCorrectRegEntries);
            this.m_itb = itb;
            this.merge();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public Vector getRegistryObjectVectorAddToCorrectRegistry() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Vector vector = this.m_vnifroeAddToCorrectReg;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(vector, joinPoint);
            return vector;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public Vector getRegistryObjectVectorRemoveFromCorrectRegistry() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Vector vector = this.m_vnifroeRemoveFromCorrectReg;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(vector, joinPoint);
            return vector;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public LinkedHashMap getMergedRegistry() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            LinkedHashMap linkedHashMap = this.m_lhmMergedEntries;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(linkedHashMap, joinPoint);
            return linkedHashMap;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected void merge() throws IOException, URISyntaxException, ParseException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sMsg = null;
            Vector vnifroeFromCorrectReg = new Vector(this.m_lhmCorrectRegEntries.keySet());
            Vector vnifroeFromRegToMerge = new Vector(this.m_lhmRegToMergeEntries.keySet());
            int i = 0;
            while (i < vnifroeFromCorrectReg.size()) {
                NIFRegistryOfferingEntry nifroeFromCorrectReg = (NIFRegistryOfferingEntry)vnifroeFromCorrectReg.get(i);
                String sOffering = nifroeFromCorrectReg.getOffering();
                String sInstallLocationPath = nifroeFromCorrectReg.getOfferingLocationPath();
                NIFRegistryOfferingEntry nifroeTemp = new NIFRegistryOfferingEntry(sOffering, sInstallLocationPath, null, null);
                int j = 0;
                boolean bFoundMatchOffering = false;
                while (j < vnifroeFromRegToMerge.size() && !bFoundMatchOffering) {
                    NIFRegistryOfferingEntry nifroeFromRegToMerge = (NIFRegistryOfferingEntry)vnifroeFromRegToMerge.get(j);
                    if (nifroeFromRegToMerge.doesThisOfferingEntryHasTheseAttributes(nifroeTemp)) {
                        Date dateRegToMerge;
                        bFoundMatchOffering = true;
                        Date dateCorrectReg = nifroeFromCorrectReg.getOfferingLastVisitedDate();
                        if (dateCorrectReg.compareTo(dateRegToMerge = nifroeFromRegToMerge.getOfferingLastVisitedDate()) < 0) {
                            Vector vnifrpeCorrectReg = (Vector)this.m_lhmCorrectRegEntries.get(nifroeFromCorrectReg);
                            this.m_vnifroeRemoveFromCorrectReg.addAll(vnifrpeCorrectReg);
                            this.m_vnifroeRemoveFromCorrectReg.add(nifroeFromCorrectReg);
                            this.m_lhmMergedEntries.remove(nifroeFromCorrectReg);
                            sMsg = "\nThis offering and pak entries are removed from correct registry as they are out-dated.\nOffering: " + nifroeFromCorrectReg.getOffering() + "\nInstall Location: " + nifroeFromCorrectReg.getOfferingLocationPath();
                            LoggingPlugin.logMessage(3, this.getClass().getName(), "merge()", "\n" + sMsg);
                            Vector vnifrpeRegToMerge = (Vector)this.m_lhmRegToMergeEntries.get(nifroeFromRegToMerge);
                            this.m_vnifroeAddToCorrectReg.addAll(vnifrpeRegToMerge);
                            this.m_vnifroeAddToCorrectReg.add(nifroeFromRegToMerge);
                            this.m_lhmMergedEntries.put(nifroeFromRegToMerge, vnifrpeRegToMerge);
                            sMsg = "\nThis offering and pak entries are added to correct registry as they are up-to-date.\nOffering: " + nifroeFromRegToMerge.getOffering() + "\nInstall Location: " + nifroeFromRegToMerge.getOfferingLocationPath();
                            LoggingPlugin.logMessage(3, this.getClass().getName(), "merge()", "\n" + sMsg);
                        }
                        this.m_lhmCorrectRegEntries.remove(nifroeFromCorrectReg);
                        this.m_lhmRegToMergeEntries.remove(nifroeFromRegToMerge);
                    }
                    ++j;
                }
                ++i;
            }
            Iterator itCorrectRegOffering = this.m_lhmCorrectRegEntries.keySet().iterator();
            while (itCorrectRegOffering.hasNext()) {
                NIFRegistryOfferingEntry nifroeThis = (NIFRegistryOfferingEntry)itCorrectRegOffering.next();
                URI uriInstallLocation = URIUtils.convertPathToDefaultTargetMachineFSURI(nifroeThis.getOfferingLocationPath(), this.m_itb);
                NIFRegistryDirectory nifrdThisLocation = NIFRegistryDirectory.getNIFRegistryDirectoryInstance(uriInstallLocation, this.m_itb);
                if (nifrdThisLocation == null || nifrdThisLocation.isThisProductInstalled(nifroeThis.getOffering())) continue;
                Vector vnifrpeThisOffering = (Vector)this.m_lhmCorrectRegEntries.get(nifroeThis);
                int i2 = 0;
                while (i2 < vnifrpeThisOffering.size()) {
                    NIFRegistryPAKEntry nifrpeThis = (NIFRegistryPAKEntry)vnifrpeThisOffering.get(i2);
                    this.m_vnifroeRemoveFromCorrectReg.add(nifrpeThis);
                    ((Vector)this.m_lhmMergedEntries.get(nifroeThis)).remove(nifrpeThis);
                    sMsg = "This pak entry is removed from correct registry as it does not exist.\nBackup pak location: " + nifrpeThis.getBackupPakLocationPath();
                    LoggingPlugin.logMessage(3, this.getClass().getName(), "merge()", "\n" + sMsg);
                    ++i2;
                }
                this.m_vnifroeRemoveFromCorrectReg.add(nifroeThis);
                this.m_lhmMergedEntries.remove(nifroeThis);
                sMsg = "This offering entry is removed from correct registry as all its paks do not exist.\n\nOffering: " + nifroeThis.getOffering() + "\nInstall Location: " + nifroeThis.getOfferingLocationPath();
                LoggingPlugin.logMessage(3, this.getClass().getName(), "merge()", "\n" + sMsg);
            }
            Iterator itRegToMergeOffering = this.m_lhmRegToMergeEntries.keySet().iterator();
            while (itRegToMergeOffering.hasNext()) {
                Vector<NIFRegistryPAKEntry> vPakEntryAddToMergedRegistry = new Vector<NIFRegistryPAKEntry>();
                NIFRegistryOfferingEntry nifroeThis = (NIFRegistryOfferingEntry)itRegToMergeOffering.next();
                URI uriInstallLocation = URIUtils.convertPathToDefaultTargetMachineFSURI(nifroeThis.getOfferingLocationPath(), this.m_itb);
                NIFRegistryDirectory nifrdThisLocation = NIFRegistryDirectory.getNIFRegistryDirectoryInstance(uriInstallLocation, this.m_itb);
                if (nifrdThisLocation == null || !nifrdThisLocation.isThisProductInstalled(nifroeThis.getOffering())) continue;
                Vector vnifrpeThisOffering = (Vector)this.m_lhmRegToMergeEntries.get(nifroeThis);
                int i3 = 0;
                while (i3 < vnifrpeThisOffering.size()) {
                    NIFRegistryPAKEntry nifrpeThis = (NIFRegistryPAKEntry)vnifrpeThisOffering.get(i3);
                    FileSystemEntry fseThisPak = URIUtils.convertPathToDefaultTargetMachineFSE(nifrpeThis.getBackupPakLocationPath(), this.m_itb);
                    if (fseThisPak.exists()) {
                        this.m_vnifroeAddToCorrectReg.add(nifrpeThis);
                        vPakEntryAddToMergedRegistry.add(nifrpeThis);
                        sMsg = "This pak entry is added to correct registry from registry-to-merge as it exists.\nBackup pak location: " + nifrpeThis.getBackupPakLocationPath();
                        LoggingPlugin.logMessage(3, this.getClass().getName(), "merge()", "\n" + sMsg);
                    }
                    ++i3;
                }
                this.m_vnifroeAddToCorrectReg.add(nifroeThis);
                this.m_lhmMergedEntries.put(nifroeThis, vPakEntryAddToMergedRegistry);
                sMsg = "This offering entry is added to correct registry as its paks exist.\n\nOffering: " + nifroeThis.getOffering() + "\nInstall Location: " + nifroeThis.getOfferingLocationPath();
                LoggingPlugin.logMessage(3, this.getClass().getName(), "merge()", "\n" + sMsg);
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private LinkedHashMap cloneLinkedHashMapEntries(LinkedHashMap linkedHashMap) {
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)linkedHashMap2);
        try {
            void lhmSource;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            LinkedHashMap lhmReturn = new LinkedHashMap(lhmSource);
            Vector vOffering = new Vector(lhmSource.keySet());
            int i = 0;
            while (i < vOffering.size()) {
                Vector vPaks = new Vector((Vector)lhmSource.get(vOffering.get(i)));
                lhmReturn.put(vOffering.get(i), vPaks);
                ++i;
            }
            LinkedHashMap linkedHashMap3 = lhmReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(linkedHashMap3, joinPoint);
            return linkedHashMap3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("NIFRegistryMergerDelta.java", Class.forName("com.ibm.ws.install.ni.framework.registry.NIFRegistryMergerDelta"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.registry.NIFRegistryMergerDelta-java.util.LinkedHashMap:java.util.LinkedHashMap:com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge:-lhmCorrectRegEntries:lhmRegToMergeEntries:itb:-java.io.IOException:java.net.URISyntaxException:java.text.ParseException:-"), 65);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getRegistryObjectVectorAddToCorrectRegistry-com.ibm.ws.install.ni.framework.registry.NIFRegistryMergerDelta----java.util.Vector-"), 89);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getRegistryObjectVectorRemoveFromCorrectRegistry-com.ibm.ws.install.ni.framework.registry.NIFRegistryMergerDelta----java.util.Vector-"), 101);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getMergedRegistry-com.ibm.ws.install.ni.framework.registry.NIFRegistryMergerDelta----java.util.LinkedHashMap-"), 111);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-merge-com.ibm.ws.install.ni.framework.registry.NIFRegistryMergerDelta---java.io.IOException:java.net.URISyntaxException:java.text.ParseException:-void-"), 143);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-cloneLinkedHashMapEntries-com.ibm.ws.install.ni.framework.registry.NIFRegistryMergerDelta-java.util.LinkedHashMap:-lhmSource:--java.util.LinkedHashMap-"), 395);
    }
}

