/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.registry;

import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.logging.LoggingPlugin;
import com.ibm.ws.install.ni.framework.registry.NIFRegistryProductInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class NIFRegistryProductFile {
    private FileSystemEntry m_fseProductFile;
    private Vector m_vProductInfoVec;
    private static final String PATTERN_PRODUCT_NODE = "<product\\s*(.*?)\\s*</product>";
    private static final String PATTERN_NAME = "name=\"(.*?)\"";
    private static final String PATTERN_ID = "<id>\\s*(.*?)\\s*</id>";
    private static final String PATTERN_VERSION = "<version>\\s*(.*?)\\s*</version>";
    private static final String PATTERN_DATE = "date=\"(.*?)\"";
    private static final String PATTERN_LEVEL = "level=\"(.*?)\"";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;

    public NIFRegistryProductFile(FileSystemEntry fseProductFile) {
        FileSystemEntry fileSystemEntry = fseProductFile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)fileSystemEntry);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.m_fseProductFile = null;
            this.m_vProductInfoVec = new Vector(1);
            this.m_fseProductFile = fseProductFile;
            this.parse();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public NIFRegistryProductInfo[] getProductInfoArray() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFRegistryProductInfo[] awaspiThis = new NIFRegistryProductInfo[this.m_vProductInfoVec.size()];
            int i = 0;
            while (i < awaspiThis.length) {
                awaspiThis[i] = (NIFRegistryProductInfo)this.m_vProductInfoVec.elementAt(i);
                ++i;
            }
            NIFRegistryProductInfo[] nIFRegistryProductInfoArray = awaspiThis;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(nIFRegistryProductInfoArray, joinPoint);
            return awaspiThis;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private void parse() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sFileContent = this.readFile(this.m_fseProductFile);
            if (sFileContent != null) {
                Pattern productPattern = Pattern.compile(PATTERN_PRODUCT_NODE, 32);
                Matcher productMatcher = productPattern.matcher(sFileContent);
                while (productMatcher.find()) {
                    String productString = productMatcher.group();
                    this.parseProductString(productString);
                }
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseProductString(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string2);
        try {
            void productString;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String name = "";
            String id = "";
            String version = "";
            String date = "";
            String level = "";
            Pattern pattern = Pattern.compile(PATTERN_NAME, 32);
            Matcher matcher = pattern.matcher((CharSequence)productString);
            if (matcher.find()) {
                String nameString = matcher.group();
                name = nameString.substring(nameString.indexOf(34) + 1, nameString.lastIndexOf(34));
            }
            if ((matcher = (pattern = Pattern.compile(PATTERN_ID, 32)).matcher((CharSequence)productString)).find()) {
                String idString = matcher.group();
                id = idString.substring(idString.indexOf("<id>") + 4, idString.indexOf("</id>"));
            }
            if ((matcher = (pattern = Pattern.compile(PATTERN_VERSION, 32)).matcher((CharSequence)productString)).find()) {
                String versionString = matcher.group();
                version = versionString.substring(versionString.indexOf("<version>") + 9, versionString.indexOf("</version>"));
            }
            if ((matcher = (pattern = Pattern.compile(PATTERN_DATE, 32)).matcher((CharSequence)productString)).find()) {
                String dateString = matcher.group();
                date = dateString.substring(dateString.indexOf(34) + 1, dateString.lastIndexOf(34));
            }
            if ((matcher = (pattern = Pattern.compile(PATTERN_LEVEL, 32)).matcher((CharSequence)productString)).find()) {
                String levelString = matcher.group();
                level = levelString.substring(levelString.indexOf(34) + 1, levelString.lastIndexOf(34));
            }
            NIFRegistryProductInfo info = new NIFRegistryProductInfo(name, id, version, date, level);
            this.m_vProductInfoVec.addElement(info);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String readFile(FileSystemEntry fileSystemEntry) {
        FileSystemEntry fileSystemEntry2 = fileSystemEntry;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)fileSystemEntry2);
        try {
            void fseProductFile;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String fileContents = null;
            try {
                InputStream inputStream = fseProductFile.getInputStream();
                byte[] abTotal = new byte[inputStream.available()];
                inputStream.read(abTotal);
                fileContents = new String(abTotal, "UTF-8");
                inputStream.close();
            }
            catch (IOException iOException) {
                String sMsg = "Can not get input stream of this file: " + fseProductFile.toString();
                LoggingPlugin.logMessage(3, "NIFRegistryProductFile", "readFile()", sMsg);
            }
            String string = fileContents;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("NIFRegistryProductFile.java", Class.forName("com.ibm.ws.install.ni.framework.registry.NIFRegistryProductFile"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.registry.NIFRegistryProductFile-com.ibm.ws.install.ni.framework.io.FileSystemEntry:-fseProductFile:--"), 54);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getProductInfoArray-com.ibm.ws.install.ni.framework.registry.NIFRegistryProductFile----[Lcom.ibm.ws.install.ni.framework.registry.NIFRegistryProductInfo;-"), 65);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-parse-com.ibm.ws.install.ni.framework.registry.NIFRegistryProductFile----void-"), 81);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-parseProductString-com.ibm.ws.install.ni.framework.registry.NIFRegistryProductFile-java.lang.String:-productString:--void-"), 105);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-readFile-com.ibm.ws.install.ni.framework.registry.NIFRegistryProductFile-com.ibm.ws.install.ni.framework.io.FileSystemEntry:-fseProductFile:--java.lang.String-"), 161);
    }
}

