/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.registry;

import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.os.PlatformConstants;
import com.ibm.ws.install.ni.framework.registry.NIFRegistry;
import com.ibm.ws.install.ni.framework.registry.NIFRegistryHelper;
import com.ibm.ws.install.ni.framework.registry.NIFRegistryOfferingEntry;
import com.ibm.ws.install.ni.framework.registry.NIFRegistryPAKEntry;
import com.ibm.ws.install.ni.framework.resourcebundle.NIFResourceBundleUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.w3c.dom.Document;

public class NIFRegistryUtils {
    private static final String S_NIFREGISTRY_FILE_NAME = ".nifregistry";
    private static final String S_DASH = "-";
    private static final String S_EMPTY = "";
    private static final int N_COMMAND_TYPE_INVALID = 0;
    private static final int N_COMMAND_TYPE_CLEAN_ALL = 10;
    private static final int N_COMMAND_TYPE_CLEAN_PRODUCT = 20;
    private static final int N_COMMAND_TYPE_CLEAN_PACKAGE = 30;
    private static final int N_COMMAND_TYPE_LIST_PRODUCTS = 40;
    private static final int N_COMMAND_TYPE_LIST_PACKAGES = 50;
    private static final int N_COMMAND_TYPE_SHOW_NIFREGISTRY_LOCATION_FOR_SUPPORT = 60;
    private static final String S_PARAM_CLEAN_ALL = "-cleanall";
    private static final String S_PARAM_CLEAN_PRODUCT = "-cleanproduct";
    private static final String S_PARAM_CLEAN_PACKAGE = "-cleanpackage";
    private static final String S_PARAM_OFFERING = "-offering";
    private static final String S_PARAM_PAK_NAME = "-pakname";
    private static final String S_PARAM_INSTALL_LOCATION = "-installlocation";
    private static final String S_PARAM_USER_HOME = "-userhome";
    private static final String S_PARAM_LIST_PRODUCTS = "-listproducts";
    private static final String S_PARAM_LIST_PAKS = "-listpackages";
    private static final String S_PARAM_SHOW_NIFREGISTRY_LOCATION_FOR_SUPPORT = "-shownifregistrylocationforsupport";
    private static final String[] AS_VALID_COMMANDS;
    private static final String[] AS_VALID_INPUT_PARAMS;
    private static final int N_SUCCESS = 0;
    private static final int N_FAIL = -1;
    private static final int N_INVALID_OFFERING = 1;
    private static final int N_USER_HOME_NOT_EXISTS = 2;
    private static final int N_USER_HOME_NO_WRITE_ACCESS = 3;
    private static final int N_NIFREGISTRY_NOT_EXISTS = 4;
    private static final int N_PARSE_NIFREGISTRY_ERROR = 5;
    private static final int N_INSTALL_LOCATION_INVALID_FORMAT = 6;
    private static final int N_OFFERING_IN_THIS_INSTALL_LOCATION_NOT_EXISTS = 7;
    private static final int N_PAK_IN_THIS_INSTALL_LOCATION_NOT_EXISTS = 8;
    private static final int N_CLEAN_ALL_FAILED = 9;
    private static final int N_CLEAN_OFFERING_FAILED = 10;
    private static final int N_CLEAN_PAK_FAILED = 11;
    private static final int N_LIST_PRODUCTS_FAILED = 12;
    private static final int N_LIST_PAKS_FAILED = 13;
    private static final int N_CLEANUP_SUCCESS = 14;
    private static final int N_SHOW_NIFREGISTRY_LOCATION = 15;
    private static final String S_CORRECT_COMMAND_USAGE_MESSAGE_TEXT_KEY = "NIFRegistryUtils.correctCommandUsageMessageText";
    private static final String S_INVALID_OFFERING_MESSAGE_TEXT_KEY = "NIFRegistryUtils.invalidOfferingMessageText";
    private static final String S_USER_HOME_NOT_EXISTS_MESSAGE_TEXT_KEY = "NIFRegistryUtils.userHomeNotExistsMessageText";
    private static final String S_USER_HOME_NO_WRITE_ACCESS_MESSAGE_TEXT_KEY = "NIFRegistryUtils.userHomeNoWriteAccessMessageText";
    private static final String S_NIFREGISTRY_NOT_EXISTS_MESSAGE_TEXT_KEY = "NIFRegistryUtils.nifregistryNotExistsMessageText";
    private static final String S_PARSE_NIFREGISTRY_ERROR_MESSAGE_TEXT_KEY = "NIFRegistryUtils.parseNIFRegistryErrorMessageText";
    private static final String S_INSTALLATION_LOCATION_INVALID_FORMAT_MESSAGE_TEXT_KEY = "NIFRegistryUtils.installationLocationInvalidFormatMessageText";
    private static final String S_OFFERING_IN_THIS_INSTALL_LOCATION_NOT_EXISTS_MESSAGE_TEXT_KEY = "NIFRegistryUtils.offeringInThisInstallLocationNotExistsMessageText";
    private static final String S_PAK_IN_THIS_INSTALL_LOCATION_NOT_EXISTS_MESSAGE_TEXT_KEY = "NIFRegistryUtils.pakInThisInstallLocationNotExistsMessageText";
    private static final String S_CLEAN_ALL_FAILED_MESSAGE_TEXT_KEY = "NIFRegistryUtils.cleanAllFailedMessageText";
    private static final String S_CLEAN_OFFERING_FAILED_MESSAGE_TEXT_KEY = "NIFRegistryUtils.cleanOfferingFailedMessageText";
    private static final String S_CLEAN_PAK_FAILED_MESSAGE_TEXT_KEY = "NIFRegistryUtils.cleanPAKFailedMessageText";
    private static final String S_LIST_PRODUCTS_FAILED_MESSAGE_TEXT_KEY = "NIFRegistryUtils.listProductsFailedMessageText";
    private static final String S_LIST_PAKS_FAILED_MESSAGE_TEXT_KEY = "NIFRegistryUtils.listPAKsFailedMessageText";
    private static final String S_CLEANUP_SUCCESS_MESSAGE_TEXT_KEY = "NIFRegistryUtils.cleanupSuccessMessageText";
    private static final String S_SHOW_NIFREGISTRY_LOCATION_MESSAGE_TEXT_KEY = "NIFRegistryUtils.nifregistryLocationMessageText";
    private static final String[] AS_MESSAGE_KEY;
    private static final String S_BLANK_LINE = "";
    private static final String S_COPYRIGHT_MESSAGE_TEXT_KEY = "NIFRegistryUtils.copyright";
    private static final String S_WAS_VERSION_MESSAGE_TEXT_KEY = "NIFRegistryUtils.WASVersion";
    private static final String S_REPORTER_VERSION_MESSAGE_KEY = "NIFRegistryUtils.reporterVersion";
    private static final String S_REPORT_HEADER_MESSAGE_TEXT_KEY = "NIFRegistryUtils.reportHeaderMessageText";
    private static final String S_REPORT_FOOTER_MESSAGE_TEXT_KEY = "NIFRegistryUtils.reportFooterMessageText";
    private static final String S_REPORT_DATE_MESSAGE_TEXT_KEY = "NIFRegistryUtils.reportDateMessageText";
    private static final String S_NO_PRODUCTS_AVAILABLE_MESSAGE_TEXT_KEY = "NIFRegistryUtils.noProductsAvailableMessageText";
    private static final String S_NO_PAKS_AVAILABLE_MESSSAGE_TEXT_KEY = "NIFRegistryUtils.noPAKsAvailableMessageText";
    private static final String S_PRODUCT_INSTALLED_MESSAGE_TEXT_KEY = "NIFRegistryUtils.productInstalledMessageText";
    private static final String S_INFORMATION_NOT_AVAILABLE_OS400_MESSAGE_TEXT_KEY = "NIFRegistryUtils.informationNotAvailableOS400MessageText";
    private static final String S_OFFERING_ID_MESSAGE_LABEL_KEY = "NIFRegistryUtils.offeringIDMessageLabel";
    private static final String S_INSTALLATION_LOCATION_MESSAGE_LABEL_KEY = "NIFRegistryUtils.installationLocationMessageLabel";
    private static final String S_VERSION_MESSAGE_LABEL_KEY = "NIFRegistryUtils.versionMessageLabel";
    private static final String S_INSTALLATION_LIBRARY_OS400_MESSAGE_LABEL_KEY = "NIFRegistryUtils.installationLibraryOS400MessageLabel";
    private static final String S_USER_DATA_PATH_OS400_MESSAGE_LABEL_KEY = "NIFRegistryUtils.userDataPathOS400MessageLabel";
    private static final String S_PACKAGE_INSTALLED_MESSAGE_TEXT_KEY = "NIFRegistryUtils.packageInstalledMessageText";
    private static final String S_PACKAGE_NAME_MESSAGE_LABEL_KEY = "NIFRegistryUtils.packageNameMessageLabel";
    private static final String S_PACKAGE_INSTALLATION_LOCATION_MESSAGE_LABEL_KEY = "NIFRegistryUtils.packageInstallationLocationMessageLabel";
    private static final String S_SEPARATOR_MESSAGE_TEXT = "----------------------------------------------------------------------------";
    private static final String S_SPACE_PADDINGS_80 = "                                                                                ";
    private static final int N_LABEL_TYPE_PRODUCTS = 100;
    private static final int N_LABEL_TYPE_PAKS = 110;
    private static final int N_LABEL_INDENT_AMOUNT = 8;
    private static final String S_NIFREGISTRYUTILS_VERSION = "1.8";
    private static final String S_YES = "yes";
    private static final String S_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    private static final String S_N_INDENT_AMOUNT = "4";
    private static HashMap m_hashmapInputParams;
    private static int m_nCommandType;
    private static URI m_uriInstallRoot;
    private static NIFRegistry m_nifregistry;
    private static NIFRegistryOfferingEntry m_nifroeToBeCleaned;
    private static NIFRegistryPAKEntry[] m_anifrpeToBeCleaned;
    private static File m_fileNIFRegistryFile;
    private static Vector m_vReportStrings;
    private static String S_OS400_PRODUCT_PROPERTIES_FILENAME;
    private static String S_PROPERTY_KEY_INSTALLATION_LIBRARY;
    private static String S_PROPERTY_KEY_USER_DATA_PATH;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;
    private static final JoinPoint.StaticPart ajc$tjp_22;
    private static final JoinPoint.StaticPart ajc$tjp_23;
    private static final JoinPoint.StaticPart ajc$tjp_24;
    private static final JoinPoint.StaticPart ajc$tjp_25;
    private static final JoinPoint.StaticPart ajc$tjp_26;
    private static final JoinPoint.StaticPart ajc$tjp_27;
    private static final JoinPoint.StaticPart ajc$tjp_28;
    private static final JoinPoint.StaticPart ajc$tjp_29;
    private static final JoinPoint.StaticPart ajc$tjp_30;

    static {
        Factory factory = new Factory("NIFRegistryUtils.java", Class.forName("com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----"), 56);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-main-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils-[Ljava.lang.String;:-args:--void-"), 63);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-validateListProducts-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----int-"), 649);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-validateListPackages-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----int-"), 685);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-validateShowNIFRegistryLocation-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----int-"), 721);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-validateUserHome-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----int-"), 758);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-cleanAll-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----int-"), 821);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-cleanProduct-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----int-"), 855);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-cleanPAK-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----int-"), 881);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-listProducts-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----int-"), 916);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-listPAKs-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----int-"), 938);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-areInputParamsWithinThisValidParamSet-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils-java.util.Set:-setParamNames:--boolean-"), 964);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-createParameterHashmap-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils-[Ljava.lang.String;:-args:--int-"), 121);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-calculateMaxLabelLength-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils-[Ljava.lang.String;:-asLabels:--int-"), 987);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getLabels-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils-int:-nLabelType:--[Ljava.lang.String;-"), 1011);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getOS400Information-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils-java.lang.String:-sInstallLocation:--[Ljava.lang.String;-"), 1100);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-printCopyright-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----void-"), 1134);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-printHeader-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----void-"), 1156);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-printFooter-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----void-"), 1170);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-printReporterTimestamp-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----void-"), 1184);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-printPAK-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils-com.ibm.ws.install.ni.framework.registry.NIFRegistryPAKEntry:[Ljava.lang.String;:-nifrpeThis:asLabels:--void-"), 1204);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-printProduct-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils-com.ibm.ws.install.ni.framework.registry.NIFRegistryOfferingEntry:[Ljava.lang.String;:-nifroeThis:asLabels:--void-"), 1241);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-printReport-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils-[Ljava.lang.Object;:-aobjNIFRegistryEntry:--void-"), 1286);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-displayMessage-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils-int:-nReturnCode:--void-"), 178);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-saveDocument-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils-org.w3c.dom.Document:java.io.File:-document:fileTo:-java.io.IOException:-void-"), 1347);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-validateInputParameters-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils-[Ljava.lang.String;:-args:--int-"), 275);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-validateCommandParams-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----int-"), 329);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-validateCleanAll-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----int-"), 405);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-validateCleanProduct-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----int-"), 439);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-validateCleanPackage-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----int-"), 527);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-validateInstallLocation-com.ibm.ws.install.ni.framework.registry.NIFRegistryUtils----int-"), 603);
        AS_VALID_COMMANDS = new String[]{S_PARAM_CLEAN_ALL, S_PARAM_CLEAN_PRODUCT, S_PARAM_CLEAN_PACKAGE, S_PARAM_LIST_PRODUCTS, S_PARAM_LIST_PAKS, S_PARAM_SHOW_NIFREGISTRY_LOCATION_FOR_SUPPORT};
        AS_VALID_INPUT_PARAMS = new String[]{S_PARAM_CLEAN_ALL, S_PARAM_CLEAN_PRODUCT, S_PARAM_CLEAN_PACKAGE, S_PARAM_OFFERING, S_PARAM_PAK_NAME, S_PARAM_INSTALL_LOCATION, S_PARAM_USER_HOME, S_PARAM_LIST_PRODUCTS, S_PARAM_LIST_PAKS, S_PARAM_SHOW_NIFREGISTRY_LOCATION_FOR_SUPPORT};
        AS_MESSAGE_KEY = new String[]{"", S_INVALID_OFFERING_MESSAGE_TEXT_KEY, S_USER_HOME_NOT_EXISTS_MESSAGE_TEXT_KEY, S_USER_HOME_NO_WRITE_ACCESS_MESSAGE_TEXT_KEY, S_NIFREGISTRY_NOT_EXISTS_MESSAGE_TEXT_KEY, S_PARSE_NIFREGISTRY_ERROR_MESSAGE_TEXT_KEY, S_INSTALLATION_LOCATION_INVALID_FORMAT_MESSAGE_TEXT_KEY, S_OFFERING_IN_THIS_INSTALL_LOCATION_NOT_EXISTS_MESSAGE_TEXT_KEY, S_PAK_IN_THIS_INSTALL_LOCATION_NOT_EXISTS_MESSAGE_TEXT_KEY, S_CLEAN_ALL_FAILED_MESSAGE_TEXT_KEY, S_CLEAN_OFFERING_FAILED_MESSAGE_TEXT_KEY, S_CLEAN_PAK_FAILED_MESSAGE_TEXT_KEY, S_LIST_PRODUCTS_FAILED_MESSAGE_TEXT_KEY, S_LIST_PAKS_FAILED_MESSAGE_TEXT_KEY, S_CLEANUP_SUCCESS_MESSAGE_TEXT_KEY, S_SHOW_NIFREGISTRY_LOCATION_MESSAGE_TEXT_KEY};
        m_hashmapInputParams = null;
        m_nCommandType = 0;
        m_uriInstallRoot = null;
        m_nifregistry = null;
        m_nifroeToBeCleaned = null;
        m_anifrpeToBeCleaned = null;
        m_fileNIFRegistryFile = null;
        m_vReportStrings = null;
        S_OS400_PRODUCT_PROPERTIES_FILENAME = "product.properties";
        S_PROPERTY_KEY_INSTALLATION_LIBRARY = "was.install.library";
        S_PROPERTY_KEY_USER_DATA_PATH = "was.userdata.path";
    }

    public NIFRegistryUtils() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)stringArray2);
        try {
            String[] args;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            int nReturnCode = NIFRegistryUtils.validateInputParameters(args);
            if (nReturnCode != 0) {
                NIFRegistryUtils.displayMessage(nReturnCode);
                System.exit(-1);
            }
            switch (m_nCommandType) {
                case 10: {
                    nReturnCode = NIFRegistryUtils.cleanAll();
                    break;
                }
                case 20: {
                    nReturnCode = NIFRegistryUtils.cleanProduct();
                    break;
                }
                case 30: {
                    nReturnCode = NIFRegistryUtils.cleanPAK();
                    break;
                }
                case 40: {
                    nReturnCode = NIFRegistryUtils.listProducts();
                    break;
                }
                case 50: {
                    nReturnCode = NIFRegistryUtils.listPAKs();
                    break;
                }
                case 60: {
                    nReturnCode = 15;
                }
            }
            NIFRegistryUtils.displayMessage(nReturnCode);
            if (nReturnCode != 0 && nReturnCode != 0) {
                System.exit(-1);
            }
            System.exit(0);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int createParameterHashmap(String[] stringArray) {
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)stringArray2);
        try {
            int n;
            block10: {
                String[] args;
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                if (args.length == 0) {
                    n = -1;
                } else {
                    m_hashmapInputParams = new HashMap();
                    int i = 0;
                    while (i < args.length) {
                        if (!args[i].startsWith(S_DASH)) {
                            n = -1;
                            break block10;
                        }
                        if (i + 1 < args.length && !args[i + 1].startsWith(S_DASH)) {
                            if (m_hashmapInputParams.keySet().contains(args[i].toLowerCase())) {
                                n = -1;
                                break block10;
                            }
                            m_hashmapInputParams.put(args[i].toLowerCase(), args[i + 1]);
                            ++i;
                        } else {
                            if (m_hashmapInputParams.keySet().contains(args[i].toLowerCase())) {
                                n = -1;
                                break block10;
                            }
                            m_hashmapInputParams.put(args[i].toLowerCase(), null);
                        }
                        ++i;
                    }
                    n = 0;
                }
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static void displayMessage(int n) {
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)Conversions.intObject((int)n2));
        try {
            int nReturnCode;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            switch (nReturnCode) {
                case -1: {
                    System.out.println(NIFResourceBundleUtils.getLocaleString(S_CORRECT_COMMAND_USAGE_MESSAGE_TEXT_KEY));
                    break;
                }
                case 14: {
                    System.out.println(NIFResourceBundleUtils.getLocaleString(S_CLEANUP_SUCCESS_MESSAGE_TEXT_KEY));
                    break;
                }
                case 1: {
                    System.out.println(NIFResourceBundleUtils.getLocaleString(AS_MESSAGE_KEY[nReturnCode], (String)m_hashmapInputParams.get(S_PARAM_OFFERING)));
                    break;
                }
                case 2: 
                case 3: {
                    System.out.println(NIFResourceBundleUtils.getLocaleString(AS_MESSAGE_KEY[nReturnCode], (String)m_hashmapInputParams.get(S_PARAM_USER_HOME)));
                    break;
                }
                case 4: 
                case 5: 
                case 9: {
                    System.out.println(NIFResourceBundleUtils.getLocaleString(AS_MESSAGE_KEY[nReturnCode]));
                    break;
                }
                case 6: {
                    System.out.println(NIFResourceBundleUtils.getLocaleString(AS_MESSAGE_KEY[nReturnCode], (String)m_hashmapInputParams.get(S_PARAM_INSTALL_LOCATION)));
                    break;
                }
                case 7: 
                case 10: {
                    String[] asParamValue = new String[]{(String)m_hashmapInputParams.get(S_PARAM_OFFERING), (String)m_hashmapInputParams.get(S_PARAM_INSTALL_LOCATION)};
                    System.out.println(NIFResourceBundleUtils.getLocaleString(AS_MESSAGE_KEY[nReturnCode], asParamValue));
                    break;
                }
                case 8: 
                case 11: {
                    String[] asParamValue = new String[]{(String)m_hashmapInputParams.get(S_PARAM_PAK_NAME), (String)m_hashmapInputParams.get(S_PARAM_INSTALL_LOCATION)};
                    System.out.println(NIFResourceBundleUtils.getLocaleString(AS_MESSAGE_KEY[nReturnCode], asParamValue));
                    break;
                }
                case 12: 
                case 13: {
                    System.out.println(NIFResourceBundleUtils.getLocaleString(AS_MESSAGE_KEY[nReturnCode]));
                    break;
                }
                case 15: {
                    System.out.println(NIFResourceBundleUtils.getLocaleString(AS_MESSAGE_KEY[nReturnCode], m_fileNIFRegistryFile.getAbsolutePath()));
                }
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int validateInputParameters(String[] stringArray) {
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)stringArray2);
        try {
            int n;
            String[] args;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            int nReturnCode = NIFRegistryUtils.createParameterHashmap(args);
            if (nReturnCode != 0) {
                n = nReturnCode;
            } else {
                nReturnCode = NIFRegistryUtils.validateCommandParams();
                if (nReturnCode != 0) {
                    n = nReturnCode;
                } else {
                    switch (m_nCommandType) {
                        case 0: {
                            n = -1;
                            break;
                        }
                        case 10: {
                            n = NIFRegistryUtils.validateCleanAll();
                            break;
                        }
                        case 20: {
                            n = NIFRegistryUtils.validateCleanProduct();
                            break;
                        }
                        case 30: {
                            n = NIFRegistryUtils.validateCleanPackage();
                            break;
                        }
                        case 40: {
                            n = NIFRegistryUtils.validateListProducts();
                            break;
                        }
                        case 50: {
                            n = NIFRegistryUtils.validateListPackages();
                            break;
                        }
                        case 60: {
                            n = NIFRegistryUtils.validateShowNIFRegistryLocation();
                            break;
                        }
                        default: {
                            n = 0;
                            break;
                        }
                    }
                }
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int validateCommandParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null);
        try {
            int n;
            block12: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                HashSet<String> setValidInputParams = new HashSet<String>();
                int i = 0;
                while (i < AS_VALID_INPUT_PARAMS.length) {
                    setValidInputParams.add(AS_VALID_INPUT_PARAMS[i]);
                    ++i;
                }
                HashSet<String> setValidCommands = new HashSet<String>();
                int i2 = 0;
                while (i2 < AS_VALID_COMMANDS.length) {
                    setValidCommands.add(AS_VALID_COMMANDS[i2]);
                    ++i2;
                }
                Iterator iteratorInputParams = m_hashmapInputParams.keySet().iterator();
                String sCommand = null;
                while (iteratorInputParams.hasNext()) {
                    sCommand = (String)iteratorInputParams.next();
                    if (!setValidInputParams.contains(sCommand)) {
                        n = -1;
                        break block12;
                    }
                    if (!setValidCommands.contains(sCommand)) continue;
                    if (m_nCommandType != 0) {
                        n = -1;
                        break block12;
                    }
                    if (sCommand.equals(S_PARAM_CLEAN_ALL)) {
                        m_nCommandType = 10;
                        continue;
                    }
                    if (sCommand.equals(S_PARAM_CLEAN_PRODUCT)) {
                        m_nCommandType = 20;
                        continue;
                    }
                    if (sCommand.equals(S_PARAM_CLEAN_PACKAGE)) {
                        m_nCommandType = 30;
                        continue;
                    }
                    if (sCommand.equals(S_PARAM_LIST_PRODUCTS)) {
                        m_nCommandType = 40;
                        continue;
                    }
                    if (sCommand.equals(S_PARAM_LIST_PAKS)) {
                        m_nCommandType = 50;
                        continue;
                    }
                    if (!sCommand.equals(S_PARAM_SHOW_NIFREGISTRY_LOCATION_FOR_SUPPORT)) continue;
                    m_nCommandType = 60;
                }
                n = 0;
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int validateCleanAll() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null);
        try {
            int n;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (m_hashmapInputParams.containsKey(S_PARAM_CLEAN_ALL) && m_hashmapInputParams.get(S_PARAM_CLEAN_ALL) == null) {
                int nReturnCode;
                HashSet<String> setValidCleanAllParams = new HashSet<String>();
                setValidCleanAllParams.add(S_PARAM_CLEAN_ALL);
                setValidCleanAllParams.add(S_PARAM_USER_HOME);
                n = !NIFRegistryUtils.areInputParamsWithinThisValidParamSet(setValidCleanAllParams) ? -1 : ((nReturnCode = NIFRegistryUtils.validateUserHome()) != 0 ? nReturnCode : 0);
            } else {
                n = -1;
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int validateCleanProduct() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null);
        try {
            int n;
            block16: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                if (m_hashmapInputParams.containsKey(S_PARAM_CLEAN_PRODUCT) && m_hashmapInputParams.get(S_PARAM_CLEAN_PRODUCT) == null) {
                    HashSet<String> setValidCleanProductParams = new HashSet<String>();
                    setValidCleanProductParams.add(S_PARAM_CLEAN_PRODUCT);
                    setValidCleanProductParams.add(S_PARAM_OFFERING);
                    setValidCleanProductParams.add(S_PARAM_INSTALL_LOCATION);
                    setValidCleanProductParams.add(S_PARAM_USER_HOME);
                    if (!NIFRegistryUtils.areInputParamsWithinThisValidParamSet(setValidCleanProductParams)) {
                        n = -1;
                    } else {
                        int nReturnCodeInstallLocation = NIFRegistryUtils.validateInstallLocation();
                        if (nReturnCodeInstallLocation == 0) {
                            String sOffering = (String)m_hashmapInputParams.get(S_PARAM_OFFERING);
                            if (sOffering == null) {
                                n = -1;
                            } else {
                                int nReturnCode = NIFRegistryUtils.validateUserHome();
                                if (nReturnCode != 0) {
                                    n = nReturnCode;
                                } else {
                                    try {
                                        m_nifroeToBeCleaned = m_nifregistry.getInstalledProductByOfferingLocationURIAndOffering(sOffering, m_uriInstallRoot);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace(System.out);
                                        n = 6;
                                        break block16;
                                    }
                                    if (m_nifroeToBeCleaned != null) {
                                        m_nCommandType = 20;
                                        n = 0;
                                    } else {
                                        n = 7;
                                    }
                                }
                            }
                        } else {
                            n = nReturnCodeInstallLocation;
                        }
                    }
                } else {
                    n = -1;
                }
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int validateCleanPackage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null);
        try {
            int n;
            block16: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                if (m_hashmapInputParams.containsKey(S_PARAM_CLEAN_PACKAGE) && m_hashmapInputParams.get(S_PARAM_CLEAN_PACKAGE) == null) {
                    HashSet<String> setValidCleanPackageParams = new HashSet<String>();
                    setValidCleanPackageParams.add(S_PARAM_CLEAN_PACKAGE);
                    setValidCleanPackageParams.add(S_PARAM_PAK_NAME);
                    setValidCleanPackageParams.add(S_PARAM_INSTALL_LOCATION);
                    setValidCleanPackageParams.add(S_PARAM_USER_HOME);
                    if (!NIFRegistryUtils.areInputParamsWithinThisValidParamSet(setValidCleanPackageParams)) {
                        n = -1;
                    } else {
                        int nReturnCodeInstallLocation = NIFRegistryUtils.validateInstallLocation();
                        if (nReturnCodeInstallLocation == 0) {
                            String sPAKName = (String)m_hashmapInputParams.get(S_PARAM_PAK_NAME);
                            if (sPAKName == null) {
                                n = -1;
                            } else {
                                int nReturnCode = NIFRegistryUtils.validateUserHome();
                                if (nReturnCode != 0) {
                                    n = nReturnCode;
                                } else {
                                    try {
                                        m_anifrpeToBeCleaned = m_nifregistry.getInstalledPAKArrayByPAKNameAndOfferingLocationURI(sPAKName, m_uriInstallRoot);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace(System.out);
                                        n = 6;
                                        break block16;
                                    }
                                    if (m_anifrpeToBeCleaned != null) {
                                        m_nCommandType = 30;
                                        n = 0;
                                    } else {
                                        n = 8;
                                    }
                                }
                            }
                        } else {
                            n = nReturnCodeInstallLocation;
                        }
                    }
                } else {
                    n = -1;
                }
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int validateInstallLocation() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null);
        try {
            int n;
            block6: {
                String sInstallLocation;
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                if (m_hashmapInputParams.containsKey(S_PARAM_INSTALL_LOCATION) && (sInstallLocation = (String)m_hashmapInputParams.get(S_PARAM_INSTALL_LOCATION)) != null && !sInstallLocation.equals("")) {
                    sInstallLocation = NIFRegistryHelper.normalizePath(sInstallLocation);
                    try {
                        m_uriInstallRoot = new URI("file", "", sInstallLocation, null, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                        n = 6;
                        break block6;
                    }
                    n = 0;
                } else {
                    n = -1;
                }
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int validateListProducts() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null);
        try {
            int n;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (m_hashmapInputParams.containsKey(S_PARAM_LIST_PRODUCTS) && m_hashmapInputParams.get(S_PARAM_LIST_PRODUCTS) == null) {
                HashSet<String> setValidListProductsParams = new HashSet<String>();
                setValidListProductsParams.add(S_PARAM_LIST_PRODUCTS);
                setValidListProductsParams.add(S_PARAM_USER_HOME);
                if (!NIFRegistryUtils.areInputParamsWithinThisValidParamSet(setValidListProductsParams)) {
                    n = -1;
                } else {
                    int nReturnCode = NIFRegistryUtils.validateUserHome();
                    if (nReturnCode != 0) {
                        n = nReturnCode;
                    } else {
                        m_nCommandType = 40;
                        n = 0;
                    }
                }
            } else {
                n = -1;
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int validateListPackages() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null);
        try {
            int n;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (m_hashmapInputParams.containsKey(S_PARAM_LIST_PAKS) && m_hashmapInputParams.get(S_PARAM_LIST_PAKS) == null) {
                HashSet<String> setValidListProductsParams = new HashSet<String>();
                setValidListProductsParams.add(S_PARAM_LIST_PAKS);
                setValidListProductsParams.add(S_PARAM_USER_HOME);
                if (!NIFRegistryUtils.areInputParamsWithinThisValidParamSet(setValidListProductsParams)) {
                    n = -1;
                } else {
                    int nReturnCode = NIFRegistryUtils.validateUserHome();
                    if (nReturnCode != 0) {
                        n = nReturnCode;
                    } else {
                        m_nCommandType = 50;
                        n = 0;
                    }
                }
            } else {
                n = -1;
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int validateShowNIFRegistryLocation() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null);
        try {
            int n;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (m_hashmapInputParams.containsKey(S_PARAM_SHOW_NIFREGISTRY_LOCATION_FOR_SUPPORT) && m_hashmapInputParams.get(S_PARAM_SHOW_NIFREGISTRY_LOCATION_FOR_SUPPORT) == null) {
                HashSet<String> setValidShowNIFRegistryLocationParams = new HashSet<String>();
                setValidShowNIFRegistryLocationParams.add(S_PARAM_SHOW_NIFREGISTRY_LOCATION_FOR_SUPPORT);
                setValidShowNIFRegistryLocationParams.add(S_PARAM_USER_HOME);
                if (!NIFRegistryUtils.areInputParamsWithinThisValidParamSet(setValidShowNIFRegistryLocationParams)) {
                    n = -1;
                } else {
                    int nReturnCode = NIFRegistryUtils.validateUserHome();
                    if (nReturnCode != 0) {
                        n = nReturnCode;
                    } else {
                        m_nCommandType = 60;
                        n = 0;
                    }
                }
            } else {
                n = -1;
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int validateUserHome() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null);
        try {
            int n;
            block10: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                try {
                    String sUserHome = null;
                    if (m_hashmapInputParams.containsKey(S_PARAM_USER_HOME)) {
                        sUserHome = (String)m_hashmapInputParams.get(S_PARAM_USER_HOME);
                        if (sUserHome != null) {
                            File fileUserHome = new File(sUserHome);
                            if (!fileUserHome.exists()) {
                                n = 2;
                                break block10;
                            }
                            if (!fileUserHome.canWrite()) {
                                n = 3;
                                break block10;
                            }
                        } else {
                            n = -1;
                            break block10;
                        }
                    }
                    m_nifregistry = NIFRegistry.getNIFRegistryInstance(sUserHome, S_NIFREGISTRY_FILE_NAME);
                    m_fileNIFRegistryFile = new File(m_nifregistry.getNIFRegistryFilePath());
                    n = 0;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    n = 4;
                }
                catch (Exception exception) {
                    n = 5;
                }
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int cleanAll() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null);
        try {
            int n;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            try {
                NIFRegistryOfferingEntry[] anifroe = m_nifregistry.getAllInstalledProducts();
                int i = 0;
                while (i < anifroe.length) {
                    m_nifregistry.purgeRegistryEntriesOfThisProduct(anifroe[i]);
                    ++i;
                }
                if (anifroe.length > 0) {
                    m_nifregistry.commitNIFRegistry();
                    NIFRegistryUtils.saveDocument(m_nifregistry.getNIFRegistryDocument(), m_fileNIFRegistryFile);
                }
                n = 14;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                n = 9;
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int cleanProduct() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, null, null);
        try {
            int n;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            try {
                m_nifregistry.purgeRegistryEntriesOfThisProduct(m_nifroeToBeCleaned);
                m_nifregistry.commitNIFRegistry();
                NIFRegistryUtils.saveDocument(m_nifregistry.getNIFRegistryDocument(), m_fileNIFRegistryFile);
                n = 14;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                n = 10;
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int cleanPAK() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, null, null);
        try {
            int n;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            try {
                int i = 0;
                while (i < m_anifrpeToBeCleaned.length) {
                    m_nifregistry.removeRegistryEntryFromNIFRegistry(m_anifrpeToBeCleaned[i]);
                    ++i;
                }
                m_nifregistry.commitNIFRegistry();
                NIFRegistryUtils.saveDocument(m_nifregistry.getNIFRegistryDocument(), m_fileNIFRegistryFile);
                n = 14;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                n = 11;
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int listProducts() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, null, null);
        try {
            int n;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            try {
                Object[] anifroeThis = m_nifregistry.getAllInstalledProducts();
                NIFRegistryUtils.printReport(anifroeThis);
                n = 0;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                n = 12;
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int listPAKs() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, null, null);
        try {
            int n;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            try {
                Object[] anifrpeThis = m_nifregistry.getAllInstalledPAKs();
                NIFRegistryUtils.printReport(anifrpeThis);
                n = 0;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                n = 13;
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static boolean areInputParamsWithinThisValidParamSet(Set set) {
        Set set2 = set;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, null, null, (Object)set2);
        try {
            boolean bl;
            block3: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                Iterator itInputParamNames = m_hashmapInputParams.keySet().iterator();
                while (itInputParamNames.hasNext()) {
                    Set setParamNames;
                    String sParamName = (String)itInputParamNames.next();
                    if (setParamNames.contains(sParamName)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static int calculateMaxLabelLength(String[] stringArray) {
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, null, null, (Object)stringArray2);
        try {
            String[] asLabels;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            int nMaxLabelLength = 0;
            int i = 0;
            while (i < asLabels.length) {
                if (asLabels[i].length() > nMaxLabelLength) {
                    nMaxLabelLength = asLabels[i].length();
                }
                ++i;
            }
            int n = nMaxLabelLength + 8;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static String[] getLabels(int n) {
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, null, null, (Object)Conversions.intObject((int)n2));
        try {
            int nLabelType;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] asLabels = null;
            switch (nLabelType) {
                case 100: {
                    String sOfferingID = NIFResourceBundleUtils.getLocaleString(S_OFFERING_ID_MESSAGE_LABEL_KEY);
                    String sInstallLocation = NIFResourceBundleUtils.getLocaleString(S_INSTALLATION_LOCATION_MESSAGE_LABEL_KEY);
                    String sVersion = NIFResourceBundleUtils.getLocaleString(S_VERSION_MESSAGE_LABEL_KEY);
                    if (PlatformConstants.isCurrentPlatformOS400()) {
                        String sInstallationLibrary = NIFResourceBundleUtils.getLocaleString(S_INSTALLATION_LIBRARY_OS400_MESSAGE_LABEL_KEY);
                        String sUserDataPath = NIFResourceBundleUtils.getLocaleString(S_USER_DATA_PATH_OS400_MESSAGE_LABEL_KEY);
                        asLabels = new String[]{sOfferingID, sInstallLocation, sVersion, sInstallationLibrary, sUserDataPath};
                    } else {
                        asLabels = new String[]{sOfferingID, sInstallLocation, sVersion};
                    }
                    int nLabelLength = NIFRegistryUtils.calculateMaxLabelLength(asLabels);
                    int i = 0;
                    while (i < asLabels.length) {
                        int n3 = i;
                        asLabels[n3] = String.valueOf(asLabels[n3]) + S_SPACE_PADDINGS_80.substring(0, nLabelLength - asLabels[i].length());
                        ++i;
                    }
                    break;
                }
                case 110: {
                    String sPAKName = NIFResourceBundleUtils.getLocaleString(S_PACKAGE_NAME_MESSAGE_LABEL_KEY);
                    String sInstallLocation = NIFResourceBundleUtils.getLocaleString(S_INSTALLATION_LOCATION_MESSAGE_LABEL_KEY);
                    String sOfferingID = NIFResourceBundleUtils.getLocaleString(S_OFFERING_ID_MESSAGE_LABEL_KEY);
                    String sBackupPAKInstallLocation = NIFResourceBundleUtils.getLocaleString(S_PACKAGE_INSTALLATION_LOCATION_MESSAGE_LABEL_KEY);
                    asLabels = new String[]{sPAKName, sInstallLocation, sOfferingID, sBackupPAKInstallLocation};
                    int nLabelLength = NIFRegistryUtils.calculateMaxLabelLength(asLabels);
                    int i = 0;
                    while (i < asLabels.length) {
                        int n4 = i;
                        asLabels[n4] = String.valueOf(asLabels[n4]) + S_SPACE_PADDINGS_80.substring(0, nLabelLength - asLabels[i].length());
                        ++i;
                    }
                    break;
                }
            }
            String[] stringArray = asLabels;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return asLabels;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String[] getOS400Information(String var0) {
        var6_1 = var0;
        var5_2 = Factory.makeJP((JoinPoint.StaticPart)NIFRegistryUtils.ajc$tjp_22, null, null, (Object)var6_1);
        try {
            block5: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(var5_2);
                asOS400Information = new String[2];
                fileProductPropertiesFile = new File(String.valueOf(sInstallLocation) + "/properties/" + NIFRegistryUtils.S_OS400_PRODUCT_PROPERTIES_FILENAME);
                try {
                    propFileInputStream = new FileInputStream(fileProductPropertiesFile);
                    pOS400ProductProperties = new Properties();
                    pOS400ProductProperties.load(propFileInputStream);
                    asOS400Information[0] = pOS400ProductProperties.getProperty(NIFRegistryUtils.S_PROPERTY_KEY_INSTALLATION_LIBRARY);
                    asOS400Information[1] = pOS400ProductProperties.getProperty(NIFRegistryUtils.S_PROPERTY_KEY_USER_DATA_PATH);
                    break block5;
                }
                catch (Exception v0) {
                    i = 0;
                    ** while (i < asOS400Information.length)
                }
lbl-1000:
                // 1 sources

                {
                    asOS400Information[i] = NIFResourceBundleUtils.getLocaleString("NIFRegistryUtils.informationNotAvailableOS400MessageText");
                    ++i;
                    continue;
                }
            }
            var7_8 = asOS400Information;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(var7_8, var5_2);
            return asOS400Information;
        }
        catch (Throwable var8_9) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(var8_9, var5_2);
            throw var8_9;
        }
    }

    private static void printCopyright() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            m_vReportStrings.add("");
            String sTemp = NIFResourceBundleUtils.getLocaleString(S_COPYRIGHT_MESSAGE_TEXT_KEY);
            m_vReportStrings.add(sTemp);
            sTemp = NIFResourceBundleUtils.getLocaleString(S_REPORTER_VERSION_MESSAGE_KEY, S_NIFREGISTRYUTILS_VERSION);
            m_vReportStrings.add(sTemp);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static void printHeader() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            m_vReportStrings.add("");
            m_vReportStrings.add(S_SEPARATOR_MESSAGE_TEXT);
            String sTemp = NIFResourceBundleUtils.getLocaleString(S_REPORT_HEADER_MESSAGE_TEXT_KEY);
            m_vReportStrings.add(sTemp);
            m_vReportStrings.add(S_SEPARATOR_MESSAGE_TEXT);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static void printFooter() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            m_vReportStrings.add("");
            m_vReportStrings.add(S_SEPARATOR_MESSAGE_TEXT);
            String sTemp = NIFResourceBundleUtils.getLocaleString(S_REPORT_FOOTER_MESSAGE_TEXT_KEY);
            m_vReportStrings.add(sTemp);
            m_vReportStrings.add(S_SEPARATOR_MESSAGE_TEXT);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static void printReporterTimestamp() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            m_vReportStrings.add("");
            Date dateCurrentDate = new Date(System.currentTimeMillis());
            String sCurrentDateTime = DateFormat.getDateTimeInstance(1, 1).format(dateCurrentDate);
            String sTemp = NIFResourceBundleUtils.getLocaleString(S_REPORT_DATE_MESSAGE_TEXT_KEY, sCurrentDateTime);
            m_vReportStrings.add(sTemp);
            m_vReportStrings.add("");
            m_vReportStrings.add(S_SEPARATOR_MESSAGE_TEXT);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void printPAK(NIFRegistryPAKEntry nIFRegistryPAKEntry, String[] stringArray) {
        NIFRegistryPAKEntry nIFRegistryPAKEntry2 = nIFRegistryPAKEntry;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, null, null, (Object)nIFRegistryPAKEntry2, (Object)stringArray2);
        try {
            NIFRegistryPAKEntry nifrpeThis;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            m_vReportStrings.add("");
            String sTemp = NIFResourceBundleUtils.getLocaleString(S_PACKAGE_INSTALLED_MESSAGE_TEXT_KEY);
            m_vReportStrings.add(sTemp);
            m_vReportStrings.add(S_SEPARATOR_MESSAGE_TEXT);
            if (nifrpeThis == null) {
                sTemp = NIFResourceBundleUtils.getLocaleString(S_NO_PAKS_AVAILABLE_MESSSAGE_TEXT_KEY);
                m_vReportStrings.add(sTemp);
            } else {
                void asLabels;
                String sPAKName = String.valueOf(asLabels[0]) + nifrpeThis.getNIFPackageName();
                String sInstallLocation = String.valueOf(asLabels[1]) + nifrpeThis.getOfferingLocationPath();
                String sOfferingID = String.valueOf(asLabels[2]) + nifrpeThis.getOffering();
                String sBackupPAKLocation = String.valueOf(asLabels[3]) + nifrpeThis.getBackupPakLocationPath();
                m_vReportStrings.add(sPAKName);
                m_vReportStrings.add(sInstallLocation);
                m_vReportStrings.add(sOfferingID);
                m_vReportStrings.add(sBackupPAKLocation);
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void printProduct(NIFRegistryOfferingEntry nIFRegistryOfferingEntry, String[] stringArray) {
        NIFRegistryOfferingEntry nIFRegistryOfferingEntry2 = nIFRegistryOfferingEntry;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, null, null, (Object)nIFRegistryOfferingEntry2, (Object)stringArray2);
        try {
            NIFRegistryOfferingEntry nifroeThis;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            m_vReportStrings.add("");
            String sTemp = NIFResourceBundleUtils.getLocaleString(S_PRODUCT_INSTALLED_MESSAGE_TEXT_KEY);
            m_vReportStrings.add(sTemp);
            m_vReportStrings.add(S_SEPARATOR_MESSAGE_TEXT);
            if (nifroeThis == null) {
                sTemp = NIFResourceBundleUtils.getLocaleString(S_NO_PRODUCTS_AVAILABLE_MESSAGE_TEXT_KEY);
                m_vReportStrings.add(sTemp);
            } else {
                void asLabels;
                String sOfferingID = String.valueOf(asLabels[0]) + nifroeThis.getOffering();
                String sInstallLocation = String.valueOf(asLabels[1]) + nifroeThis.getOfferingLocationPath();
                String sVersion = String.valueOf(asLabels[2]) + nifroeThis.getOfferingVersion();
                m_vReportStrings.add(sOfferingID);
                m_vReportStrings.add(sInstallLocation);
                m_vReportStrings.add(sVersion);
                if (PlatformConstants.isCurrentPlatformOS400()) {
                    String[] asOS400Information = NIFRegistryUtils.getOS400Information(nifroeThis.getOfferingLocationPath());
                    String sInstallationLibrary = String.valueOf(asLabels[3]) + asOS400Information[0];
                    String sUserDataPath = String.valueOf(asLabels[4]) + asOS400Information[1];
                    m_vReportStrings.add(sInstallationLibrary);
                    m_vReportStrings.add(sUserDataPath);
                }
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static void printReport(Object[] objectArray) {
        Object[] objectArray2 = objectArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, null, null, (Object)objectArray2);
        try {
            int i;
            Object[] aobjNIFRegistryEntry;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            m_vReportStrings = new Vector();
            NIFRegistryUtils.printCopyright();
            NIFRegistryUtils.printHeader();
            NIFRegistryUtils.printReporterTimestamp();
            String[] asLabels = null;
            String string = aobjNIFRegistryEntry.getClass().toString();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lcom.ibm.ws.install.ni.framework.registry.NIFRegistryOfferingEntry;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (string.equals(clazz.toString())) {
                if (aobjNIFRegistryEntry.length == 0) {
                    NIFRegistryUtils.printProduct(null, asLabels);
                } else {
                    asLabels = NIFRegistryUtils.getLabels(100);
                    i = 0;
                    while (i < aobjNIFRegistryEntry.length) {
                        NIFRegistryUtils.printProduct((NIFRegistryOfferingEntry)aobjNIFRegistryEntry[i], asLabels);
                        ++i;
                    }
                }
            } else {
                String string2 = aobjNIFRegistryEntry.getClass().toString();
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("[Lcom.ibm.ws.install.ni.framework.registry.NIFRegistryPAKEntry;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (string2.equals(clazz2.toString())) {
                    if (aobjNIFRegistryEntry.length == 0) {
                        NIFRegistryUtils.printPAK(null, asLabels);
                    } else {
                        asLabels = NIFRegistryUtils.getLabels(110);
                        i = 0;
                        while (i < aobjNIFRegistryEntry.length) {
                            NIFRegistryUtils.printPAK((NIFRegistryPAKEntry)aobjNIFRegistryEntry[i], asLabels);
                            ++i;
                        }
                    }
                }
            }
            NIFRegistryUtils.printFooter();
            Iterator iteratorReportStrings = m_vReportStrings.iterator();
            while (iteratorReportStrings.hasNext()) {
                System.out.println(iteratorReportStrings.next());
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void saveDocument(Document document, File file) throws IOException {
        Document document2 = document;
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, null, null, (Object)document2, (Object)file2);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            try {
                Document document3;
                void fileTo;
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                FileOutputStream outputStream = new FileOutputStream((File)fileTo);
                DOMSource domsource = new DOMSource(document3);
                StreamResult streamresult = new StreamResult(outputStream);
                transformer.setOutputProperty("indent", S_YES);
                transformer.setOutputProperty(S_INDENT_AMOUNT, S_N_INDENT_AMOUNT);
                transformer.transform(domsource, streamresult);
                ((OutputStream)outputStream).close();
            }
            catch (TransformerConfigurationException e) {
                throw new IOException(e.getMessage());
            }
            catch (TransformerException e) {
                throw new IOException(e.getMessage());
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

