/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.resourcebundle;

import com.ibm.ws.install.ni.framework.macro.MacroResolver;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;

public class NIFResourceBundleMacroResolver
extends MacroResolver {
    private static final String S_RESOURCEBUNDLE_ATTRIBUTE_MACRO_ID = "L";
    private static final String S_COMMA = ",";

    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_RESOURCEBUNDLE_ATTRIBUTE_MACRO_ID.equals(sMacroID);
    }

    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        try {
            StringTokenizer st = new StringTokenizer(sMacroText, S_COMMA);
            String sResourceBundleName = st.nextToken().trim();
            String sKey = st.nextToken().trim();
            Vector<String> vsParams = new Vector<String>();
            while (st.hasMoreTokens()) {
                vsParams.add(st.nextToken().trim());
            }
            Object[] asParams = vsParams.toArray(new String[vsParams.size()]);
            ResourceBundle resourcebundleWS = ResourceBundle.getBundle(sResourceBundleName);
            String sString = resourcebundleWS.getString(sKey);
            if (asParams.length > 0) {
                sString = MessageFormat.format(sString, asParams);
            }
            return sString;
        }
        catch (Throwable throwable) {
            return sMacroText;
        }
    }
}

