/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.resourcebundle;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NIFResourceBundleUtils {
    private static final String S_WS_RESOURCE_BUNDLE_NAME = "com.ibm.ws.install.ni.framework.resourcebundle.NIFResourceBundle";
    private static final Pattern messageKeyPattern = Pattern.compile("CWUPI[0-9]{4}[A-Z]:\\s");
    private static final String S_EMPTY = "";

    public static String getLocaleString(String sKey, String sParam) {
        ResourceBundle resourcebundleWS = ResourceBundle.getBundle(S_WS_RESOURCE_BUNDLE_NAME);
        try {
            String sString = resourcebundleWS.getString(sKey);
            return MessageFormat.format(sString, sParam);
        }
        catch (Throwable throwable) {
            return sKey;
        }
    }

    public static String getLocaleString(String sKey, String[] asParams) {
        ResourceBundle resourcebundleWS = ResourceBundle.getBundle(S_WS_RESOURCE_BUNDLE_NAME);
        try {
            String sString = resourcebundleWS.getString(sKey);
            return MessageFormat.format(sString, asParams);
        }
        catch (Throwable throwable) {
            return sKey;
        }
    }

    public static String getLocaleString(String sKey) {
        ResourceBundle resourcebundleWS = ResourceBundle.getBundle(S_WS_RESOURCE_BUNDLE_NAME);
        try {
            String sString = resourcebundleWS.getString(sKey);
            return sString;
        }
        catch (Throwable throwable) {
            return sKey;
        }
    }

    public static String removeMessageKeys(String sMessage) {
        Matcher matcher = messageKeyPattern.matcher(sMessage);
        if (matcher.find()) {
            return matcher.replaceAll(S_EMPTY);
        }
        return sMessage;
    }
}

