/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.satellites;

import com.ibm.ws.install.ni.framework.NIFException;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridgeException;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.maintenanceplugins.MaintenanceInfoPlugin;
import com.ibm.ws.install.ni.framework.prereq.PrereqPlugin;
import com.ibm.ws.install.ni.framework.registry.NIFRegistryPlugin;
import com.ibm.ws.install.ni.framework.resourcebundle.NIFResourceBundleUtils;
import com.ibm.ws.install.ni.framework.satellites.SatelliteUtils;
import com.ibm.ws.install.ni.framework.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SatellitesDiskSpacePrereqPlugin
extends PrereqPlugin {
    private long m_lInstallRootFreeSpace;
    private long m_lTempRootFreeSpace;
    private String[] m_asPartitionNames;
    private MaintenanceInfoPlugin[] m_amipAllSatellites;
    private long NIFRegistryFreeSpace;
    private static final String S_SATELLITES_PARAM = "satellites";
    private static final String S_SATELLITESMETADATANAME_PARAM = "satellitesmetadataname";
    private static final String S_INSTALLROOT_PARAM = "installroot";
    private static final String S_TEMPROOT_PARAM = "temproot";
    private static final String S_INSTALLROOTBUFFER_PARAM = "installrootbuffer";
    private static final String S_TEMPROOTBUFFER_PARAM = "temprootbuffer";
    private static final String S_ADDFEATUREBUFFER_PARAM = "featurerootbuffer";
    private static final String S_IGNOREINSTALLSPACEREQUIREMENTSONUNINSTALL_PARAM = "ignoreinstallspacerequirementsonuninstall";
    private static final String S_ISBACKUPPACKAGE_PARAM = "isbackuppackage";
    private static final String S_DISABLE_DISK_SPACE_CHECK_PARAM = "disableDiskSpaceCheck";
    private static final String[] AS_REQUIRED_PARAMS;
    private static final String[] AS_OPTIONAL_PARAMS;
    private static final Pattern PATTERN_DISK_SPACE;
    private static final int N_GROUP_DISK_SPACE = 1;
    private static final int N_GROUP_DISK_SPACE_UNITS = 2;
    private static final long L_BYTES_MULTIPLIER = 1L;
    private static final long L_KB_MULTIPLIER = 1024L;
    private static final long L_MB_MULTIPLIER = 0x100000L;
    private static final long L_GB_MULTIPLIER = 0x40000000L;
    private static final String S_FORMAT_ERROR = "Space requirement format error for: ";
    private static final String[] AS_BYTES_UNITS;
    private static final String[] AS_KB_UNITS;
    private static final String[] AS_MB_UNITS;
    private static final String[] AS_GB_UNITS;
    private static final String S_PREREQ_FAILURE_MESSAGE_KEY = "SatellitesDiskSpacePrereqPlugin.prereqFailureMessage";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;

    static {
        Factory factory = new Factory("SatellitesDiskSpacePrereqPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin----"), 575);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-init-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin----void-"), 47);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getInstallRoot-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin----java.lang.String-"), 294);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getTempRoot-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin----java.lang.String-"), 304);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getInstallRootSpaceRequired-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin---com.ibm.ws.install.ni.framework.NIFException:-long-"), 314);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getTempRootSpaceRequired-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin---com.ibm.ws.install.ni.framework.NIFException:-long-"), 350);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getNIFRegistrySpaceRequired-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin----long-"), 380);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-areThesePathsOnTheSamePartition-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin-java.lang.String:java.lang.String:[Ljava.lang.String;:-sPathA:sPathB:aPartitionNames:-com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridgeException:-boolean-"), 415);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getPartitionFreeSpace-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin-java.lang.String:[Ljava.lang.String;:-sPath:aPartitionNames:-com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridgeException:-long-"), 449);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-convertSpaceToBytes-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin-java.lang.String:-sSpace:-com.ibm.ws.install.ni.framework.NIFException:-long-"), 471);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getSatelliteInfoPlugins-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin---java.io.IOException:org.xml.sax.SAXException:javax.xml.parsers.ParserConfigurationException:java.net.URISyntaxException:java.lang.InstantiationException:java.lang.IllegalAccessException:java.lang.ClassNotFoundException:-[Lcom.ibm.ws.install.ni.framework.maintenanceplugins.MaintenanceInfoPlugin;-"), 521);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-isDiskSpaceCheckDisabled-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin----boolean-"), 556);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFlag-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin----java.lang.String-"), 102);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPrereqFailureMessage-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin----java.lang.String-"), 164);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getTemprootbuffer-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin----java.lang.String-"), 224);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getInstallrootbuffer-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin----java.lang.String-"), 234);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFeaturerootbuffer-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin----java.lang.String-"), 243);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getNifRegistryRoot-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin----java.lang.String-"), 259);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin----[Ljava.lang.String;-"), 274);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.satellites.SatellitesDiskSpacePrereqPlugin----[Ljava.lang.String;-"), 284);
        AS_REQUIRED_PARAMS = new String[]{S_SATELLITES_PARAM, S_SATELLITESMETADATANAME_PARAM, S_INSTALLROOT_PARAM, S_TEMPROOT_PARAM, S_INSTALLROOTBUFFER_PARAM, S_TEMPROOTBUFFER_PARAM, S_IGNOREINSTALLSPACEREQUIREMENTSONUNINSTALL_PARAM, S_ISBACKUPPACKAGE_PARAM};
        AS_OPTIONAL_PARAMS = new String[]{S_DISABLE_DISK_SPACE_CHECK_PARAM, S_ADDFEATUREBUFFER_PARAM};
        PATTERN_DISK_SPACE = Pattern.compile("(\\d+)\\s*(.*?)");
        AS_BYTES_UNITS = new String[]{"BYTES", "B"};
        AS_KB_UNITS = new String[]{"KB", "K"};
        AS_MB_UNITS = new String[]{"MB", "M"};
        AS_GB_UNITS = new String[]{"GB", "G"};
    }

    public SatellitesDiskSpacePrereqPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.m_lInstallRootFreeSpace = -1L;
            this.m_lTempRootFreeSpace = -1L;
            this.m_asPartitionNames = new String[0];
            this.m_amipAllSatellites = new MaintenanceInfoPlugin[0];
            this.NIFRegistryFreeSpace = -1L;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public void init() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            super.init();
            if (!this.isDiskSpaceCheckDisabled()) {
                try {
                    this.m_asPartitionNames = this.getInstallToolkitBridge().getUnifiedFileIO().getPartitionNames();
                    this.m_lInstallRootFreeSpace = this.getPartitionFreeSpace(this.getInstallRoot(), this.m_asPartitionNames);
                    this.m_lTempRootFreeSpace = this.getPartitionFreeSpace(this.getTempRoot(), this.m_asPartitionNames);
                    this.NIFRegistryFreeSpace = this.getPartitionFreeSpace(this.getNifRegistryRoot(), this.m_asPartitionNames);
                    this.m_amipAllSatellites = this.getSatelliteInfoPlugins();
                }
                catch (InstallToolkitBridgeException installToolkitBridgeException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IOException iOException) {
                }
                catch (ParserConfigurationException parserConfigurationException) {
                }
                catch (SAXException sAXException) {
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getFlag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            try {
                if (this.isDiskSpaceCheckDisabled()) {
                    string = Boolean.TRUE.toString();
                } else {
                    long lTotalSpaceRequiredInInstallRoot;
                    long lInstallRootSpaceRequired = this.getInstallRootSpaceRequired();
                    long lTempRootSpaceRequired = this.getTempRootSpaceRequired();
                    long lNIFRegistrySpaceRequired = this.getNIFRegistrySpaceRequired();
                    string = this.m_lInstallRootFreeSpace < lInstallRootSpaceRequired ? Boolean.FALSE.toString() : (this.m_lTempRootFreeSpace < lTempRootSpaceRequired ? Boolean.FALSE.toString() : (this.NIFRegistryFreeSpace < lNIFRegistrySpaceRequired ? Boolean.FALSE.toString() : (this.areThesePathsOnTheSamePartition(this.getInstallRoot(), this.getTempRoot(), this.m_asPartitionNames) && this.m_lInstallRootFreeSpace < (lTotalSpaceRequiredInInstallRoot = lInstallRootSpaceRequired + lTempRootSpaceRequired) ? Boolean.FALSE.toString() : Boolean.TRUE.toString())));
                }
            }
            catch (NIFException nIFException) {
                string = Boolean.FALSE.toString();
            }
            catch (InstallToolkitBridgeException installToolkitBridgeException) {
                string = Boolean.FALSE.toString();
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getPrereqFailureMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            try {
                String sPrereqFailureMessage;
                String sRequiredSpaceInstallRoot = Long.toString(this.getInstallRootSpaceRequired() / 0x100000L);
                String sRequiredSpaceTempRoot = Long.toString(this.getTempRootSpaceRequired() / 0x100000L);
                String sRequiredSpaceNifRegistryRoot = Long.toString(this.getNIFRegistrySpaceRequired() / 0x100000L);
                if (this.areThesePathsOnTheSamePartition(this.getInstallRoot(), this.getTempRoot(), this.m_asPartitionNames)) {
                    long lTotalSpaceRequiredInInstallAndTempRoot = this.getInstallRootSpaceRequired() + this.getTempRootSpaceRequired();
                    sRequiredSpaceTempRoot = sRequiredSpaceInstallRoot = Long.toString(lTotalSpaceRequiredInInstallAndTempRoot / 0x100000L);
                }
                string = sPrereqFailureMessage = NIFResourceBundleUtils.getLocaleString(S_PREREQ_FAILURE_MESSAGE_KEY, new String[]{this.getInstallRoot(), sRequiredSpaceInstallRoot, new Long(this.m_lInstallRootFreeSpace / 0x100000L).toString(), this.getTempRoot(), sRequiredSpaceTempRoot, new Long(this.m_lTempRootFreeSpace / 0x100000L).toString(), this.getNifRegistryRoot(), sRequiredSpaceNifRegistryRoot, new Long(this.NIFRegistryFreeSpace / 0x100000L).toString()});
            }
            catch (NIFException e) {
                string = e.getMessage();
            }
            catch (InstallToolkitBridgeException e) {
                string = e.getMessage();
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getTemprootbuffer() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = this.getParamValue(S_TEMPROOTBUFFER_PARAM);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getInstallrootbuffer() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = this.getParamValue(S_INSTALLROOTBUFFER_PARAM);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getFeaturerootbuffer() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = this.getParamValue(S_ADDFEATUREBUFFER_PARAM);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getNifRegistryRoot() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            try {
                NIFRegistryPlugin nifRegPlugin = NIFRegistryPlugin.getNIFRegistryPlugin(this.getInstallToolkitBridge());
                string = new File(nifRegPlugin.getNIFRegistryURI().getPath()).getParent();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                string = "";
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_REQUIRED_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_REQUIRED_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_OPTIONAL_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_OPTIONAL_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String getInstallRoot() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = this.getParamValue(S_INSTALLROOT_PARAM);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String getTempRoot() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = this.getParamValue(S_TEMPROOT_PARAM);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected long getInstallRootSpaceRequired() throws NIFException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        try {
            long l;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Boolean b_ignoreInstallSpaceRequirementsOnUninstall = new Boolean(this.getParamValue(S_IGNOREINSTALLSPACEREQUIREMENTSONUNINSTALL_PARAM));
            Boolean b_isBackupPackage = new Boolean(this.getParamValue(S_ISBACKUPPACKAGE_PARAM));
            if (b_ignoreInstallSpaceRequirementsOnUninstall.booleanValue() && b_isBackupPackage.booleanValue()) {
                l = 0L;
            } else {
                long lReturn = 0L;
                int i = 0;
                while (i < this.m_amipAllSatellites.length) {
                    lReturn += this.convertSpaceToBytes(this.m_amipAllSatellites[i].getInstallrootspacerequired());
                    ++i;
                }
                l = lReturn += this.convertSpaceToBytes(this.getParamValue(S_INSTALLROOTBUFFER_PARAM));
            }
            long l2 = l;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.longObject((long)l2), joinPoint);
            return l;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected long getTempRootSpaceRequired() throws NIFException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            long lReturn = 0L;
            int i = 0;
            while (i < this.m_amipAllSatellites.length) {
                lReturn += this.convertSpaceToBytes(this.m_amipAllSatellites[i].getTemprootspacerequired());
                ++i;
            }
            long l = lReturn += this.convertSpaceToBytes(this.getParamValue(S_TEMPROOTBUFFER_PARAM));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.longObject((long)l), joinPoint);
            return l;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected long getNIFRegistrySpaceRequired() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            long lReturn = 0L;
            try {
                NIFRegistryPlugin nifRegPlugin = NIFRegistryPlugin.getNIFRegistryPlugin(this.getInstallToolkitBridge());
                FileSystemEntry fseRegistry = new FileSystemEntry(nifRegPlugin.getNIFRegistryURI(), this.getInstallToolkitBridge());
                lReturn = fseRegistry.exists() ? fseRegistry.getSize() + this.convertSpaceToBytes("1 MB") : this.convertSpaceToBytes("2 MB");
            }
            catch (Exception exception) {}
            long l = lReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.longObject((long)l), joinPoint);
            return l;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean areThesePathsOnTheSamePartition(String string, String string2, String[] stringArray) throws InstallToolkitBridgeException {
        String string3 = string;
        String string4 = string2;
        String[] stringArray2 = stringArray;
        Object[] objectArray = new Object[]{string3, string4, stringArray2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void sPathB;
            void aPartitionNames;
            void sPathA;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sPartitionNameA = this.getInstallToolkitBridge().getUnifiedFileIO().getPartitionName((String)sPathA, (String[])aPartitionNames);
            String sPartitionNameB = this.getInstallToolkitBridge().getUnifiedFileIO().getPartitionName((String)sPathB, (String[])aPartitionNames);
            boolean bl = sPartitionNameA.equals(sPartitionNameB);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected long getPartitionFreeSpace(String string, String[] stringArray) throws InstallToolkitBridgeException {
        String string2 = string;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string2, (Object)stringArray2);
        try {
            long lPartitionFreeSpace;
            void aPartitionNames;
            void sPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sPartitionName = this.getInstallToolkitBridge().getUnifiedFileIO().getPartitionName((String)sPath, (String[])aPartitionNames);
            long l = lPartitionFreeSpace = this.getInstallToolkitBridge().getUnifiedFileIO().getPartitionFreeSpace(sPartitionName);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.longObject((long)l), joinPoint);
            return l;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected long convertSpaceToBytes(String string) throws NIFException {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)string2);
        try {
            void sSpace;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Matcher matcherDiskSpace = PATTERN_DISK_SPACE.matcher((CharSequence)sSpace);
            if (!matcherDiskSpace.matches()) {
                throw new NIFException(S_FORMAT_ERROR + (String)sSpace);
            }
            long lDiskSpace = Long.parseLong(matcherDiskSpace.group(1));
            String sDiskSpaceUnits = matcherDiskSpace.group(2);
            long l = Arrays.asList(AS_BYTES_UNITS).contains(sDiskSpaceUnits.toUpperCase()) ? lDiskSpace * 1L : (Arrays.asList(AS_KB_UNITS).contains(sDiskSpaceUnits.toUpperCase()) ? lDiskSpace * 1024L : (Arrays.asList(AS_MB_UNITS).contains(sDiskSpaceUnits.toUpperCase()) ? lDiskSpace * 0x100000L : (Arrays.asList(AS_GB_UNITS).contains(sDiskSpaceUnits.toUpperCase()) ? lDiskSpace * 0x40000000L : lDiskSpace * 1L)));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.longObject((long)l), joinPoint);
            return l;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected MaintenanceInfoPlugin[] getSatelliteInfoPlugins() throws IOException, SAXException, ParserConfigurationException, URISyntaxException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] asSatellites = StringUtils.getCollectionAsStringArray(this.getExpandedParams(this.getParamValue(S_SATELLITES_PARAM)));
            Document[] adocumentSatellites = SatelliteUtils.getSatelliteDocuments(asSatellites, this.getParamValue(S_SATELLITESMETADATANAME_PARAM), this.getInstallToolkitBridge());
            MaintenanceInfoPlugin[] amip = new MaintenanceInfoPlugin[adocumentSatellites.length];
            int i = 0;
            while (i < adocumentSatellites.length) {
                amip[i] = MaintenanceInfoPlugin.getMaintenanceInfoPlugin(adocumentSatellites[i], this.getInstallToolkitBridge());
                ++i;
            }
            MaintenanceInfoPlugin[] maintenanceInfoPluginArray = amip;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(maintenanceInfoPluginArray, joinPoint);
            return amip;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected boolean isDiskSpaceCheckDisabled() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = new Boolean(System.getProperty(S_DISABLE_DISK_SPACE_CHECK_PARAM)) != false ? true : new Boolean(this.getParamValue(S_DISABLE_DISK_SPACE_CHECK_PARAM)) != false;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

