/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.utils;

import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.config.I5OSLaunchConfigManagerPlugin;
import com.ibm.ws.install.ni.framework.config.NIFConfigPluginEvent;
import com.ibm.ws.install.ni.framework.event.NIFEventMulticaster;
import com.ibm.ws.install.ni.framework.utils.FileModifiedEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ParseConfigLogFile {
    private long m_lLastSize;
    private int m_nCurrentActionIndex;
    private int m_nPercent;
    private Vector m_vAllConfigActionNames;
    private boolean m_fActionInfoLogFound;
    private boolean m_fAllRegisteredConfigActionsFound;
    private static final String S_EMPTY = "";
    private static final String S_COMMA = ",";
    private static final int N_ACTIONS_GROUP = 3;
    private static final int N_FINISHING_PERCENT = 98;
    private static final int N_BEGINNING_PERCENT = 10;
    private static final String S_TAG_LOGGER = "<logger>com.ibm.ws.install.configmanager.ConfigManager</logger>";
    private static final Pattern PATTERN_LOG_MESSAGE;
    private static final Pattern PATTERN_ACTION_LIST;
    private static final Pattern PATTERN_ACTION_COMPLETED;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;

    static {
        Factory factory = new Factory("ParseConfigLogFile.java", Class.forName("com.ibm.ws.install.ni.framework.utils.ParseConfigLogFile"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.utils.ParseConfigLogFile----"), 220);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-parseLogFile-com.ibm.ws.install.ni.framework.utils.ParseConfigLogFile-com.ibm.ws.install.ni.framework.utils.FileModifiedEvent:-fme:--void-"), 38);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-parseForCompletedConfigAction-com.ibm.ws.install.ni.framework.utils.ParseConfigLogFile-java.lang.String:-sCurrentLineRead:--void-"), 129);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-parseForAllConfigActions-com.ibm.ws.install.ni.framework.utils.ParseConfigLogFile-java.lang.String:-sCurrentLineRead:--void-"), 169);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-recordConfigManagerActions-com.ibm.ws.install.ni.framework.utils.ParseConfigLogFile-java.lang.String:int:-sActionName:nPercentComplete:--void-"), 207);
        PATTERN_LOG_MESSAGE = Pattern.compile("(\\s*<message>)(.*)(</message>\\s*)");
        PATTERN_ACTION_LIST = Pattern.compile("(\\s*<message>List of all actions found in the repository: )([^\\w])(.*)([^\\w])(</message>\\s*)");
        PATTERN_ACTION_COMPLETED = Pattern.compile("(\\s*<message>Configuration action succeeded: )(.*)(</message>\\s*)");
    }

    public ParseConfigLogFile() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.m_lLastSize = 0L;
            this.m_nCurrentActionIndex = 0;
            this.m_nPercent = 0;
            this.m_vAllConfigActionNames = new Vector();
            this.m_fActionInfoLogFound = false;
            this.m_fAllRegisteredConfigActionsFound = false;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void parseLogFile(FileModifiedEvent fileModifiedEvent) {
        FileModifiedEvent fileModifiedEvent2 = fileModifiedEvent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)fileModifiedEvent2);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            try {
                void fme;
                long lNewFileSize = fme.getCurrentSize();
                BufferedReader bufferedreaderLogFile = new BufferedReader(new InputStreamReader(fme.getSpecifiedFileSystemEntry().getInputStream()));
                if (lNewFileSize < this.m_lLastSize) {
                    this.m_lLastSize = 0L;
                    this.m_nCurrentActionIndex = 0;
                    this.m_nPercent = 0;
                    this.m_vAllConfigActionNames = new Vector();
                    this.m_fActionInfoLogFound = false;
                    this.m_fAllRegisteredConfigActionsFound = false;
                }
                bufferedreaderLogFile.skip(this.m_lLastSize);
                int nBufferSize = (int)(lNewFileSize - this.m_lLastSize);
                char[] acBuffer = new char[nBufferSize + 8];
                bufferedreaderLogFile.read(acBuffer, 0, nBufferSize + 8);
                bufferedreaderLogFile.close();
                this.m_lLastSize = lNewFileSize;
                BufferedReader bufferedreaderNewContent = new BufferedReader(new StringReader(new String(acBuffer)));
                String sCurrentLineRead = bufferedreaderNewContent.readLine();
                while (sCurrentLineRead != null) {
                    Matcher matcherLogMessage;
                    if (sCurrentLineRead.indexOf(S_TAG_LOGGER) != -1) {
                        this.m_fActionInfoLogFound = true;
                    } else if (this.m_fActionInfoLogFound && (matcherLogMessage = PATTERN_LOG_MESSAGE.matcher(sCurrentLineRead)).matches()) {
                        this.m_fActionInfoLogFound = false;
                        if (!this.m_fAllRegisteredConfigActionsFound) {
                            this.parseForAllConfigActions(sCurrentLineRead);
                        } else {
                            this.parseForCompletedConfigAction(sCurrentLineRead);
                        }
                    }
                    sCurrentLineRead = bufferedreaderNewContent.readLine();
                }
                bufferedreaderNewContent.close();
            }
            catch (IOException iOException) {
                if (this.m_vAllConfigActionNames.size() <= 0) {
                    this.recordConfigManagerActions(S_EMPTY, 10);
                }
                if (this.m_nCurrentActionIndex >= this.m_vAllConfigActionNames.size()) {
                    this.recordConfigManagerActions((String)this.m_vAllConfigActionNames.lastElement(), 99);
                }
                this.recordConfigManagerActions((String)this.m_vAllConfigActionNames.elementAt(this.m_nCurrentActionIndex), (100 - this.m_nPercent) / 2 + this.m_nPercent);
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseForCompletedConfigAction(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2);
        try {
            void sCurrentLineRead;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Matcher matcherActionCompleted = PATTERN_ACTION_COMPLETED.matcher((CharSequence)sCurrentLineRead);
            if (matcherActionCompleted.matches()) {
                ++this.m_nCurrentActionIndex;
                if (this.m_nCurrentActionIndex >= this.m_vAllConfigActionNames.size()) {
                    this.m_nPercent = 98;
                    I5OSLaunchConfigManagerPlugin.setCurrentConfigActionBeingExecuted((String)this.m_vAllConfigActionNames.lastElement());
                    this.recordConfigManagerActions((String)this.m_vAllConfigActionNames.lastElement(), 98);
                } else {
                    this.m_nPercent = (int)((double)this.m_nCurrentActionIndex / (double)this.m_vAllConfigActionNames.size() * 100.0);
                    I5OSLaunchConfigManagerPlugin.setCurrentConfigActionBeingExecuted((String)this.m_vAllConfigActionNames.elementAt(this.m_nCurrentActionIndex));
                    this.recordConfigManagerActions((String)this.m_vAllConfigActionNames.elementAt(this.m_nCurrentActionIndex), this.m_nPercent);
                }
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseForAllConfigActions(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string2);
        try {
            void sCurrentLineRead;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Matcher matcherActionList = PATTERN_ACTION_LIST.matcher((CharSequence)sCurrentLineRead);
            if (matcherActionList.matches()) {
                String sActions = matcherActionList.group(3);
                StringTokenizer stActionParser = new StringTokenizer(sActions, S_COMMA);
                while (stActionParser.hasMoreTokens()) {
                    String sAction = stActionParser.nextToken();
                    String sActionName = sAction.substring(sAction.lastIndexOf("/") + 1);
                    this.m_vAllConfigActionNames.add(sActionName);
                }
                this.m_fAllRegisteredConfigActionsFound = true;
                if (this.m_vAllConfigActionNames.size() > 0) {
                    I5OSLaunchConfigManagerPlugin.setCurrentConfigActionBeingExecuted((String)this.m_vAllConfigActionNames.firstElement());
                    this.recordConfigManagerActions((String)this.m_vAllConfigActionNames.firstElement(), 0);
                }
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void recordConfigManagerActions(String string, int n) {
        String string2 = string;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string2, (Object)Conversions.intObject((int)n2));
        try {
            void nPercentComplete;
            void sActionName;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            NIFConfigPluginEvent nifcpe = new NIFConfigPluginEvent((String)sActionName, (int)nPercentComplete);
            NIFEventMulticaster.instance().publishEvent(nifcpe);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

