/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.utils;

import com.ibm.websphere.product.WASProductInfo;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.utils.URIUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ProductUtils {
    public static final String S_ID_WAS = "WAS";
    private static final String S_ID_BASETRIAL = "BASETRIAL";
    private static final String S_ID_EXPRESSTRIAL = "EXPRESSTRIAL";
    private static final String S_RELATIVE_VERSION_PATH = "properties/version";
    private static String S_PRODUCT_FILE_EXTENSION;
    private static final String PATTERN_PRODUCT_NODE = "<product\\s*(.*?)\\s*</product>";
    private static final String PATTERN_NAME = "name=\"(.*?)\"";
    private static final String PATTERN_ID = "<id>\\s*(.*?)\\s*</id>";
    private static final String PATTERN_VERSION = "<version>\\s*(.*?)\\s*</version>";
    private static final String PATTERN_DATE = "date=\"(.*?)\"";
    private static final String PATTERN_LEVEL = "level=\"(.*?)\"";
    private static final char S_WINDOWS_FILE_SEPARATOR = '\\';
    private static final char S_LINUX_FILE_SEPARATOR = '/';
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;

    static {
        Factory factory = new Factory("ProductUtils.java", Class.forName("com.ibm.ws.install.ni.framework.utils.ProductUtils"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.utils.ProductUtils----"), 30);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getProductVersionByProductID-com.ibm.ws.install.ni.framework.utils.ProductUtils-[Lcom.ibm.websphere.product.WASProductInfo;:java.lang.String:-wasproductinfoarrayThis:sProductID:--java.lang.String-"), 40);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-convertWASProductID-com.ibm.ws.install.ni.framework.utils.ProductUtils-java.lang.String:-sProductID:--java.lang.String-"), 75);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getWASProductInfoInstances-com.ibm.ws.install.ni.framework.utils.ProductUtils-java.lang.String:com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge:-sInstallLocation:itb:--[Lcom.ibm.websphere.product.WASProductInfo;-"), 96);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-parseProductFileFromInputStream-com.ibm.ws.install.ni.framework.utils.ProductUtils-java.io.InputStream:-inputstream:--java.util.Vector-"), 157);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-parseProductString-com.ibm.ws.install.ni.framework.utils.ProductUtils-java.lang.String:-sProductString:--com.ibm.websphere.product.WASProductInfo-"), 182);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-parseInputStreamToString-com.ibm.ws.install.ni.framework.utils.ProductUtils-java.io.InputStream:-inputStream:--java.lang.String-"), 234);
        S_PRODUCT_FILE_EXTENSION = ".product";
    }

    public ProductUtils() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static String getProductVersionByProductID(WASProductInfo[] wASProductInfoArray, String string) {
        WASProductInfo[] wASProductInfoArray2 = wASProductInfoArray;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)wASProductInfoArray2, (Object)string2);
        try {
            String string3;
            block7: {
                WASProductInfo[] wasproductinfoarrayThis;
                String sProductID;
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
                if (S_ID_BASETRIAL.equalsIgnoreCase(sProductID)) {
                    sProductID = "BASE";
                } else if (S_ID_EXPRESSTRIAL.equalsIgnoreCase(sProductID)) {
                    sProductID = "EXPRESS";
                }
                int i = 0;
                while (i < wasproductinfoarrayThis.length) {
                    if (wasproductinfoarrayThis[i].getId().equalsIgnoreCase(sProductID)) {
                        string3 = wasproductinfoarrayThis[i].getVersion();
                        break block7;
                    }
                    ++i;
                }
                string3 = null;
            }
            String string4 = string3;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string4, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static String convertWASProductID(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string2);
        try {
            String sProductID;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (S_ID_BASETRIAL.equalsIgnoreCase(sProductID) || S_ID_EXPRESSTRIAL.equalsIgnoreCase(sProductID) || "BASE".equalsIgnoreCase(sProductID) || "EXPRESS".equalsIgnoreCase(sProductID) || "ND".equalsIgnoreCase(sProductID)) {
                sProductID = S_ID_WAS;
            }
            String string3 = sProductID;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string3, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static WASProductInfo[] getWASProductInfoInstances(String string, InstallToolkitBridge installToolkitBridge) {
        String string2 = string;
        InstallToolkitBridge installToolkitBridge2 = installToolkitBridge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string2, (Object)installToolkitBridge2);
        try {
            Vector vWASProductInfo;
            block9: {
                String sInstallLocation;
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
                vWASProductInfo = new Vector();
                String sProductFileLocation = String.valueOf(sInstallLocation) + "/" + S_RELATIVE_VERSION_PATH;
                try {
                    void itb;
                    FileSystemEntry fseVersionDirectory = URIUtils.convertPathToDefaultTargetMachineFSE(sProductFileLocation, (InstallToolkitBridge)itb);
                    if (!fseVersionDirectory.isDirectory()) break block9;
                    FileSystemEntry[] fseFilesUnderVersionDir = fseVersionDirectory.getDirectoryEntries();
                    int i = 0;
                    while (i < fseFilesUnderVersionDir.length) {
                        if (fseFilesUnderVersionDir[i].getURI().getPath().endsWith(S_PRODUCT_FILE_EXTENSION)) {
                            try {
                                Vector vWASProductInfoPerProductFile = ProductUtils.parseProductFileFromInputStream(fseFilesUnderVersionDir[i].getInputStream());
                                vWASProductInfo.addAll(vWASProductInfoPerProductFile);
                            }
                            catch (IOException ioe) {
                                ioe.getMessage();
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
            WASProductInfo[] wasproductinfoarrayReturned = new WASProductInfo[vWASProductInfo.size()];
            int i = 0;
            while (i < vWASProductInfo.size()) {
                wasproductinfoarrayReturned[i] = (WASProductInfo)vWASProductInfo.elementAt(i);
                ++i;
            }
            WASProductInfo[] wASProductInfoArray = wasproductinfoarrayReturned;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(wASProductInfoArray, joinPoint);
            return wasproductinfoarrayReturned;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static Vector parseProductFileFromInputStream(InputStream inputStream) {
        InputStream inputStream2 = inputStream;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)inputStream2);
        try {
            InputStream inputstream;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Vector<WASProductInfo> vWASProductInfoReturn = new Vector<WASProductInfo>();
            String sProductFileContent = ProductUtils.parseInputStreamToString(inputstream);
            if (sProductFileContent != null) {
                Pattern patternProduct = Pattern.compile(PATTERN_PRODUCT_NODE, 32);
                Matcher matcherProduct = patternProduct.matcher(sProductFileContent);
                while (matcherProduct.find()) {
                    String sProductString = matcherProduct.group();
                    WASProductInfo wasproductinfoThis = ProductUtils.parseProductString(sProductString);
                    vWASProductInfoReturn.add(wasproductinfoThis);
                }
            }
            Vector<WASProductInfo> vector = vWASProductInfoReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(vector, joinPoint);
            return vector;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static WASProductInfo parseProductString(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)string2);
        try {
            String sProductString;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String name = "";
            String id = "";
            String version = "";
            String date = "";
            String level = "";
            Pattern pattern = Pattern.compile(PATTERN_NAME, 32);
            Matcher matcher = pattern.matcher(sProductString);
            if (matcher.find()) {
                String nameString = matcher.group();
                name = nameString.substring(nameString.indexOf(34) + 1, nameString.lastIndexOf(34));
            }
            if ((matcher = (pattern = Pattern.compile(PATTERN_ID, 32)).matcher(sProductString)).find()) {
                String idString = matcher.group();
                id = idString.substring(idString.indexOf("<id>") + 4, idString.indexOf("</id>"));
            }
            if ((matcher = (pattern = Pattern.compile(PATTERN_VERSION, 32)).matcher(sProductString)).find()) {
                String versionString = matcher.group();
                version = versionString.substring(versionString.indexOf("<version>") + 9, versionString.indexOf("</version>"));
            }
            if ((matcher = (pattern = Pattern.compile(PATTERN_DATE, 32)).matcher(sProductString)).find()) {
                String dateString = matcher.group();
                date = dateString.substring(dateString.indexOf(34) + 1, dateString.lastIndexOf(34));
            }
            if ((matcher = (pattern = Pattern.compile(PATTERN_LEVEL, 32)).matcher(sProductString)).find()) {
                String levelString = matcher.group();
                level = levelString.substring(levelString.indexOf(34) + 1, levelString.lastIndexOf(34));
            }
            WASProductInfo wASProductInfo = new WASProductInfo(name, id, version, date, level);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(wASProductInfo, joinPoint);
            return wASProductInfo;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static String parseInputStreamToString(InputStream inputStream) {
        InputStream inputStream2 = inputStream;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)inputStream2);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sFileContents = null;
            try {
                InputStream inputStream3;
                byte[] abTotal = new byte[inputStream3.available()];
                inputStream3.read(abTotal);
                sFileContents = new String(abTotal);
                inputStream3.close();
            }
            catch (IOException ex) {
                ex.getMessage();
            }
            String string = sFileContents;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

