/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.validators;

import com.ibm.ws.install.ni.framework.NIFException;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.os.PlatformConstants;
import com.ibm.ws.install.ni.framework.registry.NIFRegistryOfferingEntry;
import com.ibm.ws.install.ni.framework.registry.NIFRegistryPlugin;
import com.ibm.ws.install.ni.framework.utils.URIUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class InputValidation {
    protected static final String S_EMPTY = "";
    protected static final int WINDOWS_ALLOWED_DIR_LENGTH = 60;
    protected static final String S_IBM = ".ibm";
    protected static final Pattern PATTERN_WINDOWS_PATH;
    protected static final Pattern PATTERN_UNIX_PATH;
    protected static final int N_PATH_GROUP = 1;
    protected static final String S_WINDOWS_DRIVE_SEPARATOR = ":";
    protected static final char S_WINDOWS_FILE_SEPARATOR = '\\';
    protected static final char S_LINUX_FILE_SEPARATOR = '/';
    protected static final String S_OS400_CASESENSITIVE_PATH_QOPENSYS = "/qopensys/";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;

    static {
        Factory factory = new Factory("InputValidation.java", Class.forName("com.ibm.ws.install.ni.framework.validators.InputValidation"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.validators.InputValidation----"), 35);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isExistDirectory-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge:-sDirectoryPath:itb:--boolean-"), 45);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isPathInRegistry-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge:-sDirectoryPath:itb:--boolean-"), 345);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getMaintenancePackageURI-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge:-sPackagePath:itb:-com.ibm.ws.install.ni.framework.NIFException:-java.lang.String-"), 386);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isMaintenanceMetaDataNotReadableFromDirectory-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge:-sDirectoryPath:itb:--boolean-"), 409);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isMaintenanceMetaDataNotReadableFromPak-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge:-sPakFilePath:itb:--boolean-"), 445);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-doesCurrentUserOwnCurrentProduct-com.ibm.ws.install.ni.framework.validators.InputValidation-com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge:-itb:--boolean-"), 476);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c-areThesePathsPointToSameLocation-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:java.lang.String:-sSourcePath:sTargetPath:--boolean-"), 509);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-pathContainsSymbolicLink-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:-installLocation:--boolean-"), 585);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isExistNormalFile-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge:-sFilePath:itb:--boolean-"), 77);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isWriteable-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge:-sDirectoryPath:itb:--boolean-"), 116);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isValidInstallDirectory-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge:-sDirectoryPath:itb:--boolean-"), 150);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isPlatformValidDirectory-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge:-sDirectoryPath:itb:--boolean-"), 190);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c-isValidWindowsInstallDirectory-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:-strDirectoryName:--boolean-"), 228);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c-isValidUnixInstallDirectory-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:-strDirectoryName:--boolean-"), 269);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c-isValidI5OSInstallDirectory-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:-strDirectoryName:--boolean-"), 309);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isPartOfRegistryPath-com.ibm.ws.install.ni.framework.validators.InputValidation-java.lang.String:com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge:-sDirectoryPath:itb:--boolean-"), 322);
        PATTERN_WINDOWS_PATH = Pattern.compile("[a-zA-Z]:[\\\\/](.+)");
        PATTERN_UNIX_PATH = Pattern.compile("[/](.+)");
    }

    public InputValidation() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isExistDirectory(String string, InstallToolkitBridge installToolkitBridge) {
        String string2 = string;
        InstallToolkitBridge installToolkitBridge2 = installToolkitBridge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string2, (Object)installToolkitBridge2);
        try {
            boolean bl;
            String sDirectoryPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (sDirectoryPath == null || sDirectoryPath.trim().equals(S_EMPTY)) {
                bl = false;
            } else {
                try {
                    void itb;
                    FileSystemEntry fseFilePath = URIUtils.convertPathToDefaultTargetMachineFSE(sDirectoryPath, (InstallToolkitBridge)itb);
                    bl = fseFilePath.exists() && fseFilePath.isDirectory();
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isExistNormalFile(String string, InstallToolkitBridge installToolkitBridge) {
        String string2 = string;
        InstallToolkitBridge installToolkitBridge2 = installToolkitBridge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string2, (Object)installToolkitBridge2);
        try {
            boolean bl;
            String sFilePath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (sFilePath == null || sFilePath.trim().equals(S_EMPTY)) {
                bl = false;
            } else {
                try {
                    void itb;
                    FileSystemEntry fseFilePath = URIUtils.convertPathToDefaultTargetMachineFSE(sFilePath, (InstallToolkitBridge)itb);
                    bl = fseFilePath.exists() && !fseFilePath.isDirectory();
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isWriteable(String string, InstallToolkitBridge installToolkitBridge) {
        String string2 = string;
        InstallToolkitBridge installToolkitBridge2 = installToolkitBridge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string2, (Object)installToolkitBridge2);
        try {
            boolean bl;
            String sDirectoryPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (sDirectoryPath == null || sDirectoryPath.trim().equals(S_EMPTY)) {
                bl = false;
            } else {
                try {
                    void itb;
                    FileSystemEntry fseFilePath = URIUtils.convertPathToDefaultTargetMachineFSE(sDirectoryPath, (InstallToolkitBridge)itb);
                    bl = fseFilePath.writeable();
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isValidInstallDirectory(String string, InstallToolkitBridge installToolkitBridge) {
        String string2 = string;
        InstallToolkitBridge installToolkitBridge2 = installToolkitBridge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)string2, (Object)installToolkitBridge2);
        try {
            boolean bl;
            String sDirectoryPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (sDirectoryPath == null || sDirectoryPath.trim().equals(S_EMPTY)) {
                bl = false;
            } else {
                try {
                    void itb;
                    FileSystemEntry fseFilePath = URIUtils.convertPathToDefaultTargetMachineFSE(sDirectoryPath, (InstallToolkitBridge)itb);
                    bl = fseFilePath.exists() ? (!fseFilePath.isDirectory() ? false : fseFilePath.getDirectoryEntries().length == 0) : true;
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isPlatformValidDirectory(String string, InstallToolkitBridge installToolkitBridge) {
        String string2 = string;
        InstallToolkitBridge installToolkitBridge2 = installToolkitBridge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)string2, (Object)installToolkitBridge2);
        try {
            void itb;
            String sDirectoryPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            boolean bl = sDirectoryPath == null || sDirectoryPath.trim().equals(S_EMPTY) ? false : (InputValidation.isPartOfRegistryPath(sDirectoryPath, (InstallToolkitBridge)itb) ? false : (PlatformConstants.isOS400Install() ? InputValidation.isValidI5OSInstallDirectory(sDirectoryPath) : (PlatformConstants.isCurrentPlatformWindows() ? (sDirectoryPath.length() >= 60 ? false : InputValidation.isValidWindowsInstallDirectory(sDirectoryPath)) : InputValidation.isValidUnixInstallDirectory(sDirectoryPath))));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected static boolean isValidWindowsInstallDirectory(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)string2);
        try {
            boolean bl;
            block9: {
                String strDirectoryName;
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                Matcher winMatch = PATTERN_WINDOWS_PATH.matcher(strDirectoryName);
                if (winMatch.matches()) {
                    boolean isFileSeparator = true;
                    String testPath = winMatch.group(1);
                    int i = 0;
                    while (i < testPath.length()) {
                        char characterToCheck = testPath.charAt(i);
                        if (characterToCheck == '\\' || characterToCheck == '/') {
                            if (isFileSeparator) {
                                bl = false;
                                break block9;
                            }
                            isFileSeparator = true;
                        } else {
                            if ("{}:;*?\"<>|%,=+&'#^!`$[]".indexOf(characterToCheck) != -1) {
                                bl = false;
                                break block9;
                            }
                            isFileSeparator = false;
                        }
                        ++i;
                    }
                    bl = true;
                } else {
                    bl = false;
                }
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected static boolean isValidUnixInstallDirectory(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)string2);
        try {
            boolean bl;
            block9: {
                String strDirectoryName;
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                Matcher linuxMatch = PATTERN_UNIX_PATH.matcher(strDirectoryName);
                if (linuxMatch.matches()) {
                    boolean isFileSeparator = true;
                    String testPath = linuxMatch.group(1);
                    int i = 0;
                    while (i < testPath.length()) {
                        char characterToCheck = testPath.charAt(i);
                        if (characterToCheck == '/') {
                            if (isFileSeparator) {
                                bl = false;
                                break block9;
                            }
                            isFileSeparator = true;
                        } else {
                            if (" {}`!&*()|:^;<>?\"\\,=+%'#$[]".indexOf(characterToCheck) != -1) {
                                bl = false;
                                break block9;
                            }
                            isFileSeparator = false;
                        }
                        ++i;
                    }
                    bl = true;
                } else {
                    bl = false;
                }
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected static boolean isValidI5OSInstallDirectory(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)string2);
        try {
            String strDirectoryName;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = InputValidation.isValidUnixInstallDirectory(strDirectoryName);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static boolean isPartOfRegistryPath(String string, InstallToolkitBridge installToolkitBridge) {
        String string2 = string;
        InstallToolkitBridge installToolkitBridge2 = installToolkitBridge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)string2, (Object)installToolkitBridge2);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            try {
                String sDirectoryPath;
                bl = sDirectoryPath.indexOf(S_IBM) != -1;
            }
            catch (Exception exception) {
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isPathInRegistry(String string, InstallToolkitBridge installToolkitBridge) {
        String string2 = string;
        InstallToolkitBridge installToolkitBridge2 = installToolkitBridge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null, (Object)string2, (Object)installToolkitBridge2);
        try {
            boolean bl;
            block8: {
                String sDirectoryPath;
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
                if (sDirectoryPath == null || sDirectoryPath.trim().equals(S_EMPTY)) {
                    bl = false;
                } else {
                    try {
                        void itb;
                        String sPath = sDirectoryPath;
                        NIFRegistryPlugin nifRegistry = NIFRegistryPlugin.getNIFRegistryPlugin((InstallToolkitBridge)itb);
                        NIFRegistryOfferingEntry[] installedProducts = nifRegistry.getInstalledProducts();
                        int i = 0;
                        while (i < installedProducts.length) {
                            if (InputValidation.areThesePathsPointToSameLocation(sPath, installedProducts[i].getOfferingLocationPath())) {
                                bl = true;
                                break block8;
                            }
                            ++i;
                        }
                        bl = false;
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                }
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getMaintenancePackageURI(String string, InstallToolkitBridge installToolkitBridge) throws NIFException {
        String string2 = string;
        InstallToolkitBridge installToolkitBridge2 = installToolkitBridge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)string2, (Object)installToolkitBridge2);
        try {
            String string3;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            try {
                void itb;
                String sPackagePath;
                string3 = URIUtils.convertPathToURI(sPackagePath, (InstallToolkitBridge)itb).toString();
            }
            catch (URISyntaxException e) {
                throw new NIFException(e, (Throwable)e);
            }
            String string4 = string3;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string4, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMaintenanceMetaDataNotReadableFromDirectory(String string, InstallToolkitBridge installToolkitBridge) {
        String string2 = string;
        InstallToolkitBridge installToolkitBridge2 = installToolkitBridge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null, (Object)string2, (Object)installToolkitBridge2);
        try {
            boolean bl;
            block8: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
                try {
                    void itb;
                    String sDirectoryPath;
                    FileSystemEntry[] fseSourceFiles = URIUtils.convertPathToDefaultTargetMachineFSE(sDirectoryPath, (InstallToolkitBridge)itb).getDirectoryEntries();
                    int i = 0;
                    while (i < fseSourceFiles.length) {
                        if (fseSourceFiles[i].getAbsolutePath().endsWith(".pak")) {
                            try {
                                new FileSystemEntry(new URI(InputValidation.getMaintenancePackageURI(fseSourceFiles[i].getAbsolutePath(), (InstallToolkitBridge)itb)), "maintenance.xml", (InstallToolkitBridge)itb).getContents();
                                bl = true;
                                break block8;
                            }
                            catch (Exception exception) {}
                        }
                        ++i;
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMaintenanceMetaDataNotReadableFromPak(String string, InstallToolkitBridge installToolkitBridge) {
        String string2 = string;
        InstallToolkitBridge installToolkitBridge2 = installToolkitBridge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null, (Object)string2, (Object)installToolkitBridge2);
        try {
            boolean bl;
            block7: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
                try {
                    void itb;
                    String sPakFilePath;
                    FileSystemEntry fseSourceFile = URIUtils.convertPathToDefaultTargetMachineFSE(sPakFilePath, (InstallToolkitBridge)itb);
                    if (fseSourceFile.getAbsolutePath().endsWith(".pak")) {
                        try {
                            new FileSystemEntry(new URI(InputValidation.getMaintenancePackageURI(fseSourceFile.getAbsolutePath(), (InstallToolkitBridge)itb)), "maintenance.xml", (InstallToolkitBridge)itb).getContents();
                            bl = true;
                            break block7;
                        }
                        catch (Exception exception) {}
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static boolean doesCurrentUserOwnCurrentProduct(InstallToolkitBridge installToolkitBridge) {
        InstallToolkitBridge installToolkitBridge2 = installToolkitBridge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null, (Object)installToolkitBridge2);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            try {
                InstallToolkitBridge itb;
                NIFRegistryPlugin nifRegistry = NIFRegistryPlugin.getNIFRegistryPlugin(itb);
                bl = nifRegistry.doesCurrentUserOwnCurrentProduct();
            }
            catch (Exception exception) {
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected static boolean areThesePathsPointToSameLocation(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, null, null, (Object)string3, (Object)string4);
        try {
            boolean bl;
            String sTargetPath;
            String sSourcePath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (sSourcePath == null || sTargetPath == null) {
                bl = false;
            } else if (PlatformConstants.isCurrentPlatformWindows() && !PlatformConstants.isOS400Install()) {
                sSourcePath = sSourcePath.replace('/', '\\');
                sTargetPath = sTargetPath.replace('/', '\\');
                bl = sSourcePath.equalsIgnoreCase(sTargetPath);
            } else if (PlatformConstants.isOS400Install()) {
                if (sSourcePath.toLowerCase().startsWith(S_OS400_CASESENSITIVE_PATH_QOPENSYS) && sTargetPath.toLowerCase().startsWith(S_OS400_CASESENSITIVE_PATH_QOPENSYS)) {
                    String sSourceChildPath = sSourcePath.substring(S_OS400_CASESENSITIVE_PATH_QOPENSYS.length());
                    String sTargetChildPath = sTargetPath.substring(S_OS400_CASESENSITIVE_PATH_QOPENSYS.length());
                    bl = sSourceChildPath.equals(sTargetChildPath);
                } else {
                    bl = sSourcePath.equalsIgnoreCase(sTargetPath);
                }
            } else {
                bl = sSourcePath.equals(sTargetPath);
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static boolean pathContainsSymbolicLink(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, null, null, (Object)string2);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            try {
                String installLocation;
                if (installLocation == null || installLocation.equals(S_EMPTY)) {
                    bl = false;
                } else {
                    File file;
                    String sWindowsPathPatner;
                    if (PlatformConstants.isCurrentPlatformWindows() && installLocation.matches(sWindowsPathPatner = "[a-z]:[\\\\/](.*)")) {
                        String sDrive = installLocation.substring(0, installLocation.indexOf(S_WINDOWS_DRIVE_SEPARATOR)).toUpperCase();
                        installLocation = String.valueOf(sDrive) + installLocation.substring(installLocation.indexOf(S_WINDOWS_DRIVE_SEPARATOR));
                    }
                    bl = !(file = new File(installLocation)).getCanonicalPath().equals(file.getAbsolutePath());
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

