/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client.indications;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.client.indications.CIMEvent;
import org.sblim.wbem.client.indications.CIMIndicationListenertList;
import org.sblim.wbem.client.indications.CIMListener;
import org.sblim.wbem.util.GlobalProperties;

public class CIMEventDispatcher
extends Thread {
    protected Vector iEventQueue = new Vector();
    protected CIMIndicationListenertList iClient = null;
    private boolean iAlive = true;

    public CIMEventDispatcher(CIMIndicationListenertList pClient) {
        this.iClient = pClient;
        this.setDaemon(true);
        this.setName("CIM EventDispatcher");
        this.start();
    }

    public synchronized void dispatchEvent(CIMEvent pEvent) {
        Logger logger = GlobalProperties.getLogger();
        if (pEvent != null) {
            this.iEventQueue.add(pEvent);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Added CIMEvent (id=" + pEvent.getID() + " to the queue (" + this.iEventQueue.size() + " elements total)");
            }
            this.notify();
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "CIMEvent to dispatch was null");
        }
    }

    public synchronized void startup() {
        this.iAlive = true;
        this.start();
    }

    public synchronized void kill() {
        this.iAlive = false;
        this.notify();
    }

    public synchronized void close() {
        this.kill();
    }

    private synchronized CIMEvent getEvent() {
        CIMEvent event = null;
        Logger logger = GlobalProperties.getLogger();
        while (event == null) {
            try {
                if (this.iEventQueue.size() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.iAlive) break;
            if (this.iEventQueue.size() <= 0) continue;
            event = (CIMEvent)this.iEventQueue.remove(0);
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "Removed CIMEvent (id=" + event.getID() + "from the queue (" + this.iEventQueue.size() + " elements left)");
        }
        return event;
    }

    public void run() {
        Logger logger = GlobalProperties.getLogger();
        while (true) {
            CIMEvent event = this.getEvent();
            if (!this.iAlive) break;
            Vector currentListeners = this.iClient.getListeners(event.getID());
            int total = currentListeners.size();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Processing CIMEvent (id=" + event.getID() + ")");
            }
            Vector<Long> timePerHandler = new Vector<Long>();
            long totalTime = System.currentTimeMillis();
            for (int i = 0; i < total; ++i) {
                long totalTimePerHandle;
                block5: {
                    totalTimePerHandle = System.currentTimeMillis();
                    CIMListener listener = (CIMListener)currentListeners.elementAt(i);
                    try {
                        listener.indicationOccured(event);
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.WARNING)) break block5;
                        logger.log(Level.WARNING, "Exception caught in listener (" + listener.getClass().getName() + ") while processing CIMEvent", e);
                    }
                }
                timePerHandler.add(new Long(System.currentTimeMillis() - totalTimePerHandle));
            }
            totalTime = System.currentTimeMillis() - totalTime;
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.log(Level.FINER, "Total time to process the event by all handlers " + totalTime + "ms, TimePerHandle=" + timePerHandler.toString());
        }
    }
}

