/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.extensions.applicationext.util;

import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationextPackage;
import com.ibm.ejs.models.base.extensions.applicationext.ModuleExtension;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.application.Module;

public class ApplicationExtensionCoreSynchronizeAdapter
extends AdapterImpl {
    public void notifyChanged(Notification notification) {
        if (notification.getFeature() == ApplicationPackage.eINSTANCE.getApplication_Modules()) {
            this.modifiedModules(notification);
        } else if (notification.getFeature() == ApplicationextPackage.eINSTANCE.getApplicationExtension_Application()) {
            this.modifiedApplication(notification);
        }
    }

    private void modifiedModules(Notification notification) {
        switch (notification.getEventType()) {
            case 4: {
                this.removedModule((Module)notification.getOldValue());
                break;
            }
            case 6: {
                this.removedModules((Collection)notification.getOldValue());
            }
        }
    }

    private void removedModule(Module module) {
        ApplicationExtension applicationExtension = (ApplicationExtension)this.getTarget();
        ModuleExtension moduleExtension = applicationExtension.getModuleExtension(module);
        applicationExtension.getModuleExtensions().remove((Object)moduleExtension);
    }

    private void removedModules(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removedModule((Module)iterator.next());
        }
    }

    private void modifiedApplication(Notification notification) {
        Application application = null;
        switch (notification.getEventType()) {
            case 1: {
                application = (Application)notification.getOldValue();
                if (application != null) {
                    application.eAdapters().remove((Object)this);
                }
                if ((application = (Application)notification.getNewValue()) == null) break;
                this.beginListening(application);
                break;
            }
            case 2: {
                application = (Application)notification.getOldValue();
                if (application == null) break;
                application.eAdapters().remove((Object)this);
            }
        }
    }

    public void setTarget(Notifier notifier) {
        super.setTarget(notifier);
        Application application = ((ApplicationExtension)notifier).getApplication();
        if (application != null) {
            this.beginListening(application);
        }
    }

    private void beginListening(Application application) {
        if (!application.eAdapters().contains((Object)this)) {
            application.eAdapters().add((Object)this);
        }
    }
}

