/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.extensions.ejbext;

import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaPackage;
import org.eclipse.jst.j2ee.ejb.CommonRelationshipRole;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;

public class RoleUtility {
    static final String LINK_CLASS_TYPE_PATTERN = "{0}To{1}Link";
    static final String LINK_GETTER_NAME_PATTERN = "get{0}Link";
    static final String KEY_GETTER_NAME_PATTERN = "get{0}Key";
    static final String KEY_SETTER_NAME_PATTERN = "privateSet{0}Key";
    static final String HOME_FINDER_PATTERN = "find{0}By{1}";
    static final String SECONDARY_SETTER_NAME_PREFIX = "secondarySet";
    static final String SECONDARY_ADD_NAME_PREFIX = "secondaryAdd";
    static final String SECONDARY_REMOVE_NAME_PREFIX = "secondaryRemove";
    static final String SETTER_NAME_PREFIX = "set";
    static final String GETTER_NAME_PREFIX = "get";
    static final String ADD_NAME_PREFIX = "add";
    static final String REMOVE_NAME_PREFIX = "remove";
    static final String PARAMETER_NAME_PREFIX = "arg";
    static final String LINK_IVAR_SUFFIX = "Link";
    static final String EJB_MANY_LINK_INT_NAME = "com.ibm.ivj.ejb.associations.interfaces.ManyLink";
    static final String EJB_SINGLE_LINK_INT_NAME = "com.ibm.ivj.ejb.associations.interfaces.SingleLink";

    protected RoleUtility(EObject eObject) {
    }

    public static void collectLinkClassTypeNames(ContainerManagedEntityExtension containerManagedEntityExtension, List list) {
        if (containerManagedEntityExtension == null || list == null) {
            return;
        }
        EList eList = containerManagedEntityExtension.getLocalRelationshipRoles();
        for (int i = 0; i < eList.size(); ++i) {
            CommonRelationshipRole commonRelationshipRole = (CommonRelationshipRole)eList.get(i);
            list.add(RoleUtility.getLinkClassTypeName(commonRelationshipRole));
        }
    }

    public static void collectRoleMethodNames(ContainerManagedEntityExtension containerManagedEntityExtension, List list) {
        if (containerManagedEntityExtension == null || list == null) {
            return;
        }
        EList eList = containerManagedEntityExtension.getLocalRelationshipRoles();
        for (int i = 0; i < eList.size(); ++i) {
            CommonRelationshipRole commonRelationshipRole = (CommonRelationshipRole)eList.get(i);
            RoleUtility.collectRoleMethodNames(commonRelationshipRole, list);
        }
    }

    public static void collectRoleMethodNames(CommonRelationshipRole commonRelationshipRole, List list) {
        if (commonRelationshipRole == null || list == null) {
            return;
        }
        list.add(RoleUtility.getLinkGetterName(commonRelationshipRole));
        if (commonRelationshipRole.isForward()) {
            list.add(RoleUtility.getKeyGetterName(commonRelationshipRole));
            list.add(RoleUtility.getKeySetterName(commonRelationshipRole));
        }
        if (commonRelationshipRole.isNavigable()) {
            list.add(RoleUtility.getGetterName(commonRelationshipRole));
        }
        if (!RoleUtility.isMany(commonRelationshipRole)) {
            if (!commonRelationshipRole.getOppositeAsCommonRole().isKey()) {
                list.add(RoleUtility.getSetterName(commonRelationshipRole));
            }
            if (!commonRelationshipRole.isKey()) {
                list.add(RoleUtility.getSecondarySetterName(commonRelationshipRole));
            }
        } else {
            list.add(RoleUtility.getSecondaryAddName(commonRelationshipRole));
            list.add(RoleUtility.getSecondaryRemoveName(commonRelationshipRole));
            if (commonRelationshipRole.isNavigable()) {
                if (!commonRelationshipRole.getOppositeAsCommonRole().isKey()) {
                    list.add(RoleUtility.getAddName(commonRelationshipRole));
                }
                if (commonRelationshipRole.getOppositeAsCommonRole() != null && !commonRelationshipRole.getOppositeAsCommonRole().isRequired()) {
                    list.add(RoleUtility.getRemoveName(commonRelationshipRole));
                }
            }
        }
    }

    public static void collectRoleMethodNamesExtended(ContainerManagedEntityExtension containerManagedEntityExtension, List list) {
        if (containerManagedEntityExtension == null || list == null) {
            return;
        }
        List list2 = containerManagedEntityExtension.getRelationshipRoles();
        for (int i = 0; i < list2.size(); ++i) {
            CommonRelationshipRole commonRelationshipRole = (CommonRelationshipRole)list2.get(i);
            RoleUtility.collectRoleMethodNames(commonRelationshipRole, list);
        }
    }

    public static final String firstAsUppercase(String string) {
        if (string != null && string.length() > 0 && !Character.isUpperCase(string.charAt(0))) {
            char[] cArray = string.toCharArray();
            cArray[0] = Character.toUpperCase(cArray[0]);
            return String.valueOf(cArray);
        }
        return string;
    }

    protected static String format(String string, String[] stringArray) {
        return MessageFormat.format(string, stringArray);
    }

    public static String getAddName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        String string = RoleUtility.firstAsUppercase(commonRelationshipRole.getName());
        return ADD_NAME_PREFIX + string;
    }

    public static String getGetterName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        String string = RoleUtility.firstAsUppercase(commonRelationshipRole.getName());
        return GETTER_NAME_PREFIX + string;
    }

    public static String getHomeFinderName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        String string = RoleUtility.firstAsUppercase(commonRelationshipRole.getOppositeAsCommonRole().getName());
        String string2 = RoleUtility.firstAsUppercase(commonRelationshipRole.getName());
        return RoleUtility.format(HOME_FINDER_PATTERN, new String[]{string, string2});
    }

    public static String getKeyGetterName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        String string = RoleUtility.firstAsUppercase(commonRelationshipRole.getName());
        return RoleUtility.format(KEY_GETTER_NAME_PATTERN, new String[]{string});
    }

    public static String getKeySetterName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        String string = RoleUtility.firstAsUppercase(commonRelationshipRole.getName());
        return RoleUtility.format(KEY_SETTER_NAME_PATTERN, new String[]{string});
    }

    public static String getLinkClassTypeName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        String string = RoleUtility.getRoleType(commonRelationshipRole.getOppositeAsCommonRole()).getName();
        String string2 = RoleUtility.firstAsUppercase(commonRelationshipRole.getName());
        return RoleUtility.format(LINK_CLASS_TYPE_PATTERN, new String[]{string, string2});
    }

    public static List getLinkClassTypeNames(ContainerManagedEntityExtension containerManagedEntityExtension) {
        if (containerManagedEntityExtension == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        RoleUtility.collectLinkClassTypeNames(containerManagedEntityExtension, arrayList);
        return arrayList;
    }

    public static String getLinkFieldName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        return commonRelationshipRole.getName() + LINK_IVAR_SUFFIX;
    }

    public static String getLinkGetterName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        String string = RoleUtility.firstAsUppercase(commonRelationshipRole.getName());
        return RoleUtility.format(LINK_GETTER_NAME_PATTERN, new String[]{string});
    }

    public static String getLinkInterfaceTypeName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        if (commonRelationshipRole.isMany()) {
            return EJB_MANY_LINK_INT_NAME;
        }
        return EJB_SINGLE_LINK_INT_NAME;
    }

    public static EList getLocalRelationshipRoles(ContainerManagedEntityExtension containerManagedEntityExtension) {
        return containerManagedEntityExtension.getContainerManagedEntity().isVersion1_X() ? containerManagedEntityExtension.getLocalRelationshipRoles() : new BasicEList((Collection)containerManagedEntityExtension.getContainerManagedEntity().getRoles());
    }

    public static String getPackageName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        ContainerManagedEntity containerManagedEntity = commonRelationshipRole.getSourceEntity();
        JavaClass javaClass = containerManagedEntity == null ? null : containerManagedEntity.getEjbClass();
        JavaPackage javaPackage = javaClass == null ? null : javaClass.getJavaPackage();
        return javaPackage == null ? null : javaPackage.getName();
    }

    public static String getParameterName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        String string = RoleUtility.firstAsUppercase(commonRelationshipRole.getName());
        return PARAMETER_NAME_PREFIX + string;
    }

    public static List getQualifiedLinkClassTypeNames(ContainerManagedEntityExtension containerManagedEntityExtension) {
        List list = RoleUtility.getLinkClassTypeNames(containerManagedEntityExtension);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(containerManagedEntityExtension.getEnterpriseBean().getEjbClass().getJavaPackage().getName() + "." + (String)list.get(i));
        }
        return arrayList;
    }

    public static String getRemoveName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        String string = RoleUtility.firstAsUppercase(commonRelationshipRole.getName());
        return REMOVE_NAME_PREFIX + string;
    }

    public static ContainerManagedEntity getRoleDeclaringBean(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole != null) {
            return commonRelationshipRole.getSourceEntity();
        }
        return null;
    }

    public static List getRoleMethodNames(ContainerManagedEntityExtension containerManagedEntityExtension) {
        ArrayList arrayList = new ArrayList();
        if (containerManagedEntityExtension != null) {
            RoleUtility.collectRoleMethodNames(containerManagedEntityExtension, arrayList);
        }
        return arrayList;
    }

    public static List getRoleMethodNamesExtended(ContainerManagedEntityExtension containerManagedEntityExtension) {
        ArrayList arrayList = new ArrayList();
        if (containerManagedEntityExtension != null) {
            RoleUtility.collectRoleMethodNamesExtended(containerManagedEntityExtension, arrayList);
        }
        return arrayList;
    }

    public static ContainerManagedEntity getRoleType(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole != null) {
            return commonRelationshipRole.getSourceEntity();
        }
        return null;
    }

    public static String getSecondaryAddName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        String string = RoleUtility.firstAsUppercase(commonRelationshipRole.getName());
        return SECONDARY_ADD_NAME_PREFIX + string;
    }

    public static String getSecondaryRemoveName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        String string = RoleUtility.firstAsUppercase(commonRelationshipRole.getName());
        return SECONDARY_REMOVE_NAME_PREFIX + string;
    }

    public static String getSecondarySetterName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        String string = RoleUtility.firstAsUppercase(commonRelationshipRole.getName());
        return SECONDARY_SETTER_NAME_PREFIX + string;
    }

    public static String getSetterName(CommonRelationshipRole commonRelationshipRole) {
        if (commonRelationshipRole == null) {
            return null;
        }
        String string = RoleUtility.firstAsUppercase(commonRelationshipRole.getName());
        return SETTER_NAME_PREFIX + string;
    }

    public static boolean isMany(CommonRelationshipRole commonRelationshipRole) {
        return commonRelationshipRole != null && commonRelationshipRole.isMany();
    }
}

