/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.command;

import com.ibm.etools.common.command.AbstractCommand;
import com.ibm.etools.common.command.Command;
import com.ibm.etools.common.command.UnexecutableCommand;
import com.ibm.etools.common.internal.CommonPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class CompoundCommand
extends AbstractCommand {
    protected List commandList;
    public static final int LAST_COMMAND_ALL = Integer.MIN_VALUE;
    public static final int MERGE_COMMAND_ALL = Integer.MAX_VALUE;
    protected int resultIndex = Integer.MAX_VALUE;

    public CompoundCommand() {
        this.commandList = new ArrayList();
    }

    public CompoundCommand(int n) {
        this.resultIndex = n;
        this.commandList = new ArrayList();
    }

    public CompoundCommand(int n, String string) {
        super(string);
        this.resultIndex = n;
        this.commandList = new ArrayList();
    }

    public CompoundCommand(int n, String string, String string2) {
        super(string, string2);
        this.resultIndex = n;
        this.commandList = new ArrayList();
    }

    public CompoundCommand(int n, String string, String string2, List list) {
        super(string, string2);
        this.resultIndex = n;
        this.commandList = list;
    }

    public CompoundCommand(int n, String string, List list) {
        super(string);
        this.resultIndex = n;
        this.commandList = list;
    }

    public CompoundCommand(int n, List list) {
        this.resultIndex = n;
        this.commandList = list;
    }

    public CompoundCommand(String string) {
        super(string);
        this.commandList = new ArrayList();
    }

    public CompoundCommand(String string, String string2) {
        super(string, string2);
        this.commandList = new ArrayList();
    }

    public CompoundCommand(String string, String string2, List list) {
        super(string, string2);
        this.commandList = list;
    }

    public CompoundCommand(String string, List list) {
        super(string);
        this.commandList = list;
    }

    public CompoundCommand(List list) {
        this.commandList = list;
    }

    public void append(Command command) {
        if (command != null) {
            this.commandList.add(command);
        }
    }

    public boolean appendAndExecute(Command command) {
        if (command != null) {
            block8: {
                if (!this.isPrepared) {
                    if (this.commandList.isEmpty()) {
                        this.isPrepared = true;
                        this.isExecutable = true;
                    } else {
                        this.isExecutable = this.prepare();
                        this.isPrepared = true;
                        if (this.isExecutable) {
                            this.execute();
                        }
                    }
                }
                if (command.canExecute()) {
                    try {
                        command.execute();
                        this.commandList.add(command);
                        return true;
                    }
                    catch (RuntimeException runtimeException) {
                        if (!AbstractCommand.Trace.isEnabled) break block8;
                        AbstractCommand.Trace.out.println("! Exception is NOT rethrown.", true);
                        runtimeException.printStackTrace(AbstractCommand.Trace.out);
                        AbstractCommand.Trace.out.println("! Unrolling commands due to exception.", true);
                    }
                }
            }
            command.dispose();
        }
        return false;
    }

    public boolean appendIfCanExecute(Command command) {
        if (command == null) {
            return false;
        }
        if (command.canExecute()) {
            this.commandList.add(command);
            return true;
        }
        command.dispose();
        return false;
    }

    public boolean canUndo() {
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.enter("CompoundCommand.canUndo", this);
        }
        ListIterator listIterator = this.commandList.listIterator();
        while (listIterator.hasNext()) {
            Command command = (Command)listIterator.next();
            if (command.canUndo()) continue;
            if (AbstractCommand.Trace.isEnabled) {
                AbstractCommand.Trace.out.leave(true, false);
            }
            return false;
        }
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.leave(false, true);
        }
        return true;
    }

    public void dispose() {
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.enter("CompoundCommand.dispose", this);
        }
        ListIterator listIterator = this.commandList.listIterator();
        while (listIterator.hasNext()) {
            Command command = (Command)listIterator.next();
            command.dispose();
        }
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.leave();
        }
    }

    public void execute() {
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.enter("CompoundCommand.execute", this);
        }
        ListIterator listIterator = this.commandList.listIterator();
        while (listIterator.hasNext()) {
            try {
                Command command = (Command)listIterator.next();
                command.execute();
            }
            catch (RuntimeException runtimeException) {
                Command command;
                if (AbstractCommand.Trace.isEnabled) {
                    AbstractCommand.Trace.out.println("! Unrolling commands due to exception.", true);
                }
                if (AbstractCommand.Trace.isEnabled) {
                    runtimeException.printStackTrace(AbstractCommand.Trace.out);
                }
                listIterator.previous();
                while (listIterator.hasPrevious() && (command = (Command)listIterator.previous()).canUndo()) {
                    command.undo();
                }
                if (AbstractCommand.Trace.isEnabled) {
                    AbstractCommand.Trace.out.leave("Rethrowing...", true);
                }
                throw runtimeException;
            }
        }
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.leave();
        }
    }

    public Collection getAffectedObjects() {
        if (this.commandList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.resultIndex == Integer.MIN_VALUE) {
            return ((Command)this.commandList.get(this.commandList.size() - 1)).getAffectedObjects();
        }
        if (this.resultIndex == Integer.MAX_VALUE) {
            return this.getMergedAffectedObjectsCollection();
        }
        if (this.resultIndex < this.commandList.size()) {
            return ((Command)this.commandList.get(this.resultIndex)).getAffectedObjects();
        }
        return Collections.EMPTY_LIST;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        if (this.commandList.isEmpty()) {
            return CommonPlugin.getPlugin().getString("_UI_CompoundCommand_description");
        }
        if (this.resultIndex == Integer.MIN_VALUE || this.resultIndex == Integer.MAX_VALUE) {
            return ((Command)this.commandList.get(this.commandList.size() - 1)).getDescription();
        }
        if (this.resultIndex < this.commandList.size()) {
            return ((Command)this.commandList.get(this.resultIndex)).getDescription();
        }
        return CommonPlugin.getPlugin().getString("_UI_CompoundCommand_description");
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.commandList.isEmpty()) {
            return CommonPlugin.getPlugin().getString("_UI_CompoundCommand_label");
        }
        if (this.resultIndex == Integer.MIN_VALUE || this.resultIndex == Integer.MAX_VALUE) {
            return ((Command)this.commandList.get(this.commandList.size() - 1)).getLabel();
        }
        if (this.resultIndex < this.commandList.size()) {
            return ((Command)this.commandList.get(this.resultIndex)).getLabel();
        }
        return CommonPlugin.getPlugin().getString("_UI_CompoundCommand_label");
    }

    protected Collection getMergedAffectedObjectsCollection() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.commandList.iterator();
        while (iterator.hasNext()) {
            Command command = (Command)iterator.next();
            arrayList.addAll(command.getAffectedObjects());
        }
        return arrayList;
    }

    protected Collection getMergedResultCollection() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.commandList.iterator();
        while (iterator.hasNext()) {
            Command command = (Command)iterator.next();
            arrayList.addAll(command.getResult());
        }
        return arrayList;
    }

    public Collection getResult() {
        if (this.commandList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.resultIndex == Integer.MIN_VALUE) {
            return ((Command)this.commandList.get(this.commandList.size() - 1)).getResult();
        }
        if (this.resultIndex == Integer.MAX_VALUE) {
            return this.getMergedResultCollection();
        }
        if (this.resultIndex < this.commandList.size()) {
            return ((Command)this.commandList.get(this.resultIndex)).getResult();
        }
        return Collections.EMPTY_LIST;
    }

    public int getSize() {
        return this.commandList.size();
    }

    public boolean isEmpty() {
        return this.commandList.isEmpty();
    }

    protected boolean prepare() {
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.enter("CompoundCommand.prepare", this);
        }
        if (this.commandList.isEmpty()) {
            if (AbstractCommand.Trace.isEnabled) {
                AbstractCommand.Trace.out.leave("false *** This used to return true when the command list is empty.", true);
            }
            return false;
        }
        ListIterator listIterator = this.commandList.listIterator();
        while (listIterator.hasNext()) {
            Command command = (Command)listIterator.next();
            if (command.canExecute()) continue;
            if (AbstractCommand.Trace.isEnabled) {
                AbstractCommand.Trace.out.leave(false);
            }
            return false;
        }
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.leave(true);
        }
        return true;
    }

    public void redo() {
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.enter("CompoundCommand.redo", this);
        }
        ListIterator listIterator = this.commandList.listIterator();
        while (listIterator.hasNext()) {
            try {
                Command command = (Command)listIterator.next();
                command.redo();
            }
            catch (RuntimeException runtimeException) {
                if (AbstractCommand.Trace.isEnabled) {
                    AbstractCommand.Trace.out.println("! Unrolling commands due to exception.", true);
                }
                listIterator.previous();
                while (listIterator.hasPrevious()) {
                    Command command = (Command)listIterator.previous();
                    command.undo();
                }
                if (AbstractCommand.Trace.isEnabled) {
                    AbstractCommand.Trace.out.leave("Rethrowing...", true);
                }
                throw runtimeException;
            }
        }
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.leave();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (commandList: #" + this.commandList.size() + ")");
        stringBuffer.append(" (resultIndex: " + this.resultIndex + ")");
        return stringBuffer.toString();
    }

    public void undo() {
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.enter("CompoundCommand.undo", this);
        }
        ListIterator listIterator = this.commandList.listIterator(this.commandList.size());
        while (listIterator.hasPrevious()) {
            try {
                Command command = (Command)listIterator.previous();
                command.undo();
            }
            catch (RuntimeException runtimeException) {
                if (AbstractCommand.Trace.isEnabled) {
                    AbstractCommand.Trace.out.println("! Rerolling commands due to exception.", true);
                }
                listIterator.next();
                while (listIterator.hasNext()) {
                    Command command = (Command)listIterator.next();
                    command.redo();
                }
                if (AbstractCommand.Trace.isEnabled) {
                    AbstractCommand.Trace.out.leave("Rethrowing...", true);
                }
                throw runtimeException;
            }
        }
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.leave();
        }
    }

    public Command unwrap() {
        switch (this.commandList.size()) {
            case 0: {
                this.dispose();
                return UnexecutableCommand.INSTANCE;
            }
            case 1: {
                Command command = (Command)this.commandList.remove(0);
                this.dispose();
                return command;
            }
        }
        return this;
    }
}

