/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.util;

import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextFactory;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextPackage;
import com.ibm.ejs.models.base.extensions.ejbext.FinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.FullSelectFinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.UserFinderDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdaptor;
import org.eclipse.jem.java.Block;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.internal.impl.JavaClassImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodElementKind;

public class FinderHelperMetaDataConverter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final String FIND = "find";
    public static final String FIND_BY_PRIMARY_KEY = "findByPrimaryKey";
    public static final String FINDER_HELPER = "FinderHelper";
    public static final String WHERE_CLAUSE = "WhereClause";
    public static final String QUERY_STRING = "QueryString";
    protected EJBJarFile ejbJarFile;
    protected ContainerManagedEntity currentCMP;
    protected JavaClass currentInterface;

    public FinderHelperMetaDataConverter(EJBJarFile eJBJarFile) {
        this.ejbJarFile = eJBJarFile;
    }

    protected void addFinderDescriptor(FinderDescriptor finderDescriptor, MethodElement methodElement) {
        finderDescriptor.getFinderMethodElements().add((Object)methodElement);
        this.getCurrentExtension().getFinderDescriptors().add((Object)finderDescriptor);
    }

    protected void addFinderDescriptor(MethodElement methodElement, Field field) {
        FinderDescriptor finderDescriptor = null;
        Block block = field.getInitializer();
        String string = null;
        if (block == null || (string = block.getSource()) == null) {
            return;
        }
        String string2 = string.substring(1, string.length() - 1);
        if (this.isWhereClause(field)) {
            finderDescriptor = this.getExtensionsFactory().createWhereClauseFinderDescriptor();
            finderDescriptor.setWhereClause(string2);
        } else {
            finderDescriptor = this.getExtensionsFactory().createFullSelectFinderDescriptor();
            ((FullSelectFinderDescriptor)finderDescriptor).setSelectStatement(string2);
        }
        this.addFinderDescriptor(finderDescriptor, methodElement);
    }

    protected void addFinderDescriptor(MethodElement methodElement, Method method) {
        UserFinderDescriptor userFinderDescriptor = this.getExtensionsFactory().createUserFinderDescriptor();
        this.addFinderDescriptor(userFinderDescriptor, methodElement);
    }

    protected MethodElement createMethodElement(Method method) {
        MethodElement methodElement = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createMethodElementFrom(method);
        methodElement.setEnterpriseBean(this.currentCMP);
        methodElement.setType(MethodElementKind.HOME_LITERAL);
        if (!methodElement.hasMethodParams()) {
            methodElement.applyZeroParams();
        }
        return methodElement;
    }

    protected Field detectFinderFieldFor(Method method) {
        List list = this.currentInterface.getFieldsExtended();
        for (int i = 0; i < list.size(); ++i) {
            Field field = (Field)list.get(i);
            String string = field.getName();
            if (!string.equals(method.getName().concat(WHERE_CLAUSE)) && !string.equals(method.getName().concat(QUERY_STRING))) continue;
            return field;
        }
        return null;
    }

    protected Method detectFinderMethodFor(MethodElement methodElement) {
        List list = this.currentInterface.getMethodsExtended();
        for (int i = 0; i < list.size(); ++i) {
            Method method = (Method)list.get(i);
            if (!methodElement.nameAndParamsEquals(method)) continue;
            return method;
        }
        return null;
    }

    protected ContainerManagedEntityExtension getCurrentExtension() {
        return (ContainerManagedEntityExtension)EjbExtensionsHelper.getEjbExtension(this.currentCMP);
    }

    public EjbextFactory getExtensionsFactory() {
        return ((EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi")).getEjbextFactory();
    }

    protected List getFindMethods() {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        if (this.currentCMP.getHomeInterface() != null) {
            List list = this.currentCMP.getHomeInterface().getMethodsExtended();
            for (int i = 0; i < list.size(); ++i) {
                Method method = (Method)list.get(i);
                if (!method.getName().startsWith(FIND) || method.getName().equals(FIND_BY_PRIMARY_KEY)) continue;
                arrayList.add(method);
            }
        }
        return arrayList;
    }

    protected boolean isWhereClause(Field field) {
        return field.getName().endsWith(WHERE_CLAUSE);
    }

    protected void primReflectCurrentCMP() {
        this.setCurrentInterface();
        if (this.currentInterface == null) {
            return;
        }
        List list = this.getFindMethods();
        for (int i = 0; i < list.size(); ++i) {
            Method method = (Method)list.get(i);
            MethodElement methodElement = this.createMethodElement(method);
            Field field = this.detectFinderFieldFor(method);
            if (field != null) {
                this.addFinderDescriptor(methodElement, field);
                continue;
            }
            Method method2 = this.detectFinderMethodFor(methodElement);
            if (method2 == null) continue;
            this.addFinderDescriptor(methodElement, method2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reflectCurrentCMP() {
        block5: {
            try {
                this.primReflectCurrentCMP();
                Object var2_1 = null;
                if (this.currentInterface == null) break block5;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.currentInterface != null) {
                    JavaReflectionAdaptor.releaseSourceType(this.currentInterface);
                }
                if (this.currentCMP != null && this.currentCMP.getHomeInterface() != null) {
                    JavaReflectionAdaptor.releaseSourceType(this.currentCMP.getHomeInterface());
                }
                throw throwable;
            }
            JavaReflectionAdaptor.releaseSourceType(this.currentInterface);
        }
        if (this.currentCMP != null && this.currentCMP.getHomeInterface() != null) {
            JavaReflectionAdaptor.releaseSourceType(this.currentCMP.getHomeInterface());
        }
    }

    public void reflectMetaData() {
        EList eList = this.ejbJarFile.getDeploymentDescriptor().getEnterpriseBeans();
        for (int i = 0; i < eList.size(); ++i) {
            EnterpriseBean enterpriseBean = (EnterpriseBean)eList.get(i);
            if (!enterpriseBean.isContainerManagedEntity()) continue;
            this.currentCMP = (ContainerManagedEntity)enterpriseBean;
            this.reflectCurrentCMP();
        }
    }

    protected JavaClass setCurrentInterface() {
        String string = this.currentCMP.getEjbClassName().concat(FINDER_HELPER);
        if (!this.ejbJarFile.containsFile(ArchiveUtil.classNameToUri(string))) {
            this.currentInterface = null;
        }
        this.currentInterface = (JavaClass)JavaClassImpl.reflect(string, this.ejbJarFile.getResourceSet());
        return this.currentInterface;
    }
}

