/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.util;

import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EJBComponent;
import com.ibm.etools.commonarchive.ModuleComponent;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.commonarchive.ServletComponent;
import com.ibm.etools.commonarchive.impl.EJBModuleRefImpl;
import com.ibm.etools.commonarchive.impl.WARFileImpl;
import com.ibm.etools.commonarchive.impl.WebModuleRefImpl;
import com.ibm.etools.commonarchive.nls.CommonArchiveWASResourceHandler;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.webapplication.JSPType;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletType;

public class ModuleRefHelper {
    public static final String EXCEPTION_OCCCURRED = CommonArchiveWASResourceHandler.getString("Exception_occurred_adding__EXC_");

    public void addCopyRequiredFiles(EJBModuleRefImpl eJBModuleRefImpl, ModuleComponent moduleComponent) {
        String string;
        if (moduleComponent.getModuleFile() == null) {
            return;
        }
        EnterpriseBean enterpriseBean = ((EJBComponent)moduleComponent).getDeploymentDescriptor();
        ArrayList<String> arrayList = new ArrayList<String>(4);
        arrayList.add(enterpriseBean.getHomeInterfaceName());
        arrayList.add(enterpriseBean.getRemoteInterfaceName());
        arrayList.add(enterpriseBean.getEjbClassName());
        if (enterpriseBean.isEntity() && (string = ((Entity)enterpriseBean).getPrimaryKeyName()) != null && !string.startsWith("java")) {
            arrayList.add(string);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (string2 == null) continue;
            String string3 = ArchiveUtil.classNameToUri(string2);
            try {
                eJBModuleRefImpl.getModuleFile().addCopy(moduleComponent.getModuleFile().getFile(string3));
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
            catch (DuplicateObjectException duplicateObjectException) {
                // empty catch block
            }
        }
    }

    public void addCopyRequiredFiles(WebModuleRefImpl webModuleRefImpl, ModuleComponent moduleComponent) {
    }

    public void basicAdd(EJBModuleRefImpl eJBModuleRefImpl, ModuleComponent moduleComponent) {
        EJBComponent eJBComponent = (EJBComponent)moduleComponent;
        try {
            eJBModuleRefImpl.getEJBJar().getEnterpriseBeans().add((Object)eJBComponent.getDeploymentDescriptor());
            eJBModuleRefImpl.getEJBJarBinding().getEjbBindings().add((Object)eJBComponent.getBindings());
            eJBModuleRefImpl.getEJBJarExtension().getEjbExtensions().add((Object)eJBComponent.getExtensions());
            eJBModuleRefImpl.getComponents().add((Object)moduleComponent);
        }
        catch (Exception exception) {
            throw new ArchiveRuntimeException(EXCEPTION_OCCCURRED, exception);
        }
    }

    public void basicAdd(WebModuleRefImpl webModuleRefImpl, ModuleComponent moduleComponent) {
        ServletComponent servletComponent = (ServletComponent)moduleComponent;
        try {
            webModuleRefImpl.getWebApp().getServlets().add((Object)servletComponent.getDeploymentDescriptor());
            webModuleRefImpl.getWebAppExtension().getExtendedServlets().add((Object)servletComponent.getExtensions());
            webModuleRefImpl.getComponents().add((Object)moduleComponent);
        }
        catch (ArchiveWrappedException archiveWrappedException) {
            throw new ArchiveRuntimeException(EXCEPTION_OCCCURRED, archiveWrappedException);
        }
    }

    public void buildComponentList(EJBModuleRefImpl eJBModuleRefImpl, EList eList) {
        try {
            EList eList2 = eJBModuleRefImpl.getEJBJar().getEnterpriseBeans();
            for (int i = 0; i < eList2.size(); ++i) {
                EnterpriseBean enterpriseBean = (EnterpriseBean)eList2.get(i);
                EJBComponent eJBComponent = this.getCommonArchiveFactory().createEJBComponent();
                eJBComponent.setDeploymentDescriptor(enterpriseBean);
                eList.add((Object)eJBComponent);
            }
        }
        catch (ArchiveWrappedException archiveWrappedException) {
            throw new ArchiveRuntimeException(CommonArchiveWASResourceHandler.getString("list_components_ejb_EXC_", new Object[]{eJBModuleRefImpl.getModuleFile().getURI()}), archiveWrappedException);
        }
    }

    public void buildComponentList(WebModuleRefImpl webModuleRefImpl, EList eList) {
        try {
            EList eList2 = webModuleRefImpl.getWebApp().getServlets();
            for (int i = 0; i < eList2.size(); ++i) {
                Servlet servlet = (Servlet)eList2.get(i);
                ServletComponent servletComponent = this.getCommonArchiveFactory().createServletComponent();
                servletComponent.setDeploymentDescriptor(servlet);
                eList.add((Object)servletComponent);
            }
        }
        catch (ArchiveWrappedException archiveWrappedException) {
            throw new ArchiveRuntimeException(CommonArchiveWASResourceHandler.getString("list_components_war_EXC_", new Object[]{webModuleRefImpl.getModuleFile().getURI()}), archiveWrappedException);
        }
    }

    protected CommonarchiveFactory getCommonArchiveFactory() {
        return CommonarchiveFactory.eINSTANCE;
    }

    public void remove(EJBModuleRefImpl eJBModuleRefImpl, ModuleComponent moduleComponent) {
        EJBComponent eJBComponent = (EJBComponent)moduleComponent;
        try {
            eJBModuleRefImpl.getEJBJar().getEnterpriseBeans().remove((Object)eJBComponent.getDeploymentDescriptor());
            eJBModuleRefImpl.getEJBJarBinding().getEjbBindings().remove((Object)eJBComponent.getBindings());
            eJBModuleRefImpl.getEJBJarExtension().getEjbExtensions().remove((Object)eJBComponent.getExtensions());
            eJBModuleRefImpl.getComponents().remove((Object)moduleComponent);
        }
        catch (ArchiveWrappedException archiveWrappedException) {
            throw new ArchiveRuntimeException(EXCEPTION_OCCCURRED, archiveWrappedException);
        }
    }

    public void remove(WebModuleRefImpl webModuleRefImpl, ModuleComponent moduleComponent) {
        ServletComponent servletComponent = (ServletComponent)moduleComponent;
        try {
            webModuleRefImpl.getWebApp().getServlets().remove((Object)servletComponent.getDeploymentDescriptor());
            webModuleRefImpl.getWebAppExtension().getExtendedServlets().remove((Object)servletComponent.getExtensions());
            webModuleRefImpl.getComponents().remove((Object)moduleComponent);
        }
        catch (ArchiveWrappedException archiveWrappedException) {
            throw new ArchiveRuntimeException(EXCEPTION_OCCCURRED, archiveWrappedException);
        }
    }

    public void addCopyRequiredFiles(WARFileImpl wARFileImpl, ModuleComponent moduleComponent) {
        if (moduleComponent.getModuleFile() == null) {
            return;
        }
        Servlet servlet = ((ServletComponent)moduleComponent).getDeploymentDescriptor();
        if (servlet == null || servlet.getWebType() == null) {
            return;
        }
        String string = null;
        if (servlet.getWebType().isJspType()) {
            string = ((JSPType)servlet.getWebType()).getJspFile();
            if (string == null) {
                return;
            }
        } else {
            String string2 = ((ServletType)servlet.getWebType()).getClassName();
            if (string2 == null) {
                return;
            }
            string = ArchiveUtil.concatUri("WEB-INF/classes/", ArchiveUtil.classNameToUri(string2), '/');
        }
        try {
            wARFileImpl.addCopy(moduleComponent.getModuleFile().getFile(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (DuplicateObjectException duplicateObjectException) {
            // empty catch block
        }
    }

    public ModuleComponent addCopy(EJBModuleRefImpl eJBModuleRefImpl, ModuleComponent moduleComponent) throws DuplicateObjectException {
        ModuleComponent moduleComponent2 = eJBModuleRefImpl.getComponent(moduleComponent.getComponentName());
        if (moduleComponent2 != null) {
            throw new DuplicateObjectException(moduleComponent.getComponentName(), moduleComponent2);
        }
        ModuleComponent moduleComponent3 = CommonarchivePackage.eINSTANCE.getCommonarchiveFactory().copy(moduleComponent);
        this.basicAdd(eJBModuleRefImpl, moduleComponent3);
        this.addCopyRequiredFiles(eJBModuleRefImpl, moduleComponent);
        return moduleComponent3;
    }

    public ModuleComponent addCopy(WebModuleRefImpl webModuleRefImpl, ModuleComponent moduleComponent) throws DuplicateObjectException {
        ModuleComponent moduleComponent2 = webModuleRefImpl.getComponent(moduleComponent.getComponentName());
        if (moduleComponent2 != null) {
            throw new DuplicateObjectException(moduleComponent.getComponentName(), moduleComponent2);
        }
        ModuleComponent moduleComponent3 = CommonarchivePackage.eINSTANCE.getCommonarchiveFactory().copy(moduleComponent);
        this.basicAdd(webModuleRefImpl, moduleComponent3);
        this.addCopyRequiredFiles(webModuleRefImpl, moduleComponent);
        return moduleComponent3;
    }

    public boolean containsComponent(ModuleRef moduleRef, String string) {
        if (string == null) {
            return false;
        }
        EList eList = moduleRef.getComponents();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleComponent moduleComponent = (ModuleComponent)eList.get(i);
            if (!string.equals(moduleComponent.getComponentName())) continue;
            return true;
        }
        return false;
    }

    public ModuleComponent getComponent(ModuleRef moduleRef, String string) {
        if (string == null) {
            return null;
        }
        EList eList = moduleRef.getComponents();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleComponent moduleComponent = (ModuleComponent)eList.get(i);
            if (!string.equals(moduleComponent.getComponentName())) continue;
            return moduleComponent;
        }
        return null;
    }

    public EList getComponents(EJBModuleRefImpl eJBModuleRefImpl, EList eList) {
        if (eList.isEmpty()) {
            this.buildComponentList(eJBModuleRefImpl, eList);
        }
        return eList;
    }

    public EList getComponents(WebModuleRefImpl webModuleRefImpl, EList eList) {
        if (eList.isEmpty()) {
            this.buildComponentList(webModuleRefImpl, eList);
        }
        return eList;
    }
}

