/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.emf.workbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.internal.util.emf.workbench.EMFWorkbenchContextFactory;
import org.eclipse.jem.internal.util.emf.workbench.WorkspaceResourceHandler;
import org.eclipse.jem.util.emf.workbench.EMFWorkbenchContextBase;
import org.eclipse.jem.util.emf.workbench.IEMFContextContributor;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverter;

public class WorkbenchResourceHelperBase {
    public static final WorkbenchResourceHelperBase INSTANCE = new WorkbenchResourceHelperBase();
    protected static WorkspaceResourceHandler workspaceURILoader = new WorkspaceResourceHandler();

    protected static void resolveContainedProxies(EObject refObject) {
        EList contained = refObject.eContents();
        int i = 0;
        while (i < contained.size()) {
            EObject mofObject = (EObject)contained.get(i);
            WorkbenchResourceHelperBase.resolveProxies(mofObject);
            ++i;
        }
    }

    protected static void resolveNonContainedProxies(EObject refObject) {
        EList references = refObject.eClass().getEAllReferences();
        int i = 0;
        while (i < references.size()) {
            EReference reference = (EReference)references.get(i);
            if (!reference.isContainment()) {
                if (reference.isMany()) {
                    List value = (List)refObject.eGet((EStructuralFeature)reference);
                    int j = 0;
                    while (j < value.size()) {
                        value.get(j);
                        ++j;
                    }
                } else {
                    refObject.eGet((EStructuralFeature)reference);
                }
            }
            ++i;
        }
    }

    public static void resolveProxies(Resource resource) {
        if (resource != null) {
            EList topLevels = resource.getContents();
            int i = 0;
            while (i < topLevels.size()) {
                EObject mofObject = (EObject)topLevels.get(i);
                WorkbenchResourceHelperBase.resolveProxies(mofObject);
                ++i;
            }
        }
    }

    public static List gatherProxies(Resource resource) {
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList list = new ArrayList();
        EList topLevels = resource.getContents();
        int size = topLevels.size();
        int i = 0;
        while (i < size) {
            EObject mofObject = (EObject)topLevels.get(i);
            WorkbenchResourceHelperBase.gatherProxies((InternalEObject)mofObject, list);
            ++i;
        }
        return list;
    }

    protected static void gatherProxies(InternalEObject refObject, List proxies) {
        if (refObject == null) {
            return;
        }
        EList contains = refObject.eClass().getEAllContainments();
        if (contains != null) {
            int size = contains.size();
            EStructuralFeature sf = null;
            int i = 0;
            while (i < size) {
                sf = (EStructuralFeature)contains.get(i);
                WorkbenchResourceHelperBase.gatherProxies(refObject, sf, proxies);
                ++i;
            }
        }
    }

    protected static void gatherProxies(InternalEObject refObject, EStructuralFeature sf, List proxies) {
        Object value = null;
        InternalEObject proxy = null;
        if ((sf.isMany() || refObject.eIsSet(sf)) && (value = refObject.eGet(sf, false)) != null) {
            if (sf.isMany()) {
                Iterator j = ((InternalEList)value).basicIterator();
                while (j.hasNext()) {
                    proxy = (InternalEObject)j.next();
                    if (!proxy.eIsProxy()) continue;
                    proxies.add(proxy);
                }
            } else if (((InternalEObject)value).eIsProxy()) {
                proxies.add(value);
            }
        }
    }

    protected static void resolveProxies(EObject refObject) {
        if (refObject != null) {
            WorkbenchResourceHelperBase.resolveNonContainedProxies(refObject);
            WorkbenchResourceHelperBase.resolveContainedProxies(refObject);
        }
    }

    public static EMFWorkbenchContextBase getEMFContext(IProject aProject) {
        return EMFWorkbenchContextFactory.INSTANCE.getEMFContext(aProject);
    }

    public static Resource createResource(URI uri) {
        ResourceSet set = WorkbenchResourceHelperBase.getResourceSet(uri);
        if (set != null) {
            return set.createResource(uri);
        }
        return null;
    }

    public static Resource getExistingOrCreateResource(URI uri) {
        return WorkbenchResourceHelperBase.getExistingOrCreateResource(uri, WorkbenchResourceHelperBase.getResourceSet(uri));
    }

    public static IFile getIFile(URI uri) {
        IProject project = WorkbenchResourceHelperBase.getProject(uri);
        if (project != null) {
            IPath path = WorkbenchResourceHelperBase.isPlatformResourceURI(uri) ? new Path(URI.decode((String)uri.path())).removeFirstSegments(2) : new Path(URI.decode((String)uri.path())).removeFirstSegments(1);
            return project.getFile(path);
        }
        return null;
    }

    public static Resource getExistingOrCreateResource(URI uri, ResourceSet set) {
        if (set != null) {
            Resource res = set.getResource(uri, false);
            if (res == null) {
                res = set.createResource(uri);
            }
            return res;
        }
        return null;
    }

    public static EMFWorkbenchContextBase createEMFContext(IProject aProject, IEMFContextContributor contributor) {
        return EMFWorkbenchContextFactory.INSTANCE.createEMFContext(aProject, contributor);
    }

    public static boolean isPlatformResourceURI(URI uri) {
        return "platform".equals(uri.scheme()) && "resource".equals(uri.segment(0));
    }

    public static boolean cacheResource(Resource aResource) {
        ResourceSet set;
        if (aResource != null && (set = WorkbenchResourceHelperBase.getResourceSet(aResource.getURI())) != null) {
            return set.getResources().add((Object)aResource);
        }
        return false;
    }

    public static boolean cacheResource(IProject aProject, Resource aResource, IPath fullPath) {
        if (aProject == null || aResource == null || !aProject.isAccessible()) {
            return false;
        }
        ResourceSet set = WorkbenchResourceHelperBase.getResourceSet(aProject);
        if (set != null) {
            URI converted = set.getURIConverter().normalize(aResource.getURI());
            if (converted != aResource.getURI()) {
                aResource.setURI(converted);
            }
            return set.getResources().add((Object)aResource);
        }
        return false;
    }

    public static String getActualProjectRelativeURI(IResource aResource) {
        if (aResource == null || !aResource.isAccessible()) {
            return null;
        }
        IProject project = aResource.getProject();
        IPath path = WorkbenchResourceHelperBase.getPathInProject(project, aResource.getFullPath());
        return path.makeRelative().toString();
    }

    public static IPath getPathInProject(IProject project, IPath fullPath) {
        List containers = WorkbenchResourceHelperBase.getProjectURIConverterContainers(project);
        if (!containers.isEmpty()) {
            return WorkbenchResourceHelperBase.getPathFromContainers(containers, fullPath);
        }
        return fullPath;
    }

    protected static List getProjectURIConverterContainers(IProject project) {
        WorkbenchURIConverter conv;
        EMFWorkbenchContextBase nature = WorkbenchResourceHelperBase.createEMFContext(project, null);
        if (nature != null && (conv = (WorkbenchURIConverter)nature.getResourceSet().getURIConverter()) != null) {
            return conv.getInputContainers();
        }
        return Collections.EMPTY_LIST;
    }

    public static IPath getPathFromContainers(List containers, IPath fullPath) {
        IContainer container = null;
        int size = containers.size();
        int matching = -1;
        int i = 0;
        while (i < size) {
            container = (IContainer)containers.get(i);
            IPath containerPath = container.getFullPath();
            matching = fullPath.matchingFirstSegments(containerPath);
            if (matching > 0 && matching == containerPath.segmentCount()) {
                IPath result = fullPath.removeFirstSegments(matching);
                result = result.makeRelative();
                return result;
            }
            ++i;
        }
        return fullPath;
    }

    public static boolean hasContainerStructure(IProject project, URI uri) {
        if (project != null && uri != null) {
            Path path = new Path(uri.toString());
            List containers = WorkbenchResourceHelperBase.getProjectURIConverterContainers(project);
            int segmentCount = path.segmentCount();
            IPath containerPath = segmentCount > 1 ? path.removeLastSegments(1) : null;
            IContainer container = null;
            int i = 0;
            while (i < containers.size()) {
                IFolder folder;
                container = (IContainer)containers.get(i);
                if (container.isAccessible() && (segmentCount == 1 ? container == project : containerPath != null && (folder = container.getFolder(containerPath)) != null && folder.isAccessible())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static Resource getResource(URI uri) {
        return WorkbenchResourceHelperBase.getResource(uri, true);
    }

    public static Resource getResource(IFile aFile) {
        return WorkbenchResourceHelperBase.getResource(aFile, false);
    }

    public static Resource getResource(IFile aFile, boolean loadOnDemand) {
        if (aFile != null) {
            return WorkbenchResourceHelperBase.getResource(URI.createPlatformResourceURI((String)aFile.getFullPath().toString()), loadOnDemand);
        }
        return null;
    }

    public static Resource load(IFile aFile) {
        return WorkbenchResourceHelperBase.getResource(aFile, true);
    }

    public static Resource getResource(URI uri, boolean loadOnDemand) {
        ResourceSet set = WorkbenchResourceHelperBase.getResourceSet(uri);
        if (set != null) {
            return set.getResource(uri, loadOnDemand);
        }
        return null;
    }

    public static ResourceSet getResourceSet(URI uri) {
        IProject project = WorkbenchResourceHelperBase.getProject(uri);
        if (project != null && project.isAccessible()) {
            return WorkbenchResourceHelperBase.getResourceSet(project);
        }
        return null;
    }

    private static IProject getProject(URI uri) {
        String projectName;
        if (WorkbenchResourceHelperBase.isPlatformResourceURI(uri)) {
            projectName = uri.segment(1);
        } else if (uri.scheme() == null) {
            projectName = new Path(uri.path()).segment(0);
        } else {
            return null;
        }
        IProject project = WorkbenchResourceHelperBase.getWorkspace().getRoot().getProject(URI.decode((String)projectName));
        if (project != null && project.isAccessible()) {
            return project;
        }
        return null;
    }

    public static ResourceSet getResourceSet(IProject project) {
        EMFWorkbenchContextBase nat = WorkbenchResourceHelperBase.createEMFContext(project, null);
        if (nat != null) {
            return nat.getResourceSet();
        }
        return null;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IProject getProject(ResourceSet set) {
        if (set != null && set instanceof ProjectResourceSet) {
            ProjectResourceSet pset = (ProjectResourceSet)set;
            return pset.getProject();
        }
        return null;
    }

    protected static boolean isRegisteredURIMapping(String href) {
        if (href != null) {
            String file = href;
            int index = href.indexOf(35);
            if (index > -1) {
                file = href.substring(0, index);
            }
            return URIConverter.URI_MAP.get(file) != null;
        }
        return false;
    }

    public static void removeAndUnloadAll(List resources, ResourceSet aSet) {
        if (aSet == null || resources == null || resources.isEmpty()) {
            return;
        }
        aSet.getResources().removeAll((Collection)resources);
        int i = 0;
        while (i < resources.size()) {
            Resource res = (Resource)resources.get(i);
            res.unload();
            ++i;
        }
    }

    public static boolean becomeProxy(EObject anObject) {
        Resource res;
        if (anObject != null && (res = anObject.eResource()) != null) {
            URI uri = res.getURI();
            ((InternalEObject)anObject).eSetProxyURI(uri.appendFragment(res.getURIFragment(anObject)));
            return true;
        }
        return false;
    }

    public static boolean isResourceNotFound(WrappedException wrappedEx) {
        Exception excep = wrappedEx.exception();
        while (excep instanceof WrappedException) {
            excep = ((WrappedException)((Object)excep)).exception();
        }
        return WorkbenchResourceHelperBase.primIsResourceNotFound(excep);
    }

    private static boolean primIsResourceNotFound(Throwable excep) {
        if (excep instanceof CoreException) {
            IStatus status = ((CoreException)excep).getStatus();
            return status.getCode() == 368 && "org.eclipse.core.resources".equals(status.getPlugin());
        }
        return false;
    }

    public static boolean isResourceNotFound(Resource.IOWrappedException wrappedEx) {
        return WorkbenchResourceHelperBase.primIsResourceNotFound(wrappedEx.getCause());
    }

    public static URI getNonPlatformURI(URI platformURI) {
        if (WorkbenchResourceHelperBase.isPlatformResourceURI(platformURI)) {
            String uriString = WorkbenchResourceHelperBase.primGetNonPlatformURIString(platformURI);
            return URI.createURI((String)uriString);
        }
        return platformURI;
    }

    public static String getNonPlatformURIString(URI platformURI) {
        if (WorkbenchResourceHelperBase.isPlatformResourceURI(platformURI)) {
            return WorkbenchResourceHelperBase.primGetNonPlatformURIString(platformURI);
        }
        return platformURI.toString();
    }

    private static String primGetNonPlatformURIString(URI platformURI) {
        String uriString = platformURI.toString();
        return uriString.substring(19, uriString.length());
    }

    public static boolean isPlatformPluginResourceURI(URI uri) {
        return "platform".equals(uri.scheme()) && "plugin".equals(uri.segment(0));
    }
}

