/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.WorkbenchByteArrayOutputStream;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class BinaryProjectHelper {
    public void importArchiveAsBinary(Archive archive, IProject project, IProgressMonitor monitor) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IFile savedModuleFile = this.saveFile(archive, project);
            this.saveEnclosedFile(archive, project, ".classpath");
            this.saveEnclosedFile(archive, project, ".project");
            BinaryProjectHelper.removeImportedClassesFromClasspathIfNecessary(project);
            this.ensureBinary(javaProject, monitor);
            IPath path = savedModuleFile.getFullPath();
            IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)path, (IPath)path, null, (boolean)true);
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
            System.arraycopy(entries, 0, newEntries, 1, entries.length);
            newEntries[0] = newEntry;
            javaProject.setRawClasspath(newEntries, monitor);
        }
        catch (FileNotFoundException e) {
            Logger.getLogger().log(e);
        }
        catch (IOException e) {
            Logger.getLogger().log(e);
        }
        catch (JavaModelException e) {
            Logger.getLogger().log(e);
        }
    }

    public static void removeImportedClassesFromClasspathIfNecessary(IProject project) {
        IClasspathEntry[] entries;
        IJavaProject javaProj = JavaCore.create((IProject)project);
        if (javaProj != null && (entries = javaProj.readRawClasspath()) != null) {
            IClasspathEntry entryToRemove = null;
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getEntryKind() == 1 && entries[i].getPath().toString().endsWith("imported_classes") && !project.getFolder("imported_classes").exists()) {
                    entryToRemove = entries[i];
                    break;
                }
                ++i;
            }
            if (entryToRemove != null) {
                IClasspathEntry[] newEntries = new IClasspathEntry[entries.length - 1];
                int i2 = 0;
                int j = 0;
                while (i2 < newEntries.length && j < entries.length) {
                    if (entryToRemove != entries[j]) {
                        newEntries[i2] = entries[j];
                        ++i2;
                    }
                    ++j;
                }
                entries = newEntries;
                IPath output = javaProj.readOutputLocation();
                if (output != null) {
                    try {
                        javaProj.setRawClasspath(entries, output, null);
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
        }
    }

    protected IFile saveFile(File aFile, IProject p) throws IOException {
        IFile iFile = p.getFile(aFile.getURI());
        WorkbenchByteArrayOutputStream out = new WorkbenchByteArrayOutputStream(iFile);
        ArchiveUtil.copy(aFile.getInputStream(), (OutputStream)((Object)out));
        return iFile;
    }

    protected void saveEnclosedFile(Archive anArchive, IProject p, String uri) throws IOException {
        try {
            File aFile = anArchive.getFile(uri);
            this.saveFile(aFile, p);
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    protected void ensureBinary(IJavaProject javaProject, IProgressMonitor monitor) {
        if (javaProject == null) {
            return;
        }
        ArrayList<IClasspathEntry> newCp = new ArrayList<IClasspathEntry>();
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getEntryKind() != 3) {
                    newCp.add(entries[i]);
                }
                ++i;
            }
            entries = newCp.toArray(new IClasspathEntry[newCp.size()]);
            javaProject.setRawClasspath(entries, monitor);
        }
        catch (JavaModelException ex) {
            Logger.getLogger().log(ex);
        }
    }
}

