/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.application.internal.operations.IAnnotationsDataModel;
import org.eclipse.jst.j2ee.application.internal.operations.J2EEArtifactImportDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.J2EEUtilityJarImportDataModelProvider;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.AppClientComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.FileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.WARFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.datamodel.properties.IEARComponentImportDataModelProperties;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.archive.operations.EARComponentImportOperation;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.moduleextension.EarModuleManager;
import org.eclipse.jst.j2ee.internal.moduleextension.EjbModuleExtension;
import org.eclipse.jst.j2ee.internal.moduleextension.JcaModuleExtension;
import org.eclipse.jst.j2ee.internal.moduleextension.WebModuleExtension;
import org.eclipse.jst.j2ee.project.facet.EARFacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.WTPPlugin;
import org.eclipse.wst.common.frameworks.internal.operations.ProjectCreationDataModelProviderNew;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class EARComponentImportDataModelProvider
extends J2EEArtifactImportDataModelProvider
implements IAnnotationsDataModel,
IEARComponentImportDataModelProperties {
    public static final String NESTED_PROJECTS_VALIDATION = "EARImportDataModel.NESTED_PROJECTS_VALIDATION";
    public static final String EAR_NAME_VALIDATION = "EARImportDataModel.EAR_NAME_VALIDATION";
    private IDataModelListener nestedListener = new IDataModelListener(){

        public void propertyChanged(DataModelEvent event) {
            if (event.getPropertyName().equals("IJ2EEComponentImportDataModelProperties.PROJECT_NAME")) {
                EARComponentImportDataModelProvider.this.model.notifyPropertyChange(EARComponentImportDataModelProvider.NESTED_PROJECTS_VALIDATION, 2);
            }
        }
    };
    private Hashtable ejbJarToClientJarModels = new Hashtable();
    private Hashtable clientJarToEjbJarModels = new Hashtable();
    private ModuleFile cachedLoadError = null;

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IEnterpriseApplicationImportDataModelProperties.NESTED_MODULE_ROOT");
        propertyNames.add("IEnterpriseApplicationImportDataModelProperties.UTILITY_LIST");
        propertyNames.add("IEnterpriseApplicationImportDataModelProperties.MODULE_MODELS_LIST");
        propertyNames.add("IEnterpriseApplicationImportDataModelProperties.EJB_CLIENT_LIST");
        propertyNames.add("IEnterpriseApplicationImportDataModelProperties.UTILITY_MODELS_LIST");
        propertyNames.add(NESTED_PROJECTS_VALIDATION);
        propertyNames.add(EAR_NAME_VALIDATION);
        propertyNames.add("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST");
        propertyNames.add("IAnnotationsDataModel.useAnnotations");
        propertyNames.add("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST");
        propertyNames.add("IEnterpriseApplicationImportDataModelProperties.UNHANDLED_PROJECT_MODELS_LIST");
        propertyNames.add("IEnterpriseApplicationImportDataModelProperties.HANDLED_PROJECT_MODELS_LIST");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if ("IEnterpriseApplicationImportDataModelProperties.NESTED_MODULE_ROOT".equals(propertyName)) {
            return this.getLocation().toOSString();
        }
        if ("IEnterpriseApplicationImportDataModelProperties.MODULE_MODELS_LIST".equals(propertyName) || "IEnterpriseApplicationImportDataModelProperties.UTILITY_LIST".equals(propertyName) || "IEnterpriseApplicationImportDataModelProperties.UTILITY_MODELS_LIST".equals(propertyName) || "IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST".equals(propertyName) || "IEnterpriseApplicationImportDataModelProperties.EJB_CLIENT_LIST".equals(propertyName)) {
            return Collections.EMPTY_LIST;
        }
        if ("IAnnotationsDataModel.useAnnotations".equals(propertyName)) {
            return Boolean.FALSE;
        }
        if ("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST".equals(propertyName)) {
            return this.getProjectModels();
        }
        if ("IEnterpriseApplicationImportDataModelProperties.UNHANDLED_PROJECT_MODELS_LIST".equals(propertyName)) {
            return this.getUnhandledProjectModels();
        }
        if ("IEnterpriseApplicationImportDataModelProperties.HANDLED_PROJECT_MODELS_LIST".equals(propertyName)) {
            return this.getHandledSelectedModels();
        }
        return super.getDefaultProperty(propertyName);
    }

    public void propertyChanged(DataModelEvent event) {
        super.propertyChanged(event);
        if (event.getPropertyName().equals("IJ2EEComponentImportDataModelProperties.PROJECT_NAME")) {
            this.changeModuleCreationLocationForNameChange(this.getProjectModels());
        } else if (event.getPropertyName().equals("IFacetProjectCreationDataModelProperties.FACET_RUNTIME") && event.getDataModel() == this.model.getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION")) {
            Object propertyValue = event.getProperty();
            IDataModel nestedModel = null;
            List projectModels = (List)this.getProperty("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST");
            int i = 0;
            while (i < projectModels.size()) {
                nestedModel = (IDataModel)projectModels.get(i);
                nestedModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", propertyValue);
                ++i;
            }
        }
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST".equals(propertyName) || "IEnterpriseApplicationImportDataModelProperties.UNHANDLED_PROJECT_MODELS_LIST".equals(propertyName) || "IEnterpriseApplicationImportDataModelProperties.HANDLED_PROJECT_MODELS_LIST".equals(propertyName) || EAR_NAME_VALIDATION.equals(propertyName)) {
            throw new RuntimeException(String.valueOf(propertyName) + " is an unsettable property");
        }
        boolean doSet = super.propertySet(propertyName, propertyValue);
        if ("IEnterpriseApplicationImportDataModelProperties.NESTED_MODULE_ROOT".equals(propertyName)) {
            this.updateModuleRoot();
        } else if ("IJ2EEArtifactImportDataModelProperties.FILE_NAME".equals(propertyName)) {
            this.setProperty("IEnterpriseApplicationImportDataModelProperties.MODULE_MODELS_LIST", this.getModuleModels());
            this.updateModuleRoot();
            this.setProperty("IEnterpriseApplicationImportDataModelProperties.UTILITY_LIST", null);
            IDataModel earProjectModel = this.model.getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION");
            if (this.getArchiveFile() != null) {
                IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)earProjectModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
                IDataModel earFacetDataModel = map.getFacetDataModel("jst.ear");
                int version = ArchiveUtil.getFastSpecVersion((ModuleFile)this.getArchiveFile());
                String versionText = J2EEVersionUtil.getJ2EETextVersion(version);
                earFacetDataModel.setStringProperty("IFacetDataModelProperties.FACET_VERSION_STR", versionText);
            }
            this.model.notifyPropertyChange("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", 4);
            if (this.getJ2EEVersion() < 13) {
                this.setBooleanProperty("IAnnotationsDataModel.useAnnotations", false);
            }
            this.model.notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
        } else if ("IEnterpriseApplicationImportDataModelProperties.UTILITY_LIST".equals(propertyName)) {
            this.updateUtilityModels((List)propertyValue);
        } else if ("IAnnotationsDataModel.useAnnotations".equals(propertyName)) {
            List projectModels = (List)this.getProperty("IEnterpriseApplicationImportDataModelProperties.MODULE_MODELS_LIST");
            IDataModel nestedModel = null;
            int i = 0;
            while (i < projectModels.size()) {
                nestedModel = (IDataModel)projectModels.get(i);
                if (nestedModel.isProperty("IAnnotationsDataModel.useAnnotations")) {
                    nestedModel.setProperty("IAnnotationsDataModel.useAnnotations", propertyValue);
                }
                ++i;
            }
        } else if ("IEnterpriseApplicationImportDataModelProperties.MODULE_MODELS_LIST".equals(propertyName)) {
            ArrayList newList = new ArrayList();
            newList.addAll(this.getProjectModels());
            this.setProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST", newList);
        } else if ("IJ2EEComponentImportDataModelProperties.PROJECT_NAME".equals(propertyName)) {
            IProject project;
            List nestedModels = (List)this.getProperty("IEnterpriseApplicationImportDataModelProperties.MODULE_MODELS_LIST");
            IDataModel nestedModel = null;
            int i = 0;
            while (i < nestedModels.size()) {
                nestedModel = (IDataModel)nestedModels.get(i);
                nestedModel.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", propertyValue);
                ++i;
            }
            nestedModels = (List)this.getProperty("IEnterpriseApplicationImportDataModelProperties.UTILITY_MODELS_LIST");
            i = 0;
            while (i < nestedModels.size()) {
                nestedModel = (IDataModel)nestedModels.get(i);
                nestedModel.setProperty("J2EEUtilityJarImportDataModel.EAR_PROJECT_NAME", propertyValue);
                ++i;
            }
            if (ProjectCreationDataModelProviderNew.validateProjectName(this.getStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME")).isOK() && (project = ProjectUtilities.getProject(this.getStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME"))) != null && project.exists()) {
                IRuntime runtime;
                IFacetedProject facetedProject = null;
                boolean canContinue = true;
                try {
                    facetedProject = ProjectFacetsManager.create((IProject)project);
                }
                catch (CoreException e) {
                    Logger.getLogger().logError(e);
                    canContinue = false;
                }
                if (canContinue && (runtime = facetedProject.getRuntime()) != null) {
                    this.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", runtime);
                }
            }
        }
        return doSet;
    }

    public List getAllUtilitiesExceptEJBClients(EARFile earFile) {
        List clientList = (List)this.getProperty("IEnterpriseApplicationImportDataModelProperties.EJB_CLIENT_LIST");
        List list = EARComponentImportDataModelProvider.getAllUtilities(earFile);
        int i = list.size() - 1;
        while (i > -1) {
            FileImpl file = (FileImpl)list.get(i);
            boolean shouldRemove = false;
            int j = 0;
            while (j < clientList.size() && !shouldRemove) {
                IDataModel localModel = (IDataModel)clientList.get(j);
                if (localModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE") == file) {
                    shouldRemove = true;
                }
                ++j;
            }
            if (shouldRemove) {
                list.remove(i);
            }
            --i;
        }
        return list;
    }

    public static List getAllUtilities(EARFile earFile) {
        EList files = earFile.getFiles();
        ArrayList<FileImpl> utilJars = new ArrayList<FileImpl>();
        int i = 0;
        while (i < files.size()) {
            FileImpl file = (FileImpl)files.get(i);
            if (file.isArchive() && !file.isModuleFile() && file.getURI().endsWith(".jar")) {
                utilJars.add(file);
            }
            if (file.isWARFile()) {
                utilJars.addAll(EARComponentImportDataModelProvider.getWebLibs((WARFile)((Object)file)));
            }
            ++i;
        }
        return utilJars;
    }

    public static List getWebLibs(WARFile warFile) {
        return ((WARFileImpl)warFile).getLibArchives();
    }

    protected boolean forceResetOnPreserveMetaData() {
        return false;
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals(NESTED_PROJECTS_VALIDATION) || propertyName.equals(EAR_NAME_VALIDATION)) {
            boolean checkAgainstEARNameOnly = propertyName.equals(EAR_NAME_VALIDATION);
            String earProjectName = this.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
            List subProjects = this.getSelectedModels();
            IDataModel subDataModel = null;
            String tempProjectName = null;
            Archive tempArchive = null;
            IStatus tempStatus = null;
            Hashtable<String, Archive> projects = new Hashtable<String, Archive>(4);
            int i = 0;
            while (i < subProjects.size()) {
                subDataModel = (IDataModel)subProjects.get(i);
                tempProjectName = subDataModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                tempArchive = (Archive)subDataModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
                if (checkAgainstEARNameOnly) {
                    if (tempProjectName.equals(earProjectName)) {
                        return WTPCommonPlugin.createWarningStatus(EARCreationResourceHandler.bind((String)EARCreationResourceHandler.EARImportDataModel_UI_1, (Object[])new Object[]{tempProjectName, tempArchive.getURI()}));
                    }
                    if (!WTPPlugin.isPlatformCaseSensitive() && tempProjectName.toLowerCase().equals(earProjectName.toLowerCase())) {
                        return WTPCommonPlugin.createWarningStatus(EARCreationResourceHandler.bind((String)EARCreationResourceHandler.EARImportDataModel_UI_1a, (Object[])new Object[]{earProjectName, tempProjectName, tempArchive.getURI()}));
                    }
                } else {
                    tempStatus = subDataModel.validateProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                    if (!tempStatus.isOK()) {
                        return WTPCommonPlugin.createErrorStatus(EARCreationResourceHandler.bind((String)EARCreationResourceHandler.EARImportDataModel_UI_0, (Object[])new Object[]{tempProjectName, tempArchive.getURI()}));
                    }
                    tempStatus = subDataModel.validate();
                    if (!tempStatus.isOK()) {
                        return tempStatus;
                    }
                    if (tempProjectName.equals(earProjectName)) {
                        return WTPCommonPlugin.createErrorStatus(EARCreationResourceHandler.bind((String)EARCreationResourceHandler.EARImportDataModel_UI_1, (Object[])new Object[]{tempProjectName, tempArchive.getURI()}));
                    }
                    if (!WTPPlugin.isPlatformCaseSensitive() && tempProjectName.toLowerCase().equals(earProjectName.toLowerCase())) {
                        return WTPCommonPlugin.createErrorStatus(EARCreationResourceHandler.bind((String)EARCreationResourceHandler.EARImportDataModel_UI_1a, (Object[])new Object[]{earProjectName, tempProjectName, tempArchive.getURI()}));
                    }
                    if (projects.containsKey(tempProjectName)) {
                        return WTPCommonPlugin.createErrorStatus(EARCreationResourceHandler.bind((String)EARCreationResourceHandler.EARImportDataModel_UI_2, (Object[])new Object[]{tempProjectName, tempArchive.getURI(), ((Archive)projects.get(tempProjectName)).getURI()}));
                    }
                    if (!WTPPlugin.isPlatformCaseSensitive()) {
                        String lowerCaseProjectName = tempProjectName.toLowerCase();
                        String currentKey = null;
                        Enumeration keys = projects.keys();
                        while (keys.hasMoreElements()) {
                            currentKey = (String)keys.nextElement();
                            if (!currentKey.toLowerCase().equals(lowerCaseProjectName)) continue;
                            return WTPCommonPlugin.createErrorStatus(EARCreationResourceHandler.bind((String)EARCreationResourceHandler.EARImportDataModel_UI_2a, (Object[])new Object[]{tempProjectName, currentKey, tempArchive.getURI(), ((Archive)projects.get(currentKey)).getURI()}));
                        }
                    }
                    projects.put(tempProjectName, tempArchive);
                }
                ++i;
            }
        } else if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.FILE_NAME")) {
            IStatus status = super.validate(propertyName);
            if (!status.isOK()) {
                return status;
            }
            if (this.cachedLoadError != null) {
                return WTPCommonPlugin.createWarningStatus(EARCreationResourceHandler.bind((String)EARCreationResourceHandler.EARImportDataModel_UI_4, (Object[])new Object[]{this.cachedLoadError.getURI()}));
            }
            return status;
        }
        return super.validate(propertyName);
    }

    private void updateModuleRoot() {
        List projects = this.getProjectModels();
        String basePath = this.isPropertySet("IEnterpriseApplicationImportDataModelProperties.NESTED_MODULE_ROOT") ? this.getStringProperty("IEnterpriseApplicationImportDataModelProperties.NESTED_MODULE_ROOT") : null;
        boolean useDefault = basePath == null;
        IDataModel localModel = null;
        int i = 0;
        while (projects != null && i < projects.size()) {
            localModel = (IDataModel)projects.get(i);
            localModel.setProperty("IProjectCreationPropertiesNew.USER_DEFINED_BASE_LOCATION", basePath);
            localModel.setBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION", useDefault);
            ++i;
        }
    }

    private void changeModuleCreationLocationForNameChange(List projects) {
        IDataModel localModel = null;
        int i = 0;
        while (projects != null && i < projects.size()) {
            localModel = (IDataModel)projects.get(i);
            if (this.isPropertySet("IEnterpriseApplicationImportDataModelProperties.NESTED_MODULE_ROOT")) {
                Path newPath = new Path((String)this.getProperty("IEnterpriseApplicationImportDataModelProperties.NESTED_MODULE_ROOT"));
                newPath = newPath.append((String)localModel.getProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME"));
            }
            ++i;
        }
    }

    private IPath getLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation();
    }

    private void trimSelection() {
        boolean modified = false;
        List selectedList = this.getSelectedModels();
        List allList = this.getProjectModels();
        int i = selectedList.size() - 1;
        while (i > -1) {
            if (!allList.contains(selectedList.get(i))) {
                modified = true;
                selectedList.remove(i);
            }
            --i;
        }
        if (modified) {
            ArrayList newList = new ArrayList();
            newList.addAll(selectedList);
            this.setProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST", newList);
        }
    }

    private void updateUtilityModels(List utilityJars) {
        this.updateUtilityModels(utilityJars, "IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST", "IEnterpriseApplicationImportDataModelProperties.UTILITY_MODELS_LIST");
    }

    private void updateUtilityModels(List utilityJars, String selectedProperty, String listTypeProperty) {
        boolean allSelected = true;
        List selectedList = (List)this.getProperty(selectedProperty);
        List allList = this.getProjectModels();
        if (selectedList.size() == allList.size()) {
            int i = 0;
            while (i < selectedList.size() && allSelected) {
                if (!selectedList.contains(allList.get(i)) || !allList.contains(selectedList.get(i))) {
                    allSelected = false;
                }
                ++i;
            }
        } else {
            allSelected = false;
        }
        ArrayList<IDataModel> utilityModels = (ArrayList<IDataModel>)this.getProperty(listTypeProperty);
        Archive currentArchive = null;
        IDataModel currentUtilityModel = null;
        boolean utilityJarsModified = false;
        int i = 0;
        while (utilityJars != null && i < utilityJars.size()) {
            currentArchive = (Archive)utilityJars.get(i);
            boolean added = false;
            int j = 0;
            while (utilityModels != null && j < utilityModels.size() && !added) {
                currentUtilityModel = (IDataModel)utilityModels.get(j);
                if (currentUtilityModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE") == currentArchive) {
                    added = true;
                }
                ++j;
            }
            if (!added) {
                if (!this.isPropertySet(listTypeProperty)) {
                    utilityModels = new ArrayList<IDataModel>();
                    this.setProperty(listTypeProperty, utilityModels);
                }
                IDataModel localModel = DataModelFactory.createDataModel(new J2EEUtilityJarImportDataModelProvider());
                localModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE", currentArchive);
                localModel.setProperty("J2EEUtilityJarImportDataModel.EAR_PROJECT_NAME", this.getStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME"));
                localModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME"));
                utilityModels.add(localModel);
                localModel.addListener(this.nestedListener);
                utilityJarsModified = true;
            }
            ++i;
        }
        i = utilityModels.size() - 1;
        while (i >= 0) {
            currentUtilityModel = (IDataModel)utilityModels.get(i);
            currentArchive = (Archive)currentUtilityModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
            if (utilityJars == null || !utilityJars.contains(currentArchive)) {
                currentUtilityModel.removeListener(this.nestedListener);
                currentUtilityModel.dispose();
                utilityModels.remove(currentUtilityModel);
                utilityJarsModified = true;
            }
            --i;
        }
        allList = this.getProjectModels();
        if (allSelected) {
            ArrayList newList = new ArrayList();
            newList.addAll(allList);
            this.setProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST", newList);
        } else {
            this.trimSelection();
        }
        if (utilityJarsModified) {
            this.model.notifyPropertyChange(NESTED_PROJECTS_VALIDATION, 1);
        }
    }

    private List getModuleModels() {
        IDataModel localModel;
        if (this.getArchiveFile() == null) {
            return Collections.EMPTY_LIST;
        }
        this.cachedLoadError = null;
        List moduleFiles = this.getEARFile().getModuleFiles();
        ArrayList<IDataModel> moduleModels = new ArrayList<IDataModel>();
        ArrayList<Archive> clientJarArchives = new ArrayList<Archive>();
        String earProjectName = this.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        ArrayList<String> defaultModuleNames = new ArrayList<String>();
        defaultModuleNames.add(earProjectName);
        ArrayList<String> collidingModuleNames = null;
        Hashtable<IDataModel, Archive> ejbJarsWithClients = new Hashtable<IDataModel, Archive>();
        int i = 0;
        while (i < moduleFiles.size()) {
            localModel = null;
            ModuleFile temp = (ModuleFile)moduleFiles.get(i);
            try {
                JcaModuleExtension rarExt;
                if (temp.isApplicationClientFile()) {
                    localModel = DataModelFactory.createDataModel(new AppClientComponentImportDataModelProvider());
                } else if (temp.isWARFile()) {
                    WebModuleExtension webExt = EarModuleManager.getWebModuleExtension();
                    if (webExt != null) {
                        localModel = webExt.createImportDataModel();
                        WebModule webModule = (WebModule)this.getEARFile().getModule(temp.getURI(), null);
                        if (webModule != null && webModule.getContextRoot() != null) {
                            localModel.setProperty("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT", webModule.getContextRoot());
                        }
                    }
                } else if (temp.isEJBJarFile()) {
                    EJBJar jar;
                    EjbModuleExtension ejbExt = EarModuleManager.getEJBModuleExtension();
                    if (ejbExt != null) {
                        localModel = ejbExt.createImportDataModel();
                    }
                    if ((jar = ((EJBJarFile)temp).getDeploymentDescriptor()) != null && jar.getEjbClientJar() != null) {
                        String clientName = jar.getEjbClientJar();
                        try {
                            Archive clientArchive = (Archive)this.getEARFile().getFile(clientName);
                            clientJarArchives.add(clientArchive);
                            ejbJarsWithClients.put(localModel, clientArchive);
                        }
                        catch (Exception exception) {}
                    }
                } else if (temp.isRARFile() && (rarExt = EarModuleManager.getJCAModuleExtension()) != null) {
                    localModel = rarExt.createImportDataModel();
                }
                if (localModel != null) {
                    localModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE", temp);
                    localModel.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", earProjectName);
                    localModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME"));
                    localModel.addListener(this);
                    localModel.addListener(this.nestedListener);
                    moduleModels.add(localModel);
                    String moduleName = localModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                    if (defaultModuleNames.contains(moduleName)) {
                        if (collidingModuleNames == null) {
                            collidingModuleNames = new ArrayList<String>();
                        }
                        collidingModuleNames.add(moduleName);
                    } else {
                        defaultModuleNames.add(moduleName);
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger().logError("Error loading nested archive: " + temp.getURI());
                Logger.getLogger().logError(e);
                this.cachedLoadError = temp;
            }
            ++i;
        }
        this.updateUtilityModels(clientJarArchives, "IEnterpriseApplicationImportDataModelProperties.EJB_CLIENT_LIST", "IEnterpriseApplicationImportDataModelProperties.EJB_CLIENT_LIST");
        List clientModelList = (List)this.getProperty("IEnterpriseApplicationImportDataModelProperties.EJB_CLIENT_LIST");
        Enumeration ejbModels = ejbJarsWithClients.keys();
        this.ejbJarToClientJarModels.clear();
        this.clientJarToEjbJarModels.clear();
        while (ejbModels.hasMoreElements()) {
            Object ejbModel = ejbModels.nextElement();
            Object archive = ejbJarsWithClients.get(ejbModel);
            Object clientModel = null;
            int i2 = 0;
            while (clientModel == null && i2 < clientModelList.size()) {
                if (((IDataModel)clientModelList.get(i2)).getProperty("IJ2EEArtifactImportDataModelProperties.FILE") == archive) {
                    clientModel = clientModelList.get(i2);
                }
                ++i2;
            }
            this.ejbJarToClientJarModels.put(ejbModel, clientModel);
            this.clientJarToEjbJarModels.put(clientModel, ejbModel);
        }
        int i3 = 0;
        while (collidingModuleNames != null && i3 < moduleModels.size()) {
            localModel = (IDataModel)moduleModels.get(i3);
            String moduleName = localModel.getStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME");
            if (collidingModuleNames.contains(moduleName)) {
                ModuleFile module = (ModuleFile)localModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
                String suffix = null;
                if (module.isApplicationClientFile()) {
                    suffix = "_AppClient";
                } else if (module.isWARFile()) {
                    suffix = "_WEB";
                } else if (module.isEJBJarFile()) {
                    suffix = "_EJB";
                } else if (module.isRARFile()) {
                    suffix = "_JCA";
                }
                if (defaultModuleNames.contains(String.valueOf(moduleName) + suffix)) {
                    int count = 1;
                    while (defaultModuleNames.contains(String.valueOf(moduleName) + suffix + count) && count < 10) {
                        ++count;
                    }
                    suffix = String.valueOf(suffix) + count;
                }
                localModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", String.valueOf(moduleName) + suffix);
            }
            ++i3;
        }
        return moduleModels;
    }

    protected int getType() {
        return 2;
    }

    protected Archive openArchive(String uri) throws OpenFailureException {
        return CommonarchiveFactory.eINSTANCE.openEARFile(this.getArchiveOptions(), uri);
    }

    private EARFile getEARFile() {
        return (EARFile)this.getArchiveFile();
    }

    public boolean handlesArchive(Archive anArchive) {
        ArrayList temp = new ArrayList();
        List tempList = (List)this.getProperty("IEnterpriseApplicationImportDataModelProperties.MODULE_MODELS_LIST");
        if (tempList != null) {
            temp.addAll(tempList);
        }
        if ((tempList = (List)this.getProperty("IEnterpriseApplicationImportDataModelProperties.EJB_CLIENT_LIST")) != null) {
            temp.addAll(tempList);
        }
        tempList = this.getSelectedModels();
        int i = 0;
        while (i < tempList.size()) {
            if (!temp.contains(tempList.get(i))) {
                temp.add(tempList.get(i));
            }
            ++i;
        }
        IDataModel importDM = null;
        int i2 = 0;
        while (i2 < temp.size()) {
            importDM = (IDataModel)temp.get(i2);
            if (importDM.getProperty("IJ2EEArtifactImportDataModelProperties.FILE") == anArchive) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private List getProjectModels() {
        ArrayList temp = new ArrayList();
        List tempList = (List)this.getProperty("IEnterpriseApplicationImportDataModelProperties.MODULE_MODELS_LIST");
        if (tempList != null) {
            temp.addAll(tempList);
        }
        if ((tempList = (List)this.getProperty("IEnterpriseApplicationImportDataModelProperties.UTILITY_MODELS_LIST")) != null) {
            temp.addAll(tempList);
        }
        if ((tempList = (List)this.getProperty("IEnterpriseApplicationImportDataModelProperties.EJB_CLIENT_LIST")) != null) {
            temp.addAll(tempList);
        }
        return temp;
    }

    private List getUnhandledProjectModels() {
        List handled = this.removeHandledModels(this.getProjectModels(), this.getProjectModels(), false);
        List all = this.getProjectModels();
        all.removeAll(handled);
        return all;
    }

    public List getSelectedModels() {
        return (List)this.getProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST");
    }

    private List removeHandledModels(List listToPrune, List modelsToCheck, boolean addModels) {
        ArrayList newList = new ArrayList();
        newList.addAll(listToPrune);
        int i = 0;
        while (i < modelsToCheck.size()) {
            IDataModel cfr_ignored_0 = (IDataModel)modelsToCheck.get(i);
            ++i;
        }
        return newList;
    }

    private List getHandledSelectedModels() {
        List selectedModels = this.getSelectedModels();
        return this.removeHandledModels(selectedModels, selectedModels, true);
    }

    public int getJ2EEVersion() {
        EARFile ef = this.getEARFile();
        return ef == null ? 12 : ArchiveUtil.getFastSpecVersion(ef);
    }

    public boolean isPropertyEnabled(String propertyName) {
        if (!super.isPropertyEnabled(propertyName)) {
            return false;
        }
        if (propertyName.equals("IAnnotationsDataModel.useAnnotations")) {
            return this.getJ2EEVersion() >= 13;
        }
        return true;
    }

    public void dispose() {
        super.dispose();
        List list = this.getProjectModels();
        int i = 0;
        while (i < list.size()) {
            ((IDataModel)list.get(i)).dispose();
            ++i;
        }
        EARFile earFile = this.getEARFile();
        if (earFile != null) {
            earFile.close();
        }
    }

    protected IDataModel createJ2EEComponentCreationDataModel() {
        return DataModelFactory.createDataModel((IDataModelProvider)((Object)new EARFacetProjectCreationDataModelProvider()));
    }

    public IDataModelOperation getDefaultOperation() {
        return new EARComponentImportOperation(this.model);
    }
}

