/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy;

public abstract class ArchiveTypeDiscriminatorImpl
implements ArchiveTypeDiscriminator {
    protected List children;

    public void addChild(ArchiveTypeDiscriminator child) {
        if (this.hasChild(child)) {
            return;
        }
        this.getChildren().add(child);
    }

    public void addChildAfter(ArchiveTypeDiscriminator child, ArchiveTypeDiscriminator predecessor) throws NoSuchElementException {
        if (this.hasChild(child)) {
            return;
        }
        int index = this.getChildren().indexOf(predecessor);
        if (index < 0) {
            throw new NoSuchElementException(predecessor.toString());
        }
        this.getChildren().add(++index, child);
    }

    public void addChildBefore(ArchiveTypeDiscriminator child, ArchiveTypeDiscriminator successor) throws NoSuchElementException {
        if (this.hasChild(child)) {
            return;
        }
        int index = this.getChildren().indexOf(successor);
        if (index < 0) {
            throw new NoSuchElementException(successor.toString());
        }
        this.getChildren().add(index, child);
    }

    public abstract boolean canImport(Archive var1);

    public Archive convert(Archive anArchive) throws OpenFailureException {
        Archive destination = this.createConvertedArchive();
        destination.eSetDeliver(false);
        destination.eSetDeliver(false);
        destination.setURI(anArchive.getURI());
        destination.setOriginalURI(anArchive.getURI());
        destination.setSize(anArchive.getSize());
        destination.setLastModified(anArchive.getLastModified());
        destination.setOptions(anArchive.getOptions());
        destination.setLoadStrategy(anArchive.getLoadStrategy());
        destination.setExtraClasspath(anArchive.getExtraClasspath());
        if (destination.isModuleFile()) {
            ImportStrategy importStrategy = this.createImportStrategy(anArchive, destination);
            ((ModuleFile)destination).setImportStrategy(importStrategy);
        }
        destination.eSetDeliver(true);
        destination.eSetDeliver(true);
        return destination;
    }

    public abstract Archive createConvertedArchive();

    public abstract ImportStrategy createImportStrategy(Archive var1, Archive var2);

    public List getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    protected Archive getImportableArchiveFromChild(Archive anArchive) throws OpenFailureException {
        if (!this.hasChildren()) {
            return null;
        }
        List theChildren = this.getChildren();
        Archive childConvertedArchive = null;
        int i = 0;
        while (i < theChildren.size()) {
            ArchiveTypeDiscriminator child = (ArchiveTypeDiscriminator)theChildren.get(i);
            childConvertedArchive = child.openArchive(anArchive);
            if (childConvertedArchive != null) {
                return childConvertedArchive;
            }
            ++i;
        }
        return null;
    }

    protected String getXmlDDMessage(String archiveType, String ddUri) {
        return CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.invalid_archive_EXC_, new Object[]{archiveType, ddUri});
    }

    public boolean hasChild(ArchiveTypeDiscriminator disc) {
        return this.hasChildren() && this.getChildren().contains(disc);
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public Archive openArchive(Archive anArchive) throws OpenFailureException {
        if (!this.canImport(anArchive)) {
            return null;
        }
        Archive convertedArchive = this.convert(anArchive);
        Archive childConvertedArchive = this.getImportableArchiveFromChild(convertedArchive);
        if (childConvertedArchive != null) {
            return childConvertedArchive;
        }
        return convertedArchive;
    }

    public void removeChild(ArchiveTypeDiscriminator child) {
        this.getChildren().remove(child);
    }

    public void setChildren(List newChildren) {
        this.children = newChildren;
    }
}

