/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIteratorImpl;

public class NestedArchiveIterator
extends FileIteratorImpl {
    protected ZipInputStream zipInputStream;

    public NestedArchiveIterator(List theFiles, ZipInputStream stream) {
        super(theFiles);
        this.zipInputStream = stream;
    }

    public InputStream getInputStream(File nextFile) throws IOException, FileNotFoundException {
        Archive archiveFile;
        if (nextFile.isArchive() && (archiveFile = (Archive)nextFile).getLoadStrategy().getLooseArchive() != null) {
            return nextFile.getInputStream();
        }
        boolean foundMatch = false;
        String nextName = nextFile.getURI();
        while (!foundMatch) {
            ZipEntry currentEntry;
            try {
                currentEntry = this.zipInputStream.getNextEntry();
            }
            catch (IOException ex) {
                throw new ArchiveRuntimeException(CommonArchiveResourceHandler.Error_iterating_the_archiv_EXC_, ex);
            }
            boolean bl = foundMatch = !currentEntry.isDirectory() && nextName.equals(currentEntry.getName());
        }
        return new WrapperInputStream(this.zipInputStream);
    }

    public File next() throws NoSuchElementException {
        File next = super.next();
        return next;
    }

    public void close() throws IOException {
        this.zipInputStream.close();
    }

    static class WrapperInputStream
    extends FilterInputStream {
        public WrapperInputStream(InputStream in) {
            super(in);
        }

        public void close() throws IOException {
        }
    }
}

