/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ArchiveTypeDiscriminatorRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ReopenException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ContainerImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectorySaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipStreamSaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveFileDynamicClassLoader;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ClasspathUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class ArchiveImpl
extends ContainerImpl
implements Archive {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    protected static Logger loggerLCT = Logger.getLogger("com.ibm.config.eclipse.wtp.lct");
    private static String className;
    protected EList types = null;
    protected ArchiveManifest manifest;
    protected SaveStrategy saveStrategy;
    protected SaveFilter saveFilter;
    protected String xmlEncoding = "UTF-8";
    protected ClassLoader archiveClassLoader;
    protected String extraClasspath;
    protected ArchiveOptions options;
    private String displayMsg;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.getName();
    }

    public ArchiveImpl() {
        this.getCommonArchiveFactory().archiveOpened(this);
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.ARCHIVE;
    }

    public EList getTypes() {
        if (this.types == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.types = new EDataTypeUniqueEList((Class)clazz, (InternalEObject)this, 8);
        }
        return this.types;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getTypes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.getTypes().clear();
                this.getTypes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.getTypes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.types != null && !this.types.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (types: ");
        result.append(this.types);
        result.append(')');
        return result.toString();
    }

    public Archive addCopy(Archive anArchive) throws DuplicateObjectException {
        this.checkAddValid(anArchive);
        Archive copy = this.getCommonArchiveFactory().copy(anArchive);
        this.getFiles().add((Object)copy);
        return copy;
    }

    public File addCopy(File aFile) throws DuplicateObjectException {
        if (aFile.isReadOnlyDirectory()) {
            this.addCopy((ReadOnlyDirectory)aFile);
            return null;
        }
        this.checkAddValid(aFile);
        File copy = this.copy(aFile);
        this.getFiles().add((Object)copy);
        return copy;
    }

    public List addCopy(ReadOnlyDirectory dir) throws DuplicateObjectException {
        return this.addCopyFiles(dir.getFilesRecursive());
    }

    public List addCopyFiles(List list) throws DuplicateObjectException {
        this.getFiles();
        ArrayList<File> copyList = new ArrayList<File>();
        int i = 0;
        while (i < list.size()) {
            File aFile = (File)list.get(i);
            this.checkAddValid(aFile);
            copyList.add(this.copy(aFile));
            ++i;
        }
        this.getFiles().addAll(copyList);
        return copyList;
    }

    public void addOrReplaceMofResource(Resource aResource) {
        this.getLoadStrategy().addOrReplaceMofResource(aResource);
    }

    public boolean canClose() {
        return !this.getCommonArchiveFactory().getOpenArchivesDependingOn(this).isEmpty();
    }

    protected void checkAddValid(File aFile) throws DuplicateObjectException {
        this.checkAddValid(aFile.getURI());
    }

    protected void checkAddValid(String aUri) throws DuplicateObjectException {
        try {
            File f = this.getFile(aUri);
            if (f != null) {
                throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.duplicate_file_EXC_, new Object[]{this.getURI(), aUri}), f);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void setLoadStrategy(LoadStrategy newLoadStrategy) {
        super.setLoadStrategy(newLoadStrategy);
        if (this.loadStrategy != null && this.isModuleFile()) {
            this.getJavaAdapterFactory();
        }
    }

    protected void cleanupAfterTempSave(String aUri, java.io.File original, java.io.File destination) throws SaveFailureException {
        String originalPath;
        String methodName = "cleanupAfterTempSave";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI = [ {0} ]", aUri);
        this.checkWriteable(original);
        boolean deleteWorked = false;
        String absolutePath = original.getAbsolutePath();
        try {
            originalPath = original.getCanonicalPath();
        }
        catch (IOException ioe) {
            originalPath = original.getAbsolutePath();
        }
        logger.logp(Level.FINER, className, methodName, "Original file to be deleted [ {0} ]", originalPath);
        boolean originalIsDirectory = original.isDirectory();
        logger.logp(Level.FINER, className, methodName, "Original file a directory [ {0} ]", Boolean.toString(originalIsDirectory));
        if (!this.canRename(original)) {
            logger.logp(Level.FINER, className, methodName, "RETURN Throwing SaveFailureException because original file cannot be renamed");
            if (logger.isLoggable(Level.FINEST)) {
                new Throwable("Debug data for " + methodName).printStackTrace(System.out);
            }
            throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.unable_replace_EXC_, new Object[]{originalPath}));
        }
        int i = 0;
        while (i < 10) {
            if (ArchiveUtil.delete(original)) {
                logger.logp(Level.FINER, className, methodName, "Successfully deleted original file [ {0} ]", originalPath);
                if (i > 0) {
                    logger.logp(Level.FINER, className, methodName, "Number of times slept [ {0} ]", Integer.toString(i));
                }
                deleteWorked = true;
                break;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        String destinationPath = destination.getAbsolutePath();
        logger.logp(Level.FINER, className, methodName, "File to be renamed [ {0} ]", destinationPath);
        if (deleteWorked) {
            if (this.renameToWithRetry(destination, original)) {
                logger.logp(Level.FINER, className, methodName, "Successfully renamed file to original name [ {0} ]", originalPath);
                return;
            }
            logger.logp(Level.FINER, className, methodName, "Could not rename file to original name [ {0} ]", originalPath);
        } else {
            logger.logp(Level.FINER, className, methodName, "Could not delete original file [ {0} ]", originalPath);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN Throwing SaveFailureException");
        if (loggerLCT.isLoggable(Level.FINER)) {
            loggerLCT.logp(Level.WARNING, className, methodName, ZipFileLoadStrategyImpl.lct.printHash(absolutePath));
        }
        throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.unable_replace_EXC_, new Object[]{originalPath}));
    }

    public void close() {
        String methodName = "close";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI = [ {0} ]", this.getURI());
        this.getLoadStrategy().close();
        this.releaseClassLoader();
        this.getCommonArchiveFactory().archiveClosed(this);
        logger.logp(Level.FINER, className, methodName, "Archive closed.  Close nested archive files if archive is indexed.");
        if (this.isIndexed()) {
            List archives = this.getArchiveFiles();
            int i = 0;
            while (i < archives.size()) {
                Archive a = (Archive)archives.get(i);
                logger.logp(Level.FINER, className, methodName, "Close archive file [ {0} ]", a.getURI());
                a.close();
                ++i;
            }
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected File copy(File aFile) {
        String methodName = "copy";
        logger.logp(Level.FINER, className, methodName, "ENTRY file = [ {0} ]", aFile);
        File copy = null;
        copy = aFile.isArchive() ? this.getCommonArchiveFactory().copy((Archive)aFile) : (File)EtoolsCopyUtility.createCopy(aFile);
        logger.logp(Level.FINER, className, methodName, "RETURN copy [ {0} ]", copy);
        return copy;
    }

    protected LoadStrategy createLoadStrategyForReopen(Archive parent) throws IOException {
        String methodName = "createLoadStrategyForReopen";
        logger.logp(Level.FINER, className, methodName, "ENTRY parent = [ {0} ]", parent);
        LoadStrategy aLoadStrategy = null;
        LooseArchive loose = null;
        if (!this.getOptions().isSetAltBinariesPath()) {
            loose = this.getLoadStrategy().getLooseArchive();
        }
        if (loose != null) {
            logger.logp(Level.FINER, className, methodName, "No loose archive for load strategy.  Creating it.");
            aLoadStrategy = this.getCommonArchiveFactory().createLoadStrategy(loose.getBinariesPath());
            aLoadStrategy.setLooseArchive(loose);
        } else {
            aLoadStrategy = parent == null ? this.getCommonArchiveFactory().createLoadStrategy(this.getURI()) : this.getCommonArchiveFactory().createChildLoadStrategy(this.getURI(), parent.getLoadStrategy());
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", aLoadStrategy);
        return aLoadStrategy;
    }

    protected RuntimeClasspathEntry createRuntimeClasspathEntry(String absolutePath) {
        RuntimeClasspathEntryImpl entry = new RuntimeClasspathEntryImpl();
        entry.setAbsolutePath(absolutePath);
        return entry;
    }

    protected List createRuntimeClasspathEntries(String[] entries, String parentPath) {
        String methodName = "createRuntimeClasspathEntries";
        logger.logp(Level.FINER, className, methodName, "ENTRY parentPath = [ {0} ]", parentPath);
        ArrayList<RuntimeClasspathEntry> aList = new ArrayList<RuntimeClasspathEntry>(entries.length);
        int i = 0;
        while (i < entries.length) {
            block8: {
                String entry = entries[i];
                logger.logp(Level.FINER, className, methodName, "looking at entry [ {0} ]", entry);
                Archive dependentJar = this.resolveClasspathEntryInEAR(entry);
                logger.logp(Level.FINER, className, methodName, "dependent JAR [ {0} ]", dependentJar);
                if (dependentJar != null) {
                    try {
                        logger.logp(Level.FINER, className, methodName, "Creating runtime classpath entry for entry [ {0} ]", entry);
                        RuntimeClasspathEntry runEntry = this.createRuntimeClasspathEntry(dependentJar.getBinariesPath(), entry);
                        runEntry.setReferencedArchive(dependentJar);
                        aList.add(runEntry);
                        break block8;
                    }
                    catch (FileNotFoundException shouldntHappenInRuntime) {
                        logger.logp(Level.FINER, className, methodName, "Ignoring FileNotFoundException for entry [ {0} ]", entry);
                    }
                }
                java.io.File aFile = new java.io.File(entry);
                String absPath = null;
                if (aFile.isAbsolute()) {
                    absPath = aFile.getAbsolutePath();
                } else {
                    absPath = ArchiveUtil.getOSUri(parentPath, entry);
                    absPath = ClasspathUtil.normalizePath(absPath);
                }
                logger.logp(Level.FINER, className, methodName, "Creating runtime classpath entry for entry [ {0} ]", entry);
                aList.add(this.createRuntimeClasspathEntry(absPath, entry));
            }
            ++i;
        }
        if (logger.isLoggable(Level.FINER)) {
            String msg = "RETURN " + aList.size() + " elements";
            Iterator aIterator = aList.iterator();
            while (aIterator.hasNext()) {
                RuntimeClasspathEntryImpl pathElement = (RuntimeClasspathEntryImpl)aIterator.next();
                msg = String.valueOf(msg) + "\n  " + pathElement;
            }
            logger.logp(Level.FINER, className, methodName, msg);
        }
        return aList;
    }

    protected RuntimeClasspathEntry createRuntimeClasspathEntry(String absolutePath, String manifestValue) {
        RuntimeClasspathEntry entry = this.createRuntimeClasspathEntry(absolutePath);
        entry.setManifestValue(manifestValue);
        return entry;
    }

    protected SaveStrategy createSaveStrategyForDirectory(java.io.File dir, int expansionFlags) {
        return new DirectorySaveStrategyImpl(dir.getAbsolutePath(), expansionFlags);
    }

    protected SaveStrategy createSaveStrategyForDirectory(String aUri, int expansionFlags) {
        return new DirectorySaveStrategyImpl(aUri, expansionFlags);
    }

    protected SaveStrategy createSaveStrategyForJar(java.io.File aFile) throws IOException {
        if (aFile.exists() && aFile.isDirectory()) {
            throw new IOException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.file_exist_as_dir_EXC_, new Object[]{aFile.getAbsolutePath()}));
        }
        java.io.File parent = aFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(aFile);
        return new ZipStreamSaveStrategyImpl(out);
    }

    public void extract(int expansionFlags) throws SaveFailureException, ReopenException {
        this.extractNoReopen(expansionFlags);
        this.reopen();
    }

    public void extractNoReopen(int expansionFlags) throws SaveFailureException {
        String originalPath;
        String aUri = this.getURI();
        java.io.File aDir = new java.io.File(aUri);
        boolean inUse = this.getLoadStrategy().isUsing(aDir);
        try {
            originalPath = aDir.getCanonicalPath();
        }
        catch (IOException ioe) {
            originalPath = aDir.getAbsolutePath();
        }
        try {
            java.io.File destinationDir = inUse ? ArchiveUtil.createTempDirectory(aUri, aDir.getCanonicalFile().getParentFile()) : aDir;
            SaveStrategy aSaveStrategy = this.createSaveStrategyForDirectory(destinationDir, expansionFlags);
            this.save(aSaveStrategy);
            aSaveStrategy.close();
            this.close();
            if (inUse) {
                this.cleanupAfterTempSave(aUri, aDir, destinationDir);
            }
        }
        catch (IOException ex) {
            throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.error_saving_EXC_, new Object[]{originalPath}), ex);
        }
    }

    public void extractTo(String aUri, int expansionFlags) throws SaveFailureException {
        String originalPath;
        String methodName = "extractTo";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", aUri);
        java.io.File aDir = new java.io.File(aUri);
        if (this.getLoadStrategy().isUsing(aDir)) {
            throw new SaveFailureException(CommonArchiveResourceHandler.Extract_destination_is_the_EXC_);
        }
        try {
            originalPath = aDir.getCanonicalPath();
        }
        catch (IOException ioe) {
            originalPath = aDir.getAbsolutePath();
        }
        try {
            SaveStrategy aSaveStrategy = this.createSaveStrategyForDirectory(aDir, expansionFlags);
            this.save(aSaveStrategy);
            aSaveStrategy.close();
        }
        catch (IOException ex) {
            logger.logp(Level.FINER, className, methodName, "RETURN Throwing SaveFailureException");
            throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.error_saving_EXC_, new Object[]{originalPath}), ex);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public List filterFilesByPrefix(String prefix) {
        return this.filterFiles(prefix, null);
    }

    public List filterFiles(String prefix, String[] suffixes) {
        ArrayList<File> subset = new ArrayList<File>();
        EList theFiles = this.getFiles();
        int i = 0;
        while (i < theFiles.size()) {
            File aFile = (File)theFiles.get(i);
            if (!aFile.isDirectoryEntry() && aFile.getURI().startsWith(prefix) && (suffixes == null || this.hasSuffix(aFile.getURI(), suffixes))) {
                subset.add(aFile);
            }
            ++i;
        }
        return subset;
    }

    private boolean hasSuffix(String aUri, String[] suffixes) {
        int i = 0;
        while (i < suffixes.length) {
            if (aUri.endsWith(suffixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List filterFilesWithoutPrefix(String[] prefixes) {
        ArrayList<File> subset = new ArrayList<File>();
        EList theFiles = this.getFiles();
        int i = 0;
        while (i < theFiles.size()) {
            File aFile = (File)theFiles.get(i);
            if (!aFile.isDirectoryEntry()) {
                boolean shouldAdd = true;
                int j = 0;
                while (j < prefixes.length) {
                    if (aFile.getURI().startsWith(prefixes[j])) {
                        shouldAdd = false;
                        break;
                    }
                    ++j;
                }
                if (shouldAdd) {
                    subset.add(aFile);
                }
            }
            ++i;
        }
        return subset;
    }

    public ClassLoader getArchiveClassLoader() {
        String methodName = "getArchiveClassLoader";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        if (this.archiveClassLoader == null) {
            this.initializeClassLoader();
        }
        logger.logp(Level.FINER, className, methodName, "RETURN archiveClassLoader = [ {0} ]", this.archiveClassLoader);
        return this.archiveClassLoader;
    }

    public List getArchiveFiles() {
        ArrayList<File> archives = new ArrayList<File>();
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File aFile = (File)fileList.get(i);
            if (aFile.isArchive()) {
                archives.add(aFile);
            }
            ++i;
        }
        return archives;
    }

    protected ClassLoader getClassPathClassLoader(ClassLoader parentCl) {
        String extraCp;
        String methodName = "getClassPathClassLoader";
        logger.logp(Level.FINER, className, methodName, "ENTRY parent classloader = [ {0} ]", parentCl);
        ArrayList<String> classPathComponents = new ArrayList<String>();
        if (this.getManifest() != null) {
            logger.logp(Level.FINER, className, methodName, "manifest not null, adding its classpath");
            classPathComponents.addAll(Arrays.asList(this.getManifest().getClassPathTokenized()));
        }
        if ((extraCp = this.getExtraClasspath()) != null) {
            logger.logp(Level.FINER, className, methodName, "extra classpath not null, adding its classpath");
            classPathComponents.addAll(Arrays.asList(ArchiveUtil.getTokens(extraCp, ";")));
        }
        URL[] urlArray = ArchiveUtil.toLocalURLs(classPathComponents, this.getRootForRelativeDependentJars());
        URLClassLoader cl = new URLClassLoader(urlArray, parentCl);
        logger.logp(Level.FINER, className, methodName, "RETURN classloader = [ {0} ]", cl);
        return cl;
    }

    public ResourceSet getResourceSet() {
        return this.getLoadStrategy().getResourceSet();
    }

    public ClassLoader getParentClassLoader() {
        return this.options != null ? this.options.getParentClassLoader() : null;
    }

    public ClassLoader setParentClassLoader(ClassLoader parentClassLoader) {
        String methodName = "setParentClassLoader";
        logger.logp(Level.FINER, className, methodName, "Setting parent classloader on [ {0} ] : [ {1} ]", new Object[]{this.getURI(), parentClassLoader});
        if (this.archiveClassLoader != null) {
            StringBuffer stringBuffer = new StringBuffer("setParentClassLoader attempted on archive [ ");
            stringBuffer.append(this.getURI());
            stringBuffer.append(" ]");
            stringBuffer.append(" after the archive classloader was constructed");
            IllegalArgumentException e = new IllegalArgumentException(stringBuffer.toString());
            logger.throwing(className, methodName, e);
            throw e;
        }
        ArchiveOptions useOptions = this.getOptions();
        ClassLoader priorParentClassLoader = useOptions.getParentClassLoader();
        useOptions.setParentClassLoader(parentClassLoader);
        this.setChildParentClassLoader(parentClassLoader);
        logger.logp(Level.FINER, className, methodName, "Prior classloader [ {0} ]", priorParentClassLoader);
        return priorParentClassLoader;
    }

    protected void setChildParentClassLoader(ClassLoader parentClassLoader) {
        Iterator useFiles = this.getFiles().iterator();
        while (useFiles.hasNext()) {
            File nextFile = (File)useFiles.next();
            if (!nextFile.isArchive()) continue;
            ClassLoader classLoader = ((ArchiveImpl)nextFile).setParentClassLoader(parentClassLoader);
        }
    }

    protected ClassLoader getDefaultClassLoader() {
        String methodName = "getDefaultClassLoader";
        logger.logp(Level.FINER, className, methodName, "ENTRY for [ {0} ]", this.getURI());
        ClassLoader parentClassLoader = this.getOptions().getParentClassLoader();
        if (parentClassLoader != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN with options classloader [ {0} ]", parentClassLoader);
            return parentClassLoader;
        }
        parentClassLoader = this.getClass().getClassLoader();
        if (parentClassLoader != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN with class classloader [ {0} ]", parentClassLoader);
            return parentClassLoader;
        }
        parentClassLoader = ClassLoader.getSystemClassLoader();
        logger.logp(Level.FINER, className, methodName, "RETURN with system classloader [ {0} ]", parentClassLoader);
        return parentClassLoader;
    }

    public Set getDependentOpenArchives() {
        return this.getCommonArchiveFactory().getOpenArchivesDependingOn(this);
    }

    protected List getEntriesAsAbsolutePaths(String[] entries, String parentPath) {
        ArrayList<String> aList = new ArrayList<String>(entries.length);
        int i = 0;
        while (i < entries.length) {
            block6: {
                java.io.File aFile;
                String entry = entries[i];
                Archive dependentJar = this.resolveClasspathEntryInEAR(entry);
                if (dependentJar != null) {
                    try {
                        aList.add(dependentJar.getAbsolutePath());
                        break block6;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                if ((aFile = new java.io.File(entry)).isAbsolute()) {
                    aList.add(aFile.getAbsolutePath());
                } else {
                    aList.add(ArchiveUtil.getOSUri(parentPath, entry));
                }
            }
            ++i;
        }
        return aList;
    }

    public String getExtraClasspath() {
        return this.extraClasspath;
    }

    public FileIterator getFilesForSave() throws IOException {
        return this.getLoadStrategy().getFileIterator();
    }

    public InputStream getInputStream() throws FileNotFoundException, IOException {
        if (this.getLoadingContainer() != null || this.getLoadStrategy() == null || this.getLoadStrategy().isDirectory()) {
            return super.getInputStream();
        }
        if (this.isModuleFile() || !this.getOptions().isSaveLibrariesAsFiles()) {
            throw new IOException("Undefined state of nested archive");
        }
        EList list = this.getFiles();
        String absolutePath = null;
        int i = 0;
        while (i < list.size()) {
            File aFile = (File)list.get(i);
            if (!aFile.isArchive()) {
                absolutePath = aFile.getLoadingContainer().getAbsolutePath();
            }
            ++i;
        }
        return new FileInputStream(absolutePath);
    }

    public InputStream getResourceInputStream(String aUri) throws IOException {
        return this.getLoadStrategy().getResourceInputStream(aUri);
    }

    protected JavaJDKAdapterFactory getJavaAdapterFactory() {
        String methodName = "getJavaAdapterFactory";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        JavaJDKAdapterFactory adapterFactory = null;
        LoadStrategy ls = this.getLoadStrategy();
        if (ls == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN null.  LoadStrategy not found");
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "LoadStrategy found [ {0} ]", ls);
        ResourceSet rs = ls.getResourceSet();
        if (rs == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN null.  ResourceSet not found");
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "ResourceSet found [ {0} ]", rs);
        EList factories = rs.getAdapterFactories();
        logger.logp(Level.FINER, className, methodName, "AdapterFactories found [ {0} ]", factories);
        adapterFactory = (JavaJDKAdapterFactory)EcoreUtil.getAdapterFactory((List)factories, (Object)"JavaReflection");
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", (Object)adapterFactory);
        return adapterFactory;
    }

    public Collection getLoadedMofResources() {
        return this.getLoadStrategy().getLoadedMofResources();
    }

    /*
     * Exception decompiling
     */
    public ArchiveManifest getManifest() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 10[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Resource getMofResource(String aUri) throws FileNotFoundException, ResourceLoadException {
        return this.getLoadStrategy().getMofResource(aUri);
    }

    protected Resource getMofResourceMakeIfNecessary(String aUri) {
        if (this.getLoadStrategy() == null) {
            return null;
        }
        Resource resource = null;
        try {
            resource = this.getMofResource(aUri);
        }
        catch (FileNotFoundException ex) {
            try {
                resource = this.makeMofResource(aUri);
            }
            catch (DuplicateObjectException duplicateObjectException) {
                // empty catch block
            }
        }
        return resource;
    }

    public ArchiveOptions getOptions() {
        if (this.options == null) {
            this.options = new ArchiveOptions();
        }
        return this.options;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.options == null ? null : this.options.getProtectionDomain();
    }

    public ProtectionDomain setProtectionDomain(ProtectionDomain protectionDomain) {
        ArchiveOptions useOptions = this.getOptions();
        ProtectionDomain priorProtectionDomain = useOptions.getProtectionDomain();
        useOptions.setProtectionDomain(protectionDomain);
        this.setChildProtectionDomains(protectionDomain);
        this.setClassLoaderProtectionDomain(protectionDomain);
        return priorProtectionDomain;
    }

    protected void setChildProtectionDomains(ProtectionDomain protectionDomain) {
        String methodName = "setChildProtectionDomains";
        logger.logp(Level.FINER, className, methodName, "ENTRY protectionDomain [ {0} ]", protectionDomain);
        Iterator useFiles = this.getFiles().iterator();
        while (useFiles.hasNext()) {
            File nextFile = (File)useFiles.next();
            logger.logp(Level.FINER, className, methodName, "archive file [ {0} ]", nextFile.getURI());
            if (!nextFile.isArchive()) continue;
            ProtectionDomain childProtectionDomain = ((ArchiveImpl)nextFile).setProtectionDomain(protectionDomain);
            logger.logp(Level.FINER, className, methodName, "Set child protectionDomain [ {0} ]", childProtectionDomain);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected void setClassLoaderProtectionDomain(ProtectionDomain protectionDomain) {
        if (this.archiveClassLoader != null && this.archiveClassLoader instanceof ArchiveFileDynamicClassLoader) {
            ArchiveFileDynamicClassLoader useClassLoader = (ArchiveFileDynamicClassLoader)this.archiveClassLoader;
            useClassLoader.setProtectionDomain(protectionDomain);
        }
    }

    public String getRootForRelativeDependentJars() {
        String methodName = "getRootForRelativeDependentJars";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        String path = null;
        Container theContainer = this;
        while (theContainer != null && path == null) {
            logger.logp(Level.FINER, className, methodName, "Get absolute path of container [ {0} ]", theContainer);
            try {
                path = theContainer.getAbsolutePath();
            }
            catch (FileNotFoundException ex) {
                logger.logp(Level.FINER, className, methodName, "Ignoring FileNotFoundException while resolving absolute path");
            }
            theContainer = theContainer.getLoadingContainer();
        }
        logger.logp(Level.FINER, className, methodName, "Path [ {0} ]", path);
        if (path == null) {
            logger.logp(Level.FINER, className, methodName, "No path found, look in system property user.dir");
            path = System.getProperty("user.dir");
            if (path == null) {
                logger.logp(Level.FINER, className, methodName, "No path found, returning null");
                return "";
            }
            String root = new java.io.File(path).getAbsolutePath();
            logger.logp(Level.FINER, className, methodName, "RETURN absolute path specified by system property [ {0} ]", root);
            return root;
        }
        String root = new java.io.File(path).getParentFile().getAbsolutePath();
        logger.logp(Level.FINER, className, methodName, "RETURN absolute path of parent file [ {0} ]", root);
        return root;
    }

    public String[] getRuntimeClassPath() {
        String methodName = "getRuntimeClassPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        String absolutePath = this.internalGetBinariesPath();
        if (absolutePath == null) {
            return new String[0];
        }
        ArrayList<String> entries = new ArrayList<String>();
        entries.add(absolutePath);
        String parentPath = this.getParentPath(absolutePath);
        String[] mfEntries = this.getManifest().getClassPathTokenized();
        entries.addAll(this.getEntriesAsAbsolutePaths(mfEntries, parentPath));
        if (logger.isLoggable(Level.FINER)) {
            String msg = "RETURN " + entries.size() + " elements";
            Iterator aIterator = entries.iterator();
            while (aIterator.hasNext()) {
                String pathElement = (String)aIterator.next();
                msg = String.valueOf(msg) + "\n  " + pathElement;
            }
            logger.logp(Level.FINER, className, methodName, msg);
        }
        return entries.toArray(new String[entries.size()]);
    }

    public SaveFilter getSaveFilter() {
        return this.saveFilter;
    }

    public SaveStrategy getSaveStrategy() {
        return this.saveStrategy;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public void initializeAfterOpen() {
    }

    public void initializeClassLoader() {
        String methodName = "initializeClassLoader";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        if (!this.shouldUseJavaReflection()) {
            logger.logp(Level.FINER, className, methodName, "RETURN - no reflection, so class loader not necessary");
            return;
        }
        ClassLoader extraCl = null;
        ClassLoader defaultCl = this.getDefaultClassLoader();
        if (this.getContainer() == null || !this.getContainer().isEARFile()) {
            extraCl = this.getClassPathClassLoader(defaultCl);
        }
        ClassLoader cl = this.createDynamicClassLoader(defaultCl, extraCl);
        this.setArchiveClassLoader(cl);
        JavaJDKAdapterFactory factory = this.getJavaAdapterFactory();
        if (factory != null) {
            factory.flushAll();
        } else {
            logger.logp(Level.FINER, className, methodName, "Java Adapter Factory was null");
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public ClassLoader createDynamicClassLoader(ClassLoader parentCl, ClassLoader extraCl) {
        return new ArchiveFileDynamicClassLoader(this, parentCl, extraCl, this.getProtectionDomain());
    }

    public boolean isArchive() {
        return true;
    }

    public boolean isDuplicate(String aUri) {
        return this.containsFile(aUri) || this.isMofResourceLoaded(aUri) || "META-INF/MANIFEST.MF".equals(aUri);
    }

    public boolean isManifestSet() {
        return this.manifest != null;
    }

    public boolean isMofResourceLoaded(String aUri) {
        return this.getLoadStrategy().isMofResourceLoaded(aUri);
    }

    public boolean isNestedArchive(String aUri) {
        if (this.getLoadStrategy().isDirectory()) {
            try {
                String path = ArchiveUtil.getOSUri(this.getAbsolutePath(), aUri);
                java.io.File ioFile = new java.io.File(path);
                if (!ioFile.exists() || ioFile.isDirectory() && aUri.startsWith("ALT-INF")) {
                    return false;
                }
            }
            catch (IOException ex) {
                return false;
            }
        }
        return ArchiveTypeDiscriminatorRegistry.INSTANCE.isKnownArchiveType(aUri);
    }

    public boolean isOpen() {
        return this.getLoadStrategy() != null && this.getLoadStrategy().isOpen();
    }

    public ArchiveManifest makeManifest() {
        ArchiveManifestImpl mf = new ArchiveManifestImpl();
        this.setManifest(mf);
        return mf;
    }

    public ArchiveManifest makeManifest(InputStream in) throws IOException {
        ArchiveManifestImpl mf = new ArchiveManifestImpl(in);
        this.setManifest(mf);
        return mf;
    }

    public Resource makeMofResource(String aUri) throws DuplicateObjectException {
        return this.makeMofResource(aUri, null);
    }

    public Resource makeMofResource(String aUri, EList extent) throws DuplicateObjectException {
        if (this.isDuplicate(aUri)) {
            throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.duplicate_entry_EXC_, new Object[]{aUri, this.getURI()}));
        }
        return this.getLoadStrategy().makeMofResource(aUri, extent);
    }

    public Archive openNestedArchive(String aUri) throws OpenFailureException {
        String methodName = "openNestedArchive - URI";
        logger.logp(Level.FINER, className, methodName, "ENTRY - URI [ {0} ]", aUri);
        Archive a = this.getCommonArchiveFactory().openNestedArchive(aUri, (Archive)this);
        logger.logp(Level.FINER, className, methodName, "RETURN Factory opened archive [ {0} ]", a);
        return a;
    }

    public Archive openNestedArchive(LooseArchive loose) throws OpenFailureException {
        String methodName = "openNestedArchive - loose";
        String looseArchiveURI = loose.getUri();
        logger.logp(Level.FINER, className, methodName, "ENTRY - loose archive URI [ {0} ]", looseArchiveURI);
        Archive a = this.getCommonArchiveFactory().openNestedArchive(loose, (Archive)this);
        logger.logp(Level.FINER, className, methodName, "RETURN Factory opened archive [ {0} ]", a);
        return a;
    }

    public void primSetExtraClasspath(String newExtraClasspath) {
        this.extraClasspath = newExtraClasspath;
    }

    public void releaseClassLoader() {
        if (this.archiveClassLoader != null) {
            this.setArchiveClassLoader(null);
            JavaJDKAdapterFactory factory = this.getJavaAdapterFactory();
            if (factory != null) {
                this.getJavaAdapterFactory().setContextClassLoader(null);
            }
        }
    }

    public void remove(File aFile) {
        this.getFiles().remove((Object)aFile);
    }

    public void reopen() throws ReopenException {
        this.reopen(null);
    }

    public void reopen(Archive parent) throws ReopenException {
        LoadStrategy aLoadStrategy = null;
        try {
            aLoadStrategy = this.createLoadStrategyForReopen(parent);
        }
        catch (IOException ex) {
            throw new ReopenException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_reopen_EXC_, new Object[]{this.getURI()}), ex);
        }
        LoadStrategy current = this.getLoadStrategy();
        if (current != null) {
            aLoadStrategy.setResourceSet(current.primGetResourceSet());
            current.setResourceSet(null);
        }
        this.setLoadStrategy(aLoadStrategy);
        this.initializeClassLoader();
        if (!this.isIndexed()) {
            return;
        }
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File f = (File)fileList.get(i);
            f.setOriginalURI(f.getURI());
            f.setLoadingContainer(this);
            if (f.isArchive()) {
                ((Archive)f).reopen(this);
            }
            ++i;
        }
        this.getCommonArchiveFactory().archiveOpened(this);
    }

    protected void replaceRoot(Resource aResource, EObject root) {
        if (aResource == null) {
            return;
        }
        EList extent = aResource.getContents();
        EObject existingRoot = null;
        if (!extent.isEmpty()) {
            existingRoot = (EObject)extent.get(0);
            if (existingRoot == root) {
                return;
            }
            extent.remove(0);
        }
        if (root != null) {
            extent.add(0, (Object)root);
        }
    }

    protected Archive resolveClasspathEntryInEAR(String entry) {
        Container parent = this.getContainer();
        if (parent == null || !parent.isEARFile()) {
            return null;
        }
        String aUri = ArchiveUtil.deriveEARRelativeURI(entry, this);
        if (aUri == null) {
            return null;
        }
        File aFile = null;
        try {
            aFile = parent.getFile(aUri);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        return aFile.isArchive() ? (Archive)aFile : null;
    }

    public void save() throws SaveFailureException, ReopenException {
        this.saveAs(this.getURI());
    }

    public void save(SaveStrategy aStrategy) throws SaveFailureException {
        String methodName = "save";
        logger.logp(Level.FINER, className, methodName, "ENTRY SaveStrategy = [ {0} ]", aStrategy);
        this.setSaveStrategy(aStrategy);
        SaveFilter existingFilter = aStrategy.getFilter();
        boolean oldDelivery = this.eDeliver();
        boolean isReadOnly = this.getOptions().isReadOnly();
        if (isReadOnly) {
            logger.logp(Level.FINER, className, methodName, "isReadOnly [ {0} ]", Boolean.toString(isReadOnly));
            this.eSetDeliver(false);
        }
        aStrategy.setFilter(this.getSaveFilter());
        try {
            aStrategy.save();
            try {
                aStrategy.finish();
            }
            catch (IOException iox) {
                logger.logp(Level.FINER, className, methodName, "RETURN Throwing SaveFailureException [ {0} ]", this.getURI());
                throw new SaveFailureException(this.getURI(), iox);
            }
        }
        finally {
            if (isReadOnly && !this.getLoadStrategy().isDirectory()) {
                logger.logp(Level.FINER, className, methodName, "Clear file index");
                this.files.clear();
                this.eSetDeliver(oldDelivery);
                this.eAdapters().remove((Object)this.getFileIndexAdapter());
                this.fileIndexAdapter = null;
                this.fileIndex = null;
            }
            this.setSaveStrategy(null);
            aStrategy.setFilter(existingFilter);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void saveAs(String aUri) throws SaveFailureException, ReopenException {
        this.saveAsNoReopen(aUri);
        this.reopen();
    }

    protected boolean canRename(java.io.File orig) {
        String methodName = "canRename";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", orig);
        boolean canRename = false;
        java.io.File origCopy1 = null;
        java.io.File origCopy2 = null;
        try {
            origCopy1 = orig.getCanonicalFile();
            origCopy2 = orig.getCanonicalFile();
        }
        catch (IOException ex) {
            logger.logp(Level.FINEST, className, methodName, ex.getMessage());
            logger.logp(Level.FINER, className, methodName, "Ignoring IOException - Could not get canonicalFile for [ {0} ]", orig);
            return false;
        }
        String name = null;
        String baseName = "save.tmp";
        String parent = orig.getParent();
        if (parent != null) {
            try {
                baseName = new java.io.File(parent, baseName).getCanonicalPath();
            }
            catch (IOException ex) {
                logger.logp(Level.FINEST, className, methodName, ex.getMessage());
                logger.logp(Level.FINER, className, methodName, "Ignoring IOException - Could not get canonical path for parent [ {0} ]", parent);
                return false;
            }
        }
        java.io.File temp = null;
        int index = 0;
        do {
            name = String.valueOf(baseName) + index;
            temp = new java.io.File(name);
            ++index;
        } while (temp.exists());
        if (this.renameToWithRetry(origCopy1, temp) && this.renameToWithRetry(temp, origCopy2)) {
            canRename = true;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN[ {0} ]", Boolean.toString(canRename));
        return canRename;
    }

    protected void checkWriteable(java.io.File dest) throws SaveFailureException {
        String originalPath;
        List locked = ArchiveUtil.getWriteProtectedFiles(dest, null);
        if (locked.isEmpty()) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Cannot write to file: ");
        try {
            originalPath = dest.getCanonicalPath();
        }
        catch (IOException ioe) {
            originalPath = dest.getAbsolutePath();
        }
        msg.append(originalPath);
        msg.append('\n');
        msg.append("One or more files is write protected or locked:");
        msg.append('\n');
        int i = 0;
        while (i < locked.size()) {
            java.io.File aFile = (java.io.File)locked.get(i);
            msg.append(aFile.getAbsolutePath());
            msg.append('\n');
            ++i;
        }
        throw new SaveFailureException(msg.toString());
    }

    public void saveAsNoReopen(String aUri) throws SaveFailureException {
        java.io.File aFile = new java.io.File(aUri);
        this.checkWriteable(aFile);
        boolean fileExisted = aFile.exists();
        SaveStrategy aSaveStrategy = null;
        String destinationPath = aUri;
        try {
            try {
                java.io.File destinationFile = fileExisted ? ArchiveUtil.createTempFile(aUri, aFile.getCanonicalFile().getParentFile()) : aFile;
                aSaveStrategy = this.createSaveStrategyForJar(destinationFile);
                try {
                    destinationPath = destinationFile.getCanonicalPath();
                }
                catch (IOException ioe) {
                    destinationPath = destinationFile.getAbsolutePath();
                }
                this.save(aSaveStrategy);
                aSaveStrategy.close();
                this.close();
                if (fileExisted) {
                    this.cleanupAfterTempSave(aUri, aFile, destinationFile);
                }
            }
            catch (IOException ex) {
                throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.error_saving_EXC_, new Object[]{destinationPath}), ex);
            }
        }
        catch (SaveFailureException failure) {
            try {
                if (aSaveStrategy != null) {
                    aSaveStrategy.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!fileExisted) {
                aFile.delete();
            }
            throw failure;
        }
        this.setURI(aUri);
    }

    public void saveNoReopen() throws SaveFailureException {
        this.saveAsNoReopen(this.getURI());
    }

    public void setArchiveClassLoader(ClassLoader newArchiveClassLoader) {
        this.archiveClassLoader = newArchiveClassLoader;
    }

    public void setExtraClasspath(String newExtraClasspath) {
        this.primSetExtraClasspath(newExtraClasspath);
        if (this.archiveClassLoader != null) {
            this.initializeClassLoader();
        }
    }

    public void setManifest(ArchiveManifest newManifest) {
        this.manifest = newManifest;
    }

    public void setManifest(Manifest aManifest) {
        this.setManifest(new ArchiveManifestImpl(aManifest));
    }

    public void setManifestClassPathAndRefresh(String classpath) {
        ArchiveManifest mf = this.getManifest();
        if (this.manifest == null) {
            this.makeManifest();
        }
        mf.setClassPath(classpath);
        if (this.archiveClassLoader != null) {
            this.initializeClassLoader();
        }
    }

    public void setOptions(ArchiveOptions newOptions) {
        this.options = newOptions;
    }

    public void setSaveFilter(SaveFilter newSaveFilter) {
        this.saveFilter = newSaveFilter;
    }

    public void setSaveStrategy(SaveStrategy newSaveStrategy) {
        this.saveStrategy = newSaveStrategy;
        if (newSaveStrategy != null) {
            newSaveStrategy.setArchive(this);
        }
    }

    public void setXmlEncoding(String newXmlEncoding) {
        this.xmlEncoding = newXmlEncoding;
    }

    public boolean shouldUseJavaReflection() {
        return this.getOptions().useJavaReflection() && this.getLoadStrategy().isClassLoaderNeeded();
    }

    protected void throwResourceLoadException(String resourceUri, Exception ex) throws ResourceLoadException {
        throw new ResourceLoadException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.load_resource_EXC_, new Object[]{resourceUri, this.getURI()}), ex);
    }

    public String getResourcesPath() throws FileNotFoundException {
        return this.getLoadStrategy().getResourcesPath();
    }

    public String getBinariesPath() throws FileNotFoundException {
        String altBinariesPath;
        String methodName = "getBinariesPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", this.uri);
        String path = this.getLoadStrategy().getBinariesPath();
        ArchiveOptions ao = this.getOptions();
        if (ao.isSetAltBinariesPath() && (altBinariesPath = ao.getAltBinariesPath()) != null) {
            logger.logp(Level.FINER, className, methodName, "Replacing binariesPath [ {0} ] with altBinariesPath in archiveOptions", path);
            path = altBinariesPath;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", path);
        return path;
    }

    protected RuntimeClasspathEntry[] emptyClasspath() {
        return new RuntimeClasspathEntry[0];
    }

    protected String internalGetBinariesPath() {
        try {
            return this.getBinariesPath();
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    public RuntimeClasspathEntry[] getLocalRuntimeClassPath() {
        String methodName = "getLocalRuntimeClassPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        String absolutePath = this.internalGetBinariesPath();
        logger.logp(Level.FINER, className, methodName, "internalGetBinariesPath = [ {0} ]", absolutePath);
        if (absolutePath == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN empty classpath");
            return this.emptyClasspath();
        }
        RuntimeClasspathEntry[] rceArray = new RuntimeClasspathEntry[]{this.createRuntimeClasspathEntry(absolutePath)};
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] elements", Integer.toString(rceArray.length));
        return rceArray;
    }

    protected String getParentPath(String absolutePath) {
        String methodName = "getParentPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY absolutePath = [ {0} ]", absolutePath);
        Container parentArchive = this.getContainer();
        if (this.getLoadStrategy().getLooseArchive() != null && parentArchive != null && parentArchive.isEARFile()) {
            try {
                logger.logp(Level.FINER, className, methodName, "Non-assigned loose archive with EAR parent");
                String earPath = this.getEARFile().getBinariesPath();
                logger.logp(Level.FINER, className, methodName, "EAR file binaries path [ {0} ]", earPath);
                java.io.File virtualChildFile = new java.io.File(earPath, this.getURI());
                String parentPath = virtualChildFile.getParentFile().getAbsolutePath();
                logger.logp(Level.FINER, className, methodName, "RETURN Virtual parent path [ {0} ]", parentPath);
                return parentPath;
            }
            catch (Throwable e) {
                logger.logp(Level.FINER, className, methodName, "Ignoring Exception while calculating parent path");
            }
        }
        java.io.File parentFile = new java.io.File(absolutePath).getParentFile();
        logger.logp(Level.FINER, className, methodName, "Using absolute path of parent file named [ {0} ]", parentFile.getName());
        String parentPath = parentFile.getAbsolutePath();
        logger.logp(Level.FINER, className, methodName, "RETURN absolute parent path [ {0} ]", parentPath);
        return parentPath;
    }

    protected RuntimeClasspathEntry[] getDependencyClassPathAtThisLevel() {
        String methodName = "getDependencyClassPathAtThisLevel";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        String absolutePath = this.internalGetBinariesPath();
        if (absolutePath == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN empty classpath because binaries path not found");
            return this.emptyClasspath();
        }
        String[] mfEntries = this.getManifest().getClassPathTokenized();
        if (mfEntries.length == 0) {
            logger.logp(Level.FINER, className, methodName, "RETURN empty classpath because manifest entries not found");
            return this.emptyClasspath();
        }
        String parentPath = this.getParentPath(absolutePath);
        ArrayList entries = new ArrayList();
        entries.addAll(this.createRuntimeClasspathEntries(mfEntries, parentPath));
        if (logger.isLoggable(Level.FINER)) {
            String msg = "RETURN classpath with " + entries.size() + " elements";
            Iterator aIterator = entries.iterator();
            while (aIterator.hasNext()) {
                RuntimeClasspathEntryImpl pathElement = (RuntimeClasspathEntryImpl)aIterator.next();
                msg = String.valueOf(msg) + "\n  " + pathElement;
            }
            logger.logp(Level.FINER, className, methodName, msg);
        }
        return entries.toArray(new RuntimeClasspathEntry[entries.size()]);
    }

    public RuntimeClasspathEntry[] getFullRuntimeClassPath() {
        String methodName = "getFullRuntimeClassPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        RuntimeClasspathEntry[] rceArray = this.concat(this.getLocalRuntimeClassPath(), this.getDependencyClassPath());
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] elements", Integer.toString(rceArray.length));
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "Classpath :";
            int i = 0;
            while (i < rceArray.length) {
                RuntimeClasspathEntry pathElement = rceArray[i];
                msg = String.valueOf(msg) + "\n  " + pathElement;
                ++i;
            }
            logger.logp(Level.FINER, className, methodName, msg);
        }
        return rceArray;
    }

    protected RuntimeClasspathEntry[] concat(RuntimeClasspathEntry[] array1, RuntimeClasspathEntry[] array2) {
        ArrayList<RuntimeClasspathEntry> temp = new ArrayList<RuntimeClasspathEntry>();
        temp.addAll(Arrays.asList(array1));
        temp.addAll(Arrays.asList(array2));
        return temp.toArray(new RuntimeClasspathEntry[temp.size()]);
    }

    public RuntimeClasspathEntry[] getDependencyClassPath() {
        ArrayList entries = new ArrayList();
        HashSet<ArchiveImpl> visited = new HashSet<ArchiveImpl>();
        HashSet processedEntries = new HashSet();
        visited.add(this);
        this.getDependencyClassPath(visited, entries, processedEntries, this);
        return entries.toArray(new RuntimeClasspathEntry[entries.size()]);
    }

    protected void getDependencyClassPath(Set visitedArchives, List entries, Set processedEntries, Archive current) {
        String methodName = "getDependencyClassPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY current archive [ {0} ]", current.getURI());
        RuntimeClasspathEntry[] local = ((ArchiveImpl)current).getDependencyClassPathAtThisLevel();
        logger.logp(Level.FINER, className, methodName, "current dependency classpath has [ {0} ] elements", Integer.toString(local.length));
        int i = 0;
        while (i < local.length) {
            RuntimeClasspathEntry entry = local[i];
            logger.logp(Level.FINER, className, methodName, "classpath entry [ {0} ]", entry);
            if (!processedEntries.contains(entry)) {
                logger.logp(Level.FINER, className, methodName, "not processed yet, add to lists");
                entries.add(entry);
                processedEntries.add(entry);
            }
            Archive resolved = entry.getReferencedArchive();
            logger.logp(Level.FINER, className, methodName, "referenced archive [ {0} ]", resolved);
            if (resolved == null) {
                logger.logp(Level.FINER, className, methodName, "archive not found, process manifest");
                ClasspathUtil.processManifest(entry.getAbsolutePath(), entries, processedEntries);
            } else if (!visitedArchives.contains(resolved)) {
                logger.logp(Level.FINER, className, methodName, "not visited yet, get its path");
                visitedArchives.add(resolved);
                this.getDependencyClassPath(visitedArchives, entries, processedEntries, resolved);
            }
            ++i;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN from archive [ {0} ]", current.getURI());
    }

    protected EARFile getEARFile() {
        Container parent = this.getContainer();
        if (parent == null || !(parent instanceof EARFile)) {
            return null;
        }
        return (EARFile)parent;
    }

    protected Archive getResolvedArchive(String mfValue, EARFile ear) {
        String aUri = ArchiveUtil.deriveEARRelativeURI(mfValue, this);
        if (aUri == null) {
            return null;
        }
        try {
            return (Archive)ear.getFile(aUri);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (ClassCastException ex2) {
            return null;
        }
    }

    public boolean hasClasspathVisibilityTo(Archive other) {
        if (other == null) {
            return false;
        }
        EARFile ear = this.getEARFile();
        if (ear == null) {
            return false;
        }
        HashSet visited = new HashSet();
        return this.hasClasspathVisibilityTo(other, visited, ear);
    }

    public boolean hasClasspathVisibilityTo(Archive other, Set visited, EARFile ear) {
        if (this == other) {
            return true;
        }
        if (visited.contains(this)) {
            return false;
        }
        visited.add(this);
        String[] mfEntries = this.getManifest().getClassPathTokenized();
        int i = 0;
        while (i < mfEntries.length) {
            Archive anArchive = this.getResolvedArchive(mfEntries[i], ear);
            if (anArchive != null && anArchive.hasClasspathVisibilityTo(other, visited, ear)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isType(String type) {
        return this.types != null && this.getTypes().contains((Object)type);
    }

    private boolean renameToWithRetry(java.io.File source, java.io.File destination) {
        String methodName = "renameToWithRetry";
        logger.logp(Level.FINER, className, methodName, "ENTRY rename [ {0} ]", source);
        int i = 1;
        while (i < 21) {
            if (source.renameTo(destination)) {
                logger.logp(Level.FINER, className, methodName, "RETURN true");
                return true;
            }
            System.gc();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (i == 1 || i % 10 == 0) {
                logger.logp(Level.FINER, className, methodName, "Garbage collection forced.  Slept {0} times.", Integer.toString(i));
            }
            ++i;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN false");
        if (logger.isLoggable(Level.FINEST)) {
            this.displayFileData(source);
        }
        return false;
    }

    public void displayFileData(java.io.File source) {
        String methodName = "displayFileData";
        this.displayMsg = "\n\nDisplaying data for file [ " + source + " ]";
        boolean isDir = source.isDirectory();
        boolean exists = source.exists();
        this.displayMsg = String.valueOf(this.displayMsg) + "\n   File path [ " + source.getPath() + " ]";
        this.displayMsg = String.valueOf(this.displayMsg) + "\n   File absolute path [ " + source.getAbsolutePath() + " ]";
        try {
            this.displayMsg = String.valueOf(this.displayMsg) + "\n   File canonical file [ " + source.getCanonicalFile() + " ]";
        }
        catch (IOException e) {
            this.displayMsg = String.valueOf(this.displayMsg) + "\n   File canonical file [ unknown ]";
        }
        this.displayMsg = String.valueOf(this.displayMsg) + "\n   File parent file [ " + source.getParentFile() + " ]";
        if (!exists) {
            this.displayMsg = String.valueOf(this.displayMsg) + "\n   ERROR: File does not exist";
        } else {
            this.displayMsg = String.valueOf(this.displayMsg) + "\n   File exists";
            if (isDir) {
                this.displayMsg = String.valueOf(this.displayMsg) + "\n   File is a directory";
                int numScanned = this.scanFilesInDirectory(source);
                this.displayMsg = String.valueOf(this.displayMsg) + "\n   Scanned a total of [ " + numScanned + " ] files";
            } else {
                this.displayMsg = String.valueOf(this.displayMsg) + "\n   File is NOT a directory";
                this.checkFile(source);
            }
        }
        LoadStrategy loadStrategy = this.getLoadStrategy();
        this.displayMsg = String.valueOf(this.displayMsg) + "\n   Load Strategy [ " + loadStrategy + " ]";
        if (loadStrategy instanceof ZipFileLoadStrategyImpl) {
            ZipFileLoadStrategyImpl zipStrategy = (ZipFileLoadStrategyImpl)loadStrategy;
            java.io.File f = zipStrategy.getFile();
            this.displayMsg = String.valueOf(this.displayMsg) + "\n     File [ " + f + " ]";
            if (f != null) {
                this.displayMsg = String.valueOf(this.displayMsg) + "\n     File absolute path [ " + f.getAbsolutePath() + " ]";
                this.displayMsg = String.valueOf(this.displayMsg) + "\n     File exists [ " + f.exists() + " ]";
            }
        }
        logger.logp(Level.FINER, className, methodName, this.displayMsg);
    }

    private int scanFilesInDirectory(java.io.File currentDirectory) {
        this.displayMsg = String.valueOf(this.displayMsg) + "\nScanning directory [ " + currentDirectory + " ]";
        boolean isReadable = currentDirectory.canRead();
        boolean isWritable = currentDirectory.canWrite();
        if (!isReadable || !isWritable) {
            this.displayMsg = String.valueOf(this.displayMsg) + "\n\nERROR: directory name= + " + currentDirectory + "R/W: " + isReadable + "/" + isWritable;
        }
        int numScanned = 1;
        java.io.File[] srcFiles = currentDirectory.listFiles(new NonDirectoryFileFilter());
        int i = 0;
        while (i < srcFiles.length) {
            this.checkFile(srcFiles[i]);
            ++numScanned;
            ++i;
        }
        java.io.File[] subDirs = currentDirectory.listFiles(new DirectoryFileFilter());
        int j = 0;
        while (j < subDirs.length) {
            numScanned += this.scanFilesInDirectory(subDirs[j]);
            ++j;
        }
        return numScanned;
    }

    private void checkFile(java.io.File original) {
        boolean isReadable = original.canRead();
        boolean isWritable = original.canWrite();
        String baseName = "";
        try {
            baseName = original.getCanonicalPath();
            this.displayMsg = String.valueOf(this.displayMsg) + "\nFile's canonical path = [ " + baseName + " ]";
        }
        catch (IOException e) {
            this.displayMsg = String.valueOf(this.displayMsg) + "\n\nERROR: couldn't get canonical path of file " + original;
        }
        if (!isReadable || !isWritable) {
            this.displayMsg = String.valueOf(this.displayMsg) + "\n\nERROR: file name= + " + baseName + "R/W: " + isReadable + "/" + isWritable;
            return;
        }
        String modifiedName = String.valueOf(baseName) + ".tmp";
        java.io.File newFile = new java.io.File(modifiedName);
        boolean renamed = original.renameTo(newFile);
        if (!renamed) {
            this.displayMsg = String.valueOf(this.displayMsg) + "\n\nERROR: Could not rename original file " + baseName;
        } else {
            this.displayMsg = String.valueOf(this.displayMsg) + "\nSuccessfully renamed  original file " + baseName;
            renamed = newFile.renameTo(original);
            this.displayMsg = String.valueOf(this.displayMsg) + "\nSuccessfully renamed temporary file " + modifiedName;
            if (!renamed) {
                this.displayMsg = String.valueOf(this.displayMsg) + "\n\nERROR: Could not rename temporary file " + modifiedName;
            }
        }
    }

    class DirectoryFileFilter
    implements FileFilter {
        DirectoryFileFilter() {
        }

        public boolean accept(java.io.File file) {
            return file.isDirectory();
        }
    }

    class NonDirectoryFileFilter
    implements FileFilter {
        NonDirectoryFileFilter() {
        }

        public boolean accept(java.io.File file) {
            return !file.isDirectory();
        }
    }
}

