/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.application.ConnectorModule;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.JavaClientModule;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.client.internal.impl.ApplicationClientResourceFactory;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.EmptyResourceException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ObjectNotFoundException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.internal.impl.EJBJarResourceFactory;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.internal.impl.ConnectorResourceFactory;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.internal.impl.WebAppResourceFactory;
import org.eclipse.wst.common.internal.emf.resource.FileNameResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class EARFileImpl
extends ModuleFileImpl
implements EARFile {
    private static final Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static String className;
    protected Application deploymentDescriptor = null;
    protected EList moduleRefs = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.impl.EARFileImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.getName();
    }

    public ModuleFile getModuleFile(Module moduleDescriptor) {
        String methodName = "getModuleFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", moduleDescriptor);
        ModuleRef ref = this.getModuleRef(moduleDescriptor);
        ModuleFile mf = ref == null ? null : ref.getModuleFile();
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", mf);
        return mf;
    }

    public ModuleFile addCopy(ModuleFile aModuleFile) throws DuplicateObjectException {
        Object result = this.primAddCopyRef(aModuleFile);
        if (result instanceof ModuleRef) {
            return ((ModuleRef)result).getModuleFile();
        }
        return (ModuleFile)result;
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.EAR_FILE;
    }

    public Archive addCopy(Archive anArchive) throws DuplicateObjectException {
        if (anArchive.isModuleFile()) {
            return this.addCopy((ModuleFile)anArchive);
        }
        Archive copy = super.addCopy(anArchive);
        copy.initializeClassLoader();
        return copy;
    }

    protected Object primAddCopyRef(ModuleFile aModuleFile) throws DuplicateObjectException {
        EList refs = this.getModuleRefs();
        if (aModuleFile.isEARFile()) {
            return (ModuleFile)super.addCopy(aModuleFile);
        }
        this.checkAddValid(aModuleFile);
        ModuleFile copy = this.getCommonArchiveFactory().copy(aModuleFile);
        Module newModule = this.createModuleForCopying(aModuleFile);
        this.getFiles().add((Object)copy);
        copy.initializeClassLoader();
        if (!copy.getURI().equals(newModule.getUri())) {
            copy.setURI(newModule.getUri());
        }
        this.getDeploymentDescriptor().getModules().add((Object)newModule);
        ModuleRef aRef = this.createModuleRef(newModule, copy);
        refs.add((Object)aRef);
        return aRef;
    }

    public ModuleRef addCopyRef(ModuleFile aModuleFile) throws DuplicateObjectException {
        Object result = this.primAddCopyRef(aModuleFile);
        if (result instanceof ModuleRef) {
            return (ModuleRef)result;
        }
        return null;
    }

    public SecurityRole addCopy(SecurityRole aRole, Module aModule) throws DuplicateObjectException {
        String methodName = "addCopy";
        String moduleURI = aModule.getUri();
        String roleName = aRole.getRoleName();
        logger.entering(className, methodName, new Object[]{roleName, moduleURI});
        EObject dd = null;
        try {
            dd = this.getDeploymentDescriptor(aModule);
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            logger.exiting(className, methodName, "Throwing DeploymentDescriptorLoadException");
            String ddName = "";
            if (aModule.isWebModule()) {
                ddName = "WEB-INF/web.xml";
            } else if (aModule.isEjbModule()) {
                ddName = "META-INF/ejb-jar.xml";
            }
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{ddName, aModule.getUri(), this.getURI()}), e);
        }
        SecurityRole copy = (SecurityRole)EtoolsCopyUtility.createCopy(aRole);
        if (aModule.isEjbModule()) {
            logger.logp(Level.FINER, className, methodName, "Module found to be an EJB Module");
            EJBJar ejbJar = (EJBJar)dd;
            if (ejbJar.containsSecurityRole(roleName)) {
                logger.exiting(className, methodName, "Throwing DuplicateObjectException");
                throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.dup_sec_role_module_EXC_, new Object[]{aModule.getUri(), roleName}), ejbJar.getAssemblyDescriptor().getSecurityRoleNamed(roleName));
            }
            this.getAssemblyDescriptorAddIfNecessary(ejbJar).getSecurityRoles().add((Object)copy);
        } else if (aModule.isWebModule()) {
            logger.logp(Level.FINER, className, methodName, "Module found to be a Web Module");
            WebApp webApp = (WebApp)dd;
            if (webApp.containsSecurityRole(roleName)) {
                logger.exiting(className, methodName, "Throwing DuplicateObjectException");
                throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.dup_sec_role_module_EXC_, new Object[]{aModule.getUri(), roleName}), webApp.getSecurityRoleNamed(roleName));
            }
            webApp.getSecurityRoles().add((Object)copy);
        }
        this.addCopyIfNotExists(aRole);
        logger.exiting(className, methodName, copy);
        return copy;
    }

    public SecurityRole addCopyIfNotExists(SecurityRole aRole) {
        Application dd = this.getDeploymentDescriptor();
        SecurityRole copy = null;
        if (!dd.containsSecurityRole(aRole.getRoleName())) {
            copy = (SecurityRole)EtoolsCopyUtility.createCopy(aRole);
            dd.getSecurityRoles().add((Object)copy);
        }
        return copy;
    }

    protected void checkDuplicate(String aUri) throws DuplicateObjectException {
        if (this.isDuplicate(aUri)) {
            throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.dup_resource_EXC_, new Object[]{aUri, this.getURI()}));
        }
    }

    protected Module createModuleForCopying(ModuleFile aModuleFile) {
        Module aModule = null;
        if (aModuleFile.isWARFile()) {
            aModule = this.getApplicationFactory().createWebModule();
        } else if (aModuleFile.isEJBJarFile()) {
            aModule = this.getApplicationFactory().createEjbModule();
        } else if (aModuleFile.isApplicationClientFile()) {
            aModule = this.getApplicationFactory().createJavaClientModule();
        } else if (aModuleFile.isRARFile()) {
            aModule = this.getApplicationFactory().createConnectorModule();
        }
        aModule.setUri(aModuleFile.getURI());
        return aModule;
    }

    public EObject getAltDeploymentDescriptor(Module aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        XMLResource ddRes;
        String altDD = aModule.getAltDD();
        if (ArchiveUtil.isNullOrEmpty(altDD)) {
            return null;
        }
        if (!this.isMofResourceLoaded(altDD.trim())) {
            this.registerResourceFactory(aModule, altDD);
        }
        if (!(ddRes = (XMLResource)this.getMofResource(altDD.trim())).isAlt()) {
            ddRes.setIsAlt(true);
            ddRes.setApplication(this.getDeploymentDescriptor());
        }
        return ArchiveUtil.getRoot(ddRes);
    }

    public List getApplicationClientFiles() {
        ArrayList<File> clientFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File aFile = (File)fileList.get(i);
            if (aFile.isApplicationClientFile()) {
                clientFiles.add(aFile);
            }
            ++i;
        }
        return clientFiles;
    }

    protected ApplicationFactory getApplicationFactory() {
        return ((ApplicationPackage)EPackage.Registry.INSTANCE.getEPackage("application.xmi")).getApplicationFactory();
    }

    protected AssemblyDescriptor getAssemblyDescriptorAddIfNecessary(EJBJar ejbJar) {
        String methodName = "getAssemblyDescriptorAddIfNecessary";
        logger.entering(className, methodName, ejbJar);
        AssemblyDescriptor ad = ejbJar.getAssemblyDescriptor();
        if (ad == null) {
            ad = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createAssemblyDescriptor();
            ejbJar.setAssemblyDescriptor(ad);
            logger.logp(Level.FINER, className, methodName, "created Assembly Descriptor");
        } else {
            logger.logp(Level.FINER, className, methodName, "got existing Assembly Descriptor");
        }
        logger.exiting(className, methodName, ad);
        return ad;
    }

    public Application getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        String methodName = "getDeploymentDescriptor";
        logger.entering(className, methodName);
        Application dd = this.getDeploymentDescriptorGen();
        if (dd == null && this.canLazyInitialize()) {
            try {
                logger.logp(Level.FINER, className, methodName, "Must import metadata");
                this.getImportStrategy().importMetaData();
            }
            catch (Exception e) {
                logger.severe(e.getMessage());
                logger.exiting(className, methodName, "Throwing DeploymentDescriptorLoadException");
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), e);
            }
        }
        Application a = this.getDeploymentDescriptorGen();
        logger.exiting(className, methodName, a);
        this.displayDescriptor(a);
        return a;
    }

    public Connector getDeploymentDescriptor(ConnectorModule aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (Connector)this.getDeploymentDescriptor((Module)aModule);
    }

    public EJBJar getDeploymentDescriptor(EjbModule aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (EJBJar)this.getDeploymentDescriptor((Module)aModule);
    }

    public ApplicationClient getDeploymentDescriptor(JavaClientModule aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (ApplicationClient)this.getDeploymentDescriptor((Module)aModule);
    }

    public EObject getDeploymentDescriptor(Module aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        String methodName = "getDeploymentDescriptor - module";
        String moduleURI = aModule.getUri();
        logger.entering(className, methodName, moduleURI);
        EObject dd = this.getAltDeploymentDescriptor(aModule);
        if (dd == null) {
            dd = this.getModuleFile(aModule).getStandardDeploymentDescriptor();
            logger.logp(Level.FINER, className, methodName, "got standard Deployment Descriptor");
        } else {
            logger.logp(Level.FINER, className, methodName, "got alternate Deployment Descriptor");
        }
        logger.exiting(className, methodName, dd);
        return dd;
    }

    public WebApp getDeploymentDescriptor(WebModule aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        String methodName = "getDeploymentDescriptor - webmodule";
        String moduleURI = aModule.getUri();
        logger.entering(className, methodName, moduleURI);
        WebApp wa = (WebApp)this.getDeploymentDescriptor((Module)aModule);
        logger.exiting(className, methodName, wa);
        return wa;
    }

    public String getDeploymentDescriptorUri() {
        return "META-INF/application.xml";
    }

    public List getEJBJarFiles() {
        ArrayList<File> ejbJarFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File aFile = (File)fileList.get(i);
            if (aFile.isEJBJarFile()) {
                ejbJarFiles.add(aFile);
            }
            ++i;
        }
        return ejbJarFiles;
    }

    public EnterpriseBean getEnterpiseBeanFromRef(EjbRef ref) {
        String link = ref.getLink();
        if (link == null) {
            return null;
        }
        List jarFiles = this.getEJBJarFiles();
        int i = 0;
        while (i < jarFiles.size()) {
            EnterpriseBean bean = ((EJBJarFile)jarFiles.get(i)).getDeploymentDescriptor().getEnterpriseBeanNamed(link);
            if (bean != null) {
                return bean;
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnterpriseBean getEnterpiseBeanFromRef(EjbRef ref, String moduleUri) {
        String ejbJarUri;
        String ejbBeanName;
        block9: {
            String link = ref.getLink();
            if (link == null) {
                return null;
            }
            if (link.indexOf(35) == -1) {
                EJBJar jar;
                EnterpriseBean linkedEJB = null;
                XMLResource res = (XMLResource)ref.eResource();
                if (res instanceof EJBResource && (jar = ((EJBResource)res).getEJBJar()) != null) {
                    linkedEJB = jar.getEnterpiseBeanFromRef(ref);
                }
                if (linkedEJB != null) return linkedEJB;
                List jarFiles = this.getEJBJarFiles();
                int i = 0;
                while (i < jarFiles.size()) {
                    linkedEJB = ((EJBJarFile)jarFiles.get(i)).getDeploymentDescriptor().getEnterpriseBeanNamed(link);
                    if (linkedEJB != null) {
                        return linkedEJB;
                    }
                    ++i;
                }
                return null;
            }
            ejbBeanName = link.substring(link.indexOf("#") + 1, link.length());
            String ejbJarName = link.substring(0, link.indexOf("#"));
            if (ejbBeanName == null || ejbJarName == null || (ejbJarUri = ArchiveUtil.deriveEARRelativeURI(ejbJarName, moduleUri)) == null) return null;
            File aFile = this.getFile(ejbJarUri);
            if (aFile != null && aFile.isEJBJarFile()) break block9;
            return null;
        }
        try {
            EJBJarFile jarFile = (EJBJarFile)this.getFile(ejbJarUri);
            EList ejbs = jarFile.getDeploymentDescriptor().getEnterpriseBeans();
            if (ejbs == null || ejbs.isEmpty()) return null;
            Iterator it = ejbs.iterator();
            while (it.hasNext()) {
                EnterpriseBean ejbBean = (EnterpriseBean)it.next();
                if (ejbBean == null || !ejbBean.getName().equals(ejbBeanName)) continue;
                return ejbBean;
            }
            return null;
        }
        catch (FileNotFoundException fe) {
            return null;
        }
    }

    public Module getModule(String aUri, String altDD) {
        return this.getDeploymentDescriptor().getModule(aUri, altDD);
    }

    public ModuleRef getModuleRef(Module moduleDescriptor) {
        String methodName = "getModuleRef";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", moduleDescriptor);
        EList refs = this.getModuleRefs();
        int i = 0;
        while (i < refs.size()) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (ref.getModule() == moduleDescriptor) {
                logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", ref);
                return ref;
            }
            ++i;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN null");
        return null;
    }

    public List getModuleFiles() {
        ArrayList<File> moduleFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File aFile = (File)fileList.get(i);
            if (aFile.isModuleFile()) {
                moduleFiles.add(aFile);
            }
            ++i;
        }
        return moduleFiles;
    }

    protected ArchiveOptions getOptionsForOpening(String aUri) throws IOException {
        LoadStrategy strategy = this.getCommonArchiveFactory().createChildLoadStrategy(aUri, this.getLoadStrategy());
        return this.getOptions().cloneWith(strategy, aUri);
    }

    protected ArchiveOptions getOptionsForOpening(LooseArchive loose) throws IOException, OpenFailureException {
        if (loose.getBinariesPath() == null) {
            throw new OpenFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.open_nested_EXC_, new Object[]{loose.getUri(), this.getURI()}), null);
        }
        LoadStrategy strategy = this.getCommonArchiveFactory().createLoadStrategy(loose.getBinariesPath());
        strategy.setLooseArchive(loose);
        return this.getOptions().cloneWith(strategy, loose.getUri());
    }

    public List getRARFiles() {
        ArrayList<File> rarFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File aFile = (File)fileList.get(i);
            if (aFile.isRARFile()) {
                rarFiles.add(aFile);
            }
            ++i;
        }
        return rarFiles;
    }

    public EList getRolesFromAllModules() {
        BasicEList roleList = new BasicEList();
        EList modules = this.getDeploymentDescriptor().getModules();
        int i = 0;
        int n = modules.size();
        while (i < n) {
            Module aModule = (Module)modules.get(i);
            EList roles = this.getRolesFromModule(aModule);
            int j = 0;
            int m = roles.size();
            while (j < m) {
                roleList.add(roles.get(j));
                ++j;
            }
            ++i;
        }
        return roleList;
    }

    public EList getRolesFromModule(Module aModule) {
        String methodName = "getRolesFromModule";
        String moduleURI = aModule.getUri();
        logger.entering(className, methodName, moduleURI);
        BasicEList roleList = new BasicEList();
        try {
            if (aModule.isWebModule()) {
                logger.logp(Level.FINER, className, methodName, "Module found to be a Web Module");
                roleList = this.getDeploymentDescriptor((WebModule)aModule).getSecurityRoles();
            } else if (aModule.isEjbModule()) {
                logger.logp(Level.FINER, className, methodName, "Module found to be an EJB Module");
                roleList = this.getAssemblyDescriptorAddIfNecessary(this.getDeploymentDescriptor((EjbModule)aModule)).getSecurityRoles();
            }
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            logger.exiting(className, methodName, "Throwing DeploymentDescriptorLoadException");
            String ddName = "";
            if (aModule.isWebModule()) {
                ddName = "WEB-INF/web.xml";
            } else if (aModule.isEjbModule()) {
                ddName = "META-INF/ejb-jar.xml";
            }
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{ddName, aModule.getUri(), this.getURI()}), e);
        }
        logger.exiting(className, methodName, roleList);
        return roleList;
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor();
    }

    public List getWARFiles() {
        ArrayList<File> warFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File aFile = (File)fileList.get(i);
            if (aFile.isWARFile()) {
                warFiles.add(aFile);
            }
            ++i;
        }
        return warFiles;
    }

    public void initializeAfterOpen() {
        super.initializeAfterOpen();
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public boolean isEARFile() {
        return true;
    }

    public boolean isNestedArchive(String aUri) {
        if (super.isNestedArchive(aUri)) {
            return true;
        }
        return this.getDeploymentDescriptor().getFirstModule(aUri) != null;
    }

    public EObject makeDeploymentDescriptor(XMLResource resource) {
        Application appl = ((ApplicationPackage)EPackage.Registry.INSTANCE.getEPackage("application.xmi")).getApplicationFactory().createApplication();
        resource.setID(appl, "Application_ID");
        this.setDeploymentDescriptorGen(appl);
        resource.getContents().add((Object)appl);
        return appl;
    }

    public Archive openNestedArchive(LooseArchive loose) throws OpenFailureException {
        String methodName = "openNestedArchive - loose";
        String looseArchiveURI = loose.getUri();
        logger.logp(Level.FINER, className, methodName, "ENTRY - loose archive URI [ {0} ]", looseArchiveURI);
        Module m = this.getDeploymentDescriptor().getFirstModule(looseArchiveURI);
        logger.logp(Level.FINER, className, methodName, "Got module [ {0} ]", m);
        if (m == null) {
            Archive a = super.openNestedArchive(loose);
            if (a == null) {
                logger.logp(Level.FINER, className, methodName, "RETURN null");
            } else {
                logger.logp(Level.FINER, className, methodName, "RETURN archive [ {0} ]", a.getURI());
            }
            return a;
        }
        try {
            ArchiveOptions archiveOptions = this.getOptionsForOpening(loose);
            Archive a = this.openNestedArchive(m, archiveOptions);
            if (a == null) {
                logger.logp(Level.FINER, className, methodName, "RETURN null");
            } else {
                logger.logp(Level.FINER, className, methodName, "RETURN archive [ {0} ]", a.getURI());
            }
            return a;
        }
        catch (IOException ex) {
            logger.logp(Level.FINER, className, methodName, "java.io.IOException with module [ {0} ]", m.getUri());
            logger.logp(Level.FINER, className, methodName, "RETURN null");
            return null;
        }
    }

    public Archive openNestedArchive(String aUri) throws OpenFailureException {
        String methodName = "openNestedArchive - URI";
        logger.logp(Level.FINER, className, methodName, "ENTRY - URI [ {0} ]", aUri);
        try {
            String altBinariesPath;
            String parentBinariesPath = this.getBinariesPath();
            logger.logp(Level.FINER, className, methodName, "Found parentBinariesPath [ {0} ]", parentBinariesPath);
            ArchiveOptions ao = this.getOptions();
            if (ao.isSetAltBinariesPath() && (altBinariesPath = ao.getAltBinariesPath()) != null) {
                logger.logp(Level.FINER, className, methodName, "Replacing binariesPath [ {0} ] with altBinariesPath in archiveOptions", parentBinariesPath);
                parentBinariesPath = altBinariesPath;
            }
            this.options.setParentEarBinariesPath(parentBinariesPath);
            logger.logp(Level.FINER, className, methodName, "Saved parentBinariesPath in archiveOptions [ {0} ]", parentBinariesPath);
        }
        catch (FileNotFoundException e) {
            logger.logp(Level.WARNING, className, methodName, "Couldn't set binariesPath in archive options.  Continuing without it.");
        }
        Module m = this.getDeploymentDescriptor().getFirstModule(aUri);
        logger.logp(Level.FINER, className, methodName, "Got module [ {0} ]", m);
        if (m == null) {
            Archive a = super.openNestedArchive(aUri);
            if (a == null) {
                logger.logp(Level.FINER, className, methodName, "RETURN null");
            } else {
                logger.logp(Level.FINER, className, methodName, "RETURN archive [ {0} ]", a.getURI());
            }
            return a;
        }
        try {
            ArchiveOptions archiveOptions = this.getOptionsForOpening(aUri);
            Archive a = this.openNestedArchive(m, archiveOptions);
            if (a == null) {
                logger.logp(Level.FINER, className, methodName, "RETURN null");
            } else {
                logger.logp(Level.FINER, className, methodName, "RETURN archive [ {0} ]", a.getURI());
            }
            return a;
        }
        catch (IOException ex) {
            logger.logp(Level.FINER, className, methodName, "java.io.IOException with archive [ {0} ]", aUri);
            logger.logp(Level.FINER, className, methodName, "RETURN null");
            return null;
        }
    }

    protected Archive openNestedArchive(Module m, ArchiveOptions archiveOptions) throws OpenFailureException {
        String methodName = "openNestedArchive - module";
        String aUri = m.getUri();
        logger.logp(Level.FINER, className, methodName, "ENTRY - module URI [ {0} ]", aUri);
        try {
            ModuleFile a;
            try {
                String parentBinariesPath = this.getBinariesPath();
                logger.logp(Level.FINER, className, methodName, "Found parentBinariesPath [ {0} ]", parentBinariesPath);
                String altBinariesPath = this.getOptions().getAltBinariesPath();
                if (altBinariesPath != null) {
                    logger.logp(Level.FINER, className, methodName, "Found altBinariesPath in archiveOptions [ {0} ]", altBinariesPath);
                    parentBinariesPath = altBinariesPath;
                }
                archiveOptions.setParentEarBinariesPath(parentBinariesPath);
                logger.logp(Level.FINER, className, methodName, "Saved parentBinariesPath [ {0} ] in archiveOptions", parentBinariesPath);
            }
            catch (FileNotFoundException e) {
                logger.logp(Level.WARNING, className, methodName, "Couldn't set binariesPath in archive options.  Continuing without it.");
            }
            if (m.isWebModule()) {
                a = this.getCommonArchiveFactory().openWARFile(archiveOptions, aUri);
                logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", a);
                return a;
            }
            if (m.isEjbModule()) {
                a = this.getCommonArchiveFactory().openEJBJarFile(archiveOptions, aUri);
                logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", a);
                return a;
            }
            if (m.isJavaModule()) {
                a = this.getCommonArchiveFactory().openApplicationClientFile(archiveOptions, aUri);
                logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", a);
                return a;
            }
            if (m.isConnectorModule()) {
                a = this.getCommonArchiveFactory().openRARFile(archiveOptions, aUri);
                logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", a);
                return a;
            }
        }
        catch (OpenFailureException ex) {
            logger.severe(ex.getMessage());
            logger.logp(Level.FINER, className, methodName, "RETURN Throwing OpenFailureException");
            throw new OpenFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.nested_open_fail_EXC_, new Object[]{aUri, this.getURI()}), ex);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN null");
        return null;
    }

    public void pushDownRole(SecurityRole role) {
        if (role == null) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.Parameter_should_not_be_nu_EXC_);
        }
        EList modules = this.getDeploymentDescriptor().getModules();
        int i = 0;
        while (i < modules.size()) {
            Module m = (Module)modules.get(i);
            this.pushDownRole(role, m);
            ++i;
        }
    }

    public void pushDownRole(SecurityRole role, Module aModule) {
        String methodName = "pushDownRole";
        String moduleURI = aModule.getUri();
        String roleName = role.getRoleName();
        logger.entering(className, methodName, new Object[]{roleName, moduleURI});
        try {
            if (aModule.isWebModule()) {
                logger.logp(Level.FINER, className, methodName, "Module found to be a Web Module");
                WebApp dd = this.getDeploymentDescriptor((WebModule)aModule);
                if (dd.getSecurityRoleNamed(roleName) == null) {
                    dd.getSecurityRoles().add((Object)EtoolsCopyUtility.createCopy(role));
                }
            } else if (aModule.isEjbModule()) {
                logger.logp(Level.FINER, className, methodName, "Module found to be an EJB Module");
                AssemblyDescriptor assembly = this.getAssemblyDescriptorAddIfNecessary(this.getDeploymentDescriptor((EjbModule)aModule));
                if (assembly.getSecurityRoleNamed(roleName) == null) {
                    assembly.getSecurityRoles().add((Object)EtoolsCopyUtility.createCopy(role));
                }
            }
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            logger.exiting(className, methodName, "Throwing DeploymentDescriptorLoadException");
            String ddName = "";
            if (aModule.isWebModule()) {
                ddName = "WEB-INF/web.xml";
            } else if (aModule.isEjbModule()) {
                ddName = "META-INF/ejb-jar.xml";
            }
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{ddName, aModule.getUri(), this.getURI()}), e);
        }
        logger.exiting(className, methodName);
    }

    protected void registerResourceFactory(Module aModule, String aUri) {
        Resource.Factory factory = null;
        if (aModule.isEjbModule()) {
            factory = EJBJarResourceFactory.getRegisteredFactory();
        } else if (aModule.isWebModule()) {
            factory = WebAppResourceFactory.getRegisteredFactory();
        } else if (aModule.isJavaModule()) {
            factory = ApplicationClientResourceFactory.getRegisteredFactory();
        } else if (aModule.isConnectorModule()) {
            factory = ConnectorResourceFactory.getRegisteredFactory();
        }
        if (factory != null) {
            ResourceSet set = this.getResourceSet();
            ((FileNameResourceFactoryRegistry)set.getResourceFactoryRegistry()).registerLastFileSegment(aUri, factory);
        }
    }

    public void remove(ModuleRef aModuleRef) {
        String methodName = "remove";
        logger.entering(className, methodName, aModuleRef);
        if (aModuleRef == null) {
            return;
        }
        Module aModule = aModuleRef.getModule();
        if (aModule != null) {
            this.getDeploymentDescriptor().getModules().remove((Object)aModule);
        }
        this.getModuleRefs().remove((Object)aModuleRef);
        ModuleFile mf = aModuleRef.getModuleFile();
        if (this.getModuleRefs(mf).isEmpty()) {
            logger.logp(Level.FINER, className, methodName, "Removing EAR file list entry for module [ {0} ]", mf.getURI());
            this.getFiles().remove((Object)mf);
        }
        logger.exiting(className, methodName);
    }

    public List getModuleRefs(ModuleFile aModuleFile) {
        EList refs = this.getModuleRefs();
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>(1);
        int i = 0;
        while (i < refs.size()) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (ref.getModuleFile() == aModuleFile) {
                result.add(ref);
            }
            ++i;
        }
        return result;
    }

    protected void renameRolesInModuleDDs(String existingRoleName, String newRoleName) {
        String methodName = "renameRolesInModuleDDs";
        logger.entering(className, methodName, new Object[]{existingRoleName, newRoleName});
        EList modules = this.getDeploymentDescriptor().getModules();
        int i = 0;
        while (i < modules.size()) {
            Module m = (Module)modules.get(i);
            try {
                if (m.isEjbModule()) {
                    logger.logp(Level.FINER, className, methodName, "Module found to be an EJB Module");
                    this.getDeploymentDescriptor((EjbModule)m).renameSecurityRole(existingRoleName, newRoleName);
                } else if (m.isWebModule()) {
                    logger.logp(Level.FINER, className, methodName, "Module found to be a Web Module");
                    this.getDeploymentDescriptor((WebModule)m).renameSecurityRole(existingRoleName, newRoleName);
                }
            }
            catch (Exception e) {
                logger.severe(e.getMessage());
                logger.exiting(className, methodName, "Throwing DeploymentDescriptorLoadException");
                String ddName = "";
                if (m.isWebModule()) {
                    ddName = "WEB-INF/web.xml";
                } else if (m.isEjbModule()) {
                    ddName = "META-INF/ejb-jar.xml";
                }
                throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{ddName, m.getUri(), this.getURI()}), e);
            }
            ++i;
        }
        logger.exiting(className, methodName);
    }

    public void renameSecurityRole(String existingRoleName, String newRoleName) throws ObjectNotFoundException, DuplicateObjectException {
        Application app = this.getDeploymentDescriptor();
        SecurityRole aRole = app.getSecurityRoleNamed(existingRoleName);
        if (aRole == null) {
            throw new ObjectNotFoundException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.no_sec_role_EXC_, new Object[]{this.getURI(), existingRoleName}));
        }
        if (app.getSecurityRoleNamed(newRoleName) != null) {
            throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.dup_sec_role_EXC_, new Object[]{this.getURI(), newRoleName}), app.getSecurityRoleNamed(newRoleName));
        }
        aRole.setRoleName(newRoleName);
        this.renameRolesInModuleDDs(existingRoleName, newRoleName);
    }

    public void rollUpRoles() {
        EList modules = this.getDeploymentDescriptor().getModules();
        int i = 0;
        while (i < modules.size()) {
            Module aModule = (Module)modules.get(i);
            this.rollUpRoles(aModule);
            ++i;
        }
    }

    public void rollUpRoles(Module aModule) {
        String methodName = "rollUpRoles";
        String moduleURI = aModule.getUri();
        logger.entering(className, methodName, moduleURI);
        List securityRoles = null;
        try {
            if (aModule.isWebModule()) {
                logger.logp(Level.FINER, className, methodName, "Module found to be a Web Module");
                securityRoles = this.getDeploymentDescriptor((WebModule)aModule).getSecurityRoles();
            } else if (aModule.isEjbModule()) {
                logger.logp(Level.FINER, className, methodName, "Module found to be an EJB Module");
                EJBJar dd = this.getDeploymentDescriptor((EjbModule)aModule);
                if (dd != null) {
                    securityRoles = this.getAssemblyDescriptorAddIfNecessary(dd).getSecurityRoles();
                }
            }
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            logger.exiting(className, methodName, "Throwing DeploymentDescriptorLoadException");
            String ddName = "";
            if (aModule.isWebModule()) {
                ddName = "WEB-INF/web.xml";
            } else if (aModule.isEjbModule()) {
                ddName = "META-INF/ejb-jar.xml";
            }
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{ddName, aModule.getUri(), this.getURI()}), e);
        }
        if (securityRoles == null) {
            logger.exiting(className, methodName, "No security roles found");
            return;
        }
        int numRoles = securityRoles.size();
        int i = 0;
        while (i < numRoles) {
            this.addCopyIfNotExists((SecurityRole)securityRoles.get(i));
            ++i;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN Found {0} security roles", Integer.toString(numRoles));
    }

    public void setDeploymentDescriptor(Application l) {
        this.setDeploymentDescriptorGen(l);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), l);
    }

    public void setDeploymentDescriptor_noDD(Application l) {
        String methodName = "setDeploymentDescriptor_noDD";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        this.setDeploymentDescriptorGen(l);
        try {
            this.replaceRoot(this.makeMofResource(this.getDeploymentDescriptorUri()), l);
        }
        catch (DuplicateObjectException e) {
            logger.logp(Level.FINER, className, methodName, "Ignoring DuplicateObjectException");
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public Application getDeploymentDescriptorGen() {
        if (this.deploymentDescriptor != null && this.deploymentDescriptor.eIsProxy()) {
            InternalEObject oldDeploymentDescriptor = (InternalEObject)this.deploymentDescriptor;
            this.deploymentDescriptor = (Application)this.eResolveProxy(oldDeploymentDescriptor);
            if (this.deploymentDescriptor != oldDeploymentDescriptor && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 10, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
            }
        }
        return this.deploymentDescriptor;
    }

    public Application basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptorGen(Application newDeploymentDescriptor) {
        Application oldDeploymentDescriptor = this.deploymentDescriptor;
        this.deploymentDescriptor = newDeploymentDescriptor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getModuleRefs()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getModuleRefs()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getModuleRefs();
            }
            case 10: {
                if (resolve) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.getModuleRefs().clear();
                this.getModuleRefs().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.setDeploymentDescriptor((Application)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.getModuleRefs().clear();
                return;
            }
            case 10: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.moduleRefs != null && !this.moduleRefs.isEmpty();
            }
            case 10: {
                return this.deploymentDescriptor != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public EList getModuleRefsGen() {
        if (this.moduleRefs == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.moduleRefs = new EObjectContainmentWithInverseEList((Class)clazz, (InternalEObject)this, 9, 1);
        }
        return this.moduleRefs;
    }

    public EList getModuleRefs() {
        EList refs = this.getModuleRefsGen();
        if (refs.isEmpty()) {
            this.initRefs(refs);
        }
        return refs;
    }

    public void initRefs(EList refs) {
        EList modules = this.getDeploymentDescriptor().getModules();
        int i = 0;
        while (i < modules.size()) {
            Module module = (Module)modules.get(i);
            refs.add((Object)this.createModuleRef(module, null));
            ++i;
        }
    }

    protected ModuleRef createModuleRef(Module aModule, ModuleFile aFile) {
        ModuleRef newRef = null;
        if (aModule.isEjbModule()) {
            newRef = this.getCommonArchiveFactory().createEJBModuleRef();
        } else if (aModule.isWebModule()) {
            newRef = this.getCommonArchiveFactory().createWebModuleRef();
        } else if (aModule.isConnectorModule()) {
            newRef = this.getCommonArchiveFactory().createConnectorModuleRef();
        } else if (aModule.isJavaModule()) {
            newRef = this.getCommonArchiveFactory().createClientModuleRef();
        }
        newRef.setModule(aModule);
        newRef.setModuleFile(aFile);
        return newRef;
    }

    public List getClientModuleRefs() {
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>();
        EList refs = this.getModuleRefs();
        int i = 0;
        while (i < refs.size()) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (ref.isClient()) {
                result.add(ref);
            }
            ++i;
        }
        return result;
    }

    public List getConnectorModuleRefs() {
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>();
        EList refs = this.getModuleRefs();
        int i = 0;
        while (i < refs.size()) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (ref.isConnector()) {
                result.add(ref);
            }
            ++i;
        }
        return result;
    }

    public List getEJBModuleRefs() {
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>();
        EList refs = this.getModuleRefs();
        int i = 0;
        while (i < refs.size()) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (ref.isEJB()) {
                result.add(ref);
            }
            ++i;
        }
        return result;
    }

    public List getWebModuleRefs() {
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>();
        EList refs = this.getModuleRefs();
        int i = 0;
        while (i < refs.size()) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (ref.isWeb()) {
                result.add(ref);
            }
            ++i;
        }
        return result;
    }

    public List getFARFiles() {
        ArrayList<File> farFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File aFile = (File)fileList.get(i);
            if (aFile.isFARFile()) {
                farFiles.add(aFile);
            }
            ++i;
        }
        return farFiles;
    }

    public List getArchivesOfType(String type) {
        return Collections.EMPTY_LIST;
    }

    public Map getEJBReferences(boolean filterLinkedReferences, boolean filterNonLinkedReferences) throws ArchiveWrappedException {
        Application app;
        if (!(filterLinkedReferences && filterNonLinkedReferences || (app = this.getDeploymentDescriptor()) == null)) {
            EList modules = app.getModules();
            Map references = null;
            int i = 0;
            while (i < modules.size()) {
                Module module = (Module)modules.get(i);
                try {
                    references = this.collectEJBReferences(module, filterLinkedReferences, filterNonLinkedReferences, references);
                }
                catch (ResourceLoadException e) {
                    throw new ArchiveWrappedException(e);
                }
                catch (FileNotFoundException e) {
                    throw new ArchiveWrappedException(e);
                }
                catch (EmptyResourceException e) {
                    throw new ArchiveWrappedException(e);
                }
                ++i;
            }
            return references;
        }
        return Collections.EMPTY_MAP;
    }

    private Map collectEJBReferences(Module module, boolean filterLinkedReferences, boolean filterNonLinkedReferences, Map references) throws ResourceLoadException, FileNotFoundException, EmptyResourceException {
        HashMap myReferences = references;
        List moduleReferences = this.getEJBReferences(module);
        if (moduleReferences != null && !moduleReferences.isEmpty()) {
            EjbRef ref = null;
            ArrayList<EjbRef> filteredRefs = null;
            String link = null;
            int i = 0;
            while (i < moduleReferences.size()) {
                ref = (EjbRef)moduleReferences.get(i);
                link = ref.getLink();
                if (link != null && link.length() > 0 && !filterLinkedReferences || (link == null || link.length() == 0) && !filterNonLinkedReferences) {
                    if (filteredRefs == null) {
                        filteredRefs = new ArrayList<EjbRef>(moduleReferences.size());
                    }
                    filteredRefs.add(ref);
                }
                ++i;
            }
            if (filteredRefs != null) {
                if (myReferences == null) {
                    myReferences = new HashMap();
                }
                myReferences.put(module, filteredRefs);
            }
        }
        return myReferences;
    }

    private List getEJBReferences(Module module) throws ResourceLoadException, FileNotFoundException, EmptyResourceException {
        if (module != null) {
            ApplicationClient appClient;
            if (module.isEjbModule()) {
                EJBJar ejbJar = this.getDeploymentDescriptor((EjbModule)module);
                return this.getEJBReferences(ejbJar);
            }
            if (module.isWebModule()) {
                WebApp webApp = this.getDeploymentDescriptor((WebModule)module);
                if (webApp != null) {
                    return webApp.getEjbRefs();
                }
            } else if (module.isJavaModule() && (appClient = this.getDeploymentDescriptor((JavaClientModule)module)) != null) {
                return appClient.getEjbReferences();
            }
        }
        return Collections.EMPTY_LIST;
    }

    private List getEJBReferences(EJBJar ejbJar) {
        if (ejbJar != null) {
            EList ejbs = ejbJar.getEnterpriseBeans();
            ArrayList refs = null;
            EnterpriseBean ejb = null;
            int i = 0;
            while (i < ejbs.size()) {
                ejb = (EnterpriseBean)ejbs.get(i);
                if (refs == null) {
                    refs = new ArrayList();
                }
                refs.addAll(ejb.getEjbRefs());
                ++i;
            }
            if (refs != null) {
                return refs;
            }
        }
        return Collections.EMPTY_LIST;
    }

    protected void displayDescriptor(Application a) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        String msg = "\n    \nDescribing EAR File descriptor for [ " + this.getURI() + " ]\n";
        msg = String.valueOf(msg) + "\n    Version ID   [ " + a.getVersionID() + " ]";
        EList l = a.getModules();
        msg = String.valueOf(msg) + "\n    EAR contains [ " + l.size() + " ] modules:";
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Module m = (Module)i.next();
            msg = String.valueOf(msg) + "\n      Module URI[ " + m.getUri() + " ]";
            if (m == null) continue;
            if (m.isEjbModule()) {
                msg = String.valueOf(msg) + "\n        EJB Module";
            } else if (m.isWebModule()) {
                msg = String.valueOf(msg) + "\n        Web Module";
            } else if (m.isConnectorModule()) {
                msg = String.valueOf(msg) + "\n        Connector Module";
            } else if (m.isJavaModule()) {
                msg = String.valueOf(msg) + "\n        Java Module";
            }
            msg = String.valueOf(msg) + "\n        Alt DD      [ " + m.getAltDD() + " ]";
        }
        logger.finest(String.valueOf(msg) + "\n");
    }
}

