/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ExportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public abstract class ModuleFileImpl
extends ArchiveImpl
implements ModuleFile {
    public static final String className;
    public static Logger logger;
    protected ImportStrategy importStrategy;
    protected ExportStrategy exportStrategy;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.getName();
        logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.MODULE_FILE;
    }

    protected boolean canLazyInitialize() {
        return this.getImportStrategy() != null;
    }

    public Resource getDeploymentDescriptorResource() throws FileNotFoundException, ResourceLoadException {
        return this.getMofResource(this.getDeploymentDescriptorUri());
    }

    public abstract String getDeploymentDescriptorUri();

    public EARFile getEARFile() {
        Container aContainer = this.getContainer();
        if (aContainer == null || !aContainer.isEARFile()) {
            return null;
        }
        return (EARFile)aContainer;
    }

    public ExportStrategy getExportStrategy() {
        return this.exportStrategy;
    }

    public ImportStrategy getImportStrategy() {
        return this.importStrategy;
    }

    public String getSpecVersion() {
        float ver = this.getSpecVersionID();
        Float specVersion = new Float(ver / 10.0f);
        return specVersion.toString();
    }

    public int getSpecVersionID() {
        try {
            return ((XMLResource)this.getDeploymentDescriptorResource()).getModuleVersionID();
        }
        catch (Exception e) {
            throw new ArchiveRuntimeException(e);
        }
    }

    public abstract boolean isDeploymentDescriptorSet();

    public boolean isModuleFile() {
        return true;
    }

    public abstract EObject makeDeploymentDescriptor(XMLResource var1);

    public Resource makeDeploymentDescriptorResource() {
        XMLResource resource = null;
        try {
            resource = (XMLResource)this.makeMofResource(this.getDeploymentDescriptorUri());
        }
        catch (DuplicateObjectException ex) {
            try {
                return this.getDeploymentDescriptorResource();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        this.makeDeploymentDescriptor(resource);
        return resource;
    }

    public void save(SaveStrategy aSaveStrategy) throws SaveFailureException {
        this.setSaveStrategy(aSaveStrategy);
        if (this.getExportStrategy() != null) {
            this.getExportStrategy().preSave(aSaveStrategy);
        }
        this.preSave(aSaveStrategy);
        super.save(aSaveStrategy);
    }

    public void setExportStrategy(ExportStrategy newExportStrategy) {
        this.exportStrategy = newExportStrategy;
        if (newExportStrategy != null) {
            newExportStrategy.setArchive(this);
        }
    }

    public void setImportStrategy(ImportStrategy newImportStrategy) {
        this.importStrategy = newImportStrategy;
        if (newImportStrategy != null) {
            newImportStrategy.setArchive(this);
        }
    }

    public void setJ2EEVersion(int versionID) {
        try {
            ((XMLResource)this.getDeploymentDescriptorResource()).setVersionID(versionID);
        }
        catch (ResourceLoadException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw new ArchiveRuntimeException(e);
        }
    }

    public void preSave(SaveStrategy aStrategy) throws SaveFailureException {
        String methodName = "preSave";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void setModified(String resourcePath) throws SaveFailureException {
        String logText;
        FileNotFoundException fileException;
        ResourceLoadException loadException;
        Resource resource;
        String methodName = "setModified";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ] [ {1} ]", new Object[]{this.getURI(), resourcePath});
        try {
            resource = !this.containsFile(resourcePath) ? null : this.getMofResource(resourcePath);
            loadException = null;
            fileException = null;
        }
        catch (ResourceLoadException e) {
            resource = null;
            loadException = e;
            fileException = null;
        }
        catch (FileNotFoundException e) {
            resource = null;
            loadException = null;
            fileException = e;
        }
        if (loadException != null) {
            SaveFailureException sfe = new SaveFailureException("Failed to mark [ " + resourcePath + " ] in [ " + this.getURI() + " ]", loadException);
            logger.throwing(className, methodName, loadException);
            logger.throwing(className, methodName, sfe);
            String logText2 = "RETURN - Load Failure: " + sfe.getMessage() + " - " + loadException.getMessage() + ": Skipping mark as modified";
            logger.logp(Level.FINER, className, methodName, logText2);
            throw sfe;
        }
        if (fileException != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.throwing(className, methodName, fileException);
            }
            logText = "RETURN - Resource not present: Skipping mark as modified";
            logger.logp(Level.FINER, className, methodName, logText);
        } else {
            if (resource != null) {
                if (!resource.isModified()) {
                    resource.setModified(true);
                    logText = "RETURN - Resource present and not modified: Setting modified";
                } else {
                    logText = "RETURN - Resource present and not modified: Skipping mark as modified";
                }
            } else {
                logText = "RETURN - Resource not present and not modified: Skipping mark as modified";
            }
            logger.logp(Level.FINER, className, methodName, logText);
        }
    }
}

