/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ConnectorDirectorySaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.RarFileDynamicClassLoader;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.JcaFactory;
import org.eclipse.jst.j2ee.jca.JcaPackage;

public class RARFileImpl
extends ModuleFileImpl
implements RARFile {
    protected Connector deploymentDescriptor = null;

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.RAR_FILE;
    }

    public File addCopyClass(File aFile) throws DuplicateObjectException {
        if (aFile.isReadOnlyDirectory()) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.add_copy_class_dir_EXC_, new Object[]{aFile.getURI()}));
        }
        return this.addCopyFileAddingPrefix(aFile, "WEB-INF/classes/");
    }

    protected File addCopyFileAddingPrefix(File aFile, String uriPrefix) throws DuplicateObjectException {
        String swizzledUri = aFile.getURI();
        if (!swizzledUri.startsWith(uriPrefix)) {
            swizzledUri = ArchiveUtil.concatUri(uriPrefix, swizzledUri, '/');
        }
        this.checkAddValid(swizzledUri);
        File copy = this.copy(aFile);
        copy.setURI(swizzledUri);
        this.getFiles().add((Object)copy);
        return copy;
    }

    protected SaveStrategy createSaveStrategyForConnectorDirectory(java.io.File dir, int expansionFlags) {
        return new ConnectorDirectorySaveStrategyImpl(dir.getAbsolutePath(), expansionFlags);
    }

    public void extractToConnectorDirectory(String aUri, int expansionFlags) throws SaveFailureException {
        String originalPath;
        java.io.File aDir = new java.io.File(aUri);
        try {
            originalPath = aDir.getCanonicalPath();
        }
        catch (IOException ioe) {
            originalPath = aDir.getAbsolutePath();
        }
        if (this.getLoadStrategy().isUsing(aDir)) {
            throw new SaveFailureException(CommonArchiveResourceHandler.Extract_destination_is_the_EXC_);
        }
        try {
            SaveStrategy aSaveStrategy = this.createSaveStrategyForConnectorDirectory(aDir, expansionFlags);
            this.save(aSaveStrategy);
            aSaveStrategy.close();
        }
        catch (IOException ex) {
            throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.error_saving_EXC_, new Object[]{originalPath}), ex);
        }
    }

    public List getClasses() {
        return this.filterFilesByPrefix("com");
    }

    public Connector getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        Connector dd = this.deploymentDescriptor;
        if (dd == null && this.canLazyInitialize()) {
            try {
                this.getImportStrategy().importMetaData();
            }
            catch (Exception e) {
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), e);
            }
        }
        return this.deploymentDescriptor;
    }

    public Connector basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getDeploymentDescriptorUri() {
        return "META-INF/ra.xml";
    }

    public List getResources() {
        String[] prefixes = new String[]{"META-INF", "WEB-INF"};
        return this.filterFilesWithoutPrefix(prefixes);
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor();
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public boolean isRARFile() {
        return true;
    }

    public EObject makeDeploymentDescriptor(XMLResource resource) {
        JcaPackage p = (JcaPackage)EPackage.Registry.INSTANCE.getEPackage("jca.xmi");
        JcaFactory fct = p.getJcaFactory();
        Connector connector = fct.createConnector();
        this.setDeploymentDescriptor(connector);
        resource.getContents().add((Object)connector);
        return connector;
    }

    public void setDeploymentDescriptor(Connector l) {
        this.deploymentDescriptor = l;
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), l);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                if (resolve) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setDeploymentDescriptor((Connector)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.deploymentDescriptor != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public ClassLoader createDynamicClassLoader(ClassLoader parentCl, ClassLoader extraCl) {
        return new RarFileDynamicClassLoader(this, parentCl, extraCl);
    }
}

