/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.DeleteOnExitUtility;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseWARFile;

public abstract class DirectoryLoadStrategyImpl
extends LoadStrategyImpl
implements DirectoryArchiveLoadStrategy {
    public static final String className;
    static boolean IS_AIX;
    protected static final boolean PERMIT_NONRELATIVE_PATHS = true;
    protected static final boolean DO_NOT_PERMIT_NONRELATIVE_PATHS = false;
    protected ZipFile binariesZipFile;
    protected String binariesZipFilePath;
    protected String directoryUri;
    protected String directoryUriAsZipString;
    protected static char SEPARATOR_CHAR;
    public static final boolean DO_USE_RESOURCES = true;
    public static final boolean DO_NOT_USE_RESOURCES = false;
    protected boolean isSetContainerData;
    protected String archiveUri;
    protected String archiveResourcesPath;
    protected String archiveBinariesPath;
    protected boolean archiveBinariesIsDistinct;
    protected java.io.File archiveBinariesFile;
    protected boolean archiveBinariesExists;
    protected boolean archiveBinariesIsDirectory;
    protected String tempArchiveBinariesPath;
    protected java.io.File tempArchiveBinariesFile;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryLoadStrategyImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.getName();
        IS_AIX = "AIX".equals(System.getProperty("os.name"));
        SEPARATOR_CHAR = java.io.File.separatorChar;
    }

    public ZipFile getBinariesZipFile() {
        return this.binariesZipFile;
    }

    public String getBinariesZipFilePath() {
        return this.binariesZipFilePath;
    }

    protected ZipFile forceBinariesZipFile() throws IOException {
        String methodName = "forceBinariesZipFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        if (this.binariesZipFile == null) {
            String useBinariesPath = this.getResolvedBinariesPath();
            logger.logp(Level.FINER, className, methodName, "Opening ZIP file on location [ {0} ]", useBinariesPath);
            this.binariesZipFile = new ZipFile(this.getResolvedBinariesFile());
            this.binariesZipFilePath = useBinariesPath;
        } else {
            logger.logp(Level.FINER, className, methodName, "The binaries zip file is already open.");
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", this.binariesZipFile);
        return this.binariesZipFile;
    }

    protected void closeBinariesZipFile() {
        String methodName = "closeBinariesZipFile";
        if (this.binariesZipFile != null) {
            ZipFile useBinaryZipFile = this.binariesZipFile;
            this.binariesZipFile = null;
            String useBinariesZipFilePath = this.binariesZipFilePath;
            this.binariesZipFilePath = null;
            logger.logp(Level.FINER, className, methodName, "ENTRY Closing binaries zip [ {0} ] ...", useBinariesZipFilePath);
            try {
                useBinaryZipFile.close();
                logger.logp(Level.FINER, className, methodName, "RETURN Closed binaries Element [ {0} ]", useBinariesZipFilePath);
            }
            catch (IOException e) {
                logger.logp(Level.SEVERE, className, methodName, "RETURN Ignoring close exception [ {0} ].", useBinariesZipFilePath);
                logger.throwing(className, methodName, e);
            }
        } else {
            logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN Skipping; the binaries zip is not open.");
        }
    }

    public boolean getHaveExtractedBinaries() {
        return this.tempArchiveBinariesPath != null;
    }

    protected String getResolvedBinariesPath() {
        return this.tempArchiveBinariesPath != null ? this.tempArchiveBinariesPath : this.archiveBinariesPath;
    }

    protected java.io.File getResolvedBinariesFile() {
        return this.tempArchiveBinariesFile != null ? this.tempArchiveBinariesFile : this.archiveBinariesFile;
    }

    protected void resolveBinariesFile() throws IOException {
        String methodName = "resolveBinariesFile";
        logger.logp(Level.FINER, className, methodName, "ENTER URI [ {0} ] Archive Binaries [ {1} ]", new Object[]{this.getArchiveURI(), this.getArchiveBinariesPath()});
        if (this.getArchiveBinariesExists()) {
            logger.logp(Level.FINER, className, methodName, "RETURN Set binaries location exists");
        } else if (this.getHaveExtractedBinaries()) {
            logger.logp(Level.FINER, className, methodName, "RETURN Temporary binaries location already created");
        } else {
            logger.logp(Level.FINER, className, methodName, "Binaries location does not exist");
            this.createTempBinariesFile();
            logger.logp(Level.FINER, className, methodName, "RETURN Created temporary binaries file");
        }
    }

    public DirectoryLoadStrategyImpl(String aDirectoryUri) {
        this.setDirectoryUri(aDirectoryUri);
        String normalized = null;
        try {
            normalized = new java.io.File(aDirectoryUri).getCanonicalPath();
        }
        catch (IOException iox) {
            normalized = aDirectoryUri;
        }
        this.setDirectoryUriAsZipString(normalized.replace(SEPARATOR_CHAR, '/'));
    }

    public void setContainer(Container useContainer) {
        String methodName = "setContainer";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY");
            logger.logp(Level.FINER, className, methodName, "This load strategy [ {0} ]", this);
            logger.logp(Level.FINER, className, methodName, "Archive [ {0} ]", this.container);
        }
        super.setContainer(useContainer);
        this.isSetContainerData = false;
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public synchronized void close() {
        String methodName = "close";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY");
            logger.logp(Level.FINER, className, methodName, "This load strategy [ {0} ]", this);
            logger.logp(Level.FINER, className, methodName, "Archive [ {0} ]", this.getContainer());
        }
        this.closeBinariesZipFile();
        this.deleteTempBinariesFile();
        super.close();
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected abstract void addDirectory(java.io.File var1, List var2);

    protected void addFile(java.io.File aFile, List aList) {
        String uri = this.getURIFrom(aFile);
        if (this.collectedLooseArchiveFiles.containsKey(uri)) {
            return;
        }
        File cFile = this.createFile(uri);
        cFile.setSize(aFile.length());
        cFile.setLastModified(aFile.lastModified());
        aList.add(cFile);
    }

    protected void addFiles(java.io.File aDirectory, List aList) {
        String[] fileNames = aDirectory.list();
        if (fileNames == null) {
            return;
        }
        int i = 0;
        while (i < fileNames.length) {
            String fileName = ArchiveUtil.concatUri(aDirectory.getPath(), fileNames[i], SEPARATOR_CHAR);
            if (!(fileNames[i] == null || IS_AIX && ".backup".equals(fileNames[i]))) {
                java.io.File aFile = new java.io.File(fileName);
                if (aFile.isDirectory() && !this.isArchive(this.getURIFrom(aFile))) {
                    this.addDirectory(aFile, aList);
                } else {
                    this.addFile(aFile, aList);
                }
            }
            ++i;
        }
    }

    protected boolean primContains(String uri) {
        return new java.io.File(this.getFileNameFrom(uri)).exists();
    }

    public String getAbsolutePath() throws FileNotFoundException {
        return new java.io.File(this.getDirectoryUri()).getAbsolutePath();
    }

    protected abstract java.io.File getDirectoryForList();

    protected String getLooseFileName(String uri) {
        LooseArchive useLooseArchive = this.getLooseArchive();
        if (useLooseArchive == null) {
            return null;
        }
        int looseArchiveID = useLooseArchive.eClass().getClassifierID();
        if (looseArchiveID == 0) {
            return this.getURIFromLooseArchivesIfAvailable((List)((LooseApplication)useLooseArchive).getLooseArchives(), uri);
        }
        if (looseArchiveID == 5) {
            return this.getURIFromLooseArchivesIfAvailable((List)((LooseWARFile)useLooseArchive).getLooseLibs(), uri);
        }
        return null;
    }

    protected String getResourceFileNameFor(String uri) {
        if (SEPARATOR_CHAR != '/') {
            uri = uri.replace('/', SEPARATOR_CHAR);
        }
        return String.valueOf(this.getArchiveResourcesPath()) + SEPARATOR_CHAR + uri;
    }

    public String getDirectoryUri() {
        return this.directoryUri;
    }

    public String getDirectoryUriAsZipString() {
        return this.directoryUriAsZipString;
    }

    protected String getFileNameFrom(String uri) {
        LooseArchive aLooseArchive = this.getLooseArchive();
        if (aLooseArchive != null) {
            String result = null;
            switch (aLooseArchive.eClass().getClassifierID()) {
                case 0: {
                    result = this.getURIFromLooseArchivesIfAvailable((List)((LooseApplication)aLooseArchive).getLooseArchives(), uri);
                    break;
                }
                case 5: {
                    result = this.getURIFromLooseArchivesIfAvailable((List)((LooseWARFile)aLooseArchive).getLooseLibs(), uri);
                }
            }
            if (result != null) {
                return result;
            }
        }
        String name = uri;
        if (SEPARATOR_CHAR != '/') {
            name = name.replace('/', SEPARATOR_CHAR);
        }
        return String.valueOf(this.getDirectoryUri()) + SEPARATOR_CHAR + name;
    }

    private String getURIFromLooseArchivesIfAvailable(List looseArchives, String uri) {
        Iterator iter = looseArchives.iterator();
        while (iter.hasNext()) {
            LooseArchive looseArchiveElement = (LooseArchive)iter.next();
            if (!uri.equals(looseArchiveElement.getUri())) continue;
            return looseArchiveElement.getBinariesPath();
        }
        return null;
    }

    public List getFiles() {
        ArrayList list = new ArrayList();
        java.io.File directory = this.getDirectoryForList();
        this.addFiles(directory, list);
        return list;
    }

    public List getFiles(String subfolderPath) {
        ArrayList list = new ArrayList();
        java.io.File containerDirectory = this.getDirectoryForList();
        java.io.File subfolder = new java.io.File(containerDirectory, subfolderPath);
        this.addFiles(subfolder, list);
        return list;
    }

    public InputStream basicGetResourceInputStream(String uri) throws IOException, FileNotFoundException {
        return this.basicGetInputStream(uri, true);
    }

    public InputStream basicGetResourcesInputStream(String uri) throws IOException {
        logger.logp(Level.FINER, className, "basicGetResourcesInputStream", "Resources call: Do use resources first");
        return this.basicGetInputStream(uri, true);
    }

    public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
        String methodName = "getInputStream";
        logger.logp(Level.FINER, className, methodName, "ENTER [ {0} ]", uri);
        String looseFileName = this.getLooseFileName(uri);
        if (looseFileName != null) {
            logger.logp(Level.FINER, className, methodName, "Located as a loose file [ {0} ]", looseFileName);
            FileInputStream looseInputStream = new FileInputStream(looseFileName);
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", looseInputStream);
            return looseInputStream;
        }
        InputStream inputStream = this.basicGetInputStream(uri);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", inputStream);
        return inputStream;
    }

    public InputStream basicGetInputStream(String uri) throws IOException {
        logger.logp(Level.FINER, className, "basicGetInputStream", "Normal call: Do not use resources first");
        return this.basicGetInputStream(uri, false);
    }

    public InputStream basicGetInputStream(String uri, boolean useResources) throws IOException {
        String methodName = "basicGetInputStream";
        if (useResources || !this.getArchiveBinariesIsDistinct()) {
            boolean resourcesFileIsDirectory;
            String resourcesFileName = this.getResourceFileNameFor(uri);
            java.io.File resourcesFile = new java.io.File(resourcesFileName);
            boolean resourcesFileExists = resourcesFile.exists();
            boolean bl = resourcesFileIsDirectory = resourcesFileExists && resourcesFile.isDirectory();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, className, methodName, "ENTER [ {0} ]", uri);
                logger.logp(Level.FINER, className, methodName, "LoadStrategy [ {0} ] and archive [ {1} ]", new Object[]{this, this.getContainer()});
                logger.logp(Level.FINER, className, methodName, "Resources file name [ {0} ]", resourcesFileName);
                logger.logp(Level.FINER, className, methodName, "Resources file exists [ {0} ]", new Boolean(resourcesFileExists));
                logger.logp(Level.FINER, className, methodName, "Resources file is directory [ {0} ]", new Boolean(resourcesFileIsDirectory));
                logger.logp(Level.FINER, className, methodName, "Explicit request for resource [ {0} ]", new Boolean(useResources));
            }
            if (resourcesFileExists && !resourcesFileIsDirectory) {
                FileInputStream inputStream = new FileInputStream(resourcesFileName);
                logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", inputStream);
                return inputStream;
            }
            if (!this.getArchiveBinariesIsDistinct()) {
                throw new FileNotFoundException("File [ " + uri + " ]" + " not found in archive [ " + this.getArchiveURI() + " ]" + " at [ " + this.getArchiveResourcesPath() + "]");
            }
            logger.logp(Level.FINER, className, methodName, "File not in resources location, and there is a distinct binaries location.");
        } else {
            logger.logp(Level.FINER, className, methodName, "Load from resources is disallowed");
        }
        if (this.getArchiveBinariesIsDirectory()) {
            logger.logp(Level.FINER, className, methodName, "Binaries available exists as a directory");
            String binaryFileName = String.valueOf(this.getArchiveBinariesPath()) + java.io.File.separator + uri;
            FileInputStream inputStream = new FileInputStream(binaryFileName);
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", inputStream);
            return inputStream;
        }
        this.resolveBinariesFile();
        String useBinariesPath = this.getResolvedBinariesPath();
        logger.logp(Level.FINER, className, methodName, "Using binaries zip [ {0} ]", useBinariesPath);
        ZipFile zipFile = this.forceBinariesZipFile();
        ZipEntry targetEntry = zipFile.getEntry(uri);
        if (targetEntry != null) {
            InputStream inputStream = zipFile.getInputStream(targetEntry);
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", inputStream);
            return inputStream;
        }
        logger.logp(Level.FINER, className, methodName, "Failed to locate entry [ {0} ] in archive [ {1} ]", new Object[]{uri, useBinariesPath});
        throw new FileNotFoundException("Failed to locate entry [ " + uri + " ] in archive [ " + useBinariesPath + " ]");
    }

    protected String getURIFrom(java.io.File aFile) {
        String name = "";
        String relative = null;
        String root = this.getDirectoryUriAsZipString();
        try {
            name = aFile.getCanonicalPath();
            relative = this.makeRelative(name, root);
        }
        catch (IOException iox) {
            name = null;
        }
        if (relative == null) {
            name = aFile.getAbsolutePath();
            relative = this.makeRelative(name, root);
        }
        if (relative == null) {
            name = aFile.getPath();
            root = this.replaceSeparators(this.getDirectoryUri());
            relative = this.makeRelative(name, root);
        }
        return relative;
    }

    private String replaceSeparators(String path) {
        if (java.io.File.separatorChar != '/') {
            return path.replace(java.io.File.separatorChar, '/');
        }
        return path;
    }

    private String makeRelative(String fileName, String root) {
        String name;
        if (fileName == null || root == null) {
            return null;
        }
        int offset = root.length();
        while (offset > 0 && root.charAt(offset - 1) == '/') {
            --offset;
        }
        if (offset < root.length()) {
            if (++offset < root.length()) {
                root = root.substring(0, offset);
            }
        } else {
            root = String.valueOf(root) + '/';
        }
        name = (name = this.replaceSeparators(fileName)).startsWith(root) ? name.substring(root.length()) : null;
        return name;
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isUsing(java.io.File aSystemFile) {
        java.io.File dir = new java.io.File(this.getDirectoryUri());
        return dir.equals(aSystemFile);
    }

    public void setDirectoryUri(String newDirectoryUri) {
        this.directoryUri = newDirectoryUri;
    }

    public void setDirectoryUriAsZipString(String newDirectoryUriAsZipString) {
        this.directoryUriAsZipString = newDirectoryUriAsZipString;
    }

    protected void collectFilesFromBinaries(List filesSoFar) {
        String methodName = "collectFilesFromBinaries";
        logger.logp(Level.FINER, className, methodName, "ENTRY Container URI [ {0} ]", this.getContainer().getURI());
        String additionalBinariesPath = this.getAdditionalBinariesPath();
        if (additionalBinariesPath == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN Non-distinct binaries case)");
            return;
        }
        Set urisSoFar = ArchiveUtil.collectFileUris(filesSoFar.iterator());
        if (this.getArchiveBinariesIsDirectory()) {
            logger.logp(Level.FINER, className, methodName, "Set binaries exists as a directory.");
            this.addFilesFromBinariesDirectory("", this.getArchiveBinariesFile(), filesSoFar, urisSoFar);
            logger.logp(Level.FINER, className, methodName, "RETURN Binaries directory case");
            return;
        }
        try {
            this.resolveBinariesFile();
        }
        catch (IOException e) {
            logger.logp(Level.SEVERE, className, methodName, "Failed to extract binaries to temporary location:\nBinaries files were not added!\nThis load strategy [ {0} ] Container [ {1} ]", new Object[]{this, this.getContainer()});
            logger.throwing(className, methodName, e);
            logger.logp(Level.FINER, className, methodName, "RETURN Failed temp binaries file case");
            return;
        }
        logger.logp(Level.FINER, className, methodName, "Using binaries zip [ {0} ]", this.getResolvedBinariesPath());
        this.addFilesFromBinariesFile(this.getResolvedBinariesFile(), filesSoFar, urisSoFar);
        logger.logp(Level.FINER, className, methodName, "RETURN Binaries file case");
    }

    protected void addFilesFromBinariesDirectory(String relativeUriFromContainer, java.io.File file, List filesSoFar, Set urisSoFar) {
        String methodName = "addFilesFromBinariesDirectory";
        String fileName = file.getName();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTER Relative URI [ {0} ]; current location [ {1} ]", new Object[]{relativeUriFromContainer, fileName});
        }
        if (file.isDirectory()) {
            logger.logp(Level.FINER, className, methodName, "External directory [ {0} ]", fileName);
            java.io.File[] childFiles = file.listFiles();
            if (childFiles == null) {
                logger.logp(Level.WARNING, className, methodName, "Failed to list external directory [ {0} ]", fileName);
            } else {
                int fileNo = 0;
                while (fileNo < childFiles.length) {
                    java.io.File nextChildFile = childFiles[fileNo];
                    String nextFileName = nextChildFile.getName();
                    String nextRelativeUri = ArchiveUtil.concatenateUris(relativeUriFromContainer, nextFileName);
                    if (urisSoFar.contains(nextRelativeUri)) {
                        logger.logp(Level.FINER, className, methodName, "Skipping [ {0} ]; already listed", nextRelativeUri);
                    } else {
                        logger.logp(Level.FINER, className, methodName, "Processing new file [ {0} ]", nextRelativeUri);
                        this.addFilesFromBinariesDirectory(nextRelativeUri, nextChildFile, filesSoFar, urisSoFar);
                    }
                    ++fileNo;
                }
            }
        } else {
            this.addFileFromBinariesDirectory(relativeUriFromContainer, file, filesSoFar, urisSoFar, fileName);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected void addFileFromBinariesDirectory(String relativeUriFromContainer, java.io.File file, List filesSoFar, Set urisSoFar, String fileName) {
        String methodName = "addFileFromBinariesDirectory";
        logger.logp(Level.FINER, className, methodName, "   External file [ {0} ]", fileName);
        logger.logp(Level.FINER, className, methodName, "   file [ {0} ]", file);
        logger.logp(Level.FINER, className, methodName, "   relativeUriFromContainer [ {0} ]", relativeUriFromContainer);
        boolean isWAR = this.container.isWARFile();
        boolean isWebInfClasses = relativeUriFromContainer.startsWith("WEB-INF/classes");
        if (isWAR && isWebInfClasses) {
            String filePath = file.getPath();
            logger.logp(Level.FINER, className, methodName, "   file path [ {0} ]", filePath);
            File newFile = this.createFile(relativeUriFromContainer, filePath, true, file, null);
            filesSoFar.add(newFile);
            urisSoFar.add(relativeUriFromContainer);
            logger.logp(Level.FINER, className, methodName, "Added from WAR WEB-INF/classes: URI [ {0} ]", newFile.getURI());
        } else if (!fileName.endsWith(".jar")) {
            logger.logp(Level.FINER, className, methodName, "Skipping [ {0} ]; not a JAR file", fileName);
        } else {
            try {
                Archive archive = this.createNestedArchiveFromBinaries(relativeUriFromContainer);
                filesSoFar.add(archive);
                urisSoFar.add(relativeUriFromContainer);
                logger.logp(Level.FINER, className, methodName, "Added archive [ {0} ]", relativeUriFromContainer);
            }
            catch (OpenFailureException e) {
                logger.throwing(className, methodName, e);
                logger.logp(Level.SEVERE, className, methodName, "Failed to create archive [ {0} ]", relativeUriFromContainer);
            }
        }
    }

    protected void addFilesFromBinariesFile(java.io.File binariesRootFile, List filesSoFar, Set urisSoFar) {
        List entries;
        String methodName = "addArchivesFromBinaryFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        try {
            entries = ArchiveUtil.listArchiveEntries(binariesRootFile, false, true);
        }
        catch (IOException e) {
            logger.throwing(className, methodName, e);
            logger.logp(Level.FINER, className, methodName, "Failed to open binaries location [ {0} ]", binariesRootFile);
            return;
        }
        int numEntries = 0;
        int numAdded = 0;
        Iterator useEntries = entries.iterator();
        while (useEntries.hasNext()) {
            File file;
            ArchiveUtil.EntryDetails nextEntry = (ArchiveUtil.EntryDetails)useEntries.next();
            String nextEntryName = nextEntry.name;
            ++numEntries;
            if (urisSoFar.contains(nextEntryName)) {
                logger.logp(Level.FINER, className, methodName, "Skipping [ {0} ]; already listed", nextEntryName);
                continue;
            }
            if (nextEntry.isDirectory) {
                logger.logp(Level.FINER, className, methodName, "Skipping [ {0} ]; is-directory is true", nextEntryName);
                continue;
            }
            if (!nextEntryName.endsWith(".jar")) {
                logger.logp(Level.FINER, className, methodName, "Adding file [ {0} ]", nextEntryName);
                file = this.createNestedFileFromBinaries(nextEntry);
            } else {
                logger.logp(Level.FINER, className, methodName, "Adding java archive [ {0} ]", nextEntryName);
                try {
                    file = this.createNestedArchiveFromBinaries(nextEntryName);
                }
                catch (OpenFailureException e) {
                    logger.throwing(className, methodName, e);
                    logger.logp(Level.SEVERE, className, methodName, "Failed top open archive [ {0} ]", nextEntryName);
                    file = this.createNestedFileFromBinaries(nextEntry);
                }
            }
            filesSoFar.add(file);
            urisSoFar.add(nextEntryName);
            ++numAdded;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "RETURN Count of entries [ {0} ]; count of entries added [ {1} ]", new Object[]{new Integer(numEntries), new Integer(numAdded)});
        }
    }

    protected File createNestedFileFromBinaries(ArchiveUtil.EntryDetails details) {
        String methodName = "createNestedFileFromBinaries(EntryDetails)";
        Archive useArchive = this.getArchive();
        String useArchiveUri = useArchive.getURI();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ] parent URI [ {1} ]", new Object[]{details.name, useArchiveUri});
        }
        File file = this.createFile(details.name, details.size, details.lastModified, details.isDirectory);
        logger.logp(Level.FINER, className, methodName, "RETURN file [ {0} ]", file);
        return file;
    }

    protected File createNestedFileFromBinaries(ZipEntry entry) {
        String methodName = "createNestedFileFromBinaries(ZipEntry)";
        Archive useArchive = this.getArchive();
        String useArchiveUri = useArchive.getURI();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ] parent URI [ {1} ]", new Object[]{entry.getName(), useArchiveUri});
        }
        File file = this.createFile(entry.getName(), entry.getSize(), entry.getTime(), entry.isDirectory());
        logger.logp(Level.FINER, className, methodName, "RETURN file [ {0} ]", file);
        return file;
    }

    protected Archive createNestedArchiveFromBinaries(String uri) throws OpenFailureException {
        String methodName = "createNestedArchiveFromBinaries";
        Archive useArchive = this.getArchive();
        String useArchiveUri = useArchive.getURI();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ] parent URI [ {1} ]", new Object[]{uri, useArchiveUri});
        }
        CommonarchiveFactoryImpl factory = (CommonarchiveFactoryImpl)CommonarchiveFactory.eINSTANCE;
        Archive archive = factory.openNestedArchive(uri, this.getArchive(), true);
        logger.logp(Level.FINER, className, methodName, "RETURN archive [ {0} ]", archive);
        return archive;
    }

    protected void ensureContainerData() {
        String methodName = "ensureContainerData";
        Container useContainer = this.getContainer();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY");
            logger.logp(Level.FINER, className, methodName, "Load strategy [ {0} ]", this);
            logger.logp(Level.FINER, className, methodName, "Container [ {0} ]", this.container);
        }
        this.archiveUri = useContainer.getURI();
        if (useContainer.isReadOnlyDirectory()) {
            logger.logp(Level.FINER, className, methodName, "Read-only directory case");
            ReadOnlyDirectory useDirectory = (ReadOnlyDirectory)useContainer;
            try {
                this.archiveResourcesPath = useDirectory.getAbsolutePath();
            }
            catch (FileNotFoundException e) {
                logger.logp(Level.FINER, className, methodName, "Unable to determine directory path for [ {0} ] in [ {1} ]", new Object[]{this.archiveUri, this});
                logger.throwing(className, methodName, e);
                this.archiveResourcesPath = null;
            }
            if (this.archiveResourcesPath != null) {
                String localizedUri = this.archiveUri;
                if (java.io.File.separatorChar == '\\') {
                    localizedUri = localizedUri.replace('/', '\\');
                }
                if (!this.archiveResourcesPath.endsWith(localizedUri)) {
                    logger.logp(Level.FINER, className, methodName, "Strange: directory [ {0} ] does not show the expected trailing archive URI [ {1} ]", new Object[]{this.archiveResourcesPath, localizedUri});
                } else {
                    if (this.archiveResourcesPath.length() != localizedUri.length()) {
                        this.archiveResourcesPath = this.archiveResourcesPath.substring(0, this.archiveResourcesPath.length() - localizedUri.length());
                    }
                    if (this.archiveResourcesPath.endsWith(java.io.File.separator)) {
                        this.archiveResourcesPath = this.archiveResourcesPath.substring(0, this.archiveResourcesPath.length() - java.io.File.separator.length());
                    }
                    logger.logp(Level.FINER, className, methodName, "Updated archive resources path to [ {0} ]", this.archiveResourcesPath);
                }
            }
            this.archiveBinariesPath = this.archiveResourcesPath;
        } else if (useContainer.isArchive()) {
            logger.logp(Level.FINER, className, methodName, "Archive case");
            Archive useArchive = (Archive)useContainer;
            try {
                this.archiveResourcesPath = useArchive.getResourcesPath();
            }
            catch (FileNotFoundException e) {
                logger.logp(Level.FINER, className, methodName, "Unable to determine archive resources path for [ {0} ] in [ {1} ]", new Object[]{this.archiveUri, this});
                logger.throwing(className, methodName, e);
                this.archiveResourcesPath = null;
            }
            try {
                this.archiveBinariesPath = useArchive.getBinariesPath();
            }
            catch (FileNotFoundException e) {
                logger.logp(Level.FINER, className, methodName, "Unable to determine archive binaries path for [ {0} ] in [ {1} ]", new Object[]{this.archiveUri, this});
                logger.throwing(className, methodName, e);
                this.archiveBinariesPath = null;
            }
        } else {
            logger.logp(Level.FINER, className, methodName, "Non-archive, non-read-only directory case!  Skipping assignment of resources and binaries paths.");
            this.archiveResourcesPath = null;
            this.archiveBinariesPath = null;
        }
        boolean bl = this.archiveBinariesIsDistinct = this.archiveBinariesPath != null && !this.archiveBinariesPath.equals(this.archiveResourcesPath);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "Archive URI [ {0} ]", this.archiveUri);
            logger.logp(Level.FINER, className, methodName, "Archive Resources Path [ {0} ]", this.archiveResourcesPath);
            logger.logp(Level.FINER, className, methodName, "Archive Binaries Path [ {0} ]", this.archiveBinariesPath);
            logger.logp(Level.FINER, className, methodName, "Archive Binaries Is Distinct [ {0} ]", new Boolean(this.archiveBinariesIsDistinct));
        }
        if (this.archiveBinariesIsDistinct) {
            this.archiveBinariesFile = new java.io.File(this.archiveBinariesPath);
            this.archiveBinariesExists = this.archiveBinariesFile.exists();
            boolean bl2 = this.archiveBinariesIsDirectory = this.archiveBinariesExists && this.archiveBinariesFile.isDirectory();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, className, methodName, "Archive Binaries Exists [ {0} ]", new Boolean(this.archiveBinariesExists));
                logger.logp(Level.FINER, className, methodName, "Archive Binaries Is Directory [ {0} ]", new Boolean(this.archiveBinariesIsDirectory));
            }
        }
        this.isSetContainerData = true;
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public String getArchiveURI() {
        if (!this.isSetContainerData) {
            this.ensureContainerData();
        }
        return this.archiveUri;
    }

    public String getArchiveResourcesPath() {
        if (!this.isSetContainerData) {
            this.ensureContainerData();
        }
        return this.archiveResourcesPath;
    }

    public String getArchiveBinariesPath() {
        if (!this.isSetContainerData) {
            this.ensureContainerData();
        }
        return this.archiveBinariesPath;
    }

    public boolean getArchiveBinariesIsDistinct() {
        if (!this.isSetContainerData) {
            this.ensureContainerData();
        }
        return this.archiveBinariesIsDistinct;
    }

    public java.io.File getArchiveBinariesFile() {
        if (!this.isSetContainerData) {
            this.ensureContainerData();
        }
        return this.archiveBinariesFile;
    }

    public boolean getArchiveBinariesExists() {
        if (!this.isSetContainerData) {
            this.ensureContainerData();
        }
        return this.archiveBinariesExists;
    }

    public boolean getArchiveBinariesIsDirectory() {
        if (!this.isSetContainerData) {
            this.ensureContainerData();
        }
        return this.archiveBinariesIsDirectory;
    }

    protected void createTempBinariesFile() throws IOException {
        String methodName = "createTempBinariesFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        Container parentArchive = this.getContainer().getContainer();
        if (parentArchive == null) {
            logger.logp(Level.FINER, className, methodName, "No parent for binaries [ {0} ]", this.archiveBinariesPath);
            throw new FileNotFoundException("No parent for binaries [ " + this.archiveBinariesPath + " ]");
        }
        String useArchiveURI = this.getArchiveURI();
        InputStream archiveInputStream = parentArchive.getInputStream(useArchiveURI);
        this.tempArchiveBinariesFile = ArchiveUtil.writeFileToTemp(useArchiveURI, archiveInputStream, useArchiveURI);
        this.tempArchiveBinariesPath = this.tempArchiveBinariesFile.getCanonicalPath();
        logger.logp(Level.FINER, className, methodName, "Temp archive binaries path [ {0} ]", this.tempArchiveBinariesPath);
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected void deleteTempBinariesFile() {
        String methodName = "deleteTempBinariesFile";
        if (this.tempArchiveBinariesFile != null) {
            logger.logp(Level.FINER, className, methodName, "ENTRY Deleting temp binaries file [ {0} ] ...", this.tempArchiveBinariesPath);
            java.io.File useTempFile = this.tempArchiveBinariesFile;
            String useTempFilePath = this.tempArchiveBinariesPath;
            this.tempArchiveBinariesFile = null;
            this.tempArchiveBinariesPath = null;
            if (!useTempFile.delete()) {
                logger.logp(Level.INFO, className, methodName, "RETURN Strange: Unable to delete temp binaries file [ {0} ]", useTempFilePath);
            } else {
                logger.logp(Level.FINER, className, methodName, "RETURN Deleted temp binaries file [ {0} ]", useTempFilePath);
            }
            DeleteOnExitUtility.fileHasBeenDeleted(useTempFile);
        } else {
            logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN Skipping: Temp extraction was not performed");
        }
    }
}

