/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveURIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipStreamSaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class DirectorySaveStrategyImpl
extends SaveStrategyImpl
implements SaveStrategy {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static final String className;
    protected static Logger logger;
    protected String directoryName;
    protected URIConverter uriConverter;
    protected int expansionFlags;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectorySaveStrategyImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.getName();
        logger = Logger.getLogger(CONFIG_WTP_LOGGER);
    }

    public DirectorySaveStrategyImpl() {
    }

    public DirectorySaveStrategyImpl(String dirName, int flags) {
        this.setDirectoryName(dirName);
        this.setExpansionFlags(flags);
        this.initialize();
    }

    protected SaveStrategy createNestedDirectoryStrategy(Archive anArchive) {
        String uri = ArchiveUtil.getOSUri(this.getDirectoryName(), anArchive.getURI());
        return new DirectorySaveStrategyImpl(uri, this.getExpansionFlags());
    }

    protected SaveStrategy createNestedSaveStrategy(Archive anArchive) throws IOException {
        if (this.shouldExpand(anArchive)) {
            return this.createNestedDirectoryStrategy(anArchive);
        }
        return this.createNestedZipStrategy(anArchive);
    }

    protected SaveStrategy createNestedZipStrategy(Archive anArchive) throws IOException {
        OutputStream out = this.getUriConverter().createOutputStream(URI.createFileURI((String)anArchive.getURI()));
        return new ZipStreamSaveStrategyImpl(out);
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public int getExpansionFlags() {
        return this.expansionFlags;
    }

    protected OutputStream getOutputStreamForResource(Resource aResource) throws IOException {
        return this.getUriConverter().createOutputStream(aResource.getURI());
    }

    public URIConverter getUriConverter() {
        return this.uriConverter;
    }

    public void initialize() {
        ArchiveURIConverterImpl converter = new ArchiveURIConverterImpl(this.getArchive(), this.getDirectoryName());
        converter.setOutputFilepath(this.getDirectoryName());
        this.setUriConverter((URIConverter)converter);
    }

    public boolean isDirectory() {
        return true;
    }

    protected void mkdirs(String directoryPath) {
        java.io.File aDirectory = new java.io.File(String.valueOf(this.getDirectoryName()) + java.io.File.separatorChar + directoryPath);
        aDirectory.mkdirs();
    }

    public void save(ArchiveManifest aManifest) throws SaveFailureException {
        try {
            OutputStream out = this.getUriConverter().createOutputStream(URI.createFileURI((String)"META-INF/MANIFEST.MF"));
            aManifest.write(out);
            out.close();
            if (this.getArchive().getOptions().isReadOnly()) {
                this.setTimestampAfterSaving("META-INF/MANIFEST.MF");
            }
        }
        catch (IOException iox) {
            throw new SaveFailureException(String.valueOf(this.getDirectoryName()) + java.io.File.pathSeparator + "META-INF/MANIFEST.MF", iox);
        }
    }

    public void save(File aFile, InputStream in) throws SaveFailureException {
        String methodName = "save";
        String entryName = aFile.getURI();
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", entryName);
        if (aFile.isDirectoryEntry()) {
            logger.logp(Level.FINER, className, methodName, "Creating directory");
            this.mkdirs(entryName);
        } else {
            logger.logp(Level.FINER, className, methodName, "Writing file");
            try {
                URI targetURI = URI.createFileURI((String)entryName);
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, className, methodName, "URI (URI.createURI.toFileString) [ " + targetURI.toFileString() + " ]");
                    StringBuffer byteOutputBuffer = new StringBuffer();
                    this.dumpBytes(byteOutputBuffer, entryName.getBytes());
                    logger.logp(Level.FINER, className, methodName, "Entry Name Bytes (Default) [ {0} ]", byteOutputBuffer.toString());
                }
                OutputStream out = this.getUriConverter().createOutputStream(targetURI);
                ArchiveUtil.copy(in, out);
                this.setTimestampAfterSaving(aFile);
            }
            catch (IOException iox) {
                throw new SaveFailureException(String.valueOf(this.getDirectoryName()) + java.io.File.pathSeparator + aFile.getURI(), iox);
            }
        }
    }

    protected void dumpBytes(StringBuffer buffer, byte[] bytes) {
        buffer.append("[ ");
        int byteNo = 0;
        while (byteNo < bytes.length) {
            byte nextByte = bytes[byteNo];
            buffer.append("0x");
            buffer.append(Integer.toString(nextByte, 16));
            buffer.append(" ");
            ++byteNo;
        }
        buffer.append("]");
    }

    protected void saveMofResource(Resource aResource, OutputStream os) throws IOException {
        super.saveMofResource(aResource, os);
        os.close();
    }

    public void setDirectoryName(String newDirectoryName) {
        this.directoryName = newDirectoryName;
    }

    public void setExpansionFlags(int newExpansionFlags) {
        this.expansionFlags = newExpansionFlags;
    }

    protected void setTimestampAfterSaving(File aFile) {
        long lastMod = aFile.getLastModified();
        if (lastMod == 0L) {
            return;
        }
        String absPath = ArchiveUtil.getOSUri(this.getDirectoryName(), aFile.getURI());
        java.io.File ioFile = new java.io.File(absPath);
        ioFile.setLastModified(lastMod);
    }

    protected void setTimestampAfterSaving(String uri) {
        File aFile = null;
        try {
            aFile = this.getArchive().getFile(uri);
        }
        catch (FileNotFoundException mustBeANewEntry) {
            return;
        }
        this.setTimestampAfterSaving(aFile);
    }

    public void setUriConverter(URIConverter newUriConverter) {
        this.uriConverter = newUriConverter;
    }

    protected boolean shouldExpand(Archive anArchive) {
        int flag = 0;
        flag = anArchive.isWARFile() ? 2 : (anArchive.isEARFile() ? 4 : (anArchive.isRARFile() ? 64 : (anArchive.isEJBJarFile() ? 8 : (anArchive.isApplicationClientFile() ? 16 : 32))));
        return (this.getExpansionFlags() & flag) != 0;
    }

    protected boolean shouldIterateOver(Archive anArchive) {
        return super.shouldIterateOver(anArchive) || this.shouldExpand(anArchive);
    }
}

