/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResouceFactorySaxRegistry;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryDomRegistry;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ArchiveTypeDiscriminatorRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveURIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIteratorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveWrapperClassLoader;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;

public abstract class LoadStrategyImpl
extends AdapterImpl
implements LoadStrategy {
    protected static String className;
    protected static Logger logger;
    protected boolean isOpen = true;
    protected Container container;
    protected ResourceSet resourceSet;
    protected LooseArchive looseArchive;
    protected Map collectedLooseArchiveFiles = Collections.EMPTY_MAP;
    protected boolean readOnly = false;
    private int rendererType;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.getName();
        logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    }

    public void addOrReplaceMofResource(Resource aResource) {
        Resource existingResource = this.getResourceSet().getResource(aResource.getURI(), false);
        if (existingResource != null) {
            this.getResourceSet().getResources().remove((Object)existingResource);
        }
        this.getResourceSet().getResources().add((Object)aResource);
    }

    protected void updateModificationTracking(Resource res) {
        boolean shouldTrackMods;
        boolean trackingMods = res.isTrackingModification();
        boolean isReadOnly = this.container != null ? ((Archive)this.container).getOptions().isReadOnly() : false;
        boolean bl = shouldTrackMods = !isReadOnly && !ArchiveUtil.isJavaResource(res) && !ArchiveUtil.isRegisteredURIMapping(res);
        if (shouldTrackMods && !trackingMods) {
            res.setTrackingModification(true);
        }
    }

    public void close() {
        this.setIsOpen(false);
        if (this.resourceSet != null && this.resourceSet.eAdapters().contains((Object)this)) {
            this.resourceSet.eAdapters().remove((Object)this);
        }
    }

    protected abstract boolean primContains(String var1);

    public boolean contains(String uri) {
        if (this.containsUsingLooseArchive(uri)) {
            return true;
        }
        return this.primContains(uri);
    }

    protected boolean containsUsingLooseArchive(String uri) {
        if (this.getLooseArchive() == null) {
            return false;
        }
        LooseArchive loose = this.getLooseArchive();
        if (loose.getResourcesPath() == null) {
            return false;
        }
        java.io.File aFile = new java.io.File(loose.getResourcesPath(), uri);
        if (aFile.exists()) {
            return true;
        }
        return LooseConfigRegister.singleton().findFirstLooseChild(uri, loose) != null;
    }

    protected File createDirectory(String uri) {
        File aFile = null;
        aFile = this.getArchiveFactory().createFile();
        aFile.setDirectoryEntry(true);
        aFile.setURI(uri);
        aFile.setOriginalURI(uri);
        aFile.setLoadingContainer(this.getContainer());
        return aFile;
    }

    protected File createFile(String uri, long size, long lastModified, boolean isDirectory) {
        String methodName = "createFile";
        File aFile = this.getArchiveFactory().createFile();
        aFile.setURI(uri);
        aFile.setOriginalURI(uri);
        aFile.setSize(size);
        aFile.setLastModified(lastModified);
        aFile.setDirectoryEntry(isDirectory);
        aFile.setLoadingContainer(this.getContainer());
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", aFile);
        return aFile;
    }

    protected File createFile(String uri, boolean permitNonRelativePaths) {
        return this.createFile(uri, null, permitNonRelativePaths, null, null);
    }

    protected File createFile(String uri) {
        return this.createFile(uri, null, false, null, null);
    }

    protected File createFile(String uri, String fullpath, boolean permitNonRelativePaths, java.io.File directory, String filename) {
        String methodName = "createFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", uri);
        File aFile = null;
        if (permitNonRelativePaths && ArchiveTypeDiscriminatorRegistry.INSTANCE.isKnownArchiveType(uri)) {
            logger.logp(Level.FINER, className, methodName, "Opening non-relative path archive");
            CommonarchiveFactory factory = CommonarchiveFactory.eINSTANCE;
            String filepath = null;
            try {
                filepath = String.valueOf(directory.getPath()) + "/" + filename;
                LoadStrategy childStrategy = factory.createLoadStrategy(filepath);
                ArchiveOptions options = ((Archive)this.container).getOptions().cloneWith(childStrategy, uri);
                aFile = factory.openArchive(options, uri);
            }
            catch (OpenFailureException e) {
                logger.logp(Level.WARNING, className, methodName, "OpenFailureException creating [ {0} ]", filepath);
            }
            catch (FileNotFoundException e) {
                logger.logp(Level.WARNING, className, methodName, "FileNotFoundException creating [ {0} ]", filepath);
            }
            catch (IOException e) {
                logger.logp(Level.WARNING, className, methodName, "IOException creating [ {0} ]", filepath);
            }
        } else if (this.isArchive(uri)) {
            logger.logp(Level.FINER, className, methodName, "Opening nested archive");
            aFile = this.openNestedArchive(uri);
        }
        if (aFile == null) {
            logger.logp(Level.FINER, className, methodName, "Opening plain file");
            aFile = this.primCreateFile(uri);
        }
        aFile.setLoadingContainer(this.getContainer());
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", aFile);
        return aFile;
    }

    protected File primCreateFile(String uri) {
        File file = this.getArchiveFactory().createFile();
        file.setURI(uri);
        file.setOriginalURI(uri);
        return file;
    }

    protected File primCreateFile(String uri, java.io.File baseFile) {
        File file = this.primCreateFile(uri);
        file.setSize(baseFile.length());
        file.setLastModified(baseFile.lastModified());
        return file;
    }

    protected void finalize() throws Throwable {
        if (this.isOpen) {
            this.close();
        }
    }

    public String getAbsolutePath() throws FileNotFoundException {
        String methodName = "getAbsolutePath";
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN Throwing FileNotFoundException");
        throw new FileNotFoundException(CommonArchiveResourceHandler.Absolute_path_unknown_EXC_);
    }

    public String getResourcesPath() throws FileNotFoundException {
        return this.getLooseArchive() == null ? this.getAbsolutePath() : this.getLooseArchive().getResourcesPath();
    }

    protected String primGetResourcesPath() {
        return this.getLooseArchive() == null ? null : this.getLooseArchive().getResourcesPath();
    }

    public String getBinariesPath() throws FileNotFoundException {
        String methodName = "getBinariesPath";
        String uri = this.container.getURI();
        logger.logp(Level.FINER, className, methodName, "ENTRY for archive [ {0} ]", uri);
        LooseArchive la = this.getLooseArchive();
        if (la != null) {
            String looseBinariesPath = la.getBinariesPath();
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] from loose archive", looseBinariesPath);
            return looseBinariesPath;
        }
        logger.logp(Level.FINER, className, methodName, "No loose archive.");
        if (!this.container.isArchive()) {
            logger.logp(Level.FINER, className, methodName, "Non-archive case");
            String nonArchiveBinariesPath = this.getAbsolutePath();
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] for non-archive from absolute path", nonArchiveBinariesPath);
            return nonArchiveBinariesPath;
        }
        logger.logp(Level.FINER, className, methodName, "Archive case");
        Archive archive = (Archive)this.container;
        ArchiveOptions ao = archive.getOptions();
        if (!archive.isEARFile()) {
            String archiveBinariesPath;
            boolean parentIsEar;
            logger.logp(Level.FINER, className, methodName, "Non-EAR case");
            Archive parentArchive = (Archive)archive.getContainer();
            boolean parentIsNull = parentArchive == null;
            boolean bl = parentIsEar = !parentIsNull && parentArchive.isEARFile();
            if (!parentIsNull && !parentIsEar) {
                logger.logp(Level.FINER, className, methodName, "Assigning from parent archive");
                logger.logp(Level.FINER, className, methodName, "Parent Archive [ {0} ]", parentIsNull ? "Is Null" : "Is Not Null");
                if (!parentIsNull) {
                    logger.logp(Level.FINER, className, methodName, "Parent Archive [ Is Not EAR ]");
                }
                archiveBinariesPath = parentArchive.getBinariesPath();
            } else {
                logger.logp(Level.FINER, className, methodName, "Assigning from parent archive through options");
                archiveBinariesPath = ao.getParentEarBinariesPath();
            }
            logger.logp(Level.FINER, className, methodName, "Parent binaries path [ {0} ]", archiveBinariesPath);
            if (archiveBinariesPath != null) {
                logger.logp(Level.FINER, className, methodName, "Appending archive URI.");
                archiveBinariesPath = String.valueOf(archiveBinariesPath) + java.io.File.separatorChar + uri;
            } else {
                logger.logp(Level.FINER, className, methodName, "Null parent path; using absolute path.");
                archiveBinariesPath = this.getAbsolutePath();
            }
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] non-EAR archive case", archiveBinariesPath);
            return archiveBinariesPath;
        }
        logger.logp(Level.FINER, className, methodName, "EAR case");
        String earBinariesPath = ao.getAltBinariesPath();
        logger.logp(Level.FINER, className, methodName, "altBinariesPath [ {0} ]", earBinariesPath);
        if (earBinariesPath == null) {
            logger.logp(Level.FINER, className, methodName, "altBinariesPath is not set; using absolute path.");
            earBinariesPath = this.getAbsolutePath();
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] EAR case", earBinariesPath);
        return earBinariesPath;
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory();
    }

    public Archive getArchive() {
        return (Archive)this.container;
    }

    public Container getContainer() {
        return this.container;
    }

    public ResourceSet primGetResourceSet() {
        return this.resourceSet;
    }

    public boolean requiresIterationOnSave() {
        if (!this.getContainer().isArchive() || this.isDirectory()) {
            return true;
        }
        Archive anArchive = (Archive)this.getContainer();
        if (anArchive.isModuleFile()) {
            return !anArchive.getOptions().isReadOnly();
        }
        if (anArchive.getOptions().isSaveLibrariesAsFiles() && anArchive.getLoadingContainer() != null) {
            if (anArchive.isIndexed()) {
                EList files = anArchive.getFiles();
                File aFile = null;
                Container firstContainer = null;
                Container lContainer = null;
                int i = 0;
                while (i < files.size()) {
                    aFile = (File)files.get(i);
                    if (i == 0 && (firstContainer = aFile.getLoadingContainer()).getLoadStrategy().isDirectory()) {
                        return true;
                    }
                    lContainer = aFile.getLoadingContainer();
                    if (lContainer != firstContainer) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        return true;
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.initializeResourceSet();
            this.resourceSet.eAdapters().add((Object)this);
        }
        return this.resourceSet;
    }

    public void notifyChanged(Notification msg) {
        switch (msg.getEventType()) {
            case 3: {
                this.updateModificationTracking((Resource)msg.getNewValue());
                break;
            }
            case 5: {
                List list = (List)msg.getNewValue();
                int i = 0;
                while (i < list.size()) {
                    this.updateModificationTracking((Resource)list.get(i));
                    ++i;
                }
                break;
            }
        }
    }

    public FileIterator getFileIterator() throws IOException {
        return new FileIteratorImpl((List)this.getContainer().getFiles());
    }

    public abstract List getFiles();

    public List collectFiles() {
        String methodName = "collectFiles";
        String containerURI = "unknown";
        if (this.container != null) {
            containerURI = this.container.getURI();
        }
        logger.logp(Level.FINER, className, methodName, "ENTRY - URI [ {0} ]", containerURI);
        this.collectFilesFromLooseArchives();
        List files = this.getFiles();
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "getFiles collected files:\n";
            Iterator i = files.iterator();
            while (i.hasNext()) {
                msg = String.valueOf(msg) + i.next() + "\n";
            }
            logger.logp(Level.FINEST, className, methodName, msg);
        }
        files.addAll(this.collectedLooseArchiveFiles.values());
        this.collectedLooseArchiveFiles = Collections.EMPTY_MAP;
        this.collectFilesFromBinaries(files);
        logger.logp(Level.FINER, className, methodName, "RETURN Collected a total of [ {0} ] files", Integer.toString(files.size()));
        return files;
    }

    protected void collectFilesFromBinaries(List filesSoFar) {
    }

    protected void collectFilesFromLooseArchives() {
        String methodName = "collectFilesFromLooseArchives";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        if (!this.canHaveLooseChildren() || this.getLooseArchive() == null) {
            this.collectedLooseArchiveFiles = Collections.EMPTY_MAP;
            logger.logp(Level.FINER, className, methodName, "RETURN No loose archive files to collect");
            return;
        }
        this.collectedLooseArchiveFiles = new HashMap();
        List children = LooseConfigRegister.singleton().getLooseChildren(this.getLooseArchive());
        int i = 0;
        while (i < children.size()) {
            Archive archive;
            LooseArchive loose = (LooseArchive)children.get(i);
            String uri = loose.getUri();
            if (!this.collectedLooseArchiveFiles.containsKey(uri) && (archive = this.openNestedArchive(loose)) != null) {
                this.collectedLooseArchiveFiles.put(uri, archive);
                archive.setLoadingContainer(this.getContainer());
            }
            ++i;
        }
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "collectFilesFromLooseArchives collected files:\n";
            Iterator i2 = this.collectedLooseArchiveFiles.values().iterator();
            while (i2.hasNext()) {
                msg = String.valueOf(msg) + i2.next() + "\n";
            }
            logger.logp(Level.FINEST, className, methodName, msg);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN Collected [ {0} ] loose archive files", Integer.toString(this.collectedLooseArchiveFiles.size()));
    }

    public abstract InputStream getInputStream(String var1) throws IOException, FileNotFoundException;

    public InputStream basicGetResourcesInputStream(String uri) throws IOException, FileNotFoundException {
        return this.getInputStream(uri);
    }

    public InputStream getResourceInputStream(String uri) throws IOException {
        return this.getResourceSet().getURIConverter().createInputStream(URI.createURI((String)uri));
    }

    public Collection getLoadedMofResources() {
        EList resources = this.getResourceSet().getResources();
        if (resources.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Resource> result = new ArrayList<Resource>(resources.size());
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            Resource res = (Resource)iter.next();
            if (!res.isLoaded()) continue;
            result.add(res);
        }
        return result;
    }

    public Resource getMofResource(String uri) throws FileNotFoundException, ResourceLoadException {
        try {
            return this.getResourceSet().getResource(URI.createURI((String)uri), true);
        }
        catch (WrappedException wrapEx) {
            if (ExtendedEcoreUtil.getFileNotFoundDetector().isFileNotFound(wrapEx)) {
                FileNotFoundException fileNotFoundEx = ExtendedEcoreUtil.getInnerFileNotFoundException(wrapEx);
                throw fileNotFoundEx;
            }
            this.throwResourceLoadException(uri, (Exception)((Object)wrapEx));
            return null;
        }
    }

    protected void initializeResourceSet() {
        String methodName = "initializeResourceSet";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        Archive archive = (Archive)this.getContainer();
        ArchiveURIConverterImpl converter = new ArchiveURIConverterImpl(archive, this.primGetResourcesPath());
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource.Factory.Registry reg = this.createResourceFactoryRegistry();
        rs.setResourceFactoryRegistry(reg);
        this.setResourceSet((ResourceSet)rs);
        rs.setURIConverter((URIConverter)converter);
        JavaJDKAdapterFactory adapterFactory = new JavaJDKAdapterFactory();
        adapterFactory.setContextClassLoader(this.getWrapperClassLoader(archive));
        adapterFactory.flushAll();
        rs.getAdapterFactories().add((Object)adapterFactory);
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected ClassLoader getWrapperClassLoader(Archive archive) {
        return new ArchiveWrapperClassLoader(archive);
    }

    protected Resource.Factory.Registry createResourceFactoryRegistry() {
        if (this.isReadOnly()) {
            return new J2EEResouceFactorySaxRegistry();
        }
        J2EEResourceFactoryRegistry registry = null;
        switch (this.getRendererType()) {
            case 1: {
                registry = new J2EEResouceFactorySaxRegistry();
                break;
            }
            case 2: {
                registry = new J2EEResourceFactoryDomRegistry();
                break;
            }
            default: {
                registry = new J2EEResourceFactoryRegistry();
            }
        }
        return registry;
    }

    public int getRendererType() {
        return this.rendererType;
    }

    protected boolean isArchive(String uri) {
        return ((Archive)this.getContainer()).isNestedArchive(uri);
    }

    public boolean isClassLoaderNeeded() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public Resource getExistingMofResource(String uri) {
        return this.getResourceSet().getResource(URI.createURI((String)uri), false);
    }

    public boolean isMofResourceLoaded(String uri) {
        Resource res = this.getExistingMofResource(uri);
        return res != null && res.isLoaded();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isUsing(java.io.File aSystemFile) {
        return false;
    }

    public Resource makeMofResource(String uri, EList extent) {
        Resource existing = this.getExistingMofResource(uri);
        if (existing != null) {
            return existing;
        }
        return this.getResourceSet().createResource(URI.createURI((String)uri));
    }

    protected Archive openNestedArchive(String uri) {
        String methodName = "openNestedArchive - uri";
        logger.entering(className, methodName, uri);
        try {
            Archive a = ((Archive)this.getContainer()).openNestedArchive(uri);
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(className, methodName, "Opened [ " + a.getURI() + " ]");
            }
            return a;
        }
        catch (OpenFailureException e) {
            logger.severe(e.getMessage());
            logger.exiting(className, methodName, null);
            return null;
        }
    }

    protected Archive openNestedArchive(LooseArchive loose) {
        String methodName = "openNestedArchive - loose";
        logger.entering(className, methodName, loose.getUri());
        try {
            Archive a = ((Archive)this.getContainer()).openNestedArchive(loose);
            if (a != null) {
                logger.logp(Level.FINER, className, methodName, "RETURN Opened [ {0} ] ", a.getURI());
            } else {
                logger.logp(Level.FINER, className, methodName, "RETURN null");
            }
            return a;
        }
        catch (OpenFailureException e) {
            logger.severe(e.getMessage());
            logger.exiting(className, methodName, null);
            return null;
        }
    }

    public void setContainer(Container newContainer) {
        this.container = newContainer;
    }

    public void setResourceSet(ResourceSet newResourceSet) {
        if (this.resourceSet != newResourceSet) {
            if (this.resourceSet != null) {
                this.resourceSet.eAdapters().remove((Object)this);
            }
            if (newResourceSet != null && !newResourceSet.eAdapters().contains((Object)this)) {
                newResourceSet.eAdapters().add((Object)this);
            }
            this.resourceSet = newResourceSet;
        }
    }

    protected void setIsOpen(boolean newIsOpen) {
        this.isOpen = newIsOpen;
    }

    protected void throwResourceLoadException(String resourceUri, Exception ex) throws ResourceLoadException {
        throw new ResourceLoadException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.load_resource_EXC_, new Object[]{resourceUri, this.getContainer().getURI()}), ex);
    }

    public LooseArchive getLooseArchive() {
        String methodName = "getLooseArchive";
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN [ {0} ] ", this.looseArchive);
        return this.looseArchive;
    }

    public void setLooseArchive(LooseArchive looseArchive) {
        String methodName = "setLooseArchive";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ] ", looseArchive);
        this.looseArchive = looseArchive;
        this.checkLoosePathsValid();
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected void checkLoosePathsValid() {
        String methodName = "checkLoosePathsValid";
        if (this.looseArchive == null) {
            logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN non-applicable, as no loose archive");
            return;
        }
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        String path = this.looseArchive.getBinariesPath();
        logger.logp(Level.FINER, className, methodName, "loose archive binaries path [ {0} ] ", path);
        if (!this.exists(path)) {
            logger.logp(Level.WARNING, className, methodName, "RETURN Throwing ArchiveRuntimeException because binaries path does not exist");
            throw new ArchiveRuntimeException("Invalid binaries path: " + path);
        }
        path = this.looseArchive.getResourcesPath();
        logger.logp(Level.FINER, className, methodName, "loose archive resources path [ {0} ] ", path);
        if (!this.exists(path)) {
            logger.logp(Level.WARNING, className, methodName, "RETURN Throwing ArchiveRuntimeException because resources path does not exist");
            throw new ArchiveRuntimeException("Invalid resources path: " + path);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN loose paths valid");
    }

    private boolean exists(String path) {
        java.io.File ioFile;
        return path != null && (ioFile = new java.io.File(path)).exists();
    }

    protected boolean canHaveLooseChildren() {
        return this.container.isEARFile() || this.container.isWARFile();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setRendererType(int rendererType) {
        this.rendererType = rendererType;
    }

    public List getFiles(String subfolderPath) {
        ArrayList<File> subset = new ArrayList<File>();
        List theFiles = this.getFiles();
        int i = 0;
        while (i < theFiles.size()) {
            File aFile = (File)theFiles.get(i);
            if (aFile.getURI().startsWith(subfolderPath)) {
                subset.add(aFile);
            }
            ++i;
        }
        return subset;
    }

    public String getAdditionalBinariesPath() {
        String resourcesPath;
        String binariesPath;
        String methodName = "getAdditionalBinariesPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY Container URI [ {0} ]", this.getContainer().getURI());
        try {
            binariesPath = this.getBinariesPath();
            logger.logp(Level.FINER, className, methodName, "Binaries Path [ {0} ]", binariesPath);
        }
        catch (FileNotFoundException e) {
            binariesPath = null;
            logger.throwing(className, methodName, e);
            logger.logp(Level.SEVERE, className, methodName, "Unable to obtain binaries path for archive [ {0} ]", this.getContainer().getURI());
        }
        try {
            resourcesPath = this.getResourcesPath();
            logger.logp(Level.FINER, className, methodName, "Resource Path [ {0} ]", resourcesPath);
        }
        catch (FileNotFoundException e) {
            logger.logp(Level.FINER, className, methodName, "Unable to obtain resources path for archive [ {0} ]", this.getContainer().getURI());
            resourcesPath = null;
        }
        if (binariesPath == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN null (no binaries path)");
            return null;
        }
        if (resourcesPath != null && binariesPath.equals(resourcesPath)) {
            logger.logp(Level.FINER, className, methodName, "RETURN null (paths are the same)");
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] (paths are different)", binariesPath);
        return binariesPath;
    }
}

