/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.NestedJarException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.NestedArchiveIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;

public class NestedArchiveLoadStrategyImpl
extends LoadStrategyImpl {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME;
    protected LoadStrategy parent;
    protected Map urisToPositions;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.NestedArchiveLoadStrategyImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
    }

    public NestedArchiveLoadStrategyImpl(LoadStrategy parentStrategy) {
        this.setParent(parentStrategy);
        logger.logp(Level.FINER, CLASS_NAME, "constructor", "Initial construction");
    }

    public void setContainer(Container newContainer) {
        super.setContainer(newContainer);
        if (logger.isLoggable(Level.FINER)) {
            Container thisContainer = this.getContainer();
            Container parentContainer = this.getParent() == null ? null : this.getParent().getContainer();
            logger.logp(Level.FINER, CLASS_NAME, "setContainer", "Strategy for [ {0} ] within parent [ {1} ]", new String[]{thisContainer == null ? null : thisContainer.getURI(), parentContainer == null ? null : parentContainer.getURI()});
        }
    }

    protected boolean primContains(String uri) {
        if (this.usingIndex()) {
            return this.containsUsingIndex(uri);
        }
        return this.containsSequentially(uri);
    }

    public FileIterator getFileIterator() throws IOException {
        if (((Archive)this.getContainer()).getOptions().isReadOnly()) {
            return new NestedArchiveIterator((List)this.getContainer().getFiles(), this.getZipInputStream());
        }
        return super.getFileIterator();
    }

    public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
        if (this.usingIndex()) {
            return this.getInputStreamUsingIndex(uri);
        }
        return this.getInputStreamSequentially(uri);
    }

    public void setParent(LoadStrategy parent) {
        this.parent = parent;
    }

    public LoadStrategy getParent() {
        return this.parent;
    }

    protected ZipInputStream getZipInputStream() throws IOException, FileNotFoundException {
        String uri = this.getContainer().getURI();
        InputStream in = this.getParent().getInputStream(uri);
        return new ZipInputStream(in);
    }

    protected ZipInputStream getZipInputStreamSkippedTo(String uri) throws IOException, FileNotFoundException {
        if (uri == null) {
            throw new NullPointerException(CommonArchiveResourceHandler.Null_uri_EXC_);
        }
        ZipInputStream zis = this.getZipInputStream();
        ZipEntry entry = null;
        try {
            while ((entry = zis.getNextEntry()) != null) {
                if (!uri.equals(entry.getName())) continue;
                ZipInputStream zipInputStream = zis;
                return zipInputStream;
            }
            throw new FileNotFoundException(uri);
        }
        finally {
            if (entry == null) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected boolean containsSequentially(String uri) {
        try {
            ZipInputStream zis = this.getZipInputStreamSkippedTo(uri);
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    protected InputStream getInputStreamSequentially(String uri) throws IOException, FileNotFoundException {
        return new BufferedInputStream(this.getZipInputStreamSkippedTo(uri));
    }

    public List getFiles() throws NestedJarException {
        ZipInputStream zis;
        try {
            zis = this.getZipInputStream();
        }
        catch (IOException iox) {
            throw this.newNestedJarException(iox);
        }
        try {
            ZipEntry entry;
            ArrayList<File> list = new ArrayList<File>(500);
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                File aFile = this.createFile(entry.getName());
                aFile.setSize(entry.getSize());
                aFile.setLastModified(entry.getTime());
                list.add(aFile);
            }
            ArrayList<File> arrayList = list;
            return arrayList;
        }
        catch (IOException iox) {
            throw this.newNestedJarException(iox);
        }
        finally {
            try {
                zis.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean usingIndex() {
        return false;
    }

    public Map getUrisToPositions() {
        if (this.usingIndex() && this.urisToPositions == null) {
            this.buildIndex();
        }
        return this.urisToPositions;
    }

    public void setUrisToPositions(Map urisToPositions) {
        this.urisToPositions = urisToPositions;
    }

    protected void buildIndex() throws NestedJarException {
        this.setUrisToPositions(this.generateIndex());
    }

    protected Map generateIndex() throws NestedJarException {
        ZipInputStream zis;
        try {
            zis = this.getZipInputStream();
        }
        catch (IOException iox) {
            throw this.newNestedJarException(iox);
        }
        try {
            HashMap<String, Long> map = new HashMap<String, Long>();
            long position = 0L;
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                map.put(entry.getName(), new Long(++position));
            }
            HashMap<String, Long> hashMap = map;
            return hashMap;
        }
        catch (IOException iox) {
            throw this.newNestedJarException(iox);
        }
        finally {
            try {
                zis.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected boolean containsUsingIndex(String uri) {
        return this.getUrisToPositions().containsKey(uri);
    }

    protected InputStream getInputStreamUsingIndex(String uri) throws IOException, FileNotFoundException {
        Long position = (Long)this.getUrisToPositions().get(uri);
        if (position == null) {
            throw new FileNotFoundException();
        }
        ZipInputStream zis = this.getZipInputStream();
        try {
            long offset = position;
            while (offset > 0L) {
                zis.getNextEntry();
                --offset;
            }
            ZipInputStream consumeZip = zis;
            zis = null;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(consumeZip);
            return bufferedInputStream;
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void throwNestedJarException(Exception caughtException) throws NestedJarException {
        String errorMessage = CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.nested_jar_EXC_, new Object[]{this.getContainer().getURI(), this.getParent().getContainer().getURI()});
        throw new NestedJarException(errorMessage, caughtException);
    }

    protected NestedJarException newNestedJarException(Exception caughtException) {
        String errorMessage = CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.nested_jar_EXC_, new Object[]{this.getContainer().getURI(), this.getParent().getContainer().getURI()});
        return new NestedJarException(errorMessage, caughtException);
    }
}

