/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityURIConverter;

public class ZipStreamSaveStrategyImpl
extends SaveStrategyImpl
implements SaveStrategy {
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String className;
    protected OutputStream destinationStream;
    protected ZipOutputStream zipOutputStream;
    protected HashSet priorParentNames;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipStreamSaveStrategyImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.getName();
    }

    public ZipStreamSaveStrategyImpl(OutputStream out) {
        String methodName = "ZipStreamSaveStrategyImpl";
        this.setDestinationStream(out);
        this.setZipOutputStream(new ZipOutputStream(out));
        this.initPriorParentNames();
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN: ZipStreamSaveStrategyImpl(OutputStream) [ {0} ]", this);
    }

    public void close() throws IOException {
        String methodName = "close";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", this);
        this.getDestinationStream().close();
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected SaveStrategy createNestedSaveStrategy(Archive anArchive) {
        return new ZipStreamSaveStrategyImpl(this.getZipOutputStream());
    }

    public void finish() throws IOException {
        String methodName = "finish";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", this);
        this.getZipOutputStream().finish();
        if (!(this.getDestinationStream() instanceof ZipOutputStream)) {
            logger.logp(Level.FINER, className, methodName, "Not a zip stream; closing destination stream");
            this.getDestinationStream().close();
        } else {
            logger.logp(Level.FINER, className, methodName, "Zip stream; skipping close of destination stream");
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public OutputStream getDestinationStream() {
        return this.destinationStream;
    }

    protected OutputStream getOutputStreamForResource(Resource aResource) throws IOException {
        return this.getZipOutputStream();
    }

    public void saveMofResource(Resource aResource, OutputStream out) throws IOException {
        URIConverter conv;
        String methodName = "saveMofResource";
        URI uri = aResource.getURI();
        String entryName = uri.toString();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ] Resource [ {1} ]", new Object[]{this, entryName});
        }
        if ((conv = this.getArchive().getResourceSet().getURIConverter()) instanceof CompatibilityURIConverter) {
            uri = ((CompatibilityURIConverter)conv).deNormalize(uri);
            entryName = uri.toString();
            logger.logp(Level.FINER, className, methodName, "Updated URI to [ {0} ]", entryName);
        }
        this.putParentEntries(entryName);
        ZipEntry entry = new ZipEntry(entryName);
        this.prepareEntry(entry);
        super.saveMofResource(aResource, out);
        this.completeEntry(entry);
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected ZipOutputStream getZipOutputStream() {
        return this.zipOutputStream;
    }

    public void save(ArchiveManifest aManifest) throws SaveFailureException {
        String methodName = "save(ArchiveManifest)";
        String entryName = "META-INF/MANIFEST.MF";
        logger.logp(Level.FINER, className, methodName, "ENTRY Entry Name [ {0} ]", entryName);
        try {
            this.putParentEntries(entryName);
            ZipEntry entry = new ZipEntry(entryName);
            this.prepareEntry(entry);
            aManifest.write(this.getZipOutputStream());
            this.completeEntry(entry);
        }
        catch (IOException iox) {
            logger.throwing(className, methodName, iox);
            throw new SaveFailureException("META-INF/MANIFEST.MF", iox);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void save(Archive anArchive) throws SaveFailureException {
        String methodName = "save(Archive)";
        String entryName = anArchive.getURI();
        logger.logp(Level.FINER, className, methodName, "ENTRY Entry Name [ {0} ]", entryName);
        try {
            this.putParentEntries(entryName);
            ZipEntry entry = new ZipEntry(entryName);
            this.prepareEntry(entry);
            super.save(anArchive);
            this.completeEntry(entry);
        }
        catch (IOException iox) {
            logger.throwing(className, methodName, iox);
            throw new SaveFailureException(entryName, iox);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void save(File aFile, InputStream in) throws SaveFailureException {
        String methodName = "save(File, InputStream)";
        String entryName = aFile.getURI();
        if (aFile.isDirectoryEntry() && !entryName.endsWith("/")) {
            entryName = String.valueOf(entryName) + '/';
        }
        if (aFile.isDirectoryEntry() && !this.testAddParentName(entryName)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN Entry Name [ {0} ] - Already added as a directory", entryName);
            return;
        }
        logger.logp(Level.FINER, className, methodName, "ENTRY Entry Name [ {0} ]", entryName);
        long lastModified = aFile.getLastModified();
        try {
            this.putParentEntries(entryName);
            ZipEntry entry = new ZipEntry(entryName);
            if (lastModified > 0L) {
                entry.setTime(lastModified);
            }
            this.prepareEntry(entry);
            if (!aFile.isDirectoryEntry()) {
                ArchiveUtil.copy(in, this.getZipOutputStream());
            }
            this.completeEntry(entry);
        }
        catch (IOException iox) {
            logger.throwing(className, methodName, iox);
            throw new SaveFailureException(aFile.getURI(), iox);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void setDestinationStream(OutputStream newDestinationStream) {
        this.destinationStream = newDestinationStream;
    }

    protected void setZipOutputStream(ZipOutputStream newZipOutputStream) {
        this.zipOutputStream = newZipOutputStream;
    }

    protected void putParentEntries(String entryName) throws IOException {
        List parentNames = this.getParentNames(entryName);
        if (parentNames == null) {
            return;
        }
        Iterator useParentNames = parentNames.iterator();
        while (useParentNames.hasNext()) {
            String nextParentName = (String)useParentNames.next();
            if (!this.testAddParentName(nextParentName)) continue;
            this.addDirectoryEntry(nextParentName);
        }
    }

    protected List getParentNames(String entryName) {
        String methodName = "getParentEntries";
        ArrayList<String> parentNames = null;
        int entryLim = entryName.length() - 1;
        int entryIndex = 0;
        while (entryIndex < entryLim) {
            if (entryName.charAt(entryIndex) == '/') {
                String nextParentName = entryName.substring(0, entryIndex + 1);
                if (parentNames == null) {
                    parentNames = new ArrayList<String>();
                }
                parentNames.add(nextParentName);
            }
            ++entryIndex;
        }
        logger.logp(Level.FINER, className, methodName, "Entry Name [ " + entryName + " ] RETURN [ " + parentNames + " ]");
        return parentNames;
    }

    protected void initPriorParentNames() {
        this.priorParentNames = new HashSet();
    }

    protected boolean testAddParentName(String entryName) {
        return this.priorParentNames.add(entryName);
    }

    protected void addDirectoryEntry(String entryName) throws IOException {
        String methodName = "addDirectoryEntry";
        logger.logp(Level.FINER, className, methodName, "Entry Name [ {0} ]", entryName);
        ZipEntry directoryEntry = new ZipEntry(entryName);
        this.prepareEntry(directoryEntry);
        this.completeEntry(directoryEntry);
    }

    protected void prepareEntry(ZipEntry entry) throws IOException {
        this.getZipOutputStream().putNextEntry(entry);
    }

    protected void completeEntry(ZipEntry entry) throws IOException {
        this.getZipOutputStream().closeEntry();
    }
}

