/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.jem.java.JavaURL;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.EmptyResourceException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveURIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.DeleteOnExitUtility;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.xml.XmlDocumentReader;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ArchiveUtil {
    protected static final Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String className;
    public static final String DOT_CLASS = ".class";
    public static final String DOT_JAVA = ".java";
    public static final String DOT_SQLJ = ".sqlj";
    public static final String DOT_JSP = ".jsp";
    protected static boolean isRuntime;
    protected static boolean shouldUseTempDirectoryForRead;
    protected static String tempDirectoryName;
    protected static java.io.File tempDirectory;
    protected static boolean isAIX;
    public static final int COPY_BUFFER_SIZE = 32768;
    public static final boolean DO_ADD_DIRECTORIES = true;
    public static final boolean DONT_ADD_DIRECTORIES = false;
    public static final boolean DO_LIST_DETAILS = true;
    public static final boolean DONT_LIST_DETAILS = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.getName();
        isRuntime = false;
        shouldUseTempDirectoryForRead = true;
        String osName = System.getProperty("os.name");
        isAIX = osName != null && osName.equalsIgnoreCase("AIX");
    }

    public static String classNameToJavaUri(String className) {
        return className.replace('.', '/').concat(DOT_JAVA);
    }

    public static String classNameToUri(String className) {
        return className.replace('.', '/').concat(DOT_CLASS);
    }

    public static String classUriToJavaUri(String classUri) {
        if (classUri == null || !classUri.endsWith(DOT_CLASS)) {
            return null;
        }
        String truncated = ArchiveUtil.truncateIgnoreCase(classUri, DOT_CLASS);
        StringTokenizer tok = new StringTokenizer(truncated, "$");
        return tok.nextToken().concat(DOT_JAVA);
    }

    public static String concatUri(String directoryname, String filename, char separator) {
        String uri = directoryname;
        if (!directoryname.endsWith(String.valueOf(separator)) && !filename.startsWith(String.valueOf(separator))) {
            uri = String.valueOf(uri) + separator;
        }
        return String.valueOf(uri) + filename;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int n = in.read(buffer);
            while (n > 0) {
                out.write(buffer, 0, n);
                n = in.read(buffer);
            }
        }
        finally {
            if (!(in instanceof ZipInputStream)) {
                in.close();
            }
            if (!(out instanceof ZipOutputStream)) {
                out.close();
            }
        }
    }

    public static java.io.File createTempDirectory(String baseName, java.io.File parentDirectory) throws IOException {
        java.io.File tempFile;
        String methodName = "createTempDirectory";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ] [ {1} ]", new Object[]{baseName, parentDirectory});
        }
        if ((tempFile = ArchiveUtil.createTempFile(baseName, parentDirectory)).exists()) {
            if (!tempFile.delete()) {
                logger.logp(Level.SEVERE, className, methodName, "Could not delete new temporary file [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{tempFile, baseName, parentDirectory});
            } else {
                logger.logp(Level.FINER, className, methodName, "Deleted new temporary file [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{tempFile, baseName, parentDirectory});
            }
        } else {
            logger.logp(Level.SEVERE, className, methodName, "New temporary file already deleted [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{tempFile, baseName, parentDirectory});
        }
        if (!tempFile.mkdir()) {
            logger.logp(Level.WARNING, className, methodName, "Could not create temporary directory [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{tempFile, baseName, parentDirectory});
            if (!parentDirectory.exists()) {
                logger.logp(Level.SEVERE, className, methodName, "Parent directory does not exist [ {0} ] with basename [ {1} ] and parent directory [ {2} ]", new Object[]{tempFile, baseName, parentDirectory});
            }
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", tempFile);
        return tempFile;
    }

    public static java.io.File createTempFile(String baseName) throws IOException {
        return ArchiveUtil.createTempFile(baseName, ArchiveUtil.getTempDirectory());
    }

    public static java.io.File createTempFile(String baseName, java.io.File directory) throws IOException {
        String fileName;
        String methodName = "createTempFile";
        boolean isLoggable = logger.isLoggable(Level.FINER);
        if (isLoggable) {
            logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ] [ {1} ]", new Object[]{baseName, directory});
        }
        if (directory == null) {
            if (isLoggable) {
                logger.logp(Level.FINER, className, methodName, "No temporary location was specified; using the system defined location");
            }
        } else if (!directory.exists()) {
            if (isLoggable) {
                logger.logp(Level.FINER, className, methodName, "Temporary location does not exist!");
            }
            logger.logp(Level.WARNING, className, methodName, "Specified temporary directory [ {0} ] with basename [ {1} ] does not exist; using system temporary directory", new Object[]{directory, baseName});
            directory = null;
            String tempDir = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("java.io.tmpdir");
                }
            });
            if (isLoggable) {
                logger.logp(Level.FINER, className, methodName, "system temporary directory [ {0} ]", tempDir);
            }
        } else if (!directory.isDirectory()) {
            logger.logp(Level.SEVERE, className, methodName, "Temporary location [ {0} ] with basename [ {1} ] is not a directory", new Object[]{directory, baseName});
        }
        if ((fileName = ArchiveUtil.getFileNameTail(baseName)).length() < 3) {
            fileName = "WSTMP" + fileName;
        }
        if (isLoggable) {
            logger.logp(Level.FINER, className, methodName, "Temp File Prefix: [ {0} ]", fileName);
        }
        java.io.File tempFile = java.io.File.createTempFile(fileName, null, directory);
        if (isLoggable) {
            if (!tempFile.exists()) {
                logger.logp(Level.WARNING, className, methodName, "Temp File Was Not Created: [ {0} ]", tempFile);
            }
            logger.logp(Level.FINER, className, methodName, "RETURN Temp File: [ {0} ]", tempFile);
        }
        return tempFile;
    }

    public static boolean delete(java.io.File aFile) {
        java.io.File[] files;
        if (aFile == null) {
            return true;
        }
        if (aFile.isDirectory() && (files = aFile.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                if (!ArchiveUtil.delete(files[i])) {
                    return false;
                }
                ++i;
            }
        }
        return aFile.delete();
    }

    public static List getWriteProtectedFiles(java.io.File aFile, List aList) {
        if (aList == null) {
            aList = new ArrayList<java.io.File>();
        }
        if (aFile.exists() && !aFile.canWrite()) {
            aList.add(aFile);
        }
        if (aFile.isDirectory()) {
            java.io.File[] files = aFile.listFiles();
            int i = 0;
            while (i < files.length) {
                ArchiveUtil.getWriteProtectedFiles(files[i], aList);
                ++i;
            }
        }
        return aList;
    }

    public static String deriveEARRelativeURI(String classpathEntry, Archive anArchive) {
        return ArchiveUtil.deriveEARRelativeURI(classpathEntry, anArchive.getURI());
    }

    public static String deriveEARRelativeURI(String classpathEntry, String archiveUri) {
        String resolvedPath;
        String workingDir;
        String methodName = "deriveEARRelativeURI";
        logger.logp(Level.FINER, className, methodName, "ENTRY Archive [ {0} ] and classpath entry [ {1} ]", new Object[]{archiveUri, classpathEntry});
        try {
            workingDir = new java.io.File(".").getCanonicalPath();
        }
        catch (IOException e) {
            logger.logp(Level.FINER, className, methodName, "Unable to obtain canonical path for current directory processing archive [ {0} ] and classpath entry [ {1} ]", new Object[]{archiveUri, classpathEntry});
            logger.throwing(className, methodName, e);
            logger.logp(Level.FINER, className, methodName, "RETURN relative URI [ {0} ]", (Object)null);
            return null;
        }
        logger.logp(Level.FINEST, className, methodName, "Working directory [ {0} ]", workingDir);
        String parent = ArchiveUtil.getFileNameParent(archiveUri);
        if (parent == null || parent.equals("")) {
            parent = ".";
        }
        logger.logp(Level.FINEST, className, methodName, "Selected parent [ {0} ]", parent);
        try {
            resolvedPath = new java.io.File(parent, classpathEntry).getCanonicalPath();
        }
        catch (IOException e) {
            logger.logp(Level.WARNING, className, methodName, "Unable to obtain canonical path for resolved entry processing archive [ {0} ], classpath entry [ {1} ], and parent [ {2} ]", new Object[]{archiveUri, classpathEntry, parent});
            logger.throwing(className, methodName, e);
            logger.logp(Level.FINEST, className, methodName, "RETURN relative URI [ {0} ]", (Object)null);
            return null;
        }
        logger.logp(Level.FINEST, className, methodName, "Resolved entry [ {0} ]", resolvedPath);
        String resolvedPathLowerCase = resolvedPath.toLowerCase();
        String workingDirLowerCase = workingDir.toLowerCase();
        if (!resolvedPathLowerCase.startsWith(workingDirLowerCase)) {
            logger.logp(Level.FINER, className, methodName, "Resolved entry reaches outside of parent application for archive [ {0} ], classpath entry [ {1} ], parent [ {2} ], and resolve entry [ {3} ]", new Object[]{archiveUri, classpathEntry, parent, resolvedPath});
            logger.logp(Level.FINEST, className, methodName, "RETURN relative URI [ {0} ]", (Object)null);
            return null;
        }
        if (resolvedPathLowerCase.equals(workingDirLowerCase)) {
            logger.logp(Level.WARNING, className, methodName, "Resolved entry maps to parent application for archive [ {0} ], classpath entry [ {1} ], parent [ {2} ], and resolve entry [ {3} ]", new Object[]{archiveUri, classpathEntry, parent, resolvedPath});
            logger.logp(Level.FINEST, className, methodName, "RETURN relative URI [ {0} ]", (Object)null);
            return null;
        }
        int start = workingDir.length() == 0 ? 0 : (workingDir.endsWith(java.io.File.separator) ? workingDir.length() : workingDir.length() + 1);
        String resolvedEntry = resolvedPath.substring(start, resolvedPath.length());
        resolvedEntry = resolvedEntry.replace(java.io.File.separatorChar, '/');
        logger.logp(Level.FINEST, className, methodName, "RETURN relative URI [ {0} ]", resolvedEntry);
        return resolvedEntry;
    }

    public static String getFileNameExtension(String uri) {
        int index;
        if (uri != null && (index = uri.lastIndexOf(".")) != -1) {
            return uri.substring(index + 1);
        }
        return "";
    }

    public static String getFileNameParent(String uri) {
        int lastIndex;
        String methodName = "getFileNameParent";
        if (uri == null) {
            logger.logp(Level.WARNING, className, methodName, "RETURN null; null module URI.");
            return "";
        }
        String tempURI = uri.replace('\\', '/');
        if (tempURI.endsWith("/")) {
            logger.logp(Level.WARNING, className, methodName, "Module URI has trailing file separator characters [ {0} ]", uri);
            while (tempURI.endsWith("/")) {
                tempURI = tempURI.substring(0, tempURI.length() - 1);
            }
        }
        if ((lastIndex = tempURI.lastIndexOf(47)) == -1) {
            return "";
        }
        if (lastIndex == 0) {
            logger.logp(Level.WARNING, className, methodName, "RETURN '/'; module URI has a leading separator [ {0} ]", uri);
            return "/";
        }
        String result = uri.substring(0, lastIndex);
        logger.logp(Level.FINER, className, methodName, "RETURN trimmed URI [ {0} ]", result);
        return result;
    }

    public static String getFileNameTail(String uri) {
        String tempURI = uri.replace('\\', '/');
        while (tempURI.endsWith("/")) {
            tempURI = tempURI.substring(0, tempURI.length() - 1);
        }
        int lastIndex = tempURI.lastIndexOf(47);
        if (lastIndex == -1) {
            return uri;
        }
        return uri.substring(lastIndex + 1, tempURI.length());
    }

    public static ModuleFile getModuleFile(EObject ddObject) {
        String methodName = "getModuleFile";
        logger.entering(className, methodName, ddObject);
        Resource res = ddObject.eResource();
        if (res == null) {
            logger.exiting(className, methodName, "No resource found.  Returning null.");
            return null;
        }
        Archive archive = ArchiveUtil.getArchive(res);
        if (archive == null || !archive.isModuleFile()) {
            logger.exiting(className, methodName, "Archive resource is not a module.  Returning null.");
            return null;
        }
        if (!(res instanceof XMLResource)) {
            logger.exiting(className, methodName, "Archive resource is not an XML Resource.  Returning null.");
            return null;
        }
        XMLResource xmlRes = (XMLResource)res;
        if (xmlRes.isAlt()) {
            ModuleFile mf = ArchiveUtil.getModuleFileUsingAltDD((EARFile)archive, res);
            logger.logp(Level.FINER, className, methodName, "RETURN module file found using altDD [ {0} ]", mf);
            return mf;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN module file found [{0}]", archive);
        return (ModuleFile)archive;
    }

    protected static ModuleFile getModuleFileUsingAltDD(EARFile ear, Resource res) {
        if (res == null) {
            return null;
        }
        String uri = res.getURI().toString();
        Module m = ear.getDeploymentDescriptor().getModuleHavingAltDD(uri);
        if (m == null) {
            return null;
        }
        ModuleRef ref = ear.getModuleRef(m);
        if (ref == null) {
            return null;
        }
        return ref.getModuleFile();
    }

    public static String getModuleFileTypeName(int moduleType) {
        switch (moduleType) {
            case 2: {
                return CommonArchiveResourceHandler.A_Application_file;
            }
            case 1: {
                return CommonArchiveResourceHandler.An_Application_Client_JAR_file;
            }
            case 3: {
                return CommonArchiveResourceHandler.An_EJB_JAR_file;
            }
            case 4: {
                return CommonArchiveResourceHandler.A_WAR_file;
            }
            case 5: {
                return CommonArchiveResourceHandler.A_RAR_file;
            }
        }
        return null;
    }

    public static Archive getArchive(Resource res) {
        String methodName = "getArchive";
        logger.entering(className, methodName, res);
        if (res == null) {
            logger.exiting(className, methodName, "Resource is null.  Returning null.");
            return null;
        }
        ResourceSet set = res.getResourceSet();
        if (set == null) {
            logger.exiting(className, methodName, "Resource Set is null.  Returning null.");
            return null;
        }
        URIConverter conv = set.getURIConverter();
        if (conv == null || !(conv instanceof ArchiveURIConverterImpl)) {
            logger.exiting(className, methodName, "Archive URI Converter not found.  Returning null.");
            return null;
        }
        Archive a = ((ArchiveURIConverterImpl)conv).getArchive();
        logger.logp(Level.FINER, className, methodName, "RETURN archive [{0}]", a);
        return a;
    }

    public static String getOSUri(String uri) {
        char sep = java.io.File.separatorChar;
        if (sep != '/') {
            return uri.replace('/', sep);
        }
        return uri.replace('\\', sep);
    }

    public static String getOSUri(String directoryname, String filename) {
        String osDirName = ArchiveUtil.getOSUri(directoryname);
        String osFileName = ArchiveUtil.getOSUri(filename);
        return ArchiveUtil.concatUri(osDirName, osFileName, java.io.File.separatorChar);
    }

    public static EObject getRoot(Resource aResource) throws EmptyResourceException {
        EList extent = aResource.getContents();
        if (extent.size() < 1) {
            throw new EmptyResourceException(aResource.getURI().toString());
        }
        return (EObject)extent.get(0);
    }

    public static java.io.File getTempDirectory() {
        return tempDirectory;
    }

    public static String getTempDirectoryName() {
        return tempDirectoryName;
    }

    public static String[] getTokens(String aString) {
        return ArchiveUtil.getTokens(aString, null);
    }

    public static String[] getTokens(String aString, String delimiter) {
        StringTokenizer tok = delimiter == null ? new StringTokenizer(aString) : new StringTokenizer(aString, delimiter);
        int size = tok.countTokens();
        String[] tokens = new String[size];
        int i = 0;
        while (i < size && tok.hasMoreTokens()) {
            tokens[i] = tok.nextToken();
            ++i;
        }
        return tokens;
    }

    public static String getValueIgnoreKeyCase(String key, Attributes attr) {
        Iterator<Map.Entry<Object, Object>> keysAndValues = attr.entrySet().iterator();
        while (keysAndValues.hasNext()) {
            Map.Entry<Object, Object> entry = keysAndValues.next();
            String entryKey = entry.getKey().toString();
            if (!entryKey.equalsIgnoreCase(key)) continue;
            return entry.getValue() == null ? null : entry.getValue().toString();
        }
        return null;
    }

    public static void inform(String message) {
        logger.logp(Level.FINER, className, "inform", message);
    }

    public static byte[] inputStreamToBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArchiveUtil.copy(in, out);
        return out.toByteArray();
    }

    public static boolean isJavaResource(Resource aResource) {
        return JavaURL.isJavaURL(aResource.getURI().toString());
    }

    public static boolean isRegisteredURIMapping(Resource res) {
        return URIMappingRegistryImpl.INSTANCE.getURI(res.getURI()) != res.getURI();
    }

    public static boolean isPlatformMetaResource(Resource res) {
        URI uri = res.getURI();
        return "platform".equals(uri.scheme()) && "meta".equals(uri.segment(0));
    }

    public static boolean isNullOrEmpty(String aString) {
        return aString == null || aString.trim().length() == 0;
    }

    public static boolean isRuntime() {
        return isRuntime;
    }

    public static boolean isValidDependency(Archive referencedJAR, Archive referencingJAR) {
        if (referencedJAR.isWARFile()) {
            return false;
        }
        if (referencedJAR == referencingJAR) {
            return false;
        }
        return referencingJAR.isApplicationClientFile() || !referencedJAR.isApplicationClientFile();
    }

    public static Properties loadProperties(Archive archive, String uri) throws FileNotFoundException, IOException {
        InputStream in = null;
        try {
            in = archive.getInputStream(uri);
            Properties p = new Properties();
            p.load(in);
            Properties properties = p;
            return properties;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void setIsRuntime(boolean aBoolean) {
        isRuntime = aBoolean;
    }

    public static void setShouldUseTempDirectoryForRead(boolean value) {
        String methodName = "setShouldUseTempDirectoryForRead";
        logger.logp(Level.FINER, className, methodName, "Old Value [ {0} ] -- New Value [ {1} ]", new Object[]{new Boolean(shouldUseTempDirectoryForRead), new Boolean(value)});
        shouldUseTempDirectoryForRead = value;
    }

    public static void setTempDirectory(java.io.File newTempDirectory) {
        String methodName = "setTempDirectory";
        logger.logp(Level.FINER, className, methodName, "Old Value [ {0} ] -- New Value [ {1} ]", new Object[]{tempDirectory, newTempDirectory});
        tempDirectory = newTempDirectory;
        tempDirectoryName = newTempDirectory.getAbsolutePath();
        logger.logp(Level.FINER, className, methodName, "'tempDirectoryName' (absolute path) [ {0} ]", tempDirectoryName);
        if (!tempDirectory.exists()) {
            logger.logp(Level.WARNING, className, methodName, "Temporary directory [ {0} ] does not exist", tempDirectory);
        } else if (!tempDirectory.isDirectory()) {
            logger.logp(Level.SEVERE, className, methodName, "Temporary directory [ {0} ] is not a directory", tempDirectory);
        } else {
            logger.logp(Level.FINER, className, methodName, "Temporary directory verified to exist and is a directory.");
        }
    }

    public static void setTempDirectoryName(String newTempDirectoryName) throws ArchiveException {
        String methodName = "setTempDirectoryName";
        logger.logp(Level.FINER, className, methodName, "ENTER; New name [ {0} ]", newTempDirectoryName);
        java.io.File dir = new java.io.File(newTempDirectoryName);
        if (!dir.exists()) {
            dir.mkdirs();
            if (!dir.exists()) {
                logger.logp(Level.WARNING, className, methodName, "Failed to create temporary directory.");
                ArchiveException ex = new ArchiveException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.make_temp_dir_EXC_, new Object[]{newTempDirectoryName}));
                logger.throwing(className, methodName, ex);
                throw ex;
            }
            logger.logp(Level.FINER, className, methodName, "Verified that the temporary directory exists; marking for deletion.");
            DeleteOnExitUtility.markForDeletion(dir);
        }
        ArchiveUtil.setTempDirectory(dir);
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public static boolean shouldUseTempDirectoryForRead() {
        return shouldUseTempDirectoryForRead;
    }

    public static URL[] toLocalURLs(List entries, String uriRoot) {
        ArrayList<URL> urls = new ArrayList<URL>();
        int i = 0;
        while (i < entries.size()) {
            block22: {
                String pathEntry = (String)entries.get(i);
                java.io.File aFile = new java.io.File(pathEntry);
                if (!aFile.isAbsolute()) {
                    pathEntry = ArchiveUtil.getOSUri(uriRoot, pathEntry);
                    aFile = new java.io.File(pathEntry);
                }
                if (aFile.exists()) {
                    if (aFile.isDirectory()) {
                        if (!pathEntry.endsWith(java.io.File.separator)) {
                            pathEntry = String.valueOf(pathEntry) + java.io.File.separatorChar;
                        }
                    } else {
                        ZipFile zip = null;
                        try {
                            try {
                                ArchiveUtil.aixDisplay("ArchiveUtil.toLocalURLs");
                                zip = new ZipFile(aFile);
                            }
                            catch (Exception ex) {
                                ArchiveUtil.inform(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.invalid_classpath_WARN_, new Object[]{pathEntry}));
                                if (zip != null) {
                                    try {
                                        zip.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block22;
                            }
                        }
                        catch (Throwable throwable) {
                            if (zip != null) {
                                try {
                                    zip.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (zip != null) {
                            try {
                                zip.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    try {
                        aFile = new java.io.File(pathEntry);
                        URL aUrl = aFile.toURL();
                        urls.add(aUrl);
                    }
                    catch (MalformedURLException ex) {
                        ArchiveUtil.inform(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.invalid_cp_file_WARN_, new Object[]{pathEntry}));
                    }
                }
            }
            ++i;
        }
        URL[] urlArray = new URL[urls.size()];
        return urls.toArray(urlArray);
    }

    public static String truncateFromFrontIgnoreCase(String aString, String leadingSubString) {
        if (!aString.toLowerCase().startsWith(leadingSubString.toLowerCase())) {
            return aString;
        }
        return aString.substring(leadingSubString.length(), aString.length());
    }

    public static String truncateIgnoreCase(String aString, String trailingSubString) {
        int index = aString.toLowerCase().lastIndexOf(trailingSubString.toLowerCase());
        if (index != -1) {
            return aString.substring(0, index);
        }
        return aString;
    }

    public static String uriToClassName(String uri) {
        return ArchiveUtil.truncateIgnoreCase(uri.replace('/', '.'), DOT_CLASS);
    }

    /*
     * Loose catch block
     */
    public static boolean isJ2EE13FastCheck(ModuleFile moduleFile) {
        String[] ids;
        DocumentType docType;
        InputStream in;
        block24: {
            block23: {
                if (moduleFile == null) {
                    return false;
                }
                if (moduleFile.isRARFile()) {
                    return true;
                }
                in = null;
                String uri = moduleFile.getDeploymentDescriptorUri();
                in = moduleFile.getInputStream(uri);
                docType = XmlDocumentReader.readDocumentType(in, uri);
                if (docType != null) break block23;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            ids = ArchiveUtil.getJ2EE13PublicAndSystemIdFor(moduleFile);
            if (ids != null) break block24;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        boolean bl = ids[0].equals(docType.getPublicId()) && ids[1].equals(docType.getSystemId());
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
        catch (IOException ex) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected static String[] getJ2EE13PublicAndSystemIdFor(ModuleFile moduleFile) {
        if (moduleFile.isEARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "http://java.sun.com/dtd/application_1_3.dtd"};
        }
        if (moduleFile.isEJBJarFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "http://java.sun.com/dtd/ejb-jar_2_0.dtd"};
        }
        if (moduleFile.isApplicationClientFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN", "http://java.sun.com/dtd/application-client_1_3.dtd"};
        }
        if (moduleFile.isWARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "http://java.sun.com/dtd/web-app_2_3.dtd"};
        }
        if (moduleFile.isRARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "http://java.sun.com/dtd/connector_1_0.dtd"};
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static int getFastSpecVersion(ModuleFile moduleFile) {
        InputStream in = null;
        String uri = moduleFile.getDeploymentDescriptorUri();
        in = moduleFile.getInputStream(uri);
        DocumentType docType = null;
        InputSource source = new InputSource(in);
        XmlDocumentReader aReader = new XmlDocumentReader(source);
        aReader.setValidate(false);
        Document aDocument = aReader.parseDocument();
        if (aDocument != null) {
            docType = aDocument.getDoctype();
        }
        int version = -1;
        if (docType != null) {
            String publicID = docType.getPublicId();
            String systemID = docType.getSystemId();
            if (publicID != null && systemID != null) {
                version = ArchiveUtil.lookupVersion(moduleFile, publicID, systemID);
            }
        }
        if (version == -1) {
            NamedNodeMap map;
            String schemaName = null;
            String versionString = null;
            if (aDocument != null && docType == null && (map = aDocument.getDocumentElement().getAttributes()) != null) {
                Node versionNode;
                Node schemaNode = map.getNamedItem("xsi:schemaLocation");
                if (schemaNode != null) {
                    schemaName = schemaNode.getNodeValue();
                }
                if ((versionNode = map.getNamedItem("version")) != null) {
                    versionString = versionNode.getNodeValue();
                }
            }
            if (schemaName != null) {
                version = ArchiveUtil.lookupVersion(moduleFile, schemaName);
            }
            if (version == -1) {
                version = ArchiveUtil.parseVersionString(moduleFile, versionString);
            }
        }
        int n = version;
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
        catch (IOException ex) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return -1;
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static int parseVersionString(ModuleFile moduleFile, String versionAttr) {
        int version = -1;
        if (moduleFile.isEARFile()) {
            version = versionAttr == null ? 14 : (versionAttr.equals("1.2") ? 12 : (versionAttr.equals("1.3") ? 13 : 14));
        } else if (moduleFile.isEJBJarFile()) {
            version = versionAttr == null ? 21 : (versionAttr.equals("1.1") ? 11 : (versionAttr.equals("2.0") ? 20 : 21));
        } else if (moduleFile.isApplicationClientFile()) {
            version = versionAttr == null ? 14 : (versionAttr.equals("1.2") ? 12 : (versionAttr.equals("1.3") ? 13 : 14));
        } else if (moduleFile.isWARFile()) {
            version = versionAttr == null ? 24 : (versionAttr.equals("2.2") ? 22 : (versionAttr.equals("2.3") ? 23 : 24));
        } else if (moduleFile.isRARFile()) {
            version = versionAttr == null ? 15 : (versionAttr.equals("1.0") ? 10 : 15);
        }
        return version;
    }

    private static int lookupVersion(ModuleFile moduleFile, String schemaName) {
        int version = -1;
        if (moduleFile.isEARFile()) {
            if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd")) {
                version = 14;
            }
        } else if (moduleFile.isEJBJarFile()) {
            if (schemaName.indexOf("http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd") != -1) {
                version = 21;
            }
        } else if (moduleFile.isApplicationClientFile()) {
            if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd")) {
                version = 14;
            }
        } else if (moduleFile.isWARFile()) {
            if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd")) {
                version = 24;
            }
        } else if (moduleFile.isRARFile() && schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd")) {
            version = 15;
        }
        return version;
    }

    private static int lookupVersion(ModuleFile moduleFile, String publicID, String systemID) {
        int version = -1;
        if (moduleFile.isEARFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN") && (systemID.equals("http://java.sun.com/dtd/application_1_3.dtd") || systemID.equals("http://java.sun.com/dtd/application_1.3.dtd")) ? 13 : (publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/application_1_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/application_1.2.dtd")) ? 12 : 14);
        } else if (moduleFile.isEJBJarFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN") && (systemID.equals("http://java.sun.com/dtd/ejb-jar_2_0.dtd") || systemID.equals("http://java.sun.com/dtd/ejb-jar_2.0.dtd")) ? 20 : (publicID.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1.1.dtd")) ? 11 : 21);
        } else if (moduleFile.isApplicationClientFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN") && (systemID.equals("http://java.sun.com/dtd/application-client_1_3.dtd") || systemID.equals("http://java.sun.com/dtd/application-client_1.3.dtd")) ? 13 : (publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/application-client_1_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/application-client_1.2.dtd")) ? 12 : 14);
        } else if (moduleFile.isWARFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN") && (systemID.equals("http://java.sun.com/dtd/web-app_2_3.dtd") || systemID.equals("http://java.sun.com/dtd/web-app_2.3.dtd")) ? 23 : (publicID.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/web-app_2.2.dtd")) ? 22 : 24);
        } else if (moduleFile.isRARFile()) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN") && (systemID.equals("http://java.sun.com/dtd/connector_1_0.dtd") || systemID.equals("http://java.sun.com/dtd/connector_1.0.dtd")) ? 10 : 15;
        }
        return version;
    }

    protected static void aixDisplay(String text) {
        if (ArchiveUtil.getIsAIX()) {
            System.out.println(text);
        }
    }

    protected static boolean getIsAIX() {
        return isAIX;
    }

    public static void dumpStackTrace(String className, String methodName) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        StringBuffer sb = new StringBuffer("Stack trace of " + methodName + " caller:\n\n");
        Throwable ex = new Throwable();
        StackTraceElement[] traceElements = ex.getStackTrace();
        int i = 0;
        while (i < traceElements.length) {
            sb.append("                                                              ").append(traceElements[i] + "\n");
            ++i;
        }
        logger.logp(Level.FINER, className, methodName, sb.toString());
    }

    public static Set collectFileUris(Iterator files) {
        HashSet<String> fileUris = new HashSet<String>();
        while (files.hasNext()) {
            File nextFile = (File)files.next();
            fileUris.add(nextFile.getURI());
        }
        return fileUris;
    }

    public static java.io.File writeFileToTemp(String sourceName, InputStream sourceStream, String baseTempName) throws IOException {
        String methodName = "writeFileToTemp";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        java.io.File tempFile = ArchiveUtil.createTempFileWithFallback(baseTempName);
        String tempName = tempFile.getName();
        logger.logp(Level.FINER, className, methodName, "Opening output [ {0} ]", tempName);
        FileOutputStream tempStream = new FileOutputStream(tempFile);
        try {
            long bytesWritten = ArchiveUtil.transfer(sourceName, sourceStream, tempName, tempStream);
        }
        finally {
            ((OutputStream)tempStream).close();
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", tempFile);
        return tempFile;
    }

    public static java.io.File extractFileToTemp(String sourceZipName, String sourceEntryName, String baseTempName) throws IOException {
        String methodName = "extractFileToTemp";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        java.io.File tempFile = ArchiveUtil.createTempFileWithFallback(baseTempName);
        ArchiveUtil.transferEntryOut(sourceZipName, sourceEntryName, tempFile);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", tempFile);
        return tempFile;
    }

    public static java.io.File createTempFileWithFallback(String baseName) throws IOException {
        java.io.File tempFile;
        String methodName = "createTempFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", baseName);
        java.io.File tempDir = ArchiveUtil.getTempDirectory();
        logger.logp(Level.FINER, className, methodName, "Using temporary directory [ {0} ] ", tempDir);
        try {
            tempFile = ArchiveUtil.createTempFile(baseName);
            logger.logp(Level.FINER, className, methodName, "Using temporary file [ {0} ] ", tempFile);
        }
        catch (IOException firstException) {
            logger.logp(Level.WARNING, className, methodName, "Failed to create temp file in defined preset temporary directory.");
            logger.throwing(className, methodName, firstException);
            try {
                tempFile = ArchiveUtil.createTempFile(baseName, null);
            }
            catch (IOException secondException) {
                logger.logp(Level.WARNING, className, methodName, "Failed to create temp file in system temporary directory.");
                logger.throwing(className, methodName, secondException);
                throw firstException;
            }
        }
        DeleteOnExitUtility.markForDeletion(tempFile);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", tempFile);
        return tempFile;
    }

    public static void transferEntryOut(String sourceZipName, String sourceEntryName, java.io.File outputFile) throws IOException {
        String methodName = "transferEntryOut";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        logger.logp(Level.FINER, className, methodName, "Opening output [ {0} ]", outputFile.getName());
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        try {
            logger.logp(Level.FINER, className, methodName, "Opening source zip [ {0} ]", sourceZipName);
            ZipFile sourceZipFile = new ZipFile(sourceZipName);
            try {
                logger.logp(Level.FINER, className, methodName, "Locating source entry [ {0} ]", sourceEntryName);
                ZipEntry sourceEntry = sourceZipFile.getEntry(sourceEntryName);
                if (sourceEntry == null) {
                    throw new FileNotFoundException("Could not find [ " + sourceEntryName + " ] in [ " + sourceZipName + " ]");
                }
                logger.logp(Level.FINER, className, methodName, "Opening source entry input stream [ {0} ]", sourceEntryName);
                BufferedInputStream sourceEntryStream = new BufferedInputStream(sourceZipFile.getInputStream(sourceEntry));
                long bytesWritten = ArchiveUtil.transfer(sourceEntryName, sourceEntryStream, outputFile.getName(), outputStream);
            }
            finally {
                sourceZipFile.close();
            }
        }
        finally {
            ((OutputStream)outputStream).close();
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public static long transfer(String sourceName, InputStream sourceStream, String targetName, OutputStream targetStream) throws IOException {
        int nextRead;
        String methodName = "transfer";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTER copy from [ {0} ] to [ {1} ]", new Object[]{sourceName, targetName});
        }
        byte[] buffer = new byte[32768];
        long totalRead = 0L;
        while ((nextRead = sourceStream.read(buffer)) > 0) {
            totalRead += (long)nextRead;
            targetStream.write(buffer, 0, nextRead);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", new Long(totalRead));
        }
        return totalRead;
    }

    public static String concatenateUris(String parentUri, String childUri) {
        if (parentUri == null || parentUri.length() == 0) {
            return childUri;
        }
        if (childUri == null || childUri.length() == 0) {
            return parentUri;
        }
        return String.valueOf(parentUri) + "/" + childUri;
    }

    public static List listArchiveEntries(java.io.File file, boolean addDirectories, boolean listDetails) throws IOException {
        String methodName = "listArchiveEntries";
        String fileName = file.getName();
        logger.logp(Level.FINEST, className, methodName, "ENTRY [ {0} ]", fileName);
        ArrayList<Object> entryNames = new ArrayList<Object>();
        JarFile jarFile = new JarFile(file);
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry nextEntry = entries.nextElement();
                String nextEntryName = nextEntry.getName();
                if (!addDirectories && nextEntry.isDirectory()) {
                    logger.logp(Level.FINEST, className, methodName, "Skipping directory archive entry [ {0} ]", nextEntryName);
                    continue;
                }
                logger.logp(Level.FINEST, className, methodName, "Next archive entry [ {0} ]", nextEntryName);
                if (listDetails) {
                    entryNames.add(new EntryDetails(nextEntry));
                    continue;
                }
                entryNames.add(nextEntryName);
            }
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                logger.logp(Level.WARNING, className, methodName, "Failed to close archive file [ {0} ]", fileName);
            }
        }
        return entryNames;
    }

    public static class EntryDetails {
        public final String name;
        public final long size;
        public final long lastModified;
        public final boolean isDirectory;

        public EntryDetails(ZipEntry zipEntry) {
            this.name = zipEntry.getName();
            this.size = zipEntry.getSize();
            this.lastModified = zipEntry.getTime();
            this.isDirectory = zipEntry.isDirectory();
        }
    }
}

