/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import java.io.FileNotFoundException;
import java.security.ProtectionDomain;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveFileDynamicClassLoader;

public class RarFileDynamicClassLoader
extends ArchiveFileDynamicClassLoader {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.util.RarFileDynamicClassLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
    }

    public RarFileDynamicClassLoader(Archive anArchive, ClassLoader parentCl, ClassLoader extraCl, ProtectionDomain protectionDomain) {
        super(anArchive, parentCl, extraCl, protectionDomain);
        logger.logp(Level.FINER, CLASS_NAME, "Constructor with protection domain on archive [ {0} ]", anArchive.getURI());
    }

    public RarFileDynamicClassLoader(Archive anArchive, ClassLoader parentCl, ClassLoader extraCl) {
        this(anArchive, parentCl, extraCl, null);
    }

    protected File getFile(String name) {
        String methodName = "getFile";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY: Target file [ {0} ]", name);
        Iterator children = this.getRarFile().getArchiveFiles().iterator();
        while (children.hasNext()) {
            Archive nextChildJar = (Archive)children.next();
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Testing child JAR [ {0} ]", nextChildJar.getURI());
            try {
                File targetFile = nextChildJar.getFile(name);
                logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN: Located file in child JAR");
                return targetFile;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Failed to locate in child JAR; trying dependency JAR");
        File targetFile = this.getFileFromDependentJar(name);
        if (targetFile != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN: Located file in dependency jar");
            return targetFile;
        }
        if (this.getRarFile().getLoadStrategy().getLooseArchive() == null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN: Failed to locate file in dependency jar (non-loose case)");
            return null;
        }
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Failed to locate file in dependency jar.  Trying direct file (loose module case)");
        try {
            targetFile = this.getRarFile().getFile(name);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (targetFile == null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN: Failed to locate direct file (loose module case)");
        } else {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN: Located as direct file (loose module case)");
        }
        return targetFile;
    }

    private RARFile getRarFile() {
        return (RARFile)this.getArchive();
    }
}

