/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.j2ee.common.internal.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.internal.model.translator.ejb.EJBJarTranslator;
import org.eclipse.wst.common.internal.emf.resource.J2EESchemaUtility;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public class EJBResourceImpl
extends XMLResourceImpl
implements EJBResource {
    public EJBResourceImpl(URI uri, Renderer aRenderer) {
        super(uri, aRenderer);
    }

    public EJBResourceImpl(Renderer aRenderer) {
        super(aRenderer);
    }

    public boolean isEJB1_1() {
        return this.getModuleVersionID() == 11;
    }

    public boolean isEJB2_0() {
        return this.getModuleVersionID() == 20;
    }

    public int getType() {
        return 3;
    }

    public String getDoctype() {
        switch (this.getJ2EEVersionID()) {
            case 12: 
            case 13: {
                return "ejb-jar";
            }
        }
        return null;
    }

    public String getJ2EE_1_2_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    }

    public String getJ2EE_1_2_SystemID() {
        return "http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd";
    }

    public String getJ2EE_Alt_1_2_SystemID() {
        return "http://java.sun.com/j2ee/dtds/ejb-jar_1.1.dtd";
    }

    public String getJ2EE_1_3_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    }

    public String getJ2EE_1_3_SystemID() {
        return "http://java.sun.com/dtd/ejb-jar_2_0.dtd";
    }

    public String getJ2EE_Alt_1_3_SystemID() {
        return "http://java.sun.com/dtd/ejb-jar_2.0.dtd";
    }

    public Translator getRootTranslator() {
        return EJBJarTranslator.INSTANCE;
    }

    public int getJ2EEVersionID() {
        switch (this.getModuleVersionID()) {
            case 10: {
                return 12;
            }
            case 11: {
                return 12;
            }
            case 20: {
                return 13;
            }
            case 21: {
                return 14;
            }
        }
        return 14;
    }

    public EJBJar getEJBJar() {
        return (EJBJar)this.getRootObject();
    }

    public void setBatchMode(boolean isBatch) {
        this.renderer.setBatchMode(isBatch);
    }

    public void setModuleVersionID(int id) {
        super.setVersionID(id);
        switch (id) {
            case 21: {
                super.setDoctypeValues(null, null);
                break;
            }
            case 20: {
                super.setDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
                break;
            }
            case 11: {
                super.setDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
                break;
            }
            case 10: {
                super.setDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
            }
        }
        this.syncVersionOfRootObject();
    }

    public void setJ2EEVersionID(int id) {
        switch (id) {
            case 14: {
                this.primSetDoctypeValues(null, null);
                this.primSetVersionID(21);
                break;
            }
            case 13: {
                this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
                this.primSetVersionID(20);
                break;
            }
            case 12: {
                this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
                this.primSetVersionID(11);
            }
        }
        this.syncVersionOfRootObject();
    }

    protected int getDefaultVersionID() {
        return 21;
    }

    protected void syncVersionOfRootObject() {
        EJBJar ejbJar = this.getEJBJar();
        if (ejbJar == null) {
            return;
        }
        String version = ejbJar.getVersion();
        String newVersion = this.getModuleVersionString();
        if (!newVersion.equals(version)) {
            ejbJar.setVersion(newVersion);
        }
    }

    public boolean isBatchMode() {
        return this.renderer.isBatchMode();
    }

    protected byte[] getElementBytes() {
        return J2EESchemaUtility.EJB_JAR_BYTES;
    }

    protected byte[] getVersionBytes() {
        return J2EESchemaUtility.VERSION_2_1_BYTES;
    }

    protected byte[] getSchemaLocationBytes() {
        return J2EESchemaUtility.EJB_JAR_2_1_BYTES;
    }
}

