/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.archive.operations.EARComponentSaveStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.J2EEArtifactImportOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class EARComponentImportOperation
extends J2EEArtifactImportOperation {
    protected EARArtifactEdit artifactEdit = null;

    public EARComponentImportOperation(IDataModel model) {
        super(model);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExecute(IProgressMonitor monitor) throws ExecutionException {
        block16: {
            super.doExecute(monitor);
            List modelsToImport = (List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.HANDLED_PROJECT_MODELS_LIST");
            try {
                IDataModel importModel = null;
                int i = modelsToImport.size() - 1;
                while (i > 0) {
                    importModel = (IDataModel)modelsToImport.get(i);
                    Archive nestedArchive = (Archive)importModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
                    if (nestedArchive.getURI().startsWith("WEB-INF/lib/")) {
                        WARFile owningWar = (WARFile)nestedArchive.eContainer();
                        modelsToImport.remove(importModel);
                        int j = 0;
                        while (j < modelsToImport.size()) {
                            IDataModel warModel = (IDataModel)modelsToImport.get(j);
                            if (warModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE") == owningWar) {
                                String archivesSelected = "WARImportDataModel.WEB_LIB_ARCHIVES_SELECTED";
                                String libModels = "WARImportDataModel.WEB_LIB_MODELS";
                                ArrayList<Archive> warHandledArchives = (ArrayList<Archive>)warModel.getProperty(archivesSelected);
                                if (warHandledArchives == Collections.EMPTY_LIST) {
                                    warHandledArchives = new ArrayList<Archive>();
                                    warModel.setProperty(archivesSelected, warHandledArchives);
                                }
                                warHandledArchives.add(nestedArchive);
                                List warLibModels = (List)warModel.getProperty(libModels);
                                int k = 0;
                                while (k < warLibModels.size()) {
                                    IDataModel libModel = (IDataModel)warLibModels.get(k);
                                    if (libModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE") == nestedArchive) {
                                        libModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", importModel.getProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME"));
                                        libModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", importModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME"));
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                    --i;
                }
                ArrayList<IVirtualComponent> componentToAdd = new ArrayList<IVirtualComponent>();
                HashMap<IVirtualComponent, String> componentToURIMap = new HashMap<IVirtualComponent, String>();
                int i2 = 0;
                while (i2 < modelsToImport.size()) {
                    importModel = (IDataModel)modelsToImport.get(i2);
                    Archive nestedArchive = (Archive)importModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
                    importModel.setProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose", Boolean.FALSE);
                    IDataModel compCreationModel = importModel.getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION");
                    if (compCreationModel.isProperty("IJ2EEFacetProjectCreationDataModelProperties.MODULE_URI")) {
                        compCreationModel.setProperty("IJ2EEFacetProjectCreationDataModelProperties.MODULE_URI", nestedArchive.getURI());
                    }
                    try {
                        importModel.getDefaultOperation().execute(monitor, this.info);
                    }
                    catch (ExecutionException e) {
                        Logger.getLogger().logError(e);
                    }
                    IVirtualComponent component = (IVirtualComponent)importModel.getProperty("IJ2EEComponentImportDataModelProperties.COMPONENT");
                    componentToAdd.add(component);
                    componentToURIMap.put(component, nestedArchive.getURI());
                    ++i2;
                }
                if (componentToAdd.size() > 0) {
                    IDataModel addComponentsDM = DataModelFactory.createDataModel((IDataModelProvider)((Object)new AddComponentToEnterpriseApplicationDataModelProvider()));
                    addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", this.virtualComponent);
                    addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", componentToAdd);
                    addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", componentToURIMap);
                    addComponentsDM.getDefaultOperation().execute(monitor, this.info);
                }
            }
            catch (Throwable throwable) {
                Object var15_22 = null;
                if (this.artifactEdit != null) {
                    this.artifactEdit.dispose();
                    this.artifactEdit = null;
                }
                this.resetDisposeImportModels();
                throw throwable;
            }
            {
                Object var15_23 = null;
                if (this.artifactEdit == null) break block16;
            }
            this.artifactEdit.dispose();
            this.artifactEdit = null;
        }
        this.resetDisposeImportModels();
    }

    private void resetDisposeImportModels() {
        this.resetDisposeImportModels((List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST"));
    }

    private void resetDisposeImportModels(List models) {
        int i = 0;
        while (i < models.size()) {
            IDataModel model = (IDataModel)models.get(i);
            model.setProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose", Boolean.TRUE);
            ++i;
        }
    }

    protected SaveStrategy createSaveStrategy(IProject project) {
        return null;
    }

    protected SaveStrategy createSaveStrategy(IVirtualComponent virtualComponent) {
        return new EARComponentSaveStrategyImpl(virtualComponent);
    }

    protected EARFile getEarFile() {
        return (EARFile)this.model.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
    }
}

