/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.operations;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class J2EEModifierHelperCreator {
    public static ModifierHelper createAssemblyDescriptorHelper(EJBJar anEJBJar) {
        if (anEJBJar == null || anEJBJar.getAssemblyDescriptor() != null) {
            return null;
        }
        EjbPackage pack = EjbFactoryImpl.getPackage();
        EReference sf = pack.getEJBJar_AssemblyDescriptor();
        return new ModifierHelper((EObject)anEJBJar, (EStructuralFeature)sf, null);
    }

    public static ModifierHelper createMethodElementAsCopyHelper(MethodElement element, SecurityRole role) {
        if (role == null) {
            return null;
        }
        ModifierHelper tempHelper = new ModifierHelper();
        J2EEModifierHelperCreator.setMethodPermissionOwnerHelper(tempHelper, role);
        tempHelper.setFeature((EStructuralFeature)J2EEModifierHelperCreator.getEjbPackage().getMethodPermission_MethodElements());
        tempHelper.setValue((Object)EtoolsCopyUtility.createCopy(element));
        return tempHelper;
    }

    public static ModifierHelper createMethodElementHelper(EnterpriseBean bean, SecurityRole role, String methodType, String methodSig) {
        if (role == null) {
            return null;
        }
        ModifierHelper tempHelper = new ModifierHelper();
        J2EEModifierHelperCreator.setMethodPermissionOwnerHelper(tempHelper, role);
        tempHelper.setFeature((EStructuralFeature)J2EEModifierHelperCreator.getEjbPackage().getMethodPermission_MethodElements());
        tempHelper.addAttribute((EStructuralFeature)J2EEModifierHelperCreator.getEjbPackage().getMethodElement_Type(), (Object)methodType);
        int index = methodSig.indexOf("(");
        String methodName = methodSig;
        String methodParms = null;
        if (index > -1) {
            methodName = methodSig.substring(0, index);
            methodParms = methodSig.substring(index + 1, methodSig.length() - 1);
        }
        if (methodParms != null) {
            methodParms = methodParms.replace(',', ' ');
        }
        tempHelper.addAttribute((EStructuralFeature)J2EEModifierHelperCreator.getEjbPackage().getMethodElement_Name(), (Object)methodName);
        if (methodParms != null) {
            tempHelper.addAttribute((EStructuralFeature)J2EEModifierHelperCreator.getEjbPackage().getMethodElement_Parms(), (Object)methodParms);
        }
        tempHelper.addAttribute((EStructuralFeature)J2EEModifierHelperCreator.getEjbPackage().getMethodElement_EnterpriseBean(), (Object)bean);
        return tempHelper;
    }

    public static ModifierHelper createMethodElementHelper(EnterpriseBean bean, String methodType, String methodSig, String transType) {
        if (bean == null) {
            return null;
        }
        ModifierHelper ownerHelper = J2EEModifierHelperCreator.createMethodTransactionHelper((EJBJar)bean.eContainer(), transType);
        ModifierHelper tempHelper = new ModifierHelper();
        tempHelper.setOwnerHelper(ownerHelper);
        tempHelper.setFeature((EStructuralFeature)J2EEModifierHelperCreator.getEjbPackage().getMethodTransaction_MethodElements());
        tempHelper.addAttribute((EStructuralFeature)J2EEModifierHelperCreator.getEjbPackage().getMethodElement_Type(), (Object)methodType);
        int index = methodSig.indexOf("(");
        String methodName = methodSig;
        String methodParms = null;
        if (index > -1) {
            methodName = methodSig.substring(0, index);
            methodParms = methodSig.substring(index + 1, methodSig.length() - 1);
        }
        if (methodParms != null) {
            methodParms = methodParms.replace(',', ' ');
        }
        tempHelper.addAttribute((EStructuralFeature)J2EEModifierHelperCreator.getEjbPackage().getMethodElement_Name(), (Object)methodName);
        if (methodParms != null) {
            tempHelper.addAttribute((EStructuralFeature)J2EEModifierHelperCreator.getEjbPackage().getMethodElement_Parms(), (Object)methodParms);
        }
        tempHelper.addAttribute((EStructuralFeature)J2EEModifierHelperCreator.getEjbPackage().getMethodElement_EnterpriseBean(), (Object)bean);
        return tempHelper;
    }

    public static ModifierHelper createMethodPermissionHelper(SecurityRole role) {
        if (role == null) {
            return null;
        }
        AssemblyDescriptor assembly = (AssemblyDescriptor)role.eContainer();
        EReference sf = EjbPackage.eINSTANCE.getAssemblyDescriptor_MethodPermissions();
        ModifierHelper tempHelper = new ModifierHelper((EObject)assembly, (EStructuralFeature)sf, null);
        tempHelper.addAttribute((EStructuralFeature)J2EEModifierHelperCreator.getEjbPackage().getMethodPermission_Roles(), (Object)role);
        return tempHelper;
    }

    public static ModifierHelper createMethodTransactionHelper(EJBJar anEJBJar, String aTransType) {
        if (anEJBJar == null) {
            return null;
        }
        ModifierHelper helper = new ModifierHelper();
        J2EEModifierHelperCreator.setAssemblyDescriptorOwnerHelper(helper, anEJBJar);
        helper.setFeature((EStructuralFeature)J2EEModifierHelperCreator.getEjbPackage().getAssemblyDescriptor_MethodTransactions());
        helper.addAttribute((EStructuralFeature)J2EEModifierHelperCreator.getEjbPackage().getMethodTransaction_TransactionAttribute(), (Object)aTransType);
        return helper;
    }

    protected static CommonPackage getCommonPackage() {
        return CommonPackage.eINSTANCE;
    }

    protected static EjbPackage getEjbPackage() {
        return EjbFactoryImpl.getPackage();
    }

    public static void setAssemblyDescriptorOwnerHelper(ModifierHelper helper, EJBJar anEJBJar) {
        ModifierHelper ownerHelper = J2EEModifierHelperCreator.createAssemblyDescriptorHelper(anEJBJar);
        if (ownerHelper == null) {
            helper.setOwner((EObject)anEJBJar.getAssemblyDescriptor());
        } else {
            helper.setOwnerHelper(ownerHelper);
        }
    }

    public static void setMethodPermissionOwnerHelper(ModifierHelper helper, SecurityRole role) {
        ArrayList<SecurityRole> roleList = new ArrayList<SecurityRole>(1);
        roleList.add(role);
        MethodPermission permission = ((AssemblyDescriptor)role.eContainer()).getMethodPermission(roleList);
        ModifierHelper ownerHelper = null;
        if (permission == null) {
            ownerHelper = J2EEModifierHelperCreator.createMethodPermissionHelper(role);
        }
        if (ownerHelper == null) {
            helper.setOwner((EObject)permission);
        } else {
            helper.setOwnerHelper(ownerHelper);
        }
    }
}

