/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.jca.operations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.internal.archive.operations.ConnectorComponentSaveStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.J2EEArtifactImportOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ConnectorComponentImportOperation
extends J2EEArtifactImportOperation {
    private static final String JAR_EXTENSION = ".jar";

    public ConnectorComponentImportOperation(IDataModel model) {
        super(model);
    }

    protected void doExecute(IProgressMonitor monitor) throws ExecutionException {
        super.doExecute(monitor);
        this.addAssociateArchivesToClassPath();
    }

    protected void addAssociateArchivesToClassPath() {
        ArrayList<IClasspathEntry> extraEntries = new ArrayList<IClasspathEntry>();
        List archiveList = this.moduleFile.getArchiveFiles();
        Iterator iterator = archiveList.iterator();
        IVirtualFile vFile = null;
        IFile file = null;
        while (iterator.hasNext()) {
            Archive anArchive = (Archive)iterator.next();
            if (!anArchive.getName().endsWith(JAR_EXTENSION) || !(vFile = this.virtualComponent.getRootFolder().getFile(anArchive.getURI())).exists()) continue;
            file = vFile.getUnderlyingFile();
            extraEntries.add(JavaCore.newLibraryEntry((IPath)file.getFullPath(), (IPath)file.getFullPath(), null, (boolean)true));
        }
        try {
            ConnectorComponentImportOperation.addToClasspath(this.getDataModel(), extraEntries);
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError(e);
        }
    }

    protected static void addToClasspath(IDataModel importModel, List extraEntries) throws JavaModelException {
        if (extraEntries.size() > 0) {
            IJavaProject javaProject = JavaCore.create((IProject)((IVirtualComponent)importModel.getProperty("IJ2EEComponentImportDataModelProperties.COMPONENT")).getProject());
            ConnectorComponentImportOperation.addToClasspath(extraEntries, javaProject);
        }
    }

    protected static void addToClasspath(List extraEntries, IJavaProject javaProject) throws JavaModelException {
        if (extraEntries.size() > 0) {
            IClasspathEntry[] javaClasspath = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> nonDuplicateList = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < extraEntries.size()) {
                IClasspathEntry extraEntry = (IClasspathEntry)extraEntries.get(i);
                boolean include = true;
                int j = 0;
                while (include && j < javaClasspath.length) {
                    if (extraEntry.equals(javaClasspath[j])) {
                        include = false;
                    }
                    ++j;
                }
                if (include) {
                    nonDuplicateList.add(extraEntry);
                }
                ++i;
            }
            if (nonDuplicateList.size() > 0) {
                IClasspathEntry[] newJavaClasspath = new IClasspathEntry[javaClasspath.length + nonDuplicateList.size()];
                System.arraycopy(javaClasspath, 0, newJavaClasspath, 0, javaClasspath.length);
                int j = 0;
                while (j < nonDuplicateList.size()) {
                    newJavaClasspath[javaClasspath.length + j] = (IClasspathEntry)nonDuplicateList.get(j);
                    ++j;
                }
                javaProject.setRawClasspath(newJavaClasspath, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected SaveStrategy createSaveStrategy(IVirtualComponent component) {
        ConnectorComponentSaveStrategyImpl saveStrat = new ConnectorComponentSaveStrategyImpl(component);
        return saveStrat;
    }
}

