/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.internal.web.operations.NewServletClassOperation;
import org.eclipse.jst.j2ee.webapplication.InitParam;
import org.eclipse.jst.j2ee.webapplication.JSPType;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditProviderOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AddServletOperation
extends ArtifactEditProviderOperation {
    public AddServletOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        boolean isServletType = this.model.getBooleanProperty("NewServletClassDataModel.IS_SERVLET_TYPE");
        boolean useExisting = this.model.getBooleanProperty("NewServletClassDataModel.USE_EXISTING_CLASS");
        String qualifiedClassName = this.model.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        if (isServletType && !useExisting) {
            qualifiedClassName = this.createServletClass();
        }
        if (!this.model.getBooleanProperty("IAnnotationsDataModel.useAnnotations")) {
            this.generateServletMetaData(this.model, qualifiedClassName, isServletType);
        }
        return OK_STATUS;
    }

    protected String createServletClass() {
        NewServletClassOperation op = new NewServletClassOperation(this.model);
        try {
            op.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (Exception e) {
            Logger.getLogger().log(e);
        }
        return this.getQualifiedClassName();
    }

    public final String getQualifiedClassName() {
        String packageName = this.model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        String className = this.model.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        if (packageName != null && packageName.trim().length() > 0) {
            return String.valueOf(packageName) + "." + className;
        }
        return className;
    }

    protected void generateServletMetaData(IDataModel aModel, String qualifiedClassName, boolean isServletType) {
        List urlMappingList;
        Servlet servlet = this.createServlet(qualifiedClassName, isServletType);
        List initParamList = (List)aModel.getProperty("NewServletClassDataModel.INIT_PARAM");
        if (initParamList != null) {
            this.setUpInitParams(initParamList, servlet);
        }
        if ((urlMappingList = (List)aModel.getProperty("NewServletClassDataModel.URL_MAPPINGS")) != null) {
            this.setUpURLMappings(urlMappingList, servlet);
        }
    }

    private Servlet createServlet(String qualifiedClassName, boolean isServletType) {
        String displayName = this.model.getStringProperty("NewServletClassDataModel.DISPLAY_NAME");
        String description = this.model.getStringProperty("NewServletClassDataModel.DESCRIPTION");
        Servlet servlet = WebapplicationFactory.eINSTANCE.createServlet();
        servlet.setDisplayName(displayName);
        servlet.setServletName(displayName);
        servlet.setDescription(description);
        if (isServletType) {
            ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
            servletType.setClassName(qualifiedClassName);
            servlet.setWebType(servletType);
        } else {
            JSPType jspType = WebapplicationFactory.eINSTANCE.createJSPType();
            jspType.setJspFile(qualifiedClassName);
            servlet.setWebType(jspType);
        }
        WebApp webApp = (WebApp)this.artifactEdit.getContentModelRoot();
        webApp.getServlets().add((Object)servlet);
        return servlet;
    }

    private void setUpInitParams(List initParamList, Servlet servlet) {
        WebApp webApp = (WebApp)this.artifactEdit.getContentModelRoot();
        int nP = initParamList.size();
        if (webApp.getJ2EEVersionID() >= 14) {
            int iP = 0;
            while (iP < nP) {
                String[] stringArray = (String[])initParamList.get(iP);
                ParamValue param = CommonFactory.eINSTANCE.createParamValue();
                param.setName(stringArray[0]);
                param.setValue(stringArray[1]);
                Description descriptionObj = CommonFactory.eINSTANCE.createDescription();
                descriptionObj.setValue(stringArray[2]);
                param.getDescriptions().add((Object)descriptionObj);
                param.setDescription(stringArray[2]);
                servlet.getInitParams().add((Object)param);
                ++iP;
            }
        } else {
            int iP = 0;
            while (iP < nP) {
                String[] stringArray = (String[])initParamList.get(iP);
                InitParam ip = WebapplicationFactory.eINSTANCE.createInitParam();
                ip.setParamName(stringArray[0]);
                ip.setParamValue(stringArray[1]);
                ip.setDescription(stringArray[2]);
                servlet.getParams().add((Object)ip);
                ++iP;
            }
        }
    }

    private void setUpURLMappings(List urlMappingList, Servlet servlet) {
        WebApp webApp = (WebApp)this.artifactEdit.getContentModelRoot();
        int nM = urlMappingList.size();
        int iM = 0;
        while (iM < nM) {
            String[] stringArray = (String[])urlMappingList.get(iM);
            ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
            mapping.setServlet(servlet);
            mapping.setName(servlet.getServletName());
            mapping.setUrlPattern(stringArray[0]);
            webApp.getServletMappings().add((Object)mapping);
            ++iM;
        }
    }
}

