/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.internal.validation.ATypeVRule;
import org.eclipse.jst.j2ee.model.internal.validation.ClassUtility;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBInterfaceType;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public abstract class AInterfaceTypeVRule
extends ATypeVRule
implements IEJBInterfaceType {
    public static final List getBeanClassMethodsExtended(List[] methodsExtendedList) {
        return methodsExtendedList[0];
    }

    public final List[] getMethodsExtended(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        JavaClass beanClass = bean.getEjbClass();
        if (beanClass == null) {
            throw new InvalidInputException();
        }
        List[] result = new List[]{beanClass.getMethodsExtended()};
        return result;
    }

    public final List[] getFieldsExtended(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        return null;
    }

    public void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field, List[] fieldsExtendedLists) throws ValidationCancelledException, InvalidInputException, ValidationException {
    }

    public void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) throws ValidationCancelledException, InvalidInputException, ValidationException {
        this.validateApplicationExceptionRules(vc, bean, clazz, method);
    }

    public final boolean isEJBInterfaceMethod(EnterpriseBean bean, Method method) throws InvalidInputException {
        long[] superTypes = this.getSupertypes();
        int i = 0;
        while (i < superTypes.length) {
            if (ClassUtility.getUtility().isClassType(bean, method.getJavaClass(), superTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final JavaHelpers getOverExposedLocalType(EnterpriseBean bean, JavaClass clazz, Method method) {
        if ((this.isRemote() & 1) == 1) {
            JavaHelpers parm;
            JavaParameter[] parms = method.listParametersWithoutReturn();
            if (parms != null) {
                int i = 0;
                while (i < parms.length) {
                    JavaParameter parm2 = parms[i];
                    if (ValidationRuleUtility.isLocalType(bean, parm2.getJavaType())) {
                        return parm2.getJavaType();
                    }
                    ++i;
                }
            }
            if (ValidationRuleUtility.isLocalType(bean, parm = method.getReturnType())) {
                return parm;
            }
            return null;
        }
        return null;
    }

    public long getFieldType(EnterpriseBean bean, JavaClass clazz, Field field) {
        if (field == null) {
            return EXCLUDED_FIELD;
        }
        if (field.getName().equals("serialVersionUID")) {
            return SERIALVERSIONUID;
        }
        return OTHER_FIELD;
    }

    public void validateApplicationExceptionRules(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws ValidationCancelledException {
        EList exceptions = method.getJavaExceptions();
        if (exceptions.size() == 0) {
            return;
        }
        Iterator iterator = exceptions.iterator();
        try {
            JavaHelpers javaLangException = ValidationRuleUtility.getType("java.lang.Exception", bean);
            JavaHelpers javaLangRuntimeException = ValidationRuleUtility.getType("java.lang.RuntimeException", bean);
            while (iterator.hasNext()) {
                IMessage message;
                JavaClass exception = (JavaClass)iterator.next();
                if (!ValidationRuleUtility.isApplicationException(exception, bean)) continue;
                if (!ValidationRuleUtility.isAssignableFrom(exception, javaLangException)) {
                    message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2404", 2, bean, clazz, method, new String[]{exception.getName()}, (IValidationRule)this);
                    vc.addMessage(message);
                    continue;
                }
                if (!ValidationRuleUtility.isAssignableFrom(exception, javaLangRuntimeException)) continue;
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2416", 2, bean, clazz, method, new String[]{exception.getName()}, (IValidationRule)this);
                vc.addMessage(message);
            }
            return;
        }
        catch (InvalidInputException invalidInputException) {
            return;
        }
    }
}

