/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.internal.validation.AValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public abstract class AValidateEJB
extends AValidationRule {
    private List roleMethodNames;

    public void reset() {
        super.reset();
        if (this.roleMethodNames != null) {
            this.roleMethodNames.clear();
            this.roleMethodNames = null;
        }
    }

    protected List getRoleMethodNames(IEJBValidationContext vc, EnterpriseBean bean) {
        try {
            if (this.roleMethodNames == null && bean != null) {
                this.roleMethodNames = this.getRoleMethodNamesExtended(bean);
            }
            return this.roleMethodNames;
        }
        catch (Throwable exc) {
            Logger logger = vc.getMsgLogger();
            if (logger != null && logger.isLoggingLevel(Level.FINER)) {
                logger.write(Level.FINER, exc);
            }
            return Collections.EMPTY_LIST;
        }
    }

    protected boolean isEjbRelationshipRoleMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) {
        if (method == null) {
            return false;
        }
        List aRoleMethodNames = this.getRoleMethodNames(vc, bean);
        if (aRoleMethodNames != null && !aRoleMethodNames.isEmpty()) {
            return aRoleMethodNames.contains(method.getName());
        }
        return false;
    }

    protected boolean isValid(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field, List[] fieldsExtendedLists) throws InvalidInputException {
        ValidationRuleUtility.isValidType(ValidationRuleUtility.getType(field));
        return !field.getName().equals("serialVersionUID");
    }

    protected boolean isValid(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedList) throws InvalidInputException {
        if (method == null) {
            throw new InvalidInputException();
        }
        return true;
    }

    public void primValidate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field) throws InvalidInputException {
    }

    public abstract void primValidate(IEJBValidationContext var1, EnterpriseBean var2, JavaClass var3, Method var4) throws InvalidInputException;

    protected abstract void primValidateExistence(IEJBValidationContext var1, EnterpriseBean var2, JavaClass var3, Method var4) throws InvalidInputException;

    protected abstract List[] getMethodsExtended(IEJBValidationContext var1, EnterpriseBean var2, JavaClass var3);

    protected abstract List[] getFieldsExtended(IEJBValidationContext var1, EnterpriseBean var2, JavaClass var3);

    protected final void reflectionError(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        vc.removeMessages(clazz);
        IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2907", 1, bean, clazz, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
        vc.addMessage(message);
    }

    protected final void reflectionWarning(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field, InvalidInputException e) {
        String[] msgParm = null;
        String javaClassName = e.getJavaClass() == null ? "?" : e.getJavaClass().getQualifiedName();
        msgParm = ValidationRuleUtility.onClass(clazz, field) ? new String[]{String.valueOf(field.getName()), String.valueOf(javaClassName)} : new String[]{javaClassName};
        IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2433", 2, bean, clazz, field, msgParm, (IValidationRule)this);
        vc.addMessage(message);
    }

    protected final void reflectionWarning(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method, InvalidInputException e) {
        String[] msgParm = null;
        String javaClassName = e.getJavaClass() == null ? "?" : e.getJavaClass().getQualifiedName();
        msgParm = ValidationRuleUtility.onClass(clazz, method) ? new String[]{method.getMethodElementSignature(), javaClassName} : new String[]{javaClassName};
        IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2433", 2, bean, clazz, method, msgParm, (IValidationRule)this);
        vc.addMessage(message);
    }

    public final void validate(IEJBValidationContext vc, Object targetParent, Object target) throws ValidationException {
        vc.terminateIfCancelled();
        EnterpriseBean bean = (EnterpriseBean)targetParent;
        JavaClass clazz = (JavaClass)target;
        try {
            ValidationRuleUtility.isValidTypeHierarchy(bean, clazz);
            vc.subtask("STATUS_VALIDATING", new String[]{clazz.getQualifiedName()});
            this.validateClass(vc, bean, clazz);
            this.validateMethods(vc, bean, clazz);
            this.validateFields(vc, bean, clazz);
        }
        catch (InvalidInputException invalidInputException) {
            this.reflectionError(vc, bean, clazz);
            return;
        }
        catch (ValidationCancelledException e) {
            throw e;
        }
    }

    public final void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field, List[] fieldsExtendedList) throws InvalidInputException {
        if (this.isValid(vc, bean, clazz, field, fieldsExtendedList)) {
            this.primValidate(vc, bean, clazz, field);
        }
    }

    public final void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method ejbMethod, List[] methodsExtendedList) throws InvalidInputException {
        if (this.isValid(vc, bean, clazz, ejbMethod, methodsExtendedList)) {
            this.primValidate(vc, bean, clazz, ejbMethod);
        }
    }

    protected final void validateExistence(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method ejbMethod, List[] methodsExtendedList) throws InvalidInputException {
        if (this.isValid(vc, bean, clazz, ejbMethod, methodsExtendedList)) {
            this.primValidateExistence(vc, bean, clazz, ejbMethod);
        }
    }

    public void validateClass(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
    }

    public final void validateFields(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws ValidationCancelledException, InvalidInputException, ValidationException {
        vc.terminateIfCancelled();
        List fields = clazz.getFieldsExtended();
        Iterator iterator = fields.iterator();
        Field field = null;
        List[] fieldsExtendedList = this.getFieldsExtended(vc, bean, clazz);
        while (iterator.hasNext()) {
            vc.terminateIfCancelled();
            field = (Field)iterator.next();
            if (field == null) {
                Logger logger = vc.getMsgLogger();
                if (logger == null || !logger.isLoggingLevel(Level.FINEST)) continue;
                LogEntry entry = vc.getLogEntry();
                entry.setSourceID("AValidateEJB.validateFields()");
                entry.setText("A field is null on " + clazz);
                logger.write(Level.FINEST, entry);
                continue;
            }
            try {
                this.validate(vc, bean, clazz, field, fieldsExtendedList);
            }
            catch (InvalidInputException e) {
                this.reflectionWarning(vc, bean, clazz, field, e);
            }
        }
        vc.terminateIfCancelled();
    }

    public final void validateLegalRMIMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        this.validateLegalRMIMethodWithoutExceptions(vc, bean, clazz, method);
        this.validateLegalRMIMethodExceptions(vc, bean, clazz, method);
    }

    public final void validateLegalRMIMethodArguments(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        JavaParameter[] args = method.listParametersWithoutReturn();
        int i = 0;
        while (i < args.length) {
            vc.terminateIfCancelled();
            if (!ValidationRuleUtility.isLegalRMI_IIOPType(bean, args[i].getJavaType())) {
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2413", 4, bean, clazz, method, new String[]{args[i].getQualifiedName()}, (IValidationRule)this);
                vc.addMessage(message);
            }
            ++i;
        }
    }

    public final void validateLegalRMIMethodExceptions(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        if (!ValidationRuleUtility.throwsRemoteExceptionOrParent(bean, method)) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2414", 1, bean, clazz, method, new String[]{"java.rmi.RemoteException"}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public final void validateLegalRMIMethodReturnType(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        if (!ValidationRuleUtility.isLegalRMI_IIOPType(bean, method.getReturnType())) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2412", 4, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public final void validateLegalRMIMethodWithoutExceptions(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        this.validateLegalRMIMethodArguments(vc, bean, clazz, method);
        this.validateLegalRMIMethodReturnType(vc, bean, clazz, method);
    }

    protected abstract void validateMethodExists(IEJBValidationContext var1, EnterpriseBean var2, JavaClass var3) throws InvalidInputException;

    public final void validateMethods(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws ValidationCancelledException, InvalidInputException, ValidationException {
        vc.terminateIfCancelled();
        Method[] ejbMethods = clazz.listMethodExtended();
        Method method = null;
        List[] methodsExtendedList = this.getMethodsExtended(vc, bean, clazz);
        int i = 0;
        while (i < ejbMethods.length) {
            vc.terminateIfCancelled();
            method = ejbMethods[i];
            if (method == null) {
                Logger logger = vc.getMsgLogger();
                if (logger != null && logger.isLoggingLevel(Level.FINEST)) {
                    LogEntry entry = vc.getLogEntry();
                    entry.setSourceID("AValidateEJB.validateMethods()");
                    entry.setText("On " + clazz + ", there is a null method.");
                    logger.write(Level.FINEST, entry);
                }
            } else {
                try {
                    this.validateExistence(vc, bean, clazz, method, methodsExtendedList);
                    this.validate(vc, bean, clazz, method, methodsExtendedList);
                }
                catch (InvalidInputException e) {
                    this.reflectionWarning(vc, bean, clazz, method, e);
                }
            }
            ++i;
        }
        this.validateMethodExists(vc, bean, clazz);
        vc.terminateIfCancelled();
    }
}

