/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.model.internal.validation.AValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IMessagePrefixEjb20Constants;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRuleList;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class EJBExt20VRule
extends AValidationRule
implements IMessagePrefixEjb20Constants {
    private static final Map MESSAGE_IDS;
    private static final Object[] DEPENDS_ON;

    static {
        DEPENDS_ON = new Object[]{IValidationRuleList.EJB20_STATELESS_SESSION_BEANCLASS, IValidationRuleList.EJB20_STATELESS_SESSION_REMOTE, IValidationRuleList.EJB20_STATELESS_SESSION_HOME, IValidationRuleList.EJB20_STATELESS_SESSION_LOCAL, IValidationRuleList.EJB20_STATELESS_SESSION_LOCALHOME, IValidationRuleList.EJB20_STATEFUL_SESSION_BEANCLASS, IValidationRuleList.EJB20_STATEFUL_SESSION_REMOTE, IValidationRuleList.EJB20_STATEFUL_SESSION_HOME, IValidationRuleList.EJB20_STATEFUL_SESSION_LOCAL, IValidationRuleList.EJB20_STATEFUL_SESSION_LOCALHOME, IValidationRuleList.EJB20_CMP_BEANCLASS, IValidationRuleList.EJB20_CMP_REMOTE, IValidationRuleList.EJB20_CMP_HOME, IValidationRuleList.EJB20_CMP_LOCAL, IValidationRuleList.EJB20_CMP_LOCALHOME, IValidationRuleList.EJB20_CMP_KEYCLASS, IValidationRuleList.EJB20_BMP_BEANCLASS, IValidationRuleList.EJB20_BMP_REMOTE, IValidationRuleList.EJB20_BMP_HOME, IValidationRuleList.EJB20_BMP_LOCAL, IValidationRuleList.EJB20_BMP_LOCALHOME, IValidationRuleList.EJB20_BMP_KEYCLASS, IValidationRuleList.EJB20_MESSAGE_BEANCLASS, IValidationRuleList.EJB20_EJBJAR};
        MESSAGE_IDS = new HashMap();
        MESSAGE_IDS.put("CHKJ2106", new String[]{"CHKJ2106.ejb20"});
        MESSAGE_IDS.put("CHKJ2849", new String[]{"CHKJ2849.ejb20"});
        MESSAGE_IDS.put("CHKJ2852", new String[]{"CHKJ2852"});
    }

    public Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public Object getId() {
        return IValidationRuleList.EJB20_EJBEXT;
    }

    public Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public Object getTarget(Object parent, Object clazz) {
        return null;
    }

    public boolean areBeanComponentsReflected(EnterpriseBean bean) {
        try {
            ValidationRuleUtility.isValidTypeHierarchy(bean, bean.getEjbClass());
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        if (bean instanceof MessageDriven) {
            return true;
        }
        try {
            if (bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_HomeInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(bean, bean.getHomeInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        try {
            if (bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_RemoteInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(bean, bean.getRemoteInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        try {
            if (bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_LocalHomeInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(bean, bean.getLocalHomeInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        try {
            if (bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_LocalInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(bean, bean.getLocalInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        if (bean.isEntity()) {
            JavaClass primaryKey = ((Entity)bean).getPrimaryKey();
            try {
                if (((Entity)bean).eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEntity_PrimaryKey())) {
                    ValidationRuleUtility.isValidTypeHierarchy(bean, primaryKey);
                }
            }
            catch (InvalidInputException invalidInputException) {
                return false;
            }
        }
        return true;
    }

    public void validate(IEJBValidationContext vc, Object targetParent, Object target) throws ValidationCancelledException, ValidationException {
        Logger logger = vc.getMsgLogger();
        if (logger != null && logger.isLoggingLevel(Level.FINEST)) {
            LogEntry entry = vc.getLogEntry();
            entry.setSourceID("EJB20Validator - validate");
            entry.setText(String.valueOf(this.getClass().getName()) + "::validate(" + targetParent + ", " + target);
            logger.write(Level.FINEST, entry);
        }
        EJBJar ejbJar = null;
        if (targetParent == null) {
            ejbJar = (EJBJar)target;
            this.validate(vc, ejbJar);
        } else {
            ejbJar = (EJBJar)vc.loadModel("EJB_MODEL");
            EnterpriseBean bean = (EnterpriseBean)targetParent;
            this.validate(vc, ejbJar, bean);
        }
    }

    public void validate(IEJBValidationContext vc, EJBJar ejbJar) throws ValidationCancelledException, ValidationException {
        EList enterpriseBeans = ejbJar.getEnterpriseBeans();
        Iterator iterator = enterpriseBeans.iterator();
        EnterpriseBean bean = null;
        while (iterator.hasNext()) {
            bean = (EnterpriseBean)iterator.next();
            if (bean == null) continue;
            this.validate(vc, ejbJar, bean);
        }
    }

    public void validate(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) throws ValidationCancelledException, ValidationException {
        block5: {
            try {
                if (!this.areBeanComponentsReflected(bean)) {
                    return;
                }
                this.validateAppendixB(vc, ejbJar, bean);
            }
            catch (ValidationCancelledException e) {
                throw e;
            }
            catch (Throwable exc) {
                String superTypeName = this.getEJBInheritanceFileName();
                if (superTypeName == null) {
                    superTypeName = "unknown super type";
                }
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2852", 2, bean, new String[]{superTypeName, bean.getName()}, (IValidationRule)this);
                vc.addMessage(message);
                Logger logger = vc.getMsgLogger();
                if (logger == null || !logger.isLoggingLevel(Level.SEVERE)) break block5;
                logger.write(Level.SEVERE, exc);
            }
        }
    }

    protected void validateAppendixB(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        if (bean == null) {
            return;
        }
        if (!bean.isEntity()) {
            return;
        }
        JavaClass thisKey = ((Entity)bean).getPrimaryKey();
        EnterpriseBean supertype = this.getSuperType(bean);
        JavaClass parentKey = null;
        if (supertype != null && supertype instanceof Entity) {
            parentKey = ((Entity)supertype).getPrimaryKey();
            if (thisKey == null || parentKey == null || !thisKey.equals(parentKey)) {
                String[] msgParm = new String[]{bean.getName(), parentKey.getQualifiedName()};
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2106", 1, bean, msgParm, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }
}

