/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.model.internal.validation.AbstractEJBValidationRuleFactory;
import org.eclipse.jst.j2ee.model.internal.validation.BMPBeanClassVRule;
import org.eclipse.jst.j2ee.model.internal.validation.BMPKeyClassVRule;
import org.eclipse.jst.j2ee.model.internal.validation.BMPLocalComponentVRule;
import org.eclipse.jst.j2ee.model.internal.validation.BMPLocalHomeVRule;
import org.eclipse.jst.j2ee.model.internal.validation.BMPRemoteComponentVRule;
import org.eclipse.jst.j2ee.model.internal.validation.BMPRemoteHomeVRule;
import org.eclipse.jst.j2ee.model.internal.validation.CMPBeanClassVRule;
import org.eclipse.jst.j2ee.model.internal.validation.CMPKeyClassVRule;
import org.eclipse.jst.j2ee.model.internal.validation.CMPLocalComponentVRule;
import org.eclipse.jst.j2ee.model.internal.validation.CMPLocalHomeVRule;
import org.eclipse.jst.j2ee.model.internal.validation.CMPRemoteComponentVRule;
import org.eclipse.jst.j2ee.model.internal.validation.CMPRemoteHomeVRule;
import org.eclipse.jst.j2ee.model.internal.validation.EJBJar11VRule;
import org.eclipse.jst.j2ee.model.internal.validation.EJBJar20VRule;
import org.eclipse.jst.j2ee.model.internal.validation.EnterpriseBean11VRule;
import org.eclipse.jst.j2ee.model.internal.validation.EnterpriseBean20VRule;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRuleList;
import org.eclipse.jst.j2ee.model.internal.validation.MessageDrivenBeanClassVRule;
import org.eclipse.jst.j2ee.model.internal.validation.StatefulSessionBeanClassVRule;
import org.eclipse.jst.j2ee.model.internal.validation.StatefulSessionLocalComponentVRule;
import org.eclipse.jst.j2ee.model.internal.validation.StatefulSessionLocalHomeVRule;
import org.eclipse.jst.j2ee.model.internal.validation.StatefulSessionRemoteComponentVRule;
import org.eclipse.jst.j2ee.model.internal.validation.StatefulSessionRemoteHomeVRule;
import org.eclipse.jst.j2ee.model.internal.validation.StatelessSessionBeanClassVRule;
import org.eclipse.jst.j2ee.model.internal.validation.StatelessSessionLocalComponentVRule;
import org.eclipse.jst.j2ee.model.internal.validation.StatelessSessionLocalHomeVRule;
import org.eclipse.jst.j2ee.model.internal.validation.StatelessSessionRemoteComponentVRule;
import org.eclipse.jst.j2ee.model.internal.validation.StatelessSessionRemoteHomeVRule;
import org.eclipse.jst.j2ee.model.internal.validation.ValidateBMPBean;
import org.eclipse.jst.j2ee.model.internal.validation.ValidateBMPHome;
import org.eclipse.jst.j2ee.model.internal.validation.ValidateBMPKey;
import org.eclipse.jst.j2ee.model.internal.validation.ValidateBMPRemote;
import org.eclipse.jst.j2ee.model.internal.validation.ValidateCMPBean;
import org.eclipse.jst.j2ee.model.internal.validation.ValidateCMPKey;
import org.eclipse.jst.j2ee.model.internal.validation.ValidateCMPRemote;
import org.eclipse.jst.j2ee.model.internal.validation.ValidateSessionBean;
import org.eclipse.jst.j2ee.model.internal.validation.ValidateSessionHome;
import org.eclipse.jst.j2ee.model.internal.validation.ValidateSessionRemote;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;

public class EJBValidationRuleFactory
extends AbstractEJBValidationRuleFactory {
    private static EJBValidationRuleFactory _inst = null;
    private Logger logger = null;

    public EJBValidationRuleFactory() {
        this.createRuleList();
    }

    public static EJBValidationRuleFactory getFactory() {
        if (_inst == null) {
            _inst = new EJBValidationRuleFactory();
        }
        return _inst;
    }

    protected Logger getMsgLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger("org.eclipse.jst.j2ee.internal.core");
        }
        return this.logger;
    }

    private void createRuleList() {
        this._ruleList = new HashMap();
        this._ruleList.put(IValidationRuleList.EJB11_EJBJAR, new EJBJar11VRule());
        this._ruleList.put(IValidationRuleList.EJB20_EJBJAR, new EJBJar20VRule());
        this._ruleList.put(IValidationRuleList.EJB11_ENTERPRISEBEAN, new EnterpriseBean11VRule());
        this._ruleList.put(IValidationRuleList.EJB20_ENTERPRISEBEAN, new EnterpriseBean20VRule());
        this._ruleList.put(IValidationRuleList.EJB11_SESSION_BEANCLASS, new ValidateSessionBean());
        this._ruleList.put(IValidationRuleList.EJB11_SESSION_REMOTE, new ValidateSessionRemote());
        this._ruleList.put(IValidationRuleList.EJB11_SESSION_HOME, new ValidateSessionHome());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_BEANCLASS, new StatelessSessionBeanClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_REMOTE, new StatelessSessionRemoteComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_HOME, new StatelessSessionRemoteHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_LOCAL, new StatelessSessionLocalComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_LOCALHOME, new StatelessSessionLocalHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_BEANCLASS, new StatefulSessionBeanClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_REMOTE, new StatefulSessionRemoteComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_HOME, new StatefulSessionRemoteHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_LOCAL, new StatefulSessionLocalComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_LOCALHOME, new StatefulSessionLocalHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB11_CMP_BEANCLASS, new ValidateCMPBean());
        this._ruleList.put(IValidationRuleList.EJB11_CMP_REMOTE, new ValidateCMPRemote());
        this._ruleList.put(IValidationRuleList.EJB11_CMP_KEYCLASS, new ValidateCMPKey());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_BEANCLASS, new CMPBeanClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_REMOTE, new CMPRemoteComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_HOME, new CMPRemoteHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_LOCAL, new CMPLocalComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_LOCALHOME, new CMPLocalHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_KEYCLASS, new CMPKeyClassVRule());
        this._ruleList.put(IValidationRuleList.EJB11_BMP_BEANCLASS, new ValidateBMPBean());
        this._ruleList.put(IValidationRuleList.EJB11_BMP_REMOTE, new ValidateBMPRemote());
        this._ruleList.put(IValidationRuleList.EJB11_BMP_HOME, new ValidateBMPHome());
        this._ruleList.put(IValidationRuleList.EJB11_BMP_KEYCLASS, new ValidateBMPKey());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_BEANCLASS, new BMPBeanClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_REMOTE, new BMPRemoteComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_HOME, new BMPRemoteHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_LOCAL, new BMPLocalComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_LOCALHOME, new BMPLocalHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_KEYCLASS, new BMPKeyClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_MESSAGE_BEANCLASS, new MessageDrivenBeanClassVRule());
        this.addDependentRuleToRuleList();
        this.logAllDependentRules();
    }

    public Object getRuleId(IEJBValidationContext vc, String fileName) {
        if (fileName == null) {
            Logger aLogger = vc.getMsgLogger();
            if (aLogger != null && aLogger.isLoggingLevel(Level.FINE)) {
                aLogger.write(Level.FINE, "Cannot load rule from fileName: " + fileName);
            }
            return null;
        }
        EJBJar ejbJar = this.getEJBJar(vc);
        if (fileName.endsWith("ejb-jar.xml")) {
            if (ejbJar.getVersionID() == 11) {
                return IValidationRuleList.EJB11_EJBJAR;
            }
            return IValidationRuleList.EJB20_EJBJAR;
        }
        return null;
    }

    public final Object getRuleId(IEJBValidationContext vc, JavaClass clazz, EnterpriseBean bean) {
        Logger aLogger;
        boolean isStatefulSession;
        if (clazz == null || bean == null) {
            Logger aLogger2 = vc.getMsgLogger();
            if (aLogger2 != null && aLogger2.isLoggingLevel(Level.FINE)) {
                aLogger2.write(Level.FINE, "Cannot load rule because either bean (" + bean + ") or class (" + clazz + ") is null");
            }
            return null;
        }
        boolean isStatelessSession = bean.isSession() && ValidationRuleUtility.isStateless(bean);
        boolean bl = isStatefulSession = bean.isSession() && ValidationRuleUtility.isStateful(bean);
        if (bean.getVersionID() >= 20) {
            if (clazz.equals(bean.getEjbClass())) {
                if (isStatelessSession) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_BEANCLASS;
                }
                if (isStatefulSession) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_BEANCLASS;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_BEANCLASS;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_BEANCLASS;
                }
                if (bean.isMessageDriven()) {
                    return IValidationRuleList.EJB20_MESSAGE_BEANCLASS;
                }
                Logger aLogger3 = vc.getMsgLogger();
                if (aLogger3 != null && aLogger3.isLoggingLevel(Level.FINE)) {
                    aLogger3.write(Level.FINE, "Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getEjbClass()");
                }
                return null;
            }
            if (clazz.equals(bean.getRemoteInterface())) {
                if (isStatelessSession) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_REMOTE;
                }
                if (isStatefulSession) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_REMOTE;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_REMOTE;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_REMOTE;
                }
                Logger aLogger4 = vc.getMsgLogger();
                if (aLogger4.isLoggingLevel(Level.FINE)) {
                    aLogger4.write(Level.FINE, "Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getRemoteInterface()");
                }
                return null;
            }
            if (clazz.equals(bean.getHomeInterface())) {
                if (isStatelessSession) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_HOME;
                }
                if (isStatefulSession) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_HOME;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_HOME;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_HOME;
                }
                Logger aLogger5 = vc.getMsgLogger();
                if (aLogger5.isLoggingLevel(Level.FINE)) {
                    aLogger5.write(Level.FINE, "Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getHomeInterface()");
                }
                return null;
            }
            if (clazz.equals(bean.getLocalHomeInterface())) {
                if (isStatelessSession) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_LOCALHOME;
                }
                if (isStatefulSession) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_LOCALHOME;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_LOCALHOME;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_LOCALHOME;
                }
                Logger aLogger6 = vc.getMsgLogger();
                if (aLogger6.isLoggingLevel(Level.FINE)) {
                    aLogger6.write(Level.FINE, "Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getLocalHomeInterface()");
                }
                return null;
            }
            if (clazz.equals(bean.getLocalInterface())) {
                if (isStatelessSession) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_LOCAL;
                }
                if (isStatefulSession) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_LOCAL;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_LOCAL;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_LOCAL;
                }
                Logger aLogger7 = vc.getMsgLogger();
                if (aLogger7.isLoggingLevel(Level.FINE)) {
                    aLogger7.write(Level.FINE, "Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getLocalInterface()");
                }
                return null;
            }
            if (bean instanceof Entity && clazz.equals(((Entity)bean).getPrimaryKey())) {
                if (bean.isContainerManagedEntity()) {
                    ContainerManagedEntity cmp = (ContainerManagedEntity)bean;
                    if (ValidationRuleUtility.isPrimitivePrimaryKey(cmp)) {
                        return null;
                    }
                    if (ValidationRuleUtility.usesUnknownPrimaryKey(cmp)) {
                        return null;
                    }
                    return IValidationRuleList.EJB20_CMP_KEYCLASS;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_KEYCLASS;
                }
                Logger aLogger8 = vc.getMsgLogger();
                if (aLogger8.isLoggingLevel(Level.FINE)) {
                    aLogger8.write(Level.FINE, "Cannot load rule: bean.isVersion2_X() && clazz.equals(((Entity)bean).getPrimaryKey()");
                }
                return null;
            }
            Logger aLogger9 = vc.getMsgLogger();
            if (aLogger9.isLoggingLevel(Level.FINE)) {
                aLogger9.write(Level.FINE, "Cannot load rule: bean.isVersion2_X()");
            }
            return null;
        }
        if (bean.getVersionID() <= 11) {
            if (clazz.equals(bean.getEjbClass())) {
                if (bean.isSession()) {
                    return IValidationRuleList.EJB11_SESSION_BEANCLASS;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB11_CMP_BEANCLASS;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB11_BMP_BEANCLASS;
                }
                Logger aLogger10 = vc.getMsgLogger();
                if (aLogger10.isLoggingLevel(Level.FINE)) {
                    aLogger10.write(Level.FINE, "Cannot load rule: bean.isVersion1_X() && clazz.equals(bean.getEjbClass()");
                }
                return null;
            }
            if (clazz.equals(bean.getRemoteInterface())) {
                if (bean.isSession()) {
                    return IValidationRuleList.EJB11_SESSION_REMOTE;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB11_CMP_REMOTE;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB11_BMP_REMOTE;
                }
                Logger aLogger11 = vc.getMsgLogger();
                if (aLogger11.isLoggingLevel(Level.FINE)) {
                    aLogger11.write(Level.FINE, "Cannot load rule: bean.isVersion1_X() && clazz.equals(bean.getRemoteInterface()");
                }
                return null;
            }
            if (clazz.equals(bean.getHomeInterface())) {
                if (bean.isSession()) {
                    return IValidationRuleList.EJB11_SESSION_HOME;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB11_CMP_HOME;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB11_BMP_HOME;
                }
                Logger aLogger12 = vc.getMsgLogger();
                if (aLogger12.isLoggingLevel(Level.FINE)) {
                    aLogger12.write(Level.FINE, "Cannot load rule: bean.isVersion1_X() && clazz.equals(bean.getHomeInterface()");
                }
                return null;
            }
            if (bean instanceof Entity && clazz.equals(((Entity)bean).getPrimaryKey())) {
                if (bean.isContainerManagedEntity()) {
                    ContainerManagedEntity cmp = (ContainerManagedEntity)bean;
                    if (ValidationRuleUtility.isPrimitivePrimaryKey(cmp)) {
                        return null;
                    }
                    if (ValidationRuleUtility.usesUnknownPrimaryKey(cmp)) {
                        return null;
                    }
                    return IValidationRuleList.EJB11_CMP_KEYCLASS;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB11_BMP_KEYCLASS;
                }
                Logger aLogger13 = vc.getMsgLogger();
                if (aLogger13.isLoggingLevel(Level.FINE)) {
                    aLogger13.write(Level.FINE, "Cannot load rule: bean.isVersion1_X() && clazz.equals(((Entity)bean).getPrimaryKey()");
                }
                return null;
            }
        }
        if ((aLogger = vc.getMsgLogger()).isLoggingLevel(Level.FINE)) {
            aLogger.write(Level.FINE, "Cannot load rule: !bean.isVersion1_X() && !bean.isVersion2_X()");
        }
        return null;
    }
}

