/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.CommonRelationshipRole;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBRelation;
import org.eclipse.jst.j2ee.ejb.EJBRelationshipRole;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public final class MessageUtility {
    public static final String NO_MESSAGE_ID = "";
    private static MessageUtility inst = null;

    private MessageUtility() {
    }

    public static MessageUtility getUtility() {
        if (inst == null) {
            inst = new MessageUtility();
        }
        return inst;
    }

    public static String getGroupName(Object targetParent) {
        if (targetParent == null) {
            return null;
        }
        if (targetParent instanceof EnterpriseBean) {
            EnterpriseBean bean = (EnterpriseBean)targetParent;
            if (bean == null) {
                return null;
            }
            if (bean.getName() != null) {
                return bean.getName();
            }
            return ((XMIResource)bean.eResource()).getID((EObject)bean);
        }
        return null;
    }

    protected String getMessageId(Object messageNumber, EnterpriseBean bean, IValidationRule rule) {
        if (messageNumber == null) {
            return NO_MESSAGE_ID;
        }
        Map ids = rule.getMessageIds();
        if (ids == null || ids.size() == 0) {
            return messageNumber.toString();
        }
        int index = -1;
        String[] result = (String[])ids.get(messageNumber);
        if (result == null) {
            return messageNumber.toString();
        }
        if (result.length == 1) {
            if (result[0].equals(NO_MESSAGE_ID)) {
                return messageNumber.toString();
            }
            return result[0];
        }
        if (bean.isSession()) {
            index = 0;
        } else if (bean.isContainerManagedEntity()) {
            index = 1;
        } else if (bean.isBeanManagedEntity()) {
            index = 2;
        } else if (bean.isMessageDriven()) {
            index = 3;
        } else {
            return messageNumber.toString();
        }
        if (result.length <= index || result[index].equals(NO_MESSAGE_ID)) {
            return messageNumber.toString();
        }
        return result[index];
    }

    protected String getMessageId(Object messageNumber, IValidationRule rule) {
        if (messageNumber == null) {
            return NO_MESSAGE_ID;
        }
        Map ids = rule.getMessageIds();
        if (ids == null || ids.size() == 0) {
            return messageNumber.toString();
        }
        String[] result = (String[])ids.get(messageNumber);
        if (result == null || result.length == 0 || result[0].equals(NO_MESSAGE_ID)) {
            return messageNumber.toString();
        }
        return result[0];
    }

    protected String getMessageId(Object messageNumber, IValidationRule rule, boolean isMethodOnClass) {
        if (messageNumber == null) {
            return NO_MESSAGE_ID;
        }
        Map ids = rule.getMessageIds();
        if (ids == null || ids.size() == 0) {
            return messageNumber.toString();
        }
        String[] messages = (String[])ids.get(messageNumber);
        String result = null;
        if (messages != null) {
            if (isMethodOnClass && messages.length == 2) {
                result = messages[1];
            } else if (messages.length >= 1) {
                result = messages[0];
            }
        }
        if (result == null || result.equals(NO_MESSAGE_ID)) {
            return messageNumber.toString();
        }
        return result;
    }

    protected IMessage getMessage(IEJBValidationContext vc, int severity, String id, String[] parms, Object target, String groupName) {
        IMessage message = vc.getMessage();
        message.setSeverity(severity);
        message.setId(id);
        message.setParams(parms);
        message.setTargetObject(target);
        message.setGroupName(groupName);
        return message;
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EJBJar target, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, null, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, SecurityRole target, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, null, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, SecurityRoleRef target, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, null, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, MethodElement target, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, null, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, MethodTransaction target, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, null, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, MethodPermission target, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, null, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EJBRelationshipRole target, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, null, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, CommonRelationshipRole target, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, null, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EJBRelation target, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, null, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, AssemblyDescriptor target, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, null, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EJBJar target, String[] parms, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, parms, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, MethodElement target, String[] parms, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, parms, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EJBRelationshipRole target, String[] parms, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, parms, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, SecurityRoleRef target, String[] parms, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, parms, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EJBRelation target, String[] parms, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, parms, (Object)target, null);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EnterpriseBean bean, Object target, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, null, target, MessageUtility.getGroupName(bean));
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EnterpriseBean bean, Object target, String[] parms, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, parms, target, MessageUtility.getGroupName(bean));
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EnterpriseBean bean, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, bean, rule);
        return this.getMessage(vc, severity, id, null, (Object)bean, MessageUtility.getGroupName(bean));
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EnterpriseBean bean, String[] parms, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, bean, rule);
        return this.getMessage(vc, severity, id, parms, (Object)bean, MessageUtility.getGroupName(bean));
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EnterpriseBean bean, JavaClass clazz, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, null, (Object)clazz, MessageUtility.getGroupName(bean));
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EnterpriseBean bean, JavaClass clazz, String[] additionalParms, IValidationRule rule) {
        String id = this.getMessageId(messageNumber, rule);
        return this.getMessage(vc, severity, id, additionalParms, (Object)clazz, MessageUtility.getGroupName(bean));
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EnterpriseBean bean, JavaClass clazz, Method method, IValidationRule rule) {
        if (method == null) {
            return this.getMessage(vc, messageNumber, severity, bean, clazz, rule);
        }
        return this.getMessage(vc, messageNumber, severity, null, clazz, (EObject)method, method.getMethodElementSignature(), ValidationRuleUtility.onClass(clazz, method), MessageUtility.getGroupName(bean), rule);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EnterpriseBean bean, JavaClass clazz, Method method, String[] additionalParms, IValidationRule rule) {
        if (method == null) {
            return this.getMessage(vc, messageNumber, severity, bean, clazz, additionalParms, rule);
        }
        return this.getMessage(vc, messageNumber, severity, additionalParms, clazz, (EObject)method, method.getMethodElementSignature(), ValidationRuleUtility.onClass(clazz, method), MessageUtility.getGroupName(bean), rule);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EnterpriseBean bean, JavaClass clazz, Field field, IValidationRule rule) {
        if (field == null) {
            return this.getMessage(vc, messageNumber, severity, bean, clazz, rule);
        }
        return this.getMessage(vc, messageNumber, severity, null, clazz, (EObject)field, field.getName(), ValidationRuleUtility.onClass(clazz, field), MessageUtility.getGroupName(bean), rule);
    }

    public IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, EnterpriseBean bean, JavaClass clazz, Field field, String[] additionalParms, IValidationRule rule) {
        if (field == null) {
            return this.getMessage(vc, messageNumber, severity, bean, clazz, additionalParms, rule);
        }
        return this.getMessage(vc, messageNumber, severity, additionalParms, clazz, (EObject)field, field.getName(), ValidationRuleUtility.onClass(clazz, field), MessageUtility.getGroupName(bean), rule);
    }

    protected IMessage getMessage(IEJBValidationContext vc, Object messageNumber, int severity, String[] additionalParms, JavaClass clazz, EObject fieldOrMethod, String fieldOrMethodName, boolean isMethodOnClass, String groupName, IValidationRule rule) {
        if (fieldOrMethod == null) {
            String id = this.getMessageId(messageNumber, rule);
            return this.getMessage(vc, severity, id, additionalParms, (Object)clazz, groupName);
        }
        String[] parms = null;
        Object target = null;
        if (isMethodOnClass) {
            target = fieldOrMethod;
            parms = additionalParms;
        } else {
            if (additionalParms == null) {
                parms = new String[]{fieldOrMethodName};
            } else {
                parms = new String[additionalParms.length + 1];
                parms[0] = fieldOrMethodName;
                System.arraycopy(additionalParms, 0, parms, 1, additionalParms.length);
            }
            target = clazz;
        }
        String id = this.getMessageId(messageNumber, rule, isMethodOnClass);
        return this.getMessage(vc, severity, id, parms, target, groupName);
    }
}

