/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.model.internal.validation.AValidateBean;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IMessagePrefixEjb11Constants;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRuleList;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ValidateSessionBean
extends AValidateBean
implements IMessagePrefixEjb11Constants {
    private boolean hasValidConstructor = false;
    private boolean hasAConstructor = false;
    private boolean hasDefaultCreateMethod = false;
    private Set createMethods = new HashSet();
    private static final String MSSGID = ".sb";
    private static final String EXT = ".sb.ejb11";
    private static final String BEXT = ".sb.i.ejb11";
    private static final String MEXT = ".sb.m.ejb11";
    private static final Object ID = IValidationRuleList.EJB11_SESSION_BEANCLASS;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB11_SESSION_HOME, IValidationRuleList.EJB11_SESSION_REMOTE};
    private static final Map MESSAGE_IDS = new HashMap();

    static {
        MESSAGE_IDS.put("CHKJ2003I", new String[]{"CHKJ2003I.ejb11"});
        MESSAGE_IDS.put("CHKJ2003E", new String[]{"CHKJ2003E.ejb11"});
        MESSAGE_IDS.put("CHKJ2006", new String[]{"CHKJ2006.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2007", new String[]{"CHKJ2007.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2008", new String[]{"CHKJ2008.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2013", new String[]{"CHKJ2013.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2014", new String[]{"CHKJ2014.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2015", new String[]{"CHKJ2015.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2022", new String[]{"CHKJ2022.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2025", new String[]{"CHKJ2025.sb.i.ejb11", "CHKJ2025.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2040", new String[]{"CHKJ2040.sb.ejb11"});
        MESSAGE_IDS.put("CHKJ2103", new String[]{"CHKJ2103.ejb11"});
        MESSAGE_IDS.put("CHKJ2200", new String[]{"CHKJ2200.i.ejb11", "CHKJ2200.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2400.bus", new String[]{"CHKJ2400.bus.sb.i.ejb11", "CHKJ2400.bus.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2400.ejbCreate", new String[]{"CHKJ2400.ejbCreate.sb.i.ejb11", "CHKJ2400.ejbCreate.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2401", new String[]{"CHKJ2401.sb.i.ejb11", "CHKJ2401.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2408.bus", new String[]{"CHKJ2408.bus.sb.i.ejb11", "CHKJ2408.bus.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2408.ejbCreate", new String[]{"CHKJ2408.ejbCreate.sb.i.ejb11", "CHKJ2408.ejbCreate.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2409.bus", new String[]{"CHKJ2409.bus.sb.i.ejb11", "CHKJ2409.bus.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2409.ejbCreate", new String[]{"CHKJ2409.ejbCreate.sb.i.ejb11", "CHKJ2409.ejbCreate.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2410.bus", new String[]{"CHKJ2410.bus.sb.i.ejb11", "CHKJ2410.bus.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2410.ejbCreate", new String[]{"CHKJ2410.ejbCreate.sb.i.ejb11", "CHKJ2410.ejbCreate.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2411", new String[]{"CHKJ2411.sb.i.ejb11", "CHKJ2411.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2412", new String[]{"CHKJ2412.sb.i.ejb11", "CHKJ2412.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2413", new String[]{"CHKJ2413.sb.i.ejb11", "CHKJ2413.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2414", new String[]{"CHKJ2414.sb.i.ejb11", "CHKJ2414.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2420", new String[]{"CHKJ2420.sb.i.ejb11", "CHKJ2420.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2432", new String[]{"CHKJ2432.sb.i.ejb11", "CHKJ2432.sb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2041", new String[]{"CHKJ2041"});
        MESSAGE_IDS.put("CHKJ2433", new String[]{"CHKJ2433"});
        MESSAGE_IDS.put("CHKJ2456", new String[]{"CHKJ2456.i", "CHKJ2456.m"});
        MESSAGE_IDS.put("CHKJ2907", new String[]{"CHKJ2907"});
    }

    public void reset() {
        super.reset();
        this.createMethods.clear();
    }

    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public final Object getId() {
        return ID;
    }

    protected final String getParentName() {
        return "javax.ejb.SessionBean";
    }

    protected boolean hasCreateMethod() {
        if (this.hasDefaultCreateMethod) {
            return true;
        }
        return this.createMethods.size() > 0;
    }

    protected void incrementCreateMethodCount(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) {
        if (method == null) {
            return;
        }
        if (method.listParametersWithoutReturn().length == 0 && !this.hasDefaultCreateMethod) {
            this.hasDefaultCreateMethod = true;
        } else {
            this.createMethods.add(method);
        }
    }

    public boolean isFrameworkMethod(String name) {
        if (super.isFrameworkMethod(name)) {
            return true;
        }
        return name.equals("setSessionContext");
    }

    public void primValidate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method ejbMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        String name = ejbMethod.getName();
        if (name.equals("ejbCreate")) {
            this.validateEjbCreateMethod(vc, bean, clazz, ejbMethod);
        } else if (name.equals("finalize")) {
            this.validateFinalizeMethod(vc, bean, clazz, ejbMethod);
        } else if (ejbMethod.isConstructor()) {
            this.validateConstructor(vc, bean, clazz, ejbMethod);
        } else if (this.isBusinessMethod(vc, bean, clazz, ejbMethod)) {
            this.validateBusinessMethod(vc, bean, clazz, ejbMethod);
        } else if (!this.isFrameworkMethod(name)) {
            this.validateHelperMethod(vc, bean, clazz, ejbMethod);
        }
        vc.terminateIfCancelled();
    }

    protected void primValidateExistence(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method ejbMethod) throws InvalidInputException {
        if ("ejbCreate".equals(ejbMethod.getName())) {
            this.incrementCreateMethodCount(vc, bean, clazz, ejbMethod);
        } else if (ejbMethod.isConstructor()) {
            this.validateConstructor(vc, bean, clazz, ejbMethod);
        }
    }

    public void validateBusinessMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        super.validateBusinessMethod(vc, bean, clazz, method);
        this.validateLegalRMIMethodWithoutExceptions(vc, bean, clazz, method);
        this.validateBusinessModifiersAndExceptions(vc, bean, clazz, method);
    }

    public void validateClass(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        boolean isBeanManagedStateful;
        vc.terminateIfCancelled();
        super.validateClass(vc, bean, clazz);
        Session session = (Session)bean;
        boolean isStateless = ValidationRuleUtility.isStateless(bean);
        boolean bl = isBeanManagedStateful = ValidationRuleUtility.isBeanManagedSession(session) && ValidationRuleUtility.isStateful(session);
        if (isStateless) {
            try {
                if (ValidationRuleUtility.isAssignableFrom(bean.getEjbClass(), ValidationRuleUtility.getType("javax.ejb.SessionSynchronization", bean))) {
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2003E", 1, bean, bean.getEjbClass(), (IValidationRule)this);
                    vc.addMessage(message);
                }
            }
            catch (InvalidInputException e) {
                String beanClassName = bean.getEjbClass() == null ? "<ejb-class>" : bean.getEjbClass().getJavaName();
                String eClass = e.getJavaClass() == null ? "javax.ejb.SessionSynchronization" : e.getJavaClass().getJavaName();
                String[] msgParm = new String[]{beanClassName, eClass};
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2433", 2, bean, msgParm, (IValidationRule)this);
                vc.addMessage(message);
            }
        } else if (isBeanManagedStateful) {
            try {
                if (ValidationRuleUtility.isAssignableFrom(bean.getEjbClass(), ValidationRuleUtility.getType("javax.ejb.SessionSynchronization", bean))) {
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2003I", 4, bean, bean.getEjbClass(), (IValidationRule)this);
                    vc.addMessage(message);
                }
            }
            catch (InvalidInputException e) {
                String[] msgParm = new String[]{bean.getEjbClass().getQualifiedName(), e.getJavaClass().getQualifiedName()};
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2907", 2, bean, msgParm, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
        this.validateClass_remoteDep(vc, bean, clazz);
    }

    public void validateClass_remoteDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        vc.terminateIfCancelled();
        JavaClass remote = bean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, remote);
        if (ValidationRuleUtility.isAssignableFrom(clazz, remote)) {
            String[] msgParm = new String[]{clazz.getQualifiedName(), remote.getQualifiedName()};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2040", 4, bean, clazz, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateConstructor(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) {
        if (method == null) {
            return;
        }
        this.hasAConstructor = true;
        if (!this.hasValidConstructor && ValidationRuleUtility.isPublic(method) && method.listParametersWithoutReturn().length == 0) {
            this.hasValidConstructor = true;
        }
    }

    public void validateEjbCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        String returnTypeName;
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        JavaHelpers parmType = method.getReturnType();
        String string = returnTypeName = parmType == null ? "" : parmType.getQualifiedName();
        if (!returnTypeName.equals("void")) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2401", 1, bean, clazz, method, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateLegalRMIMethodArguments(vc, bean, clazz, method);
        this.validateEjbCreateModifiersAndExceptions(vc, bean, clazz, method);
        this.validateEjbCreateMethod_homeDep(vc, bean, clazz, method);
    }

    protected void validateFinalizeMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) {
        if (method == null) {
            return;
        }
        if (method.listParametersWithoutReturn().length == 0) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2007", 2, bean, clazz, method, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateMethodExists(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        IMessage message;
        String[] modelObjectName = new String[]{clazz.getQualifiedName()};
        if (!this.hasValidConstructor && this.hasAConstructor) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2006", 1, bean, clazz, modelObjectName, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!this.hasCreateMethod()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2008", 1, bean, clazz, modelObjectName, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (ValidationRuleUtility.isStateless(bean) && this.createMethods.size() > 0) {
            Iterator iterator = this.createMethods.iterator();
            while (iterator.hasNext()) {
                IMessage message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2025", 1, bean, clazz, (Method)iterator.next(), modelObjectName, (IValidationRule)this);
                vc.addMessage(message2);
            }
        }
    }

    public void validateBusinessModifiersAndExceptions(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        IMessage message;
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        if (!ValidationRuleUtility.isPublic(method)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2408.bus", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method.isStatic()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2410.bus", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method.isFinal()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2409.bus", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateNoRemoteException(vc, bean, clazz, method, "CHKJ2400.bus");
    }

    public void validateEjbCreateModifiersAndExceptions(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        IMessage message;
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        if (!ValidationRuleUtility.isPublic(method)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2408.ejbCreate", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method.isStatic()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2410.ejbCreate", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method.isFinal()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2409.ejbCreate", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateNoRemoteException(vc, bean, clazz, method, "CHKJ2400.ejbCreate");
    }

    public void preValidate(IEJBValidationContext vc, Object targetParent, Object target) throws ValidationCancelledException, ValidationException {
        super.preValidate(vc, targetParent, target);
        this.hasValidConstructor = false;
        this.hasAConstructor = false;
        this.hasDefaultCreateMethod = false;
    }
}

