/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.ext.test;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.ws.internal.ext.WebServiceExtensionImpl;

public class WebServiceTestExtension
extends WebServiceExtensionImpl {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private List supportedRuntimes_ = new ArrayList();

    public WebServiceTestExtension(IConfigurationElement configElement) {
        super(configElement);
        String runtimesList = this.getConfigElement().getAttribute("supportedClientRuntimes");
        this.addRuntimes(runtimesList);
    }

    public void addRuntimes(String runtimesList) {
        if (runtimesList == null) {
            return;
        }
        String[] runtimes = runtimesList.split("\\s+");
        int i = 0;
        while (i < runtimes.length) {
            if (runtimes[i].length() > 0) {
                this.supportedRuntimes_.add(runtimes[i]);
            }
            ++i;
        }
    }

    public boolean isCodeGenNeeded() {
        return Boolean.valueOf(this.getConfigElement().getAttribute("codeGenerated"));
    }

    public boolean useDefaultCodeGenFolder() {
        return Boolean.valueOf(this.getConfigElement().getAttribute("defaultcodegenfolder"));
    }

    public String getCodeGenFolder() {
        return this.getConfigElement().getAttribute("codegenfolder");
    }

    public boolean isLaunchRequired() {
        return Boolean.valueOf(this.getConfigElement().getAttribute("launchRequired"));
    }

    public boolean areMethodsNeeded() {
        return Boolean.valueOf(this.getConfigElement().getAttribute("methodsneeded"));
    }

    public boolean isServerNeeded() {
        return Boolean.valueOf(this.getConfigElement().getAttribute("serverRequired"));
    }

    public boolean useDefaultServer() {
        return Boolean.valueOf(this.getConfigElement().getAttribute("defaultserver"));
    }

    public String useServer() {
        return this.getConfigElement().getAttribute("useserver");
    }

    public boolean testWSDL() {
        String wsdl = this.getConfigElement().getAttribute("testWSDL");
        return wsdl.equals("yes") || wsdl.equals("true");
    }

    public String getId() {
        return this.getConfigElement().getAttribute("id");
    }

    public boolean allowClientRuntimesRestriction() {
        return Boolean.valueOf(this.getConfigElement().getAttribute("allowClientRuntimesRestriction"));
    }

    public boolean supportsRuntime(String runtimeId) {
        if (!this.allowClientRuntimesRestriction() || this.supportedRuntimes_.isEmpty()) {
            return true;
        }
        return this.supportedRuntimes_.contains(runtimeId);
    }
}

