/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.common.internal.emf.resource.AbstractRendererImpl;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapterImpl;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXRenderer;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.eclipse.wst.common.internal.emf.utilities.DOMLoadOptions;
import org.eclipse.wst.common.internal.emf.utilities.DOMUtilities;
import org.eclipse.wst.common.internal.emf.utilities.Revisit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EMF2DOMRenderer
extends AbstractRendererImpl
implements Renderer {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME;
    protected Map domAdapterRegistry;
    protected boolean needsToCreateDOM = true;
    protected Document document;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.internal.emf.resource.EMF2DOMRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
    }

    public EMF2DOMRenderer() {
        if (this.managesDOMAdapters()) {
            this.initDOMAdapterRegistry();
        }
    }

    public void doLoad(InputStream in, Map options) throws IOException {
        if (in != null || !this.useStreamsForIO()) {
            this.loadDocument(in, options);
            EMF2DOMAdapter adapter = this.createRootDOMAdapter();
            adapter.updateMOF();
        }
    }

    protected void loadDocument(InputStream in, Map options) throws IOException {
        String methodName = "loadDocument";
        try {
            DOMLoadOptions domOpts = new DOMLoadOptions();
            domOpts.setAllowJavaEncodings(true);
            domOpts.setExpandEntityRefererences(true);
            if (this.isValidating()) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "Disabled validation to support external entity processing.");
            }
            domOpts.setValidate(false);
            URI useSystemId = EMF2SAXRenderer.getSystemId(options);
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Parsing with system ID [ {0} ]", new Object[]{useSystemId});
            if (useSystemId != null) {
                domOpts.setSystemId(useSystemId);
            }
            this.document = DOMUtilities.loadDocument(in, domOpts, this.getResource().getEntityResolver());
            this.needsToCreateDOM = false;
        }
        catch (RuntimeException t_rex) {
            throw t_rex;
        }
        catch (IOException iox) {
            throw iox;
        }
        catch (Exception ex) {
            throw new WrappedException(ex);
        }
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        this.createDOMTreeIfNecessary();
        this.serializeDocument(outputStream);
    }

    protected boolean managesDOMAdapters() {
        return true;
    }

    protected void initDOMAdapterRegistry() {
        if (this.domAdapterRegistry == null) {
            this.domAdapterRegistry = new HashMap();
        }
    }

    public void registerDOMAdapter(Node node, EMF2DOMAdapter adapter) {
        this.domAdapterRegistry.put(node, adapter);
    }

    public EMF2DOMAdapter getExistingDOMAdapter(Node node) {
        return (EMF2DOMAdapter)this.domAdapterRegistry.get(node);
    }

    public void removeDOMAdapter(Node aNode, EMF2DOMAdapter anAdapter) {
        this.domAdapterRegistry.remove(aNode);
    }

    public void prepareToAddContents() {
    }

    protected Node createDOMTree() {
        this.createDocument();
        EMF2DOMAdapter adapter = this.createRootDOMAdapter();
        adapter.updateDOM();
        this.needsToCreateDOM = false;
        return this.document;
    }

    protected EMF2DOMAdapter createRootDOMAdapter() {
        EMF2DOMAdapterImpl root = new EMF2DOMAdapterImpl(this.getResource(), this.document, this, this.getResource().getRootTranslator());
        this.registerDOMAdapter(this.document, root);
        return root;
    }

    protected void createDOMTreeIfNecessary() {
        if (this.needsToCreateDOM) {
            this.createDOMTree();
        }
    }

    protected void createDocument() {
        TranslatorResource res = this.getResource();
        res.setDefaults();
        try {
            this.document = DOMUtilities.createNewDocument(res.getDoctype(), res.getPublicId(), res.getSystemId());
        }
        catch (ParserConfigurationException e) {
            throw new WrappedException((Exception)e);
        }
        catch (SAXException e) {
            throw new WrappedException((Exception)e);
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }

    public void serializeDocument(OutputStream out) throws IOException {
        String methodName = "serializeDocument";
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", this.getResource().getEncoding());
            transformer.setOutputProperty("version", this.getResource().getXMLVersion());
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            if (this.getResource().getPublicId() != null) {
                transformer.setOutputProperty("doctype-public", this.getResource().getPublicId());
            }
            if (this.getResource().getSystemId() != null) {
                transformer.setOutputProperty("doctype-system", this.getResource().getSystemId());
            }
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(this.document.getDocumentElement());
            transformer.transform(source, new StreamResult(out));
        }
        catch (TransformerConfigurationException e) {
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "Ignoring exception [ {0} ]", e);
            logger.throwing(CLASS_NAME, methodName, e);
        }
        catch (TransformerFactoryConfigurationError e) {
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "Ignoring exception [ {0} ]", e);
            logger.throwing(CLASS_NAME, methodName, e);
        }
        catch (TransformerException e) {
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "Ignoring exception [ {0} ]", e);
            logger.throwing(CLASS_NAME, methodName, e);
        }
    }

    public void replaceDocumentType(String docTypeName, String publicId, String systemId) {
        Revisit.revisit();
        Document newDoc = null;
        try {
            newDoc = DOMUtilities.createNewDocument(docTypeName, publicId, systemId);
        }
        catch (ParserConfigurationException e) {
            throw new WrappedException((Exception)e);
        }
        catch (SAXException e) {
            throw new WrappedException((Exception)e);
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
        this.replaceNode(this.document.getDocumentElement(), newDoc, newDoc);
        this.readapt(this.document, newDoc);
        this.document = newDoc;
    }

    protected void replaceNode(Node oldChild, Node newParent, Document newDoc) {
        Node newChild = newDoc.importNode(oldChild, false);
        newParent.appendChild(newChild);
        this.readapt(oldChild, newChild);
        NodeList children = oldChild.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            this.replaceNode(children.item(i), newChild, newDoc);
            ++i;
        }
    }

    public void preUnload() {
        EMF2DOMAdapter adapter = (EMF2DOMAdapter)EcoreUtil.getAdapter((List)this.resource.eAdapters(), (Object)EMF2DOMAdapter.ADAPTER_CLASS);
        if (adapter != null) {
            adapter.removeAdapters(adapter.getNode());
        }
    }

    protected void readapt(Node oldChild, Node newChild) {
        EMF2DOMAdapter adapter = this.getExistingDOMAdapter(oldChild);
        if (adapter != null) {
            this.registerDOMAdapter(newChild, adapter);
            if (adapter.getNode() == oldChild) {
                adapter.setNode(newChild);
            }
        }
    }

    public int getVersionID() {
        return this.getResource().getVersionID();
    }
}

