/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.common.internal.emf.resource.CacheEventNode;
import org.eclipse.wst.common.internal.emf.resource.CacheEventPool;
import org.eclipse.wst.common.internal.emf.resource.CacheEventStack;
import org.eclipse.wst.common.internal.emf.resource.EntityWidget;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class EMF2SAXDocumentHandler
extends DefaultHandler {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME;
    private TranslatorResource resource = null;
    private final CacheEventStack eventStack = new CacheEventStack();
    private CacheEventPool availableEventPool = new CacheEventPool();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.internal.emf.resource.EMF2SAXDocumentHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
    }

    public EMF2SAXDocumentHandler(TranslatorResource resource) {
        this.resource = resource;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            return this.basicResolveEntity(publicId, systemId);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    protected InputSource basicResolveEntity(String publicId, String systemId) throws IOException, SAXException {
        InputSource result;
        TranslatorResource useResource = this.getResource();
        useResource.setDoctypeValues(publicId, systemId);
        EntityResolver entityResolver = useResource.getEntityResolver();
        if (entityResolver != null && (result = entityResolver.resolveEntity(publicId, systemId)) != null) {
            return result;
        }
        InputSource archiveResult = EntityWidget.resolveLocalEntity(publicId, systemId, useResource.getResourceSet());
        if (archiveResult != null) {
            return archiveResult;
        }
        return super.resolveEntity(publicId, systemId);
    }

    public void startDocument() throws SAXException {
        this.availableEventPool.warmPool();
        this.eventStack.clear();
        this.createRoot(this.resource);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.addToStack(qName, attributes);
    }

    public void characters(char[] data, int start, int length) throws SAXException {
        CacheEventNode currentRecord = this.getCurrentRecord();
        if (currentRecord != null) {
            currentRecord.appendToBuffer(data, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        CacheEventNode currentRecord = null;
        if (qName.equals(this.getCurrentRecord().getNodeName()) && (currentRecord = this.removeCurrentRecord()) != null) {
            currentRecord.commit();
        }
    }

    public void endDocument() throws SAXException {
        CacheEventNode lastRecord = this.removeCurrentRecord();
        lastRecord.commit();
        this.availableEventPool.freezePool();
    }

    public void error(SAXParseException ex) throws SAXException {
        throw ex;
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        throw ex;
    }

    public void warning(SAXParseException ex) throws SAXException {
        String methodName = "warning";
        logger.logp(Level.WARNING, CLASS_NAME, methodName, "Ignoring parse exception [ {0} ]", new Object[]{ex});
        logger.throwing(CLASS_NAME, methodName, ex);
    }

    public TranslatorResource getResource() {
        return this.resource;
    }

    protected void createRoot(TranslatorResource resourceArg) {
        this.eventStack.push(this.availableEventPool.createCacheEventNode(resourceArg));
    }

    protected void addToStack(String nodeName, Attributes attributes) {
        CacheEventNode parent = this.getCurrentRecord();
        if (!parent.isChildIgnorable(nodeName)) {
            this.eventStack.push(this.availableEventPool.createCacheEventNode(parent, nodeName, attributes));
        }
    }

    protected CacheEventNode getCurrentRecord() {
        CacheEventNode result = null;
        if (!this.eventStack.isEmpty()) {
            result = this.eventStack.peek();
        }
        return result;
    }

    protected CacheEventNode removeCurrentRecord() {
        CacheEventNode result = null;
        if (!this.eventStack.isEmpty()) {
            result = this.eventStack.pop();
        }
        return result;
    }
}

