/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.wst.common.internal.emf.resource.AbstractRendererImpl;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXDocumentHandler;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXWriter;
import org.eclipse.wst.common.internal.emf.resource.EntityWidget;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;

public class EMF2SAXRenderer
extends AbstractRendererImpl {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME;
    public static final String SYSTEM_ID_OPTION = "org.eclipse.wst.common.internal.emf.resource.systemIdOption";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.internal.emf.resource.EMF2SAXRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
    }

    public void doLoad(InputStream in, Map options) {
        String methodName = "doLoad";
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(this.isValidating());
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            EMF2SAXDocumentHandler handler = new EMF2SAXDocumentHandler(this.getResource());
            try {
                reader.setFeature("http://xml.org/sax/features/validation", this.isValidating());
            }
            catch (SAXNotRecognizedException snre) {
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "Unrecognized feature [ {0} ]", "http://xml.org/sax/features/validation");
                logger.throwing(CLASS_NAME, methodName, snre);
            }
            try {
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXNotRecognizedException snre) {
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "Unrecognized feature [ {0} ]", "http://xml.org/sax/namespace-prefixes");
                logger.throwing(CLASS_NAME, methodName, snre);
            }
            try {
                reader.setFeature("http://apache.org/xml/features/validation/schema", this.isValidating());
            }
            catch (SAXNotRecognizedException e) {
                reader.setFeature("http://xml.org/sax/features/validation", false);
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "Disabling validation because of unrecognized feature [ {0} ]", "http://apache.org/xml/features/validation/schema");
                logger.throwing(CLASS_NAME, methodName, e);
            }
            try {
                reader.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            }
            catch (SAXNotRecognizedException e) {
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "Unrecognized feature [ {0} ]", "http://xml/features/allow-java-encodings");
                logger.throwing(CLASS_NAME, methodName, e);
            }
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.setEntityResolver(handler);
            InputSource inputSource = new InputSource(in);
            URI useSystemURI = EMF2SAXRenderer.getSystemId(options);
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Parsing with system ID [ {0} ]", new Object[]{useSystemURI});
            if (useSystemURI != null) {
                inputSource.setSystemId(useSystemURI.toString());
            }
            reader.parse(inputSource);
        }
        catch (RuntimeException t_rex) {
            throw t_rex;
        }
        catch (Exception ex) {
            throw new WrappedException(ex);
        }
    }

    public static Map addURI(Map options, URI uri) {
        HashMap newOptions = new HashMap();
        if (options != null) {
            Iterator optionKeys = options.keySet().iterator();
            while (optionKeys.hasNext()) {
                Object nextKey = optionKeys.next();
                Object nextValue = options.get(nextKey);
                newOptions.put(nextKey, nextValue);
            }
        }
        newOptions.put(SYSTEM_ID_OPTION, EntityWidget.createLocalArchiveURI(uri));
        return newOptions;
    }

    public static URI getSystemId(Map options) {
        if (options == null) {
            return null;
        }
        return (URI)options.get(SYSTEM_ID_OPTION);
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        String methodName = "doSave";
        TransformerHandler handler = null;
        try {
            try {
                SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
                handler = factory.newTransformerHandler();
                handler.setResult(new StreamResult(outputStream));
                Transformer transformer = handler.getTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", this.getResource().getEncoding());
                transformer.setOutputProperty("version", this.getResource().getXMLVersion());
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("omit-xml-declaration", "no");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                if (this.getResource().getPublicId() != null) {
                    transformer.setOutputProperty("doctype-public", this.getResource().getPublicId());
                }
                if (this.getResource().getSystemId() != null) {
                    transformer.setOutputProperty("doctype-system", this.getResource().getSystemId());
                }
            }
            catch (TransformerConfigurationException e) {
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "Ignoring exception [ {0} ]", e);
                logger.throwing(CLASS_NAME, methodName, e);
            }
            catch (TransformerFactoryConfigurationError e) {
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "Ignoring exception [ {0} ]", e);
                logger.throwing(CLASS_NAME, methodName, e);
            }
            if (handler == null) {
                logger.logp(Level.SEVERE, CLASS_NAME, methodName, "Null transformer handler; serialization has been skipped.");
                return;
            }
            EMF2SAXWriter writer = new EMF2SAXWriter();
            writer.serialize(this.resource, handler);
        }
        catch (SAXException saxe) {
            throw new WrappedException((Exception)saxe);
        }
    }

    public void prepareToAddContents() {
    }

    public int getVersionID() {
        return this.getResource().getVersionID();
    }
}

