//////////////////////////////////////////////////////////////////////

// help controller

//////////////////////////////////////////////////////////////////////



/**
 * Create the controller instance when the page is loaded in the browser window.
 * @param 
 */

var helpController = new function ( ) 

{

  

  this.eclipsePath    = "";

  

  //to store Assistant's toggle state

  this.assistOn       = true;  

  //Reference to the Assistant instance 

  this.taskAssistant  = undefined;

  this.assistImpl     = null;

  this.toggleBtnImpl  = null;



  this.currentPlugin  = undefined;

  this.currentTopic   = undefined;



  /* Task Assitant window handle. This will be defined when TA opened in a seperate window

   *for Lotus.

  */

  this.TAWindow      	= undefined;

  this.isTAWindow    	= false;



  // Help Viewer window handle 

  this.viewer		= undefined;



  /* Reference to the parent controller, which is used to communicate between them.

   * Any of its children would become parent controller, when the controller is unloaded

  */

  this.parentController = null;

  //to keep track of child controllers

  this.children 	  = new Array (  );

  this.controllerId 	  = -1; 



  

};





/*
helpController.constructor.prototype.contentPathBase = "content/help:/";
yewb: change this to the following line
*/
helpController.constructor.prototype.contentPathBase = "topic/";


/** 
 * This method must be invoked when the page that embedes controller.jsp module, is 

 * loaded. This method will call getParentController ( ) method to get the parent

 * controller, and add itself to the parent controller.

 * 
 * @param
*/
helpController.constructor.prototype.load = function ( ) 

{

 this . log ( "load called" );

 this . parentController = this . getParentController (  );

 if ( this . parentController != null )  

 {

    this . parentController . addChildren ( this );

 }





};



/**
 * This method will be invoked by the load ( ) method . It will call findHelpController ( ) 

 * method from finder.js module to findout the parent controller, and return it.

 * 
 * @param
*/

helpController.constructor.prototype.getParentController = function ( )

{

   if ( this . parentController ) return this . parentController;



   return findHelpController ( window.opener );      

     

};



/** 
 * This method might be called by other javascript instances whoever has this controller

 * reference, to set the eclipse path to the controller.

 * 
 * @param  path		The path for the eclipse installation.	
*/

helpController.constructor.prototype.setEclipsePath = function ( path )

{

  this.eclipsePath = path;

};



/**
 * This will return the eclipse path.

 * 
 * @param
*/

helpController.constructor.prototype.getEclipsePath = function ( ) 

{

  return this.eclipsePath;

};



/*This method will make the partial url to the help document

 * 
 * @param  plugin   The plugin for the help system.
 * @param  topic    The topic to be displayed in the help assistant.
*/

helpController.constructor.prototype.getContentPath = function ( plugin, topic ) 

{



  if ( plugin == null || topic == null )

    return null;

  return this.contentPathBase + plugin + "/" + topic;



};



/** 
 * Returns the help topic location.

 *
 * @param  plugin   The plugin for the help system.
 * @param  topic    The topic to be displayed in the help assistant.
 * 
*/

helpController.constructor.prototype.getPage = function( plugin, topic )

{



  var path = this.getContentPath( plugin, topic );

  if ( path == null ) 

   return null;

  return this.eclipsePath + path;



};



/** Assistant instance from assistant/assistant.jsp module will invoke this method to
 * registering it to the controller.

 * 
 * @param  frame            The frame is the refrrence of the task assistant.
 * @param  hasController    The boolean value that tells whether the frame has controller script.
 * 
*/

helpController.constructor.prototype.setTaskAssistant = function( frame, hasController )

{

  if ( frame == null || ! frame.setController )

    return;

  this.taskAssistant = frame;

  if ( arguments.length < 2 || ! hasController )

    frame.setController( this );

  if ( this.eclipsePath && this . currentPlugin && this . currentTopic )

    this.showCurrentAssist();

};



/** 
 * This method will be called from the web page, which needs the Task Assistant help.

 * (eg: In TPC console, the web page placed in work Area will invoke this call )

 * @param  plugin   The plugin for the help system.
 * @param  topic    The topic to be displayed in the help assistant.
*/

helpController.constructor.prototype.setHelp = function ( plugin, topic ) 

{
this.log("Come to setHelp()" + plugin + topic);

  this.currentPlugin = plugin;

  this.setTopic ( topic );



}

/** 
 * The method sets the plugin for the Task assistant help.
 * @param  plugin   The plugin for the help system.
*/

helpController.constructor.prototype.setPlugin = function( plugin ) 

{
this.log("Come to setPlugin()");


  this.currentPlugin = plugin;

  this.currentTopic  = undefined;



};

/** 
 * This method will be called from the web page, which needs the Task Assistant help.

 * (eg: In TPC console, the web page placed in work Area will invoke this call ).

 * The method sets the topic for the Task assistant help.
 * @param  topic    The topic to be displayed in the help assistant.
*/

helpController.constructor.prototype.setTopic = function ( topic ) 

{



  this.currentTopic = topic;

  this.showCurrentAssist();



};

/** 
 * This method displays the Task assistant help with available plugin and topic.

 * @param  
*/

helpController.constructor.prototype.showCurrentAssist = function() 

{

this.log("Come to showCurrentAssist()");
  this.showAssist( this.currentPlugin, this.currentTopic );

};



/**
 * This will invoke showPage ( ) method call in Assistant instance, that would display the help topic

 * in the Task Assistant frame. Help topic will be opened in a seperate window if application wants

 * TA in a seperate window. Lotus is interested in this approach. To activate this application should

 * call setTaWindow ( true ).

 * @param  plugin   The plugin for the help system.
 * @param  topic    The topic to be displayed in the help assistant.
*/

helpController.constructor.prototype.showAssist = function( plugin, topic ) 

{

  this.log("Come to showAssist()");


  if ( ! this.assistOn )

    return;

  this . openTAWindow (  );


  if ( this.taskAssistant == null || this.taskAssistant.showPage == null )

    return;
	this.log("to call getPage, plugin=" + plugin +", topic=" + topic);
  var page = this.getPage( plugin, topic );
  

  if ( page ) {
		this.log("page is " + page);
    this.taskAssistant.showPage( page );
    }

};



/**
 * The function will set the assistant toggle function reference.

 * @param  implFunction   The name of the function implementing the toggle.
*/

helpController.constructor.prototype.setToggleAssistImpl = function( implFunction ) 

{

  this . assistImpl = implFunction;

}



/**
 * The method will set the toggle btn OnClick function reference.

 * @param  implFunction   The name of the function implementing the onClick for the button.
*/

helpController.constructor.prototype.setToggleButtonImpl = function( implFunction ) 

{

  this . toggleBtnImpl = implFunction;

}



/**
 * The method will on and off the Task Assistant window/frame.

 * @param  on   The boolean variable to indicate the state of the toggle for assistant frame.
*/

helpController.constructor.prototype.toggleAssist = function( on ) 

{

  

  this.assistOn = on;

  if ( on )

    this.showCurrentAssist();

  else

  {

   

   if ( this . isTAWindow )  this . closeTAWindow (  );

  }

 



};



/**
 * This method will be invoked when Help button is clicked. This would show the current

 * help topic of the web page or the current topic of Task Assistant if it is there.

*/

helpController.constructor.prototype.showCurrentTopic = function() 

{

  //savari : controller should pass the topic shown in assistant if assistant is not off
//yewb: Defect 27647 Help page is incorrect while Help Assistant is open
// The taskAssistant.getCurentTopic() does not work correctly.  
//  if ( this.taskAssistant && this . assistOn ) {
//   plugin = this . taskAssistant . getCurrentPlugin ( );
//   topic  = this . taskAssistant . getCurrentTopic ( );
//   this . showHelp ( plugin, topic );
//  }
//  else  {
   this.showHelp( this.currentPlugin, this.currentTopic );
//}

};



/**
 * This method will show the help in the assistant if it is on for the given topic.
 * If the assistant is not available, it will invoke helpviewer.

 * @param  topic     The topic to be displayed in assistant or helpviewer.
*/

helpController.constructor.prototype.showTopic = function( topic ) 

{

  

  //savari : controller should pass the topic shown in assistant if assistant is not off

  if ( this.taskAssistant && this . assistOn )

  {



   plugin = this . taskAssistant . getCurrentPlugin ( );

   topic  = this . taskAssistant . getCurrentTopic ( );

   this . showHelp ( plugin, topic );



  }

  else

   this.showHelp( this.currentPlugin, topic );



};


/**
 * The method returns true if the controller object is available.
 */

helpController.constructor.prototype.hasParentController = function (  )

{

 if ( this . parentController ) return true;



 return false;

};



 

/**
 * The method returns true if the viewer is open and available.
 */

helpController.constructor.prototype.hasViewerOpened = function (  )

{

  if ( this . hasParentController (  ) )

  {

   return this . parentController . hasViewerOpened (  );  

  }

  

  if ( this . viewer == null || this . viewer . closed )

   return null;

  else

   return this . viewer;

};

  

/** This method is used to search in the help viewer, and will be invoked by toolbar.jsp

 * when the user clicked 'GO' button from the assistant toolbar. The call is farwarded to

 * the parent controller, if there is no viewer opened it will open the viewer window othere

 * wise it will call the doSearch ( ) method from help.js

 * @param  searchWord   The word or words in the search textbox.
 * @param  maxHits      The maximum no. of hits for the search word.
*/

helpController.constructor.prototype.Search = function ( searchWord, maxHits )

{

  

  if ( this . hasParentController (  ) )

   this . parentController . Search ( searchWord, maxHits );

  else 

  {

    var query = "searchWord=" + encodeURIComponent(searchWord) + "&maxHits=" + maxHits + "&tab=search";  

    if ( this . viewer == null || this.viewer.closed ) 

    { 

      this . viewer = window . open ( this . eclipsePath + "?" + query,

                                    "",

			            "resizable=yes,screenX=100,screenY=100,scrollbars=yes,status=yes,height=400,width=700"


                                  );

      

    }

    else 

    {

      

      var doSearch = "doSearch ( \"" + query + "\" );";

      //this . viewer . doSearch ( query );

      this . viewer . setTimeout ( doSearch,1 );

      this . viewer . SearchFrame.document.searchForm.searchWord.value = searchWord;



    }



    this . viewer . focus (  );

  }




};



/** 
 * This method operates in the context of parent controller. If child controller calls this

 * method, it will delegate the call to the parent controller because parent controller is sole

 * responsible for opening and closing the Help Viewer window. The Help Viewer window handle will

 * be valid only in the context of parent controller.

 * @param  plugin   The plugin for the help system.
 * @param  topic    The topic to be displayed in the help assistant.
*/

helpController.constructor.prototype.showHelp = function ( plugin, topic ) 

{
	
  if ( plugin == null || topic == null ) ;

   

  else if ( this . parentController )

   this . parentController . showHelp ( plugin, topic );



  else if ( this.viewer == null || this.viewer.closed ) 

  {

    //var topicParam = this.getContentPath ( plugin, topic ); 
    var topicParam = "/" + plugin + "/" + topic;

    if ( topicParam != null ) 

    {

      this.viewer = window.open ( this.eclipsePath + "index.jsp?topic=" + topicParam,

        "",

        "resizable=yes,screenX=100,screenY=100,scrollbars=yes,status=yes,height=400,width=700"

      				);

    }

  }



  else 

  {

    var page = this.getPage ( plugin, topic );

    if ( page != null ) 

    { 

      this.viewer.MainFrame.location.href = page;

      var loadTOC = "displayTocFor ( \"" + page + "\" );";

      this .viewer . setTimeout ( loadTOC, 1 ); 

      this.viewer.focus();

    }

  }



};


/** This method will be called when the help is shown in the help assistant frame.

  * If the assistant is on , help will be shown there, if not this will call 

  * showHelp function to display help.

  * @param plugin 	Given plugin for the help system.

  * @param topic	Topic to be displayed in the help window.

  */

helpController.constructor.prototype.viewHelp = function(plugin, topic)

{
this.log("Come to viewHelp()");

 if ( plugin == null || topic == null ) 

 	return;

 if ( this.assistOn )

   this.showAssist(plugin, topic);

 else

   this.showHelp(plugin, topic);

   

};



/** View help when only topic is given. The function calls viewHelp function

  * with given topic.

  * @param topic		Toipc to be displayed in the help window.

 */

helpController.constructor.prototype.viewHelpTopic = function(topic)

{

   this.viewHelp(this.currentPlugin, topic);

};


/**
 * Return the current page with default plugin and default topic

 */

helpController.constructor.prototype.getCurrentPage = function ( ) 

{

  return this.getPage( this.currentPlugin, this.currentTopic );

};



/**
 * This method must be called if the application wants a sepereate window for Task Assistant.
 * @param  flag   Boolean variable indicating whether the window is a task assistant window.

*/

helpController.constructor.prototype.setTAWindow = function ( flag )

{

 this . isTAWindow = flag;

};



/** 
 * This method will be invoked when the controller is unloaded, TA toggle is off and Assistant is unloaded.

 * This will close the TA window if it is in a seperate window

 * @param
*/

helpController.constructor.prototype.closeTAWindow = function (  )

{ 

 

  this.taskAssistant = undefined;  

  //this . assistOn = false;

  if ( this . isTAWindow )  

  {

 

   if ( this.TAWindow && !this . TAWindow .closed ) 

    this.TAWindow.close (  );



   this.TAWindow = undefined;

  }





};



/** 
 * This will open the Task Assistant in a window

*/

helpController.constructor.prototype.openTAWindow = function (  )

{

  

 if ( this . isTAWindow && ( this.TAWindow == null || this.taskAssistant == null ) )

 {

   this.TAWindow = window.open( this . eclipsePath + "assistant/assistant.jsp", "",

                                "resizable=yes,screenX=600,screenY=700,scrollbars=yes,status=yes,height=450,width=375"

                              );

 }



};



//savari: sharing single HelpViewer(HV) Window to one or more main windows/application



/**
 * Parent controller will call its children register ( ) method. Parent controller is registered

 * with child controller. 

 * @param   pcontroller  The parent controller window.
*/

helpController.constructor.prototype.register = function ( pcontroller )

{

 this . parentController = pcontroller;

 this . log ( "register " + pcontroller );

};



/** 
 * If a parent controller is unloaded, it should hand over all its child controllers to the

 * first child controller. Basically, this function will update the children record of the controller.

 * @param  childControllers    The list of controllers of the parent being unloaded.
*/

helpController.constructor.prototype.updateChildren = function ( childControllers )

{

 for ( i=0; i < childControllers . length; i++ )

  this . addChildren ( childControllers [ i ] );



};



/** 
 * If a child controller call this method, it will be delegated to the parent controller.

 * Always there will be only one parent. If a child controller creates any child controll that will

 * be given to the parent.

 * @param childController    The child controller window.
*/

helpController.constructor.prototype.addChildren = function ( childController )

{



 if ( this . parentController )

 {

   this . parentController . addChildren ( childController );

   return;

 } 

 childController . controllerId = this . children . length;

 this . log ( childController + " id " + childController . controllerId );

 childController . register ( this );

 this . children . push ( childController );



};



/**
 * Every controller is identified with an ID. This will be helpful when

 * a child is removes from the record.

 * @param id 	The identifiction name for the controller window.
*/

helpController.constructor.prototype.setId = function ( id )

{

 this . controllerId = id;

};


/**
 * This function will set the ids for the child windows.
 */

helpController.constructor.prototype.updateId = function (  )

{

  for ( i=0; i < this . children . length; i++ )

   this . children [ i ] . setId ( i );

};



/**
 * Remove the child  from the record and upate the children with new id.
 * @param  controllerId    The id of the child window to be removed.

*/

helpController.constructor.prototype.removeChildren = function ( controllerId )

{



 this . log ( "before splice " + this . children . length );

 this . children . splice ( controllerId, 1 ); 

 this . updateId (  );

 this . log ( "after splice " + this . children . length );



};





/**
 * Set the help viewer handle to the controller. This will be invoked

 * when the parent controller is unloaded and a child becomes a parent.

*/

helpController.constructor.prototype.setViewer = function ( viewer )

{

 if ( this . hasParentController ( ) ) 

  this . parentController . setViewer ( viewer );

 else

  this . viewer = viewer;

 



};



/**
 * This method will be invoked when the conroller is unloaded from the page.

 * There are three situations are handled here.

 * 1. if the controller has zero child controller

 *      call shutdown

 * 2. if the controller has no parent controller and has children:

 *    Take the first child from the record, which becomes parent controller, 
 *    and set the Help viewer handle to it.

 *    update all its child controllers to the new parent controller.

 * 3. if the controller has parent controller and child controllers [ not valid at this point ]

*/



helpController.constructor.prototype.unload = function (  )

{

 this . log ( "unload " + this . children . length + "\n" +

              "pvMgr " + this . parentController + "\n"  +

              "viewer " + this . viewer );

 if ( this . children . length == 0 )

  this . shutdown (  );



 else if ( this . parentController == null )

 {

  temp = this . children . shift (  );

  temp . parentController = null;

  temp . setViewer ( this . viewer );

  this . viewer = null; 
  temp . updateChildren ( this . children );

 }



 else if ( this . parentController )

 {

  this . parentController . removeChildren ( this . controllerId );

  this . parentController . updateChildren ( this . children );

  

 }



 this . closeTAWindow (  );



};

  

/**
 * For closing the Help viewer window. This will close the window if there is no other controllers.

 * if the child controller is unloaded, it will be removed from its parent record.

*/

helpController.constructor.prototype.shutdown = function (  )

{

 this . log ( "shutdown: viewer " + this . viewer + "\n" +

              "pVMgr " + this . parentController );

 if ( this . viewer  && !this . viewer . closed )   

 {

  this . log ( "shutting down ...." );

  this . viewer . close (  );

  this . viewer = null;

 }



 if ( this . parentController )

  this . parentController . removeChildren ( this . controllerId );

};





/**
 * The function is used for debugging.
 * @param  msg   The string to be displayed in the alertbox.
 */
helpController.constructor.prototype.log = function ( msg )

{

 //alert ( msg );

};



